/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.videodev;

import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTableConfigDlg;
import com.aastra.oamp.guiutil.GuiUtilTableFilterDlg;
import com.aastra.oamp.guiutil.GuiUtilTaskPanel;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.videodev.VideoDevConfigMainPanel;
import com.aastra.oamp.videodev.VideoDevMonitorMainPanel;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.style.AastraLinkButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class VideoDevMonitorTaskPanel
extends GuiUtilTaskPanel {
    private static final long serialVersionUID = 1L;
    private VideoDevMonitorMainPanel videoDevMainPanel = null;
    private ConfiguratorTable videoDevTable = null;
    private AastraLinkButton buttonShowVideoDevDetails = null;
    private AastraLinkButton buttonFilterVideoDevTable = null;
    private AastraLinkButton buttonConfigureVideoDevTable = null;
    private GuiUtilTableFilterDlg videoDevTableFilterDlg = null;

    public VideoDevMonitorTaskPanel(VideoDevMonitorMainPanel videoDevMonitorMainPanel, ConfiguratorTable configuratorTable) {
        this.videoDevMainPanel = videoDevMonitorMainPanel;
        this.videoDevTable = configuratorTable;
        this.initialize();
    }

    private void initialize() {
        this.add((Component)this.getButtonShowVideoDevDetails(), null);
        this.add((Component)this.getButtonFilterVideoDevTable(), null);
        this.add(this.getButtonConfigureVideoDevTable());
    }

    private AastraLinkButton getButtonShowVideoDevDetails() {
        if (this.buttonShowVideoDevDetails == null) {
            this.buttonShowVideoDevDetails = this.createTaskButtonDisabled(UtilLocale.getString("TXT_SHOW_DETAILS_20"));
            this.buttonShowVideoDevDetails.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VideoDevMonitorTaskPanel.this.videoDevMainPanel.showVideoDevDetails();
                }
            });
        }
        return this.buttonShowVideoDevDetails;
    }

    private AastraLinkButton getButtonFilterVideoDevTable() {
        if (this.buttonFilterVideoDevTable == null) {
            this.buttonFilterVideoDevTable = this.createTaskButtonDisabled(UtilLocale.getString("TXT_FILTER_20"), GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            this.buttonFilterVideoDevTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VideoDevMonitorTaskPanel.this.getVideoDevTableFilterDlg().setVisible(true);
                    VideoDevMonitorTaskPanel.this.videoDevMainPanel.configureTableFilter();
                }
            });
        }
        return this.buttonFilterVideoDevTable;
    }

    private GuiUtilTableFilterDlg getVideoDevTableFilterDlg() {
        if (this.videoDevTableFilterDlg == null) {
            this.videoDevTableFilterDlg = new GuiUtilTableFilterDlg(this.videoDevTable, UtilPreferences.TableFilterValuesKeyTypeEnum.TableFilterValuesVideoDevMonitor);
        }
        return this.videoDevTableFilterDlg;
    }

    private AastraLinkButton getButtonConfigureVideoDevTable() {
        if (this.buttonConfigureVideoDevTable == null) {
            this.buttonConfigureVideoDevTable = this.createTaskButtonDisabled(UtilLocale.getString("TXT_SELECT_COLUMNS_20"));
            this.buttonConfigureVideoDevTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilTableConfigDlg guiUtilTableConfigDlg = new GuiUtilTableConfigDlg(VideoDevMonitorTaskPanel.this.videoDevTable, VideoDevConfigMainPanel.videoDevTableConfigIdxArray, UtilPreferences.TableColSelectKeyTypeEnum.TableColSelectVideoDevMonitor);
                    guiUtilTableConfigDlg.setVisible(true);
                }
            });
        }
        return this.buttonConfigureVideoDevTable;
    }

    public void setTaskButtonShowDetails(boolean bl) {
        this.buttonShowVideoDevDetails.setEnabled(bl);
    }

    public void setTaskButtonFilter(boolean bl) {
        this.buttonFilterVideoDevTable.setEnabled(bl);
    }

    public void setTaskButtonFilterState(Boolean bl, String string) {
        if (bl != null) {
            if (bl.booleanValue()) {
                this.buttonFilterVideoDevTable.setIcon(GuiUtilIcon.getIconActive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            } else {
                this.buttonFilterVideoDevTable.setIcon(GuiUtilIcon.getIconInactive(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
            }
        }
        this.buttonFilterVideoDevTable.setToolTipText(string);
    }

    public void setTaskButtonConfigureTable(boolean bl) {
        this.buttonConfigureVideoDevTable.setEnabled(bl);
    }
}

