/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.wlan;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.guiutil.GuiUtilButton;
import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilFileChooser;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.guiutil.GuiUtilTextFieldFS;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.wlan.WlanProfileMainPanel;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.WLANProfileHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.table.TableColumnModel;

public class WlanProfileACLDetailPanel
extends GuiUtilDetailPanel
implements ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface {
    private static final long serialVersionUID = 1L;
    private static final int TAB_GENERAL = 0;
    private static final int TAB_EXPORT = 2;
    private WlanProfileMainPanel wlanProfileMainPanel = null;
    private WLANProfileHandler wlanProfileHandler = null;
    private int currentProfileId = 1;
    private UtilErrorComp utilErrorComp = null;
    private boolean createMode = false;
    private AastraButton buttonCancel = null;
    private AastraPanel tabGeneral = null;
    private AastraPanel panelTable = null;
    private ConfiguratorTable currentACLTable = null;
    private AastraPanel panelConfigureACL = null;
    private GuiUtilTextFieldFS textFieldEthAddr = null;
    private GuiUtilTextFieldFS textFieldName = null;
    private ScrollPaneACLTable[] scrollPaneACLTable = null;
    private AastraButton buttonCreateACLEntry = null;
    private AastraButton buttonConfigureACLEntry = null;
    private AastraButton buttonDeleteACLEntry = null;
    private AastraButton buttonOK = null;
    private AastraPanel tabImport = null;
    private AastraButton buttonImport = null;
    private AastraButton buttonFile = null;
    private GuiUtilTextField textFieldImportFile = null;
    private String importFileName = null;
    private WLANProfileHandler.ACLEntry[] aclImport = null;
    private GuiUtilFileChooser importFileChooser = null;
    private AastraPanel tabExport = null;
    private AastraButton buttonExport = null;
    private AastraButton buttonExportDir = null;
    private GuiUtilTextField textFieldExportDir = null;
    private String exportDirName = null;
    private boolean isEditable = true;
    private GuiUtilFileChooser exportFileChooser = null;

    protected WlanProfileACLDetailPanel(WlanProfileMainPanel wlanProfileMainPanel, WLANProfileHandler wLANProfileHandler) {
        super(400, 220);
        this.wlanProfileMainPanel = wlanProfileMainPanel;
        this.wlanProfileHandler = wLANProfileHandler;
        this.initialize();
    }

    private void initialize() {
        if (this.wlanProfileMainPanel.isGuiNavPanelTypeConfig()) {
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        this.labelHeaderBar.setText(String.format("%s #%d - %s", UtilLocale.getString("TXT_WLAN_PROFILE"), this.currentProfileId, UtilLocale.getString("TXT_MAC_ACCESS_FILTER")));
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL_20"), null, this.getTabGeneral(), null);
        if (this.isEditable) {
            this.panelTabbed.addTab(UtilLocale.getString("TXT_IMPORT_20"), null, this.getTabImport(), null);
            this.panelTabbed.addTab(UtilLocale.getString("TXT_EXPORT_20"), null, this.getTabExport(), null);
        }
        this.panelButtonBar.add((Component)this.getButtonCancel(), null);
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(new BoxLayout(this.tabGeneral, 0));
            this.tabGeneral.add(Box.createRigidArea(new Dimension(30, 0)));
            this.tabGeneral.add(this.getPanelTable());
            if (this.isEditable) {
                this.tabGeneral.add(this.getPanelConfigureACL());
            }
        }
        return this.tabGeneral;
    }

    protected AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = GuiUtilButton.ButtonCancel(230, 15);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (WlanProfileACLDetailPanel.this.isEditable) {
                        WlanProfileACLDetailPanel.this.utilErrorComp.clearComponents();
                    }
                    WlanProfileACLDetailPanel.this.wlanProfileMainPanel.removeWlanProfileACLDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    private AastraPanel getPanelTable() {
        if (this.panelTable == null) {
            this.panelTable = new AastraPanel();
            Dimension dimension = null;
            dimension = this.isEditable ? new Dimension(330, 250) : new Dimension(310, 250);
            this.panelTable.setMinimumSize(dimension);
            this.panelTable.setPreferredSize(dimension);
            this.panelTable.setMaximumSize(dimension);
            this.panelTable.setLayout(new BoxLayout(this.panelTable, 0));
            this.panelTable.add(this.getScrollPaneACLTable(this.currentProfileId));
            this.currentACLTable = this.scrollPaneACLTable[this.currentProfileId - 1].getTable();
        }
        return this.panelTable;
    }

    private ScrollPaneACLTable getScrollPaneACLTable(int n) {
        int n2 = n - 1;
        if (this.scrollPaneACLTable == null) {
            this.scrollPaneACLTable = new ScrollPaneACLTable[20];
        }
        if (this.scrollPaneACLTable[n2] == null) {
            this.scrollPaneACLTable[n2] = new ScrollPaneACLTable(this.getACLTable(n));
        }
        return this.scrollPaneACLTable[n2];
    }

    private ConfiguratorTable getACLTable(int n) {
        ConfiguratorTable configuratorTable = new ConfiguratorTable(this.wlanProfileHandler.getAclDb(n));
        int[] nArray = new int[]{0, 1};
        configuratorTable.setColumnArr(nArray, nArray.length);
        configuratorTable.getTableHeader().setReorderingAllowed(false);
        TableColumnModel tableColumnModel = configuratorTable.getColumnModel();
        if (this.isEditable) {
            configuratorTable.registerEventListener(this);
            configuratorTable.registerMultiSelectListener(this);
            tableColumnModel.getColumn(1).setPreferredWidth(125);
            tableColumnModel.getColumn(1).setResizable(false);
            tableColumnModel.getColumn(2).setPreferredWidth(175);
            tableColumnModel.getColumn(2).setResizable(false);
        } else {
            configuratorTable.setSelectionMode(0);
            tableColumnModel.getColumn(0).setPreferredWidth(115);
            tableColumnModel.getColumn(0).setResizable(false);
            tableColumnModel.getColumn(1).setPreferredWidth(165);
            tableColumnModel.getColumn(1).setResizable(false);
        }
        return configuratorTable;
    }

    private AastraPanel getPanelConfigureACL() {
        if (this.panelConfigureACL == null) {
            this.panelConfigureACL = new AastraPanel();
            this.panelConfigureACL.setLayout(null);
            this.panelConfigureACL.setMaximumSize(new Dimension(400, 300));
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(30, 20, 140, 16);
            aastraLabel.setText(UtilLocale.getString("TXT_MAC_ADDRESS"));
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(30, 70, 140, 16);
            aastraLabel2.setText(UtilLocale.getString("TXT_NAME"));
            this.panelConfigureACL.add(aastraLabel);
            this.panelConfigureACL.add(this.getTextFieldEthAddr());
            this.panelConfigureACL.add(aastraLabel2);
            this.panelConfigureACL.add(this.getTextFieldName());
            this.panelConfigureACL.add(this.getButtonCreateACLEntry());
            this.panelConfigureACL.add(this.getButtonConfigureACLEntry());
            this.panelConfigureACL.add(this.getButtonDeleteACLEntry());
            this.panelConfigureACL.add(this.getButtonOK());
            this.utilErrorComp.put(OmiMessage.ACLEntryType.ethAddr.name(), aastraLabel, this.textFieldEthAddr);
            this.utilErrorComp.put(OmiMessage.ACLEntryType.name.name(), aastraLabel2, this.textFieldName);
        }
        return this.panelConfigureACL;
    }

    private GuiUtilTextFieldFS getTextFieldEthAddr() {
        if (this.textFieldEthAddr == null) {
            this.textFieldEthAddr = new GuiUtilTextFieldFS(30, 40, AastraCommon.TextFieldSizeType.m);
            this.textFieldEthAddr.setEnabled(false);
            this.textFieldEthAddr.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    WlanProfileACLDetailPanel.this.buttonOK.setEnabled(true);
                }
            });
        }
        return this.textFieldEthAddr;
    }

    private GuiUtilTextFieldFS getTextFieldName() {
        if (this.textFieldName == null) {
            this.textFieldName = new GuiUtilTextFieldFS(30, 90, AastraCommon.TextFieldSizeType.m);
            this.textFieldName.setEnabled(false);
            this.textFieldName.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    WlanProfileACLDetailPanel.this.buttonOK.setEnabled(true);
                }
            });
        }
        return this.textFieldName;
    }

    protected AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = GuiUtilButton.ButtonOK(140, 270);
            this.buttonOK.setEnabled(false);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = WlanProfileACLDetailPanel.this.textFieldEthAddr.getText();
                    WlanProfileACLDetailPanel.this.utilErrorComp.clearComponents();
                    if (!UtilMisc.validateMACAddress(string)) {
                        GuiInfoConsole.showError(UtilLocale.getString("TXT_MAC_ADDRESS_FORMAT_INVALID"));
                        WlanProfileACLDetailPanel.this.markErrorComponent(OmiMessage.ACLEntryType.ethAddr.name());
                        return;
                    }
                    WLANProfileHandler.ACLEntry aCLEntry = new WLANProfileHandler.ACLEntry();
                    aCLEntry.ethAddr = string;
                    aCLEntry.name = WlanProfileACLDetailPanel.this.textFieldName.getText();
                    if (WlanProfileACLDetailPanel.this.createMode) {
                        WlanProfileACLDetailPanel.this.wlanProfileMainPanel.createACLEntry(aCLEntry, WlanProfileACLDetailPanel.this.currentProfileId);
                    } else {
                        WlanProfileACLDetailPanel.this.wlanProfileMainPanel.changeACLEntry(aCLEntry, WlanProfileACLDetailPanel.this.currentProfileId);
                    }
                    WlanProfileACLDetailPanel.this.buttonOK.setEnabled(false);
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCreateACLEntry() {
        if (this.buttonCreateACLEntry == null) {
            this.buttonCreateACLEntry = new AastraButton();
            this.buttonCreateACLEntry.setBounds(140, 130, 90, 25);
            this.buttonCreateACLEntry.setText(UtilLocale.getString("TXT_CREATE_20"));
            this.buttonCreateACLEntry.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WlanProfileACLDetailPanel.this.utilErrorComp.clearComponents();
                    WlanProfileACLDetailPanel.this.currentACLTable.clearSelection();
                    WlanProfileACLDetailPanel.this.textFieldEthAddr.setEnabled(true);
                    WlanProfileACLDetailPanel.this.textFieldEthAddr.setText(null);
                    WlanProfileACLDetailPanel.this.textFieldName.setEnabled(true);
                    WlanProfileACLDetailPanel.this.textFieldName.setText(null);
                    WlanProfileACLDetailPanel.this.buttonCreateACLEntry.setEnabled(false);
                    WlanProfileACLDetailPanel.this.createMode = true;
                }
            });
        }
        return this.buttonCreateACLEntry;
    }

    private AastraButton getButtonConfigureACLEntry() {
        if (this.buttonConfigureACLEntry == null) {
            this.buttonConfigureACLEntry = new AastraButton();
            this.buttonConfigureACLEntry.setBounds(140, 170, 90, 25);
            this.buttonConfigureACLEntry.setText(UtilLocale.getString("TXT_CONFIGURE_20"));
            this.buttonConfigureACLEntry.setEnabled(false);
            this.buttonConfigureACLEntry.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WlanProfileACLDetailPanel.this.utilErrorComp.clearComponents();
                    WlanProfileACLDetailPanel.this.textFieldName.setEnabled(true);
                    WlanProfileACLDetailPanel.this.buttonConfigureACLEntry.setEnabled(false);
                    WlanProfileACLDetailPanel.this.createMode = false;
                }
            });
        }
        return this.buttonConfigureACLEntry;
    }

    private AastraButton getButtonDeleteACLEntry() {
        if (this.buttonDeleteACLEntry == null) {
            this.buttonDeleteACLEntry = new AastraButton();
            this.buttonDeleteACLEntry.setBounds(140, 210, 90, 25);
            this.buttonDeleteACLEntry.setText(UtilLocale.getString("TXT_DELETE_20"));
            this.buttonDeleteACLEntry.setEnabled(false);
            this.buttonDeleteACLEntry.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WlanProfileACLDetailPanel.this.utilErrorComp.clearComponents();
                    GuiUtilDialog guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_MAC_ACCESS_FILTER_ENTRIES_?"), true);
                    if (guiUtilDialog.getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
                        int n = WlanProfileACLDetailPanel.this.currentACLTable.getRowCount();
                        int n2 = WlanProfileACLDetailPanel.this.currentACLTable.getSelectedRowCount();
                        if (n2 > 0) {
                            if (n == n2) {
                                WlanProfileACLDetailPanel.this.wlanProfileMainPanel.deleteAllACLEntries(WlanProfileACLDetailPanel.this.currentProfileId);
                            } else {
                                int[] nArray = WlanProfileACLDetailPanel.this.currentACLTable.getSelectedRows();
                                WLANProfileHandler.ACLEntry[] aCLEntryArray = new WLANProfileHandler.ACLEntry[n2];
                                for (int i = 0; i < nArray.length; ++i) {
                                    int n3 = WlanProfileACLDetailPanel.this.currentACLTable.convertRowIndexToModel(nArray[i]);
                                    aCLEntryArray[i] = WlanProfileACLDetailPanel.this.wlanProfileHandler.getAclEntryByTableIdx(WlanProfileACLDetailPanel.this.currentProfileId, n3);
                                }
                                WlanProfileACLDetailPanel.this.wlanProfileMainPanel.deleteACLEntries(aCLEntryArray, WlanProfileACLDetailPanel.this.currentProfileId);
                            }
                        }
                    }
                }
            });
        }
        return this.buttonDeleteACLEntry;
    }

    private AastraPanel getTabImport() {
        if (this.tabImport == null) {
            this.tabImport = new AastraPanel();
            this.tabImport.setLayout(null);
            this.tabImport.add(this.getButtonFile());
            this.tabImport.add(this.getTextFieldImportFile());
            this.tabImport.add(this.getButtonImport());
        }
        return this.tabImport;
    }

    protected AastraButton getButtonFile() {
        if (this.buttonFile == null) {
            this.buttonFile = new AastraButton(GuiUtilIcon.getIconDocumentAdd());
            this.buttonFile.setText(UtilLocale.getString("TXT_FILE"));
            this.buttonFile.setBounds(30, 60, 106, 25);
            this.buttonFile.setToolTipText(UtilLocale.getString("TXT_SELECT_MAC_ACCESS_FILTER_FILE_TO_IMPORT"));
            this.buttonFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file = WlanProfileACLDetailPanel.this.getImportFileChooser(WlanProfileACLDetailPanel.this.tabImport).fileChooser();
                    if (file != null) {
                        WlanProfileACLDetailPanel.this.importFileName = file.getAbsolutePath();
                        WlanProfileACLDetailPanel.this.buttonImport.setEnabled(true);
                    } else {
                        WlanProfileACLDetailPanel.this.importFileName = null;
                        WlanProfileACLDetailPanel.this.buttonImport.setEnabled(false);
                    }
                    WlanProfileACLDetailPanel.this.textFieldImportFile.setText(WlanProfileACLDetailPanel.this.importFileName);
                }
            });
        }
        return this.buttonFile;
    }

    private GuiUtilTextField getTextFieldImportFile() {
        if (this.textFieldImportFile == null) {
            this.textFieldImportFile = new GuiUtilTextField();
            this.textFieldImportFile.setBounds(170, 60, 425, 18);
            this.textFieldImportFile.setEnabled(false);
        }
        return this.textFieldImportFile;
    }

    protected AastraButton getButtonImport() {
        if (this.buttonImport == null) {
            this.buttonImport = new AastraButton();
            this.buttonImport.setBounds(30, 105, 106, 25);
            this.buttonImport.setText(UtilLocale.getString("TXT_IMPORT_20"));
            this.buttonImport.setEnabled(false);
            this.buttonImport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WlanProfileACLDetailPanel.this.importACLFile();
                }
            });
        }
        return this.buttonImport;
    }

    private GuiUtilFileChooser getImportFileChooser(AastraPanel aastraPanel) {
        if (this.importFileChooser == null) {
            this.importFileChooser = new GuiUtilFileChooser(aastraPanel);
        }
        return this.importFileChooser;
    }

    private AastraPanel getTabExport() {
        if (this.tabExport == null) {
            this.tabExport = new AastraPanel();
            this.tabExport.setLayout(null);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setText(UtilLocale.getString("TXT_FILE"));
            aastraLabel.setBounds(30, 100, 76, 16);
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setText("export_mac_access_filter.csv");
            aastraLabel2.setBounds(170, 100, 300, 18);
            this.tabExport.add(this.getButtonExportDir());
            this.tabExport.add(this.getTextFieldExportDir());
            this.tabExport.add(aastraLabel);
            this.tabExport.add(aastraLabel2);
            this.tabExport.add(this.getButtonExport());
        }
        return this.tabExport;
    }

    private AastraButton getButtonExportDir() {
        if (this.buttonExportDir == null) {
            this.buttonExportDir = new AastraButton(GuiUtilIcon.getIconFolderAdd());
            this.buttonExportDir.setText(UtilLocale.getString("TXT_DIRECTORY"));
            this.buttonExportDir.setBounds(30, 60, 106, 25);
            this.buttonExportDir.setToolTipText(UtilLocale.getString("TXT_SELECT_DIRECTORY_TO_SAVE_MAC_ACCESS_FILTER_FILE"));
            this.buttonExportDir.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file = WlanProfileACLDetailPanel.this.getExportFileChooser(WlanProfileACLDetailPanel.this.tabExport).directoryChooser();
                    if (file != null) {
                        WlanProfileACLDetailPanel.this.exportDirName = file.getAbsolutePath();
                        WlanProfileACLDetailPanel.this.buttonExport.setEnabled(true);
                    } else {
                        WlanProfileACLDetailPanel.this.exportDirName = null;
                        WlanProfileACLDetailPanel.this.buttonExport.setEnabled(false);
                    }
                    WlanProfileACLDetailPanel.this.textFieldExportDir.setText(WlanProfileACLDetailPanel.this.exportDirName);
                }
            });
        }
        return this.buttonExportDir;
    }

    private GuiUtilTextField getTextFieldExportDir() {
        if (this.textFieldExportDir == null) {
            this.textFieldExportDir = new GuiUtilTextField();
            this.textFieldExportDir.setBounds(170, 60, 425, 18);
            this.textFieldExportDir.setText(this.exportDirName);
            this.textFieldExportDir.setEnabled(false);
        }
        return this.textFieldExportDir;
    }

    private AastraButton getButtonExport() {
        if (this.buttonExport == null) {
            this.buttonExport = new AastraButton();
            this.buttonExport.setBounds(30, 135, 106, 25);
            this.buttonExport.setText(UtilLocale.getString("TXT_EXPORT_20"));
            this.buttonExport.setEnabled(false);
            this.buttonExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WlanProfileACLDetailPanel.this.writeExportFile();
                }
            });
        }
        return this.buttonExport;
    }

    private GuiUtilFileChooser getExportFileChooser(AastraPanel aastraPanel) {
        if (this.exportFileChooser == null) {
            this.exportFileChooser = new GuiUtilFileChooser(aastraPanel);
        }
        return this.exportFileChooser;
    }

    protected void setProfile(int n) {
        if (this.currentProfileId != n) {
            this.panelTable.remove(this.getScrollPaneACLTable(this.currentProfileId));
            this.currentProfileId = n;
            this.panelTable.add(this.getScrollPaneACLTable(this.currentProfileId));
            this.currentACLTable = this.scrollPaneACLTable[this.currentProfileId - 1].getTable();
            this.labelHeaderBar.setText(String.format("%s #%d - %s", UtilLocale.getString("TXT_WLAN_PROFILE"), this.currentProfileId, UtilLocale.getString("TXT_MAC_ACCESS_FILTER")));
        }
        this.configureInputFields();
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    public void markErrorComponent(String string) {
        JComponent jComponent;
        if (string != null && (jComponent = this.utilErrorComp.getField(string)) != null) {
            this.utilErrorComp.markComponent(jComponent);
        }
    }

    private void configureInputFields() {
        if (this.isEditable) {
            int[] nArray = this.currentACLTable.getSelectedRows();
            int n = nArray.length;
            if (this.currentACLTable.getRowCount() == 0) {
                if (this.panelTabbed.getSelectedIndex() == 2) {
                    this.panelTabbed.setSelectedIndex(0);
                }
                this.panelTabbed.setEnabledAt(2, false);
            } else {
                this.panelTabbed.setEnabledAt(2, true);
            }
            if (this.currentACLTable.getRowCount() == 512) {
                this.buttonCreateACLEntry.setEnabled(false);
            } else {
                this.buttonCreateACLEntry.setEnabled(true);
            }
            if (n == 0) {
                this.textFieldEthAddr.setEnabled(false);
                this.textFieldEthAddr.setText(null);
                this.textFieldName.setEnabled(false);
                this.textFieldName.setText(null);
                this.buttonConfigureACLEntry.setEnabled(false);
                this.buttonDeleteACLEntry.setEnabled(false);
            } else if (n == 1) {
                int n2 = this.currentACLTable.convertRowIndexToModel(nArray[0]);
                WLANProfileHandler.ACLEntry aCLEntry = this.wlanProfileHandler.getAclEntryByTableIdx(this.currentProfileId, n2);
                this.textFieldEthAddr.setEnabled(false);
                this.textFieldEthAddr.setText(aCLEntry.ethAddr);
                this.textFieldName.setEnabled(false);
                this.textFieldName.setText(aCLEntry.name);
                this.buttonConfigureACLEntry.setEnabled(true);
                this.buttonDeleteACLEntry.setEnabled(true);
            } else {
                this.textFieldEthAddr.setEnabled(false);
                this.textFieldEthAddr.setText(AastraCommon.AastraTriStateText);
                this.textFieldName.setEnabled(false);
                this.textFieldName.setText(AastraCommon.AastraTriStateText);
                this.buttonConfigureACLEntry.setEnabled(false);
                this.buttonDeleteACLEntry.setEnabled(true);
            }
            this.utilErrorComp.clearComponents();
            this.buttonOK.setEnabled(false);
        }
    }

    protected void processACLDataNotification(int n, DataNotificationEnum dataNotificationEnum, String string) {
        if (n == this.currentProfileId) {
            switch (dataNotificationEnum) {
                case NEW_DATA: 
                case DATA_CHANGED: 
                case DATA_DELETED: {
                    this.configureInputFields();
                    break;
                }
            }
        }
    }

    private void importACLFile() {
        int n;
        BufferedReader bufferedReader = null;
        this.aclImport = new WLANProfileHandler.ACLEntry[512];
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.importFileName), "UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Reading MAC access filter list file '" + this.importFileName + "' failed (unsupported encoding)");
            GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_IMPORT_OF_MAC_ACCESS_FILTER_FILE_*_FAILED"), this.importFileName));
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Reading ACL file '" + this.importFileName + "' failed (not found)");
            GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_IMPORT_OF_MAC_ACCESS_FILTER_FILE_*_FAILED"), this.importFileName));
            return;
        }
        try {
            n = this.processACLFile(bufferedReader);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Reading ACL file '" + this.importFileName + "' failed (IO exception)");
            GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_IMPORT_OF_MAC_ACCESS_FILTER_FILE_*_FAILED"), this.importFileName));
            return;
        }
        if (n == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "MAC access filter file import - no valid entries");
            GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_MAC_ACCESS_FILTER_FILE_*_CONTAINS_NO_VALID_ENTRIES"), this.importFileName));
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, String.format("MAC access filter file import successful - %d entries", n));
            GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_MAC_ACCESS_FILTER_FILE_*_WITH_*_VALID_ENTRIES_IMPORTED_SUCCESSFULLY"), this.importFileName, n));
            for (int i = 0; i < n; ++i) {
                this.wlanProfileMainPanel.createACLEntry(this.aclImport[i], this.currentProfileId);
            }
        }
    }

    private int processACLFile(BufferedReader bufferedReader) throws IOException {
        String string;
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (n < 512) {
                String[] stringArray = string.split(";", 2);
                if (UtilMisc.validateMACAddress(stringArray[0])) {
                    this.aclImport[n] = new WLANProfileHandler.ACLEntry();
                    this.aclImport[n].ethAddr = stringArray[0];
                    if (stringArray.length == 2) {
                        this.aclImport[n].name = stringArray[1];
                    }
                    ++n;
                    continue;
                }
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, String.format("MAC access filter file import - invalid entry mac: '%s'", stringArray[0]));
                continue;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "MAC access filter file import - too much entries");
            break;
        }
        return n;
    }

    private void writeExportFile() {
        BufferedWriter bufferedWriter = null;
        String string = this.exportDirName + File.separator + "export_mac_access_filter.csv";
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Exporting MAC access filter file to '" + string + "'");
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), Charset.forName("UTF8")));
        }
        catch (FileNotFoundException fileNotFoundException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "MAC access filter file  '" + string + "' failed (not found)");
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_MAC_ACCESS_FILTER_FILE_EXPORT_PATH_*_NOT_FOUND"), string));
            return;
        }
        try {
            this.writeACLToFile(bufferedWriter);
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "MAC access filter file  '" + string + "' failed (IO exception)");
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_EXPORT_OF_MAC_ACCESS_FILTER_TO_FILE_*_FAILED"), string));
            return;
        }
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "MAC access filter file export successful");
        GuiInfoConsole.showInfo(String.format(UtilLocale.getString("TXT_MAC_ACCESS_FILTER_FILE_*_EXPORTED_SUCCESSFULLY"), string));
    }

    private void writeACLToFile(BufferedWriter bufferedWriter) throws IOException {
        int n = this.wlanProfileHandler.getAclDb(this.currentProfileId).getRecordNumber();
        for (int i = 0; i < n; ++i) {
            WLANProfileHandler.ACLEntry aCLEntry = this.wlanProfileHandler.getAclEntryByTableIdx(this.currentProfileId, i);
            String string = aCLEntry.name.isEmpty() ? aCLEntry.ethAddr : String.format("%s;%s", aCLEntry.ethAddr, aCLEntry.name);
            bufferedWriter.write(string);
            bufferedWriter.newLine();
        }
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.configureInputFields();
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        int[] nArray;
        int n;
        if (this.isEditable && (n = (nArray = this.currentACLTable.getSelectedRows()).length) == 1) {
            int n2 = this.currentACLTable.convertRowIndexToModel(nArray[0]);
            WLANProfileHandler.ACLEntry aCLEntry = this.wlanProfileHandler.getAclEntryByTableIdx(this.currentProfileId, n2);
            this.textFieldEthAddr.setEnabled(false);
            this.textFieldEthAddr.setText(aCLEntry.ethAddr);
            this.textFieldName.setEnabled(true);
            this.textFieldName.setText(aCLEntry.name);
            this.buttonConfigureACLEntry.setEnabled(false);
            this.buttonDeleteACLEntry.setEnabled(true);
            this.buttonOK.setSelected(false);
            this.createMode = false;
            this.utilErrorComp.clearComponents();
        }
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.configureInputFields();
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
    }

    protected void setDefaultTab() {
        this.panelTabbed.setFirstTab();
    }

    private class ScrollPaneACLTable
    extends AastraScrollPane {
        private static final long serialVersionUID = 1L;
        private ConfiguratorTable table;

        private ScrollPaneACLTable(ConfiguratorTable configuratorTable) {
            super(configuratorTable);
            this.table = configuratorTable;
            this.setVerticalScrollBarPolicy(22);
        }

        private ConfiguratorTable getTable() {
            return this.table;
        }
    }
}

