/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.wlan;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.guiutil.GuiUtilButton;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilDetailPanel;
import com.aastra.oamp.guiutil.GuiUtilTextFieldFS;
import com.aastra.oamp.guiutil.GuiUtilTextFieldFSGuiMode;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.util.UtilSetPanelEditable;
import com.aastra.oamp.wlan.WlanProfileMainPanel;
import com.aastra.oamp.wlan.WlanProfileSSIDGeneralDetailPanel;
import com.aastra.oamp.wlan.WlanProfileSSIDSecurityDetailPanel;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.WLANProfileHandler;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class WlanProfileDetailPanel
extends GuiUtilDetailPanel {
    private static final long serialVersionUID = 1L;
    private static final int MAX_SSID = 4;
    private WlanProfileMainPanel wlanProfileMainPanel = null;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private UtilErrorComp utilErrorComp = null;
    private WLANProfileHandler.WLANProfile backupProfile = null;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraPanel tabGeneral = null;
    private GuiUtilCheckBox checkBoxProfileActive = null;
    private GuiUtilTextFieldFS textFieldNumberRFPs = null;
    private GuiUtilCheckBox checkBoxInterferenceAvoidance = null;
    private GuiUtilComboBox comboBoxProfileType = null;
    private GuiUtilComboBox comboBoxModeType = null;
    private boolean comboBoxModeTypeActionListenerActive = false;
    private GuiUtilCheckBox checkBoxWME = null;
    private GuiUtilComboBox comboBoxQoSType = null;
    private GuiUtilComboBox comboBoxMaxRateType = null;
    private GuiUtilTextFieldFS textFieldBeaconInterval = null;
    private GuiUtilTextFieldFS textFieldDTIMInterval = null;
    private GuiUtilTextFieldFS textFieldRTSThreshold = null;
    private GuiUtilTextFieldFS textFieldFragmentationThreshold = null;
    private AastraPanel tabSSIDSelection = null;
    private AastraLabel[] labelSSIDx = new AastraLabel[4];
    private GuiUtilCheckBox[] checkBoxSSIDInUse = new GuiUtilCheckBox[4];
    private GuiUtilTextFieldFSGuiMode[] textFieldSSIDName = new GuiUtilTextFieldFSGuiMode[4];
    private WlanProfileSSIDGeneralDetailPanel[] tabSSIDGeneral = null;
    private WlanProfileSSIDSecurityDetailPanel[] tabSSIDSecurity = null;
    private boolean isEditable = true;

    public WlanProfileDetailPanel(WlanProfileMainPanel wlanProfileMainPanel, UtilErrorComp utilErrorComp) {
        super(400, 220);
        this.wlanProfileMainPanel = wlanProfileMainPanel;
        this.utilErrorComp = utilErrorComp;
        this.initialize();
    }

    private void initialize() {
        if (this.wlanProfileMainPanel.isGuiNavPanelTypeConfig()) {
            this.utilChangeHandler = new GuiUtilChangeHandler(this.getButtonOK(), this.getButtonCancel(), false);
        } else {
            this.isEditable = false;
        }
        this.panelTabbed.addTab(UtilLocale.getString("TXT_GENERAL_20"), null, this.getTabGeneral(UtilLocale.getString("TXT_GENERAL_20")), null);
        this.panelTabbed.addTab(UtilLocale.getString("TXT_SSID_SELECTION_20"), null, this.getTabSSIDSelection(UtilLocale.getString("TXT_SSID_SELECTION_20")), null);
        this.panelTabbed.addTab(String.format(UtilLocale.getString("TXT_SSID_*_GENERAL_20"), 1), null, this.getTabSSIDGeneral(0), null);
        this.panelTabbed.addTab(String.format(UtilLocale.getString("TXT_SSID_*_SECURITY_20"), 1), null, this.getSSIDSecurity(0).getPanelSecurity(), null);
        this.panelTabbed.setEnabledAt(3, false);
        if (this.isEditable) {
            this.panelButtonBar.add((Component)this.getButtonOK(), null);
        }
        this.panelButtonBar.add((Component)this.getButtonCancel(), null);
    }

    protected WlanProfileMainPanel getWlanProfileMainPanel() {
        return this.wlanProfileMainPanel;
    }

    protected AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = GuiUtilButton.ButtonOK(70, 15);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WlanProfileDetailPanel.this.utilChangeHandler.deactivate();
                    WlanProfileDetailPanel.this.utilErrorComp.clearComponents();
                    if (WlanProfileDetailPanel.this.backupProfile == null) {
                        WlanProfileDetailPanel.this.wlanProfileMainPanel.createWlanProfile();
                    } else {
                        WlanProfileDetailPanel.this.wlanProfileMainPanel.changeWlanProfile();
                    }
                }
            });
        }
        return this.buttonOK;
    }

    protected AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = this.isEditable ? GuiUtilButton.ButtonCancel(230, 15) : GuiUtilButton.ButtonCancel(120, 15);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (WlanProfileDetailPanel.this.isEditable) {
                        WlanProfileDetailPanel.this.utilChangeHandler.deactivate();
                    }
                    WlanProfileDetailPanel.this.wlanProfileMainPanel.removeWlanProfileDetailPanel();
                }
            });
        }
        return this.buttonCancel;
    }

    private AastraPanel getTabGeneral(String string) {
        if (this.tabGeneral == null) {
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(null);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(30, 30, 170, 16);
            aastraLabel.setText(UtilLocale.getString("TXT_PROFILE_ENABLED"));
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(30, 60, 170, 16);
            aastraLabel2.setText(UtilLocale.getString("TXT_AVOID_INTERFERENCES"));
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setBounds(280, 30, 170, 16);
            aastraLabel3.setText(UtilLocale.getString("TXT_PROFILE_TYPE"));
            AastraLabel aastraLabel4 = new AastraLabel();
            aastraLabel4.setBounds(280, 60, 170, 16);
            aastraLabel4.setText(UtilLocale.getString("TXT_802_11_MODE_TYPE"));
            AastraLabel aastraLabel5 = new AastraLabel();
            aastraLabel5.setBounds(280, 90, 170, 16);
            aastraLabel5.setText(UtilLocale.getString("TXT_WME"));
            AastraLabel aastraLabel6 = new AastraLabel();
            aastraLabel6.setBounds(280, 120, 170, 16);
            aastraLabel6.setText(UtilLocale.getString("TXT_MAX_BIT_RATE"));
            AastraLabel aastraLabel7 = new AastraLabel();
            aastraLabel7.setBounds(525, 120, 100, 16);
            aastraLabel7.setText(UtilLocale.getString("TXT_UNIT_MBPS"));
            AastraLabel aastraLabel8 = new AastraLabel();
            aastraLabel8.setBounds(280, 150, 170, 16);
            aastraLabel8.setText(UtilLocale.getString("TXT_BEACON_INTERVAL"));
            AastraLabel aastraLabel9 = new AastraLabel();
            aastraLabel9.setBounds(525, 150, 100, 16);
            aastraLabel9.setText(UtilLocale.getString("TXT_UNIT_MILLISECOND"));
            AastraLabel aastraLabel10 = new AastraLabel();
            aastraLabel10.setBounds(280, 180, 170, 16);
            aastraLabel10.setText(UtilLocale.getString("TXT_DTIM_INTERVAL"));
            AastraLabel aastraLabel11 = new AastraLabel();
            aastraLabel11.setBounds(525, 180, 100, 16);
            aastraLabel11.setText(UtilLocale.getString("TXT_BEACONS"));
            AastraLabel aastraLabel12 = new AastraLabel();
            aastraLabel12.setBounds(280, 210, 170, 16);
            aastraLabel12.setText(UtilLocale.getString("TXT_RTS_THRESHOLD"));
            AastraLabel aastraLabel13 = new AastraLabel();
            aastraLabel13.setBounds(525, 210, 100, 16);
            aastraLabel13.setText(UtilLocale.getString("TXT_BYTES"));
            AastraLabel aastraLabel14 = new AastraLabel();
            aastraLabel14.setBounds(280, 240, 170, 16);
            aastraLabel14.setText(UtilLocale.getString("TXT_FRAGMENTATION_THRESHOLD"));
            AastraLabel aastraLabel15 = new AastraLabel();
            aastraLabel15.setBounds(525, 240, 100, 16);
            aastraLabel15.setText(UtilLocale.getString("TXT_BYTES"));
            this.tabGeneral.add(aastraLabel);
            this.tabGeneral.add(this.getCheckBoxProfileActive());
            this.tabGeneral.add(aastraLabel2);
            this.tabGeneral.add(this.getCheckBoxInterferenceAvoidance());
            if (!this.isEditable) {
                AastraLabel aastraLabel16 = new AastraLabel();
                aastraLabel16.setBounds(30, 90, 170, 16);
                aastraLabel16.setText(UtilLocale.getString("TXT_RADIO_FIXED_PARTS"));
                this.tabGeneral.add(aastraLabel16);
                this.tabGeneral.add(this.getTextFieldNumberRFPS());
            }
            this.tabGeneral.add(aastraLabel3);
            this.tabGeneral.add(this.getComboBoxProfileType());
            this.tabGeneral.add(aastraLabel4);
            this.tabGeneral.add(this.getComboBoxModeType());
            this.tabGeneral.add(aastraLabel5);
            this.tabGeneral.add(this.getCheckBoxWME());
            this.tabGeneral.add(this.getComboBoxQoSType());
            this.tabGeneral.add(aastraLabel6);
            this.tabGeneral.add(this.getComboBoxMaxRateType());
            this.tabGeneral.add(aastraLabel7);
            this.tabGeneral.add(aastraLabel8);
            this.tabGeneral.add(this.getTextFieldBeaconInterval());
            this.tabGeneral.add(aastraLabel9);
            this.tabGeneral.add(aastraLabel10);
            this.tabGeneral.add(this.getTextFieldDTIMInterval());
            this.tabGeneral.add(aastraLabel11);
            this.tabGeneral.add(aastraLabel12);
            this.tabGeneral.add(this.getTextFieldRTSThreshold());
            this.tabGeneral.add(aastraLabel13);
            this.tabGeneral.add(aastraLabel14);
            this.tabGeneral.add(this.getTextFieldFragmentationThreshold());
            this.tabGeneral.add(aastraLabel15);
            if (this.isEditable) {
                this.utilErrorComp.putWithTabTitle(OmiMessage.WLANProfileType.mode.name(), aastraLabel4, this.comboBoxModeType, string);
                this.utilErrorComp.putWithTabTitle(OmiMessage.WLANProfileType.beaconIntval.name(), aastraLabel8, this.textFieldBeaconInterval, string);
                this.utilErrorComp.putWithTabTitle(OmiMessage.WLANProfileType.dtimIntval.name(), aastraLabel10, this.textFieldDTIMInterval, string);
                this.utilErrorComp.putWithTabTitle(OmiMessage.WLANProfileType.rtsThreshold.name(), aastraLabel12, this.textFieldRTSThreshold, string);
                this.utilErrorComp.putWithTabTitle(OmiMessage.WLANProfileType.fragThreshold.name(), aastraLabel14, this.textFieldFragmentationThreshold, string);
            } else {
                UtilSetPanelEditable.setDisabled(this.tabGeneral);
            }
        }
        return this.tabGeneral;
    }

    private GuiUtilCheckBox getCheckBoxProfileActive() {
        if (this.checkBoxProfileActive == null) {
            this.checkBoxProfileActive = new GuiUtilCheckBox(this.utilChangeHandler, 215, 30);
            this.checkBoxProfileActive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WlanProfileDetailPanel.this.tabSSIDGeneral[0].setCheckBoxActive(((GuiUtilCheckBox)actionEvent.getSource()).isSelected());
                }
            });
        }
        return this.checkBoxProfileActive;
    }

    private GuiUtilCheckBox getCheckBoxInterferenceAvoidance() {
        if (this.checkBoxInterferenceAvoidance == null) {
            this.checkBoxInterferenceAvoidance = new GuiUtilCheckBox(this.utilChangeHandler, 215, 60);
            this.checkBoxInterferenceAvoidance.setEnabled(false);
        }
        return this.checkBoxInterferenceAvoidance;
    }

    private GuiUtilTextFieldFS getTextFieldNumberRFPS() {
        if (this.textFieldNumberRFPs == null) {
            this.textFieldNumberRFPs = new GuiUtilTextFieldFS(215, 90, AastraCommon.TextFieldSizeType.xs);
            this.textFieldNumberRFPs.setEditable(false);
            this.textFieldNumberRFPs.setToolTipText(UtilLocale.getString("TXT_NUMBER_OF_WLAN_ACTIVATED_RFPS_ASSIGNED_TO_THIS_PROFILE"));
        }
        return this.textFieldNumberRFPs;
    }

    private GuiUtilComboBox getComboBoxProfileType() {
        if (this.comboBoxProfileType == null) {
            this.comboBoxProfileType = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxProfileType.setBounds(460, 30, 80, 20);
            for (int i = 0; i < OmiMessage.WLANProfileRFPType.values().length; ++i) {
                this.comboBoxProfileType.addItem(OmiMessage.WLANProfileRFPType.values()[i]);
            }
            this.comboBoxProfileType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WlanProfileDetailPanel.this.configureRFPTypeRelatedInputFields();
                    if (WlanProfileDetailPanel.this.isEditable) {
                        WlanProfileDetailPanel.this.configureWME();
                    }
                }
            });
            this.comboBoxProfileType.activateActionListener();
        }
        return this.comboBoxProfileType;
    }

    private GuiUtilComboBox getComboBoxModeType() {
        if (this.comboBoxModeType == null) {
            this.comboBoxModeType = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxModeType.setBounds(460, 60, 100, 20);
            this.comboBoxModeType.activateActionListener();
            this.comboBoxModeType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (WlanProfileDetailPanel.this.comboBoxModeTypeActionListenerActive) {
                        WlanProfileDetailPanel.this.configureSecurityWEP();
                        if (WlanProfileDetailPanel.this.isEditable) {
                            WlanProfileDetailPanel.this.configureWME();
                            WlanProfileDetailPanel.this.configureSecurityFromModeType();
                        }
                    }
                }
            });
            this.comboBoxModeTypeActionListenerActive = true;
        }
        return this.comboBoxModeType;
    }

    private GuiUtilCheckBox getCheckBoxWME() {
        if (this.checkBoxWME == null) {
            this.checkBoxWME = new GuiUtilCheckBox(this.utilChangeHandler, 460, 90);
            if (this.isEditable) {
                this.checkBoxWME.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (OmiMessage.WLANProfileRFPType.valueOf(WlanProfileDetailPanel.this.comboBoxProfileType.getSelectedItem().toString()) == OmiMessage.WLANProfileRFPType.RFP42) {
                            if (WlanProfileDetailPanel.this.checkBoxWME.isSelected()) {
                                WlanProfileDetailPanel.this.comboBoxQoSType.removeAllItems();
                                WlanProfileDetailPanel.this.comboBoxQoSType.addItem(OmiMessage.WMEQoSType.WME_DiffServ);
                                if (WlanProfileDetailPanel.this.tabSSIDGeneral[0].isCheckBoxVLANTagSelected()) {
                                    WlanProfileDetailPanel.this.comboBoxQoSType.addItem(OmiMessage.WMEQoSType.WME_VLAN);
                                }
                                WlanProfileDetailPanel.this.comboBoxQoSType.setSelectedItem((Object)OmiMessage.WMEQoSType.WME_DiffServ);
                                WlanProfileDetailPanel.this.comboBoxQoSType.setEnabled(true);
                            } else {
                                WlanProfileDetailPanel.this.comboBoxQoSType.setSelectedItem(null);
                                WlanProfileDetailPanel.this.comboBoxQoSType.setEnabled(false);
                            }
                        }
                    }
                });
            }
        }
        return this.checkBoxWME;
    }

    private GuiUtilComboBox getComboBoxQoSType() {
        if (this.comboBoxQoSType == null) {
            this.comboBoxQoSType = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxQoSType.setBounds(490, 90, 80, 20);
            this.comboBoxQoSType.activateActionListener();
        }
        return this.comboBoxQoSType;
    }

    private GuiUtilComboBox getComboBoxMaxRateType() {
        if (this.comboBoxMaxRateType == null) {
            this.comboBoxMaxRateType = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxMaxRateType.setBounds(460, 120, 60, 20);
            for (int i = 0; i < OmiMessage.WLANMaxRateType.values().length; ++i) {
                this.comboBoxMaxRateType.addItem(OmiMessage.WLANMaxRateType.values()[i]);
            }
            this.comboBoxMaxRateType.setEnabled(false);
            this.comboBoxMaxRateType.activateActionListener();
        }
        return this.comboBoxMaxRateType;
    }

    private GuiUtilTextFieldFS getTextFieldBeaconInterval() {
        if (this.textFieldBeaconInterval == null) {
            this.textFieldBeaconInterval = new GuiUtilTextFieldFS(460, 150, AastraCommon.TextFieldSizeType.xs, this.utilChangeHandler);
            this.textFieldBeaconInterval.setToolTipText(UtilLocale.getString("TXT_BEACON_INTERVAL_HELP"));
        }
        return this.textFieldBeaconInterval;
    }

    private GuiUtilTextFieldFS getTextFieldDTIMInterval() {
        if (this.textFieldDTIMInterval == null) {
            this.textFieldDTIMInterval = new GuiUtilTextFieldFS(460, 180, AastraCommon.TextFieldSizeType.xs, this.utilChangeHandler);
            this.textFieldDTIMInterval.setToolTipText(UtilLocale.getString("TXT_DTIM_INTERVAL_HELP"));
        }
        return this.textFieldDTIMInterval;
    }

    private GuiUtilTextFieldFS getTextFieldRTSThreshold() {
        if (this.textFieldRTSThreshold == null) {
            this.textFieldRTSThreshold = new GuiUtilTextFieldFS(460, 210, AastraCommon.TextFieldSizeType.xs, this.utilChangeHandler);
        }
        return this.textFieldRTSThreshold;
    }

    private GuiUtilTextFieldFS getTextFieldFragmentationThreshold() {
        if (this.textFieldFragmentationThreshold == null) {
            this.textFieldFragmentationThreshold = new GuiUtilTextFieldFS(460, 240, AastraCommon.TextFieldSizeType.xs, this.utilChangeHandler);
        }
        return this.textFieldFragmentationThreshold;
    }

    private void configureRFPTypeRelatedInputFields() {
        this.comboBoxModeTypeActionListenerActive = false;
        OmiMessage.WLANProfileRFPType wLANProfileRFPType = OmiMessage.WLANProfileRFPType.valueOf(this.comboBoxProfileType.getSelectedItem().toString());
        if (this.comboBoxProfileType.getSelectedItem() != null) {
            this.comboBoxModeType.removeAllItems();
            if (wLANProfileRFPType == OmiMessage.WLANProfileRFPType.RFP43) {
                for (int i = 0; i < OmiMessage.WLANModeType.values().length; ++i) {
                    this.comboBoxModeType.addItem(OmiMessage.WLANModeType.values()[i]);
                }
                this.comboBoxModeType.setSelectedItem((Object)OmiMessage.WLANModeType.N);
                this.checkBoxInterferenceAvoidance.setEnabled(false);
                this.checkBoxInterferenceAvoidance.setSelected(false);
                this.comboBoxMaxRateType.setSelectedItem(null);
                this.comboBoxMaxRateType.setEnabled(false);
                this.textFieldFragmentationThreshold.setToolTipText(String.format(UtilLocale.getString("TXT_FRAGMENTATION_THRESHOLD_HELP_*"), 256, 2346));
                this.textFieldRTSThreshold.setToolTipText(String.format(UtilLocale.getString("TXT_RTS_THRESHOLD_HELP_*"), 0, 2347));
            } else {
                this.comboBoxModeType.addItem(OmiMessage.WLANModeType.B);
                this.comboBoxModeType.addItem(OmiMessage.WLANModeType.G);
                this.comboBoxModeType.addItem(OmiMessage.WLANModeType.BG);
                this.comboBoxModeType.setSelectedItem((Object)OmiMessage.WLANModeType.BG);
                this.checkBoxInterferenceAvoidance.setEnabled(true);
                this.checkBoxInterferenceAvoidance.setSelected(false);
                if (this.isEditable) {
                    this.comboBoxMaxRateType.setEnabled(true);
                }
                this.comboBoxMaxRateType.setSelectedItem((Object)OmiMessage.WLANMaxRateType.RATE_54000);
                this.textFieldFragmentationThreshold.setToolTipText(String.format(UtilLocale.getString("TXT_FRAGMENTATION_THRESHOLD_HELP_*"), 0, 4096));
                this.textFieldRTSThreshold.setToolTipText(String.format(UtilLocale.getString("TXT_RTS_THRESHOLD_HELP_*"), 0, 4096));
            }
            this.configureSecurityWEP();
        }
        OmiMessage.WLANModeType wLANModeType = OmiMessage.WLANModeType.guiValueToEnum(this.comboBoxModeType.getSelectedItem().toString());
        for (int i = 0; i < 4; ++i) {
            if (!this.checkBoxSSIDInUse[i].isSelected()) continue;
            if (i > 0) {
                this.tabSSIDGeneral[i].setProfileRFPTypeDependencies(wLANProfileRFPType);
            }
            this.tabSSIDSecurity[i].setProfileRFPTypeDependencies(wLANProfileRFPType);
            this.tabSSIDSecurity[i].setModeTypeDependencies(wLANModeType);
        }
        this.comboBoxModeTypeActionListenerActive = true;
    }

    private void configureSecurityWEP() {
        boolean bl = true;
        if (OmiMessage.WLANModeType.guiValueToEnum(this.comboBoxModeType.getSelectedItem().toString()) == OmiMessage.WLANModeType.N) {
            bl = false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.tabSSIDGeneral[i] == null) continue;
            this.tabSSIDGeneral[i].updateSecurityWEP(bl);
        }
    }

    private void configureSecurityFromModeType() {
        OmiMessage.WLANModeType wLANModeType = OmiMessage.WLANModeType.guiValueToEnum(this.comboBoxModeType.getSelectedItem().toString());
        for (int i = 0; i < 4; ++i) {
            if (this.tabSSIDSecurity[i] == null) continue;
            this.tabSSIDSecurity[i].setModeTypeDependencies(wLANModeType);
        }
    }

    protected void configureWME() {
        if (this.comboBoxProfileType.getSelectedItem() != null) {
            if (OmiMessage.WLANProfileRFPType.valueOf(this.comboBoxProfileType.getSelectedItem().toString()) == OmiMessage.WLANProfileRFPType.RFP43) {
                this.comboBoxQoSType.setSelectedItem(null);
                this.comboBoxQoSType.setEnabled(false);
                if (OmiMessage.WLANModeType.guiValueToEnum(this.comboBoxModeType.getSelectedItem().toString()) == OmiMessage.WLANModeType.N) {
                    this.checkBoxWME.setSelected(true);
                    this.checkBoxWME.setEnabled(false);
                } else {
                    this.checkBoxWME.setSelected(false);
                    this.checkBoxWME.setEnabled(true);
                }
            } else {
                this.comboBoxQoSType.setSelectedItem((Object)OmiMessage.WMEQoSType.WME_DiffServ);
                this.comboBoxQoSType.setEnabled(true);
                this.checkBoxWME.setSelected(false);
                this.checkBoxWME.setEnabled(true);
            }
        }
    }

    protected void configureWMEDependencyVLAN(boolean bl) {
        if (this.comboBoxProfileType.getSelectedItem() != null && OmiMessage.WLANProfileRFPType.valueOf(this.comboBoxProfileType.getSelectedItem().toString()) == OmiMessage.WLANProfileRFPType.RFP42) {
            this.comboBoxQoSType.removeAllItems();
            this.comboBoxQoSType.addItem(OmiMessage.WMEQoSType.WME_DiffServ);
            if (bl) {
                this.comboBoxQoSType.addItem(OmiMessage.WMEQoSType.WME_VLAN);
            }
            this.comboBoxQoSType.setSelectedItem((Object)OmiMessage.WMEQoSType.WME_DiffServ);
        }
    }

    private AastraPanel getTabSSIDSelection(String string) {
        if (this.tabSSIDSelection == null) {
            AastraLabel aastraLabel = null;
            this.tabSSIDSelection = new AastraPanel();
            this.tabSSIDSelection.setLayout(null);
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(125, 15, 100, 16);
            aastraLabel2.setText(UtilLocale.getString("TXT_CONFIGURE"));
            aastraLabel = new AastraLabel();
            aastraLabel.setBounds(235, 15, 100, 16);
            aastraLabel.setText(UtilLocale.getString("TXT_NAME"));
            this.tabSSIDSelection.add(aastraLabel2);
            this.tabSSIDSelection.add(aastraLabel);
            this.labelSSIDx = new AastraLabel[4];
            this.checkBoxSSIDInUse = new GuiUtilCheckBox[4];
            this.textFieldSSIDName = new GuiUtilTextFieldFSGuiMode[4];
            for (int i = 0; i < 4; ++i) {
                this.labelSSIDx[i] = new AastraLabel();
                this.labelSSIDx[i].setBounds(30, 45 + i * 30, 70, 16);
                this.labelSSIDx[i].setText(String.format(UtilLocale.getString("TXT_SSID_*"), i + 1));
                this.checkBoxSSIDInUse[i] = this.getCheckBoxSSIDInUse(i);
                this.textFieldSSIDName[i] = this.getTextFieldSSIDName(i);
                this.tabSSIDSelection.add(this.labelSSIDx[i]);
                this.tabSSIDSelection.add(this.checkBoxSSIDInUse[i]);
                this.tabSSIDSelection.add(this.textFieldSSIDName[i]);
                if (!this.isEditable) continue;
                this.utilErrorComp.putWithTabTitle(OmiMessage.SSIDProfileType.ssid.name() + (i + 1), this.labelSSIDx[i], this.textFieldSSIDName[i], string);
            }
            this.checkBoxSSIDInUse[0].setSelected(true);
            this.checkBoxSSIDInUse[0].setEnabled(false);
            this.textFieldSSIDName[0].setEditable(true);
            if (!this.isEditable) {
                UtilSetPanelEditable.setDisabled(this.tabSSIDSelection);
            }
        }
        return this.tabSSIDSelection;
    }

    private GuiUtilCheckBox getCheckBoxSSIDInUse(final int n) {
        if (this.checkBoxSSIDInUse[n] == null) {
            this.checkBoxSSIDInUse[n] = new GuiUtilCheckBox(this.utilChangeHandler, 125, 45 + n * 30);
            if (n > 0) {
                this.checkBoxSSIDInUse[n].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (((GuiUtilCheckBox)actionEvent.getSource()).isSelected()) {
                            WlanProfileDetailPanel.this.textFieldSSIDName[n].setEditable(true);
                            WlanProfileDetailPanel.this.insertTabSSIDx(n);
                        } else {
                            WlanProfileDetailPanel.this.textFieldSSIDName[n].setText(null);
                            WlanProfileDetailPanel.this.textFieldSSIDName[n].setEditable(false);
                            WlanProfileDetailPanel.this.removeTabSSIDx(n);
                        }
                    }
                });
            }
        }
        return this.checkBoxSSIDInUse[n];
    }

    private GuiUtilTextFieldFSGuiMode getTextFieldSSIDName(int n) {
        if (this.textFieldSSIDName[n] == null) {
            this.textFieldSSIDName[n] = new GuiUtilTextFieldFSGuiMode(235, 45 + n * 30, AastraCommon.TextFieldSizeType.m, this.utilChangeHandler, this.isEditable);
            this.textFieldSSIDName[n].setEditable(false);
        }
        return this.textFieldSSIDName[n];
    }

    private WlanProfileSSIDGeneralDetailPanel getTabSSIDGeneral(int n) {
        if (this.tabSSIDGeneral == null) {
            this.tabSSIDGeneral = new WlanProfileSSIDGeneralDetailPanel[4];
        }
        if (this.tabSSIDGeneral[n] == null) {
            String string = String.format(UtilLocale.getString("TXT_SSID_*_GENERAL_20"), n + 1);
            this.tabSSIDGeneral[n] = new WlanProfileSSIDGeneralDetailPanel(this, n, string, this.utilChangeHandler, this.isEditable);
        }
        if (!this.isEditable) {
            UtilSetPanelEditable.setDisabled(this.tabSSIDGeneral[n]);
        }
        return this.tabSSIDGeneral[n];
    }

    private WlanProfileSSIDSecurityDetailPanel getSSIDSecurity(int n) {
        if (this.tabSSIDSecurity == null) {
            this.tabSSIDSecurity = new WlanProfileSSIDSecurityDetailPanel[4];
        }
        if (this.tabSSIDSecurity[n] == null) {
            String string = String.format(UtilLocale.getString("TXT_SSID_*_SECURITY_20"), n + 1);
            this.tabSSIDSecurity[n] = new WlanProfileSSIDSecurityDetailPanel(this, n, string, this.utilChangeHandler, this.isEditable);
        }
        if (!this.isEditable) {
            UtilSetPanelEditable.setDisabled(this.tabSSIDSecurity[n].getPanelSecurity());
        }
        return this.tabSSIDSecurity[n];
    }

    private Integer getTabPosByTitle(String string) {
        for (int i = this.panelTabbed.getTabCount() - 1; i >= 0; --i) {
            if (!string.equals(this.panelTabbed.getTitleAt(i))) continue;
            return i;
        }
        return null;
    }

    private void insertTabSSIDx(int n) {
        int n2 = this.panelTabbed.getTabCount();
        if (n2 > 4) {
            for (int i = 4; i < n2; ++i) {
                String string = this.panelTabbed.getTitleAt(i);
                if (string.compareTo(String.format(UtilLocale.getString("TXT_SSID_*_GENERAL_20"), n + 1)) <= 0) continue;
                this.panelTabbed.insertTab(String.format(UtilLocale.getString("TXT_SSID_*_GENERAL_20"), n + 1), null, this.getTabSSIDGeneral(n), null, i);
                this.panelTabbed.insertTab(String.format(UtilLocale.getString("TXT_SSID_*_SECURITY_20"), n + 1), null, this.getSSIDSecurity(n).getPanelSecurity(), null, i + 1);
                this.panelTabbed.setEnabledAt(i + 1, false);
                this.prepareTabsSSIDx(n);
                return;
            }
        }
        this.panelTabbed.addTab(String.format(UtilLocale.getString("TXT_SSID_*_GENERAL_20"), n + 1), null, this.getTabSSIDGeneral(n), null);
        this.panelTabbed.addTab(String.format(UtilLocale.getString("TXT_SSID_*_SECURITY_20"), n + 1), null, this.getSSIDSecurity(n).getPanelSecurity(), null);
        this.panelTabbed.setEnabledAt(5, false);
        this.prepareTabsSSIDx(n);
    }

    private void prepareTabsSSIDx(int n) {
        OmiMessage.WLANModeType wLANModeType = OmiMessage.WLANModeType.guiValueToEnum(this.comboBoxModeType.getSelectedItem().toString());
        this.tabSSIDGeneral[n].setProfileRFPTypeDependencies(OmiMessage.WLANProfileRFPType.valueOf(this.comboBoxProfileType.getSelectedItem().toString()));
        this.configureSecurityWEP();
        this.tabSSIDSecurity[n].setProfileRFPTypeDependencies(OmiMessage.WLANProfileRFPType.valueOf(this.comboBoxProfileType.getSelectedItem().toString()));
        this.tabSSIDSecurity[n].setModeTypeDependencies(wLANModeType);
        this.tabSSIDGeneral[n].setData(null);
        this.tabSSIDSecurity[n].setData(null);
    }

    private void removeTabSSIDx(int n) {
        Integer n2 = this.getTabPosByTitle(String.format(UtilLocale.getString("TXT_SSID_*_GENERAL_20"), n + 1));
        if (n2 != null) {
            this.panelTabbed.removeTabAt(n2 + 1);
            this.panelTabbed.removeTabAt(n2);
        }
    }

    protected void configureTabSecurity(int n, OmiMessage.WLANSecurityType wLANSecurityType) {
        if (this.tabSSIDSecurity[n] != null) {
            String string = String.format(UtilLocale.getString("TXT_SSID_*_SECURITY_20"), n + 1);
            Integer n2 = this.getTabPosByTitle(string);
            this.tabSSIDSecurity[n].setSecurityType(wLANSecurityType);
            if (n2 != null) {
                boolean bl = true;
                if (wLANSecurityType == OmiMessage.WLANSecurityType.Open) {
                    bl = false;
                }
                this.panelTabbed.removeTabAt(n2);
                this.panelTabbed.insertTab(string, null, this.getSSIDSecurity(n).getPanelSecurity(), null, n2);
                this.panelTabbed.setEnabledAt(n2, bl);
            }
        }
    }

    protected void setWlanProfileData(WLANProfileHandler.WLANProfile wLANProfile) {
        if (wLANProfile != null) {
            this.backupProfile = wLANProfile;
            this.labelHeaderBar.setText(String.format("%s #%d", UtilLocale.getString("TXT_WLAN_PROFILE"), wLANProfile.id));
            this.comboBoxProfileType.deactivateActionListener();
            this.comboBoxProfileType.setSelectedItem((Object)wLANProfile.profileType);
            this.comboBoxProfileType.activateActionListener();
            this.checkBoxProfileActive.setSelected(wLANProfile.enable);
            if (!this.isEditable) {
                this.textFieldNumberRFPs.setText(String.valueOf(wLANProfile.numberRFPs));
            }
            if (wLANProfile.profileType == OmiMessage.WLANProfileRFPType.RFP42) {
                this.checkBoxInterferenceAvoidance.setEnabled(true);
                this.checkBoxInterferenceAvoidance.setSelected(wLANProfile.interferenceAvoidance);
            } else {
                this.checkBoxInterferenceAvoidance.setEnabled(false);
                this.checkBoxInterferenceAvoidance.setSelected(false);
            }
            this.comboBoxModeType.deactivateActionListener();
            this.comboBoxModeType.setSelectedItem((Object)wLANProfile.mode);
            this.comboBoxModeType.activateActionListener();
            this.comboBoxQoSType.deactivateActionListener();
            if (wLANProfile.qos != null) {
                switch (wLANProfile.qos) {
                    case None: {
                        this.checkBoxWME.setSelected(false);
                        this.comboBoxQoSType.setSelectedItem(null);
                        this.comboBoxQoSType.setEnabled(false);
                        break;
                    }
                    case WME: {
                        this.checkBoxWME.setSelected(true);
                        this.comboBoxQoSType.setSelectedItem(null);
                        this.comboBoxQoSType.setEnabled(false);
                        break;
                    }
                    case WME_VLAN: 
                    case WME_DiffServ: {
                        this.comboBoxQoSType.removeAllItems();
                        this.comboBoxQoSType.addItem(OmiMessage.WMEQoSType.WME_DiffServ);
                        if (wLANProfile.ssidProfiles[0] != null && wLANProfile.ssidProfiles[0].vlanTag != 0) {
                            this.comboBoxQoSType.addItem(OmiMessage.WMEQoSType.WME_VLAN);
                        }
                        this.checkBoxWME.setSelected(true);
                        this.comboBoxQoSType.setSelectedItem((Object)wLANProfile.qos);
                        if (this.isEditable) {
                            this.comboBoxQoSType.setEnabled(true);
                            break;
                        }
                        this.comboBoxQoSType.setEnabled(false);
                    }
                }
            } else {
                this.checkBoxWME.setSelected(false);
                this.comboBoxQoSType.setSelectedItem(null);
                this.comboBoxQoSType.setEnabled(false);
            }
            this.comboBoxQoSType.activateActionListener();
            if (wLANProfile.profileType == OmiMessage.WLANProfileRFPType.RFP42) {
                this.comboBoxMaxRateType.deactivateActionListener();
                this.comboBoxMaxRateType.setSelectedItem((Object)wLANProfile.maxRate);
                this.comboBoxMaxRateType.activateActionListener();
            } else {
                this.comboBoxMaxRateType.setSelectedItem(null);
            }
            this.textFieldBeaconInterval.setText(String.valueOf(wLANProfile.beaconInterval));
            this.textFieldDTIMInterval.setText(String.valueOf(wLANProfile.dtimInterval));
            this.textFieldRTSThreshold.setText(String.valueOf(wLANProfile.rtsThreshold));
            this.textFieldFragmentationThreshold.setText(String.valueOf(wLANProfile.fragThreshold));
            if (wLANProfile.ssidProfiles[0] != null && wLANProfile.ssidProfiles[0].ssid != null && wLANProfile.ssidProfiles[0].ssid.length() > 0) {
                this.textFieldSSIDName[0].setText(wLANProfile.ssidProfiles[0].ssid);
                this.tabSSIDGeneral[0].setData(wLANProfile.ssidProfiles[0]);
                this.tabSSIDSecurity[0].setProfileRFPTypeDependencies(wLANProfile.profileType);
                this.tabSSIDSecurity[0].setData(wLANProfile.ssidProfiles[0]);
            } else {
                this.textFieldSSIDName[0].setText(null);
                this.tabSSIDGeneral[0].setData(null);
                this.tabSSIDSecurity[0].setProfileRFPTypeDependencies(wLANProfile.profileType);
                this.tabSSIDSecurity[0].setData(null);
            }
            this.tabSSIDGeneral[0].setCheckBoxActive(wLANProfile.enable);
            for (int i = 1; i < 4; ++i) {
                boolean bl = false;
                if (wLANProfile.ssidProfiles[i] != null && wLANProfile.ssidProfiles[i].ssid.length() > 0) {
                    bl = true;
                }
                this.checkBoxSSIDInUse[i].setSelected(bl);
                this.textFieldSSIDName[i].setEditable(bl);
                if (bl) {
                    this.textFieldSSIDName[i].setText(wLANProfile.ssidProfiles[i].ssid);
                    if (this.getTabPosByTitle(String.format(UtilLocale.getString("TXT_SSID_*_GENERAL_20"), i + 1)) == null) {
                        this.insertTabSSIDx(i);
                    }
                    this.tabSSIDGeneral[i].setData(wLANProfile.ssidProfiles[i]);
                    this.tabSSIDGeneral[i].setProfileRFPTypeDependencies(wLANProfile.profileType);
                    this.tabSSIDSecurity[i].setProfileRFPTypeDependencies(wLANProfile.profileType);
                    this.tabSSIDSecurity[i].setData(wLANProfile.ssidProfiles[i]);
                    continue;
                }
                this.textFieldSSIDName[i].setText(null);
                Integer n = this.getTabPosByTitle(String.format(UtilLocale.getString("TXT_SSID_*_GENERAL_20"), i + 1));
                if (n == null) continue;
                if (!this.isEditable && n.intValue() == this.panelTabbed.getSelectedIndex()) {
                    this.panelTabbed.setFirstTab();
                }
                this.removeTabSSIDx(i);
            }
        } else {
            int n;
            this.backupProfile = null;
            this.labelHeaderBar.setText(UtilLocale.getString("TXT_NEW_WLAN_PROFILE"));
            this.checkBoxProfileActive.setSelected(true);
            this.checkBoxInterferenceAvoidance.setSelected(false);
            this.comboBoxProfileType.deactivateActionListener();
            this.comboBoxProfileType.setSelectedItem((Object)OmiMessage.WLANProfileRFPType.RFP43);
            this.comboBoxProfileType.activateActionListener();
            this.comboBoxModeType.deactivateActionListener();
            this.comboBoxModeTypeActionListenerActive = false;
            this.comboBoxModeType.setSelectedItem((Object)OmiMessage.WLANModeType.N);
            this.comboBoxModeTypeActionListenerActive = true;
            this.comboBoxModeType.activateActionListener();
            this.checkBoxWME.setSelected(true);
            this.checkBoxWME.setEnabled(false);
            this.comboBoxQoSType.deactivateActionListener();
            this.comboBoxQoSType.setSelectedItem(null);
            this.comboBoxQoSType.setEnabled(false);
            this.comboBoxQoSType.activateActionListener();
            this.comboBoxMaxRateType.setSelectedItem(null);
            this.textFieldBeaconInterval.setText(String.valueOf(100));
            this.textFieldDTIMInterval.setText(String.valueOf(5));
            this.textFieldRTSThreshold.setText(String.valueOf(2347));
            this.textFieldFragmentationThreshold.setText(String.valueOf(2346));
            for (n = 0; n < 4; ++n) {
                if (n != 0) {
                    this.checkBoxSSIDInUse[n].setSelected(false);
                    this.textFieldSSIDName[n].setEditable(false);
                }
                this.textFieldSSIDName[n].setText(null);
            }
            this.tabSSIDGeneral[0].setData(null);
            this.tabSSIDGeneral[0].setCheckBoxActive(true);
            this.tabSSIDSecurity[0].setProfileRFPTypeDependencies(OmiMessage.WLANProfileRFPType.RFP43);
            this.tabSSIDSecurity[0].setModeTypeDependencies(OmiMessage.WLANModeType.N);
            this.tabSSIDSecurity[0].setData(null);
            for (n = 1; n < 4; ++n) {
                if (this.getTabPosByTitle(String.format(UtilLocale.getString("TXT_SSID_*_GENERAL_20"), n + 1)) == null) continue;
                this.removeTabSSIDx(n);
            }
        }
        if (this.isEditable) {
            this.utilChangeHandler.deactivate();
        }
    }

    protected WLANProfileHandler.WLANProfile getWlanProfileData() {
        boolean bl;
        WLANProfileHandler.WLANProfile wLANProfile;
        block89: {
            block85: {
                Integer n;
                OmiMessage.WLANModeType wLANModeType;
                wLANProfile = null;
                bl = false;
                if (this.backupProfile == null) break block85;
                wLANProfile = new WLANProfileHandler.WLANProfile(this.backupProfile.id);
                OmiMessage.WLANProfileRFPType wLANProfileRFPType = OmiMessage.WLANProfileRFPType.valueOf(this.comboBoxProfileType.getSelectedItem().toString());
                if (this.backupProfile.profileType != wLANProfileRFPType) {
                    wLANProfile.profileType = wLANProfileRFPType;
                    bl = true;
                }
                boolean bl2 = this.checkBoxProfileActive.isSelected();
                if (this.backupProfile.enable != bl2) {
                    wLANProfile.enable = bl2;
                    bl = true;
                }
                if (wLANProfileRFPType == OmiMessage.WLANProfileRFPType.RFP42) {
                    bl2 = this.checkBoxInterferenceAvoidance.isSelected();
                    if (this.backupProfile.interferenceAvoidance == null) {
                        wLANProfile.interferenceAvoidance = bl2;
                        bl = true;
                    } else if (this.backupProfile.interferenceAvoidance != bl2) {
                        wLANProfile.interferenceAvoidance = bl2;
                        bl = true;
                    }
                }
                if (this.backupProfile.mode != (wLANModeType = OmiMessage.WLANModeType.guiValueToEnum(this.comboBoxModeType.getSelectedItem().toString()))) {
                    wLANProfile.mode = wLANModeType;
                    bl = true;
                }
                OmiMessage.WMEQoSType wMEQoSType = this.checkBoxWME.isSelected() ? (wLANProfileRFPType == OmiMessage.WLANProfileRFPType.RFP43 ? OmiMessage.WMEQoSType.WME : OmiMessage.WMEQoSType.guiValueToEnum(this.comboBoxQoSType.getSelectedItem().toString())) : OmiMessage.WMEQoSType.None;
                if (this.backupProfile.qos != wMEQoSType) {
                    wLANProfile.qos = wMEQoSType;
                    bl = true;
                }
                if ((n = this.getIntFromWlanProfileDetailPanelTextField(this.textFieldBeaconInterval, UtilLocale.getString("TXT_BEACON_INTERVAL"))) == null) {
                    return null;
                }
                if (this.backupProfile.beaconInterval.intValue() != n.intValue()) {
                    wLANProfile.beaconInterval = n;
                    bl = true;
                }
                if ((n = this.getIntFromWlanProfileDetailPanelTextField(this.textFieldDTIMInterval, UtilLocale.getString("TXT_DTIM_INTERVAL"))) == null) {
                    return null;
                }
                if (this.backupProfile.dtimInterval.intValue() != n.intValue()) {
                    wLANProfile.dtimInterval = n;
                    bl = true;
                }
                if ((n = this.getIntFromWlanProfileDetailPanelTextField(this.textFieldRTSThreshold, UtilLocale.getString("TXT_RTS_THRESHOLD"))) == null) {
                    return null;
                }
                if (this.backupProfile.rtsThreshold.intValue() != n.intValue()) {
                    wLANProfile.rtsThreshold = n;
                    bl = true;
                }
                if ((n = this.getIntFromWlanProfileDetailPanelTextField(this.textFieldFragmentationThreshold, UtilLocale.getString("TXT_FRAGMENTATION_THRESHOLD"))) == null) {
                    return null;
                }
                if (this.backupProfile.fragThreshold.intValue() != n.intValue()) {
                    wLANProfile.fragThreshold = n;
                    bl = true;
                }
                if (wLANProfileRFPType == OmiMessage.WLANProfileRFPType.RFP42) {
                    OmiMessage.WLANMaxRateType wLANMaxRateType = OmiMessage.WLANMaxRateType.guiValueToEnum(this.comboBoxMaxRateType.getSelectedItem().toString());
                    if (this.backupProfile.maxRate == null) {
                        wLANProfile.maxRate = wLANMaxRateType;
                        bl = true;
                    } else if (this.backupProfile.maxRate != wLANMaxRateType) {
                        wLANProfile.maxRate = wLANMaxRateType;
                        bl = true;
                    }
                }
                for (int i = 0; i < 4; ++i) {
                    boolean bl3;
                    WLANProfileHandler.SSIDProfile sSIDProfile;
                    block87: {
                        block86: {
                            block88: {
                                WLANProfileHandler.SSIDProfile sSIDProfile2;
                                sSIDProfile = new WLANProfileHandler.SSIDProfile();
                                bl3 = false;
                                if (!this.checkBoxSSIDInUse[i].isSelected()) break block86;
                                String string = this.textFieldSSIDName[i].getText();
                                if (string.isEmpty()) {
                                    GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), UtilLocale.getString("TXT_NAME")));
                                    this.markErrorComponent(OmiMessage.SSIDProfileType.ssid.name() + (i + 1));
                                    return null;
                                }
                                if (this.backupProfile.ssidProfiles[i] == null || !this.backupProfile.ssidProfiles[i].ssid.equals(string)) {
                                    sSIDProfile.ssid = string;
                                    bl3 = true;
                                }
                                if ((sSIDProfile2 = this.tabSSIDGeneral[i].getData()) != null) {
                                    if (this.backupProfile.ssidProfiles[i] == null) {
                                        sSIDProfile.enable = sSIDProfile2.enable;
                                        sSIDProfile.vlanTag = (int)sSIDProfile2.vlanTag;
                                        sSIDProfile.security = sSIDProfile2.security;
                                        sSIDProfile.bssIsolation = sSIDProfile2.bssIsolation;
                                        sSIDProfile.useACL = sSIDProfile2.useACL;
                                        sSIDProfile.hiddenSSID = sSIDProfile2.hiddenSSID;
                                    } else {
                                        if (this.backupProfile.ssidProfiles[i].enable != sSIDProfile2.enable) {
                                            sSIDProfile.enable = sSIDProfile2.enable;
                                            bl3 = true;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].vlanTag.intValue() != sSIDProfile2.vlanTag.intValue()) {
                                            sSIDProfile.vlanTag = sSIDProfile2.vlanTag;
                                            bl3 = true;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].security != sSIDProfile2.security) {
                                            sSIDProfile.security = sSIDProfile2.security;
                                            bl3 = true;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].bssIsolation != sSIDProfile2.bssIsolation) {
                                            sSIDProfile.bssIsolation = sSIDProfile2.bssIsolation;
                                            bl3 = true;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].useACL != sSIDProfile2.useACL) {
                                            sSIDProfile.useACL = sSIDProfile2.useACL;
                                            bl3 = true;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].hiddenSSID != sSIDProfile2.hiddenSSID) {
                                            sSIDProfile.hiddenSSID = sSIDProfile2.hiddenSSID;
                                            bl3 = true;
                                        }
                                    }
                                } else {
                                    return null;
                                }
                                OmiMessage.WLANSecurityType wLANSecurityType = sSIDProfile2.security;
                                if (wLANSecurityType == OmiMessage.WLANSecurityType.Open) break block87;
                                sSIDProfile2 = this.tabSSIDSecurity[i].getData(wLANSecurityType);
                                if (sSIDProfile2 == null) break block88;
                                switch (wLANSecurityType) {
                                    case WEP: {
                                        if (this.backupProfile.ssidProfiles[i] == null) {
                                            sSIDProfile.privacy = sSIDProfile2.privacy;
                                            sSIDProfile.wepKeyHex = sSIDProfile2.wepKeyHex;
                                            sSIDProfile.keyLength = sSIDProfile2.keyLength;
                                            sSIDProfile.defaultWepKey = sSIDProfile2.defaultWepKey;
                                            sSIDProfile.wepKey1 = sSIDProfile2.wepKey1;
                                            sSIDProfile.wepKey2 = sSIDProfile2.wepKey2;
                                            sSIDProfile.wepKey3 = sSIDProfile2.wepKey3;
                                            sSIDProfile.wepKey4 = sSIDProfile2.wepKey4;
                                            break;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].privacy == null || this.backupProfile.ssidProfiles[i].privacy != sSIDProfile2.privacy) {
                                            sSIDProfile.privacy = sSIDProfile2.privacy;
                                            bl3 = true;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].wepKeyHex == null || this.backupProfile.ssidProfiles[i].wepKeyHex != sSIDProfile2.wepKeyHex) {
                                            sSIDProfile.wepKeyHex = sSIDProfile2.wepKeyHex;
                                            bl3 = true;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].keyLength == null || this.backupProfile.ssidProfiles[i].keyLength != sSIDProfile2.keyLength) {
                                            sSIDProfile.keyLength = sSIDProfile2.keyLength;
                                            bl3 = true;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].defaultWepKey == null || this.backupProfile.ssidProfiles[i].defaultWepKey.intValue() != sSIDProfile2.defaultWepKey.intValue()) {
                                            sSIDProfile.defaultWepKey = sSIDProfile2.defaultWepKey;
                                            bl3 = true;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].wepKey1 == null) {
                                            if (sSIDProfile2.wepKey1 != null) {
                                                sSIDProfile.wepKey1 = sSIDProfile2.wepKey1;
                                                bl3 = true;
                                            }
                                        } else if (!this.backupProfile.ssidProfiles[i].wepKey1.equals(sSIDProfile2.wepKey1)) {
                                            sSIDProfile.wepKey1 = sSIDProfile2.wepKey1;
                                            bl3 = true;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].wepKey2 == null) {
                                            if (sSIDProfile2.wepKey2 != null) {
                                                sSIDProfile.wepKey2 = sSIDProfile2.wepKey2;
                                                bl3 = true;
                                            }
                                        } else if (!this.backupProfile.ssidProfiles[i].wepKey2.equals(sSIDProfile2.wepKey2)) {
                                            sSIDProfile.wepKey2 = sSIDProfile2.wepKey2 != null ? sSIDProfile2.wepKey2 : "";
                                            bl3 = true;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].wepKey3 == null) {
                                            if (sSIDProfile2.wepKey3 != null) {
                                                sSIDProfile.wepKey3 = sSIDProfile2.wepKey3;
                                                bl3 = true;
                                            }
                                        } else if (!this.backupProfile.ssidProfiles[i].wepKey3.equals(sSIDProfile2.wepKey3)) {
                                            sSIDProfile.wepKey3 = sSIDProfile2.wepKey3 != null ? sSIDProfile2.wepKey3 : "";
                                            bl3 = true;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].wepKey4 == null) {
                                            if (sSIDProfile2.wepKey4 != null) {
                                                sSIDProfile.wepKey4 = sSIDProfile2.wepKey4;
                                                bl3 = true;
                                                break;
                                            }
                                        } else if (!this.backupProfile.ssidProfiles[i].wepKey4.equals(sSIDProfile2.wepKey4)) {
                                            sSIDProfile.wepKey4 = sSIDProfile2.wepKey4 != null ? sSIDProfile2.wepKey4 : "";
                                            bl3 = true;
                                            break;
                                        }
                                        break block87;
                                    }
                                    case WPA: {
                                        if (this.backupProfile.ssidProfiles[i] == null) {
                                            sSIDProfile.wpaType = sSIDProfile2.wpaType;
                                            sSIDProfile.distributionIntval = sSIDProfile2.distributionIntval;
                                            sSIDProfile.useRadius = sSIDProfile2.useRadius;
                                            sSIDProfile.radiusAddr = sSIDProfile2.radiusAddr;
                                            sSIDProfile.radiusPort = sSIDProfile2.radiusPort;
                                            sSIDProfile.radiusSecret = sSIDProfile2.radiusSecret;
                                            sSIDProfile.keyLength = sSIDProfile2.keyLength;
                                            sSIDProfile.pskHex = sSIDProfile2.pskHex;
                                            sSIDProfile.psk = sSIDProfile2.psk;
                                            break;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].wpaType == null || this.backupProfile.ssidProfiles[i].wpaType != sSIDProfile2.wpaType) {
                                            sSIDProfile.wpaType = sSIDProfile2.wpaType;
                                            bl3 = true;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].distributionIntval == null || this.backupProfile.ssidProfiles[i].distributionIntval.intValue() != sSIDProfile2.distributionIntval.intValue()) {
                                            sSIDProfile.distributionIntval = sSIDProfile2.distributionIntval;
                                            bl3 = true;
                                        }
                                        if (this.backupProfile.ssidProfiles[i].useRadius == null || this.backupProfile.ssidProfiles[i].useRadius != sSIDProfile2.useRadius) {
                                            sSIDProfile.useRadius = sSIDProfile2.useRadius;
                                            bl3 = true;
                                        }
                                        if (!(sSIDProfile2.radiusAddr == null || this.backupProfile.ssidProfiles[i].radiusAddr != null && this.backupProfile.ssidProfiles[i].radiusAddr.equals(sSIDProfile2.radiusAddr))) {
                                            sSIDProfile.radiusAddr = sSIDProfile2.radiusAddr;
                                            bl3 = true;
                                        }
                                        if (sSIDProfile2.radiusPort != null && (this.backupProfile.ssidProfiles[i].radiusPort == null || this.backupProfile.ssidProfiles[i].radiusPort.intValue() != sSIDProfile2.radiusPort.intValue())) {
                                            sSIDProfile.radiusPort = sSIDProfile2.radiusPort;
                                            bl3 = true;
                                        }
                                        if (!(sSIDProfile2.radiusSecret == null || this.backupProfile.ssidProfiles[i].radiusSecret != null && this.backupProfile.ssidProfiles[i].radiusSecret.equals(sSIDProfile2.radiusSecret))) {
                                            sSIDProfile.radiusSecret = sSIDProfile2.radiusSecret;
                                            bl3 = true;
                                        }
                                        if (sSIDProfile2.pskHex != null && (this.backupProfile.ssidProfiles[i].pskHex == null || this.backupProfile.ssidProfiles[i].pskHex != sSIDProfile2.pskHex)) {
                                            sSIDProfile.pskHex = sSIDProfile2.pskHex;
                                            bl3 = true;
                                        }
                                        if (!(sSIDProfile2.psk == null || this.backupProfile.ssidProfiles[i].psk != null && this.backupProfile.ssidProfiles[i].psk.equals(sSIDProfile2.psk))) {
                                            sSIDProfile.psk = sSIDProfile2.psk;
                                            bl3 = true;
                                            break;
                                        }
                                        break block87;
                                    }
                                }
                                break block87;
                            }
                            return null;
                        }
                        if (this.backupProfile.ssidProfiles[i] != null) {
                            sSIDProfile.ssid = "";
                            bl3 = true;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    wLANProfile.ssidProfiles[i] = sSIDProfile;
                }
                break block89;
            }
            wLANProfile = new WLANProfileHandler.WLANProfile();
            wLANProfile.profileType = OmiMessage.WLANProfileRFPType.valueOf(this.comboBoxProfileType.getSelectedItem().toString());
            wLANProfile.enable = this.checkBoxProfileActive.isSelected();
            if (wLANProfile.profileType == OmiMessage.WLANProfileRFPType.RFP42) {
                wLANProfile.interferenceAvoidance = this.checkBoxInterferenceAvoidance.isSelected();
            }
            wLANProfile.mode = OmiMessage.WLANModeType.guiValueToEnum(this.comboBoxModeType.getSelectedItem().toString());
            wLANProfile.qos = this.checkBoxWME.isSelected() ? (wLANProfile.profileType == OmiMessage.WLANProfileRFPType.RFP43 ? OmiMessage.WMEQoSType.WME : OmiMessage.WMEQoSType.guiValueToEnum(this.comboBoxQoSType.getSelectedItem().toString())) : OmiMessage.WMEQoSType.None;
            wLANProfile.beaconInterval = this.getIntFromWlanProfileDetailPanelTextField(this.textFieldBeaconInterval, UtilLocale.getString("TXT_BEACON_INTERVAL"));
            if (wLANProfile.beaconInterval == null) {
                return null;
            }
            wLANProfile.dtimInterval = this.getIntFromWlanProfileDetailPanelTextField(this.textFieldDTIMInterval, UtilLocale.getString("TXT_DTIM_INTERVAL"));
            if (wLANProfile.dtimInterval == null) {
                return null;
            }
            wLANProfile.rtsThreshold = this.getIntFromWlanProfileDetailPanelTextField(this.textFieldRTSThreshold, UtilLocale.getString("TXT_RTS_THRESHOLD"));
            if (wLANProfile.rtsThreshold == null) {
                return null;
            }
            wLANProfile.fragThreshold = this.getIntFromWlanProfileDetailPanelTextField(this.textFieldFragmentationThreshold, UtilLocale.getString("TXT_FRAGMENTATION_THRESHOLD"));
            if (wLANProfile.fragThreshold == null) {
                return null;
            }
            if (wLANProfile.profileType == OmiMessage.WLANProfileRFPType.RFP42) {
                wLANProfile.maxRate = OmiMessage.WLANMaxRateType.guiValueToEnum(this.comboBoxMaxRateType.getSelectedItem().toString());
            }
            for (int i = 0; i < 4; ++i) {
                if (!this.checkBoxSSIDInUse[i].isSelected()) continue;
                WLANProfileHandler.SSIDProfile sSIDProfile = new WLANProfileHandler.SSIDProfile();
                String string = this.textFieldSSIDName[i].getText();
                if (string.isEmpty()) {
                    GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), UtilLocale.getString("TXT_NAME")));
                    this.markErrorComponent(OmiMessage.SSIDProfileType.ssid.name() + (i + 1));
                    return null;
                }
                sSIDProfile.ssid = string;
                WLANProfileHandler.SSIDProfile sSIDProfile3 = this.tabSSIDGeneral[i].getData();
                if (sSIDProfile3 == null) {
                    return null;
                }
                sSIDProfile.enable = sSIDProfile3.enable;
                sSIDProfile.vlanTag = sSIDProfile3.vlanTag;
                sSIDProfile.security = sSIDProfile3.security;
                sSIDProfile.bssIsolation = sSIDProfile3.bssIsolation;
                sSIDProfile.useACL = sSIDProfile3.useACL;
                sSIDProfile.hiddenSSID = sSIDProfile3.hiddenSSID;
                if (sSIDProfile.security != OmiMessage.WLANSecurityType.Open) {
                    sSIDProfile3 = this.tabSSIDSecurity[i].getData(sSIDProfile.security);
                    if (sSIDProfile3 != null) {
                        switch (sSIDProfile.security) {
                            case WEP: {
                                sSIDProfile.privacy = sSIDProfile3.privacy;
                                sSIDProfile.wepKeyHex = sSIDProfile3.wepKeyHex;
                                sSIDProfile.keyLength = sSIDProfile3.keyLength;
                                sSIDProfile.defaultWepKey = sSIDProfile3.defaultWepKey;
                                sSIDProfile.wepKey1 = sSIDProfile3.wepKey1;
                                sSIDProfile.wepKey2 = sSIDProfile3.wepKey2;
                                sSIDProfile.wepKey3 = sSIDProfile3.wepKey3;
                                sSIDProfile.wepKey4 = sSIDProfile3.wepKey4;
                                break;
                            }
                            case WPA: {
                                sSIDProfile.wpaType = sSIDProfile3.wpaType;
                                sSIDProfile.distributionIntval = sSIDProfile3.distributionIntval;
                                sSIDProfile.useRadius = sSIDProfile3.useRadius;
                                sSIDProfile.radiusAddr = sSIDProfile3.radiusAddr;
                                sSIDProfile.radiusPort = sSIDProfile3.radiusPort;
                                sSIDProfile.radiusSecret = sSIDProfile3.radiusSecret;
                                sSIDProfile.keyLength = sSIDProfile3.keyLength;
                                sSIDProfile.pskHex = sSIDProfile3.pskHex;
                                sSIDProfile.psk = sSIDProfile3.psk;
                                break;
                            }
                        }
                    } else {
                        return null;
                    }
                }
                wLANProfile.ssidProfiles[i] = sSIDProfile;
            }
            bl = true;
        }
        if (bl) {
            return wLANProfile;
        }
        this.wlanProfileMainPanel.removeWlanProfileDetailPanel();
        return null;
    }

    protected UtilErrorComp getUtilErrorComp() {
        return this.utilErrorComp;
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    public void markErrorComponent(String string) {
        JComponent jComponent;
        if (string != null && (jComponent = this.utilErrorComp.getField(string)) != null) {
            int n = this.getTabPosByTitle(this.utilErrorComp.getTabTitle(string));
            this.panelTabbed.setSelectedIndex(n);
            this.utilErrorComp.markComponent(jComponent);
        }
    }

    protected void errorCompPut(String string, JComponent jComponent, JComponent jComponent2, String string2) {
        this.utilErrorComp.putWithTabTitle(string, jComponent, jComponent2, string2);
    }

    public void setDefaultTab() {
        this.panelTabbed.setFirstTab();
    }

    private Integer getIntFromWlanProfileDetailPanelTextField(AastraTextField aastraTextField, String string) {
        Integer n = UtilMisc.getIntFromTextField(aastraTextField, string, this.utilErrorComp, 10);
        if (n == -1) {
            this.panelTabbed.setSelectedIndex(this.getTabPosByTitle(UtilLocale.getString("TXT_GENERAL_20")));
            return null;
        }
        return n;
    }

    Integer getIntFromOtherWlanProfilePanelTextField(AastraTextField aastraTextField, String string, String string2) {
        Integer n = UtilMisc.getIntFromTextField(aastraTextField, string, this.utilErrorComp, 10);
        if (n == -1) {
            this.panelTabbed.setSelectedIndex(this.getTabPosByTitle(this.utilErrorComp.getTabTitle(string2)));
            return null;
        }
        return n;
    }

    Integer getIntFromOtherWlanProfilePanelTextFieldNotNull(AastraTextField aastraTextField, String string, String string2) {
        Integer n = UtilMisc.getIntFromTextFieldNotNull(aastraTextField, string, this.utilErrorComp, 10);
        if (n == -1) {
            this.panelTabbed.setSelectedIndex(this.getTabPosByTitle(this.utilErrorComp.getTabTitle(string2)));
            return null;
        }
        return n;
    }
}

