/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.wlan;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.guiutil.GuiUtilChangeHandler;
import com.aastra.oamp.guiutil.GuiUtilCheckBox;
import com.aastra.oamp.guiutil.GuiUtilComboBox;
import com.aastra.oamp.guiutil.GuiUtilTextFieldFS;
import com.aastra.oamp.guiutil.GuiUtilTextFieldFSGuiMode;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilMisc;
import com.aastra.oamp.wlan.WlanProfileDetailPanel;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.WLANProfileHandler;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WlanProfileSSIDSecurityDetailPanel {
    private WlanProfileDetailPanel wlanProfileDetailPanel = null;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private final int instance;
    private String tabTitle = null;
    private boolean isConfigurable;
    private AastraPanel panelSecurity = null;
    private AastraPanel panelOpen = null;
    private AastraPanel panelWEP = null;
    private GuiUtilCheckBox checkBoxPrivacy = null;
    private AastraLabel[] labelWEPKey = null;
    private GuiUtilTextFieldFSGuiMode[] textFieldWEPKey = null;
    private AastraButton[] buttonWEPKeyGenerate = null;
    private GuiUtilComboBox comboBoxNumberOfWEPKeys = null;
    private GuiUtilComboBox comboBoxWEPKeyFormat = null;
    private GuiUtilComboBox comboBoxWEPKeyLength = null;
    private GuiUtilComboBox comboBoxDefaultWEPKey = null;
    private AastraPanel panelWPA = null;
    private GuiUtilComboBox comboBoxWPAType = null;
    private GuiUtilComboBox comboBoxModePskRadius = null;
    private GuiUtilTextFieldFSGuiMode textFieldPreSharedKey = null;
    private AastraButton buttonPreSharedKeyGenerate = null;
    private GuiUtilComboBox comboBoxPreSharedKeyFormat = null;
    private GuiUtilTextFieldFS textFieldDistributionInterval = null;
    private GuiUtilTextFieldFSGuiMode textFieldRadiusIpAddress = null;
    private GuiUtilTextFieldFSGuiMode textFieldRadiusPort = null;
    private GuiUtilTextFieldFSGuiMode textFieldRadiusSecret = null;

    protected WlanProfileSSIDSecurityDetailPanel(WlanProfileDetailPanel wlanProfileDetailPanel, int n, String string, GuiUtilChangeHandler guiUtilChangeHandler, boolean bl) {
        this.wlanProfileDetailPanel = wlanProfileDetailPanel;
        this.instance = n;
        this.utilChangeHandler = guiUtilChangeHandler;
        this.tabTitle = string;
        this.isConfigurable = bl;
        this.panelSecurity = this.getPanelOpen();
    }

    protected AastraPanel getPanelSecurity() {
        return this.panelSecurity;
    }

    protected AastraPanel setSecurityType(OmiMessage.WLANSecurityType wLANSecurityType) {
        switch (wLANSecurityType) {
            case Open: {
                this.panelSecurity = this.getPanelOpen();
                break;
            }
            case WEP: {
                this.panelSecurity = this.getPanelWEP();
                break;
            }
            case WPA: {
                this.panelSecurity = this.getPanelWPA();
            }
        }
        return this.panelSecurity;
    }

    private AastraPanel getPanelOpen() {
        if (this.panelOpen == null) {
            this.panelOpen = new AastraPanel();
            this.panelOpen.setLayout(null);
        }
        return this.panelOpen;
    }

    private AastraPanel getPanelWEP() {
        if (this.panelWEP == null) {
            this.panelWEP = new AastraPanel();
            this.panelWEP.setLayout(null);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(30, 30, 200, 16);
            aastraLabel.setText(String.format(UtilLocale.getString("TXT_SECURITY_SETTINGS_*_:"), "WEP"));
            this.panelWEP.add(aastraLabel);
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(30, 60, 170, 16);
            aastraLabel2.setText(UtilLocale.getString("TXT_PRIVACY"));
            this.panelWEP.add(aastraLabel2);
            this.panelWEP.add(this.getCheckBoxPrivacy());
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setBounds(30, 90, 170, 16);
            aastraLabel3.setText(UtilLocale.getString("TXT_NUMBER_OF_KEYS"));
            this.panelWEP.add(aastraLabel3);
            this.panelWEP.add(this.getComboBoxNumberOfWEPKeys());
            AastraLabel aastraLabel4 = new AastraLabel();
            aastraLabel4.setBounds(30, 120, 170, 16);
            aastraLabel4.setText(UtilLocale.getString("TXT_KEY_FORMAT"));
            this.panelWEP.add(aastraLabel4);
            this.panelWEP.add(this.getComboBoxWEPKeyFormat());
            AastraLabel aastraLabel5 = new AastraLabel();
            aastraLabel5.setBounds(30, 150, 170, 16);
            aastraLabel5.setText(UtilLocale.getString("TXT_KEY_LENGTH"));
            AastraLabel aastraLabel6 = new AastraLabel();
            aastraLabel6.setBounds(270, 153, 50, 16);
            aastraLabel6.setText(UtilLocale.getString("TXT_BIT"));
            this.panelWEP.add(aastraLabel5);
            this.panelWEP.add(this.getComboBoxWEPKeyLength());
            this.panelWEP.add(aastraLabel6);
            AastraLabel aastraLabel7 = new AastraLabel();
            aastraLabel7.setBounds(30, 180, 170, 16);
            aastraLabel7.setText(UtilLocale.getString("TXT_DEFAULT_KEY"));
            this.panelWEP.add(aastraLabel7);
            this.panelWEP.add(this.getComboBoxDefaultWEPKey());
            this.labelWEPKey = new AastraLabel[4];
            for (int i = 0; i < 4; ++i) {
                this.labelWEPKey[i] = new AastraLabel();
                int n = this.isConfigurable ? 60 + i * 60 : 60 + i * 30;
                this.labelWEPKey[i].setBounds(340, n, 70, 16);
                this.labelWEPKey[i].setText(String.format(UtilLocale.getString("TXT_KEY_*"), i + 1));
                this.panelWEP.add(this.labelWEPKey[i]);
                this.panelWEP.add(this.getTextFieldWEPKey(i));
                if (this.isConfigurable) {
                    this.panelWEP.add(this.getButtonWEPKeyGenerate(i));
                }
                String string = null;
                switch (i) {
                    case 0: {
                        string = OmiMessage.SSIDProfileType.wepKey1.name();
                        break;
                    }
                    case 1: {
                        string = OmiMessage.SSIDProfileType.wepKey2.name();
                        break;
                    }
                    case 2: {
                        string = OmiMessage.SSIDProfileType.wepKey3.name();
                        break;
                    }
                    case 3: {
                        string = OmiMessage.SSIDProfileType.wepKey4.name();
                    }
                }
                if (!this.isConfigurable) continue;
                this.wlanProfileDetailPanel.errorCompPut(String.format("%s%d", string, this.instance + 1), this.labelWEPKey[i], this.textFieldWEPKey[i], this.tabTitle);
            }
        }
        return this.panelWEP;
    }

    private GuiUtilCheckBox getCheckBoxPrivacy() {
        if (this.checkBoxPrivacy == null) {
            this.checkBoxPrivacy = new GuiUtilCheckBox(this.utilChangeHandler, 210, 60);
        }
        return this.checkBoxPrivacy;
    }

    private GuiUtilComboBox getComboBoxNumberOfWEPKeys() {
        if (this.comboBoxNumberOfWEPKeys == null) {
            this.comboBoxNumberOfWEPKeys = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxNumberOfWEPKeys.setBounds(210, 90, 50, 20);
            Integer n = 1;
            while (n <= 4) {
                this.comboBoxNumberOfWEPKeys.addItem(n);
                Integer n2 = n;
                Integer n3 = n = Integer.valueOf(n + 1);
            }
            if (this.isConfigurable) {
                this.comboBoxNumberOfWEPKeys.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Integer n;
                        Integer n2;
                        Integer n3 = new Integer(((GuiUtilComboBox)actionEvent.getSource()).getSelectedItem().toString());
                        WlanProfileSSIDSecurityDetailPanel.this.comboBoxDefaultWEPKey.removeAllItems();
                        Integer n4 = 0;
                        while (n4 < n3) {
                            WlanProfileSSIDSecurityDetailPanel.this.comboBoxDefaultWEPKey.addItem(n4 + 1);
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldWEPKey[n4].setEditable(true);
                            WlanProfileSSIDSecurityDetailPanel.this.buttonWEPKeyGenerate[n4].setEnabled(true);
                            n2 = n4;
                            n = n4 = Integer.valueOf(n4 + 1);
                        }
                        WlanProfileSSIDSecurityDetailPanel.this.comboBoxDefaultWEPKey.setSelectedItem(1);
                        n4 = n3;
                        while (n4 < 4) {
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldWEPKey[n4].setText(null);
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldWEPKey[n4].setEditable(false);
                            WlanProfileSSIDSecurityDetailPanel.this.buttonWEPKeyGenerate[n4].setEnabled(false);
                            n2 = n4;
                            n = n4 = Integer.valueOf(n4 + 1);
                        }
                    }
                });
            }
            this.comboBoxNumberOfWEPKeys.activateActionListener();
        }
        return this.comboBoxNumberOfWEPKeys;
    }

    private GuiUtilComboBox getComboBoxWEPKeyFormat() {
        if (this.comboBoxWEPKeyFormat == null) {
            this.comboBoxWEPKeyFormat = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxWEPKeyFormat.setBounds(210, 120, 90, 20);
            this.comboBoxWEPKeyFormat.addItem(UtilLocale.getString("TXT_TEXT_20"));
            this.comboBoxWEPKeyFormat.addItem(UtilLocale.getString("TXT_HEX_VALUE_20"));
            this.comboBoxWEPKeyFormat.activateActionListener();
        }
        return this.comboBoxWEPKeyFormat;
    }

    private GuiUtilComboBox getComboBoxWEPKeyLength() {
        if (this.comboBoxWEPKeyLength == null) {
            this.comboBoxWEPKeyLength = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxWEPKeyLength.setBounds(210, 150, 50, 20);
            this.comboBoxWEPKeyLength.activateActionListener();
        }
        return this.comboBoxWEPKeyLength;
    }

    private GuiUtilComboBox getComboBoxDefaultWEPKey() {
        if (this.comboBoxDefaultWEPKey == null) {
            this.comboBoxDefaultWEPKey = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxDefaultWEPKey.setBounds(210, 180, 50, 20);
            this.comboBoxDefaultWEPKey.activateActionListener();
        }
        return this.comboBoxDefaultWEPKey;
    }

    private GuiUtilTextFieldFSGuiMode getTextFieldWEPKey(int n) {
        if (this.textFieldWEPKey == null) {
            this.textFieldWEPKey = new GuiUtilTextFieldFSGuiMode[4];
        }
        int n2 = this.isConfigurable ? 60 + n * 60 : 60 + n * 30;
        if (this.textFieldWEPKey[n] == null) {
            this.textFieldWEPKey[n] = new GuiUtilTextFieldFSGuiMode(410, n2, AastraCommon.TextFieldSizeType.m, this.utilChangeHandler, this.isConfigurable);
            this.textFieldWEPKey[n].setEditable(false);
        }
        return this.textFieldWEPKey[n];
    }

    private AastraButton getButtonWEPKeyGenerate(final int n) {
        if (this.buttonWEPKeyGenerate == null) {
            this.buttonWEPKeyGenerate = new AastraButton[4];
        }
        if (this.buttonWEPKeyGenerate[n] == null) {
            this.buttonWEPKeyGenerate[n] = new AastraButton();
            this.buttonWEPKeyGenerate[n].setBounds(520, 85 + n * 60, 90, 25);
            this.buttonWEPKeyGenerate[n].setText(UtilLocale.getString("TXT_GENERATE_20"));
            this.buttonWEPKeyGenerate[n].setEnabled(false);
            this.buttonWEPKeyGenerate[n].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WlanProfileSSIDSecurityDetailPanel.this.textFieldWEPKey[n].setText(WlanProfileSSIDSecurityDetailPanel.this.GenerateWEPKey());
                    WlanProfileSSIDSecurityDetailPanel.this.utilChangeHandler.activate();
                }
            });
        }
        return this.buttonWEPKeyGenerate[n];
    }

    private String GenerateWEPKey() {
        OmiMessage.WEPKeyLengthType wEPKeyLengthType = OmiMessage.WEPKeyLengthType.guiValueToEnum(this.comboBoxWEPKeyLength.getSelectedItem().toString());
        int n = 0;
        boolean bl = false;
        switch (wEPKeyLengthType) {
            case LEN_64: {
                n = 5;
                break;
            }
            case LEN_128: {
                n = 13;
                break;
            }
            case LEN_256: {
                n = 29;
            }
        }
        if (this.comboBoxWEPKeyFormat.getSelectedIndex() == 1) {
            bl = true;
            n *= 2;
        }
        return this.GenerateKey(bl, n);
    }

    private AastraPanel getPanelWPA() {
        if (this.panelWPA == null) {
            this.panelWPA = new AastraPanel();
            this.panelWPA.setLayout(null);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(30, 30, 200, 16);
            aastraLabel.setText(String.format(UtilLocale.getString("TXT_SECURITY_SETTINGS_*_:"), "WPA"));
            this.panelWPA.add(aastraLabel);
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(30, 60, 170, 16);
            aastraLabel2.setText(UtilLocale.getString("TXT_WPA_TYPE"));
            this.panelWPA.add(aastraLabel2);
            this.panelWPA.add(this.getComboBoxWPAType());
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setBounds(30, 90, 170, 16);
            aastraLabel3.setText(UtilLocale.getString("TXT_DISTRIBUTION_INTERVAL"));
            AastraLabel aastraLabel4 = new AastraLabel();
            aastraLabel4.setBounds(270, 90, 50, 16);
            aastraLabel4.setText(UtilLocale.getString("TXT_UNIT_SECOND"));
            this.panelWPA.add(aastraLabel3);
            this.panelWPA.add(aastraLabel4);
            this.panelWPA.add(this.getTextFieldDistributionInterval());
            AastraLabel aastraLabel5 = new AastraLabel();
            aastraLabel5.setBounds(30, 120, 170, 16);
            aastraLabel5.setText(UtilLocale.getString("TXT_MODE"));
            this.panelWPA.add(aastraLabel5);
            this.panelWPA.add(this.getComboBoxModePskRadius());
            AastraLabel aastraLabel6 = new AastraLabel();
            aastraLabel6.setBounds(30, 150, 170, 16);
            aastraLabel6.setText(UtilLocale.getString("TXT_PRE_SHARED_KEY_FORMAT"));
            this.panelWPA.add(aastraLabel6);
            this.panelWPA.add(this.getComboBoxPreSharedKeyFormat());
            AastraLabel aastraLabel7 = new AastraLabel();
            aastraLabel7.setBounds(30, 180, 170, 16);
            aastraLabel7.setText(UtilLocale.getString("TXT_PRE_SHARED_KEY"));
            this.panelWPA.add(aastraLabel7);
            this.panelWPA.add(this.getTextFieldPreSharedKey());
            if (this.isConfigurable) {
                this.panelWPA.add(this.getButtonPreSharedKeyGenerate());
            }
            AastraLabel aastraLabel8 = new AastraLabel();
            aastraLabel8.setBounds(370, 60, 150, 16);
            aastraLabel8.setText(String.format(UtilLocale.getString("TXT_RADIUS_CONFIGURATION_:"), new Object[0]));
            this.panelWPA.add(aastraLabel8);
            AastraLabel aastraLabel9 = new AastraLabel();
            aastraLabel9.setBounds(370, 90, 100, 16);
            aastraLabel9.setText(String.format(UtilLocale.getString("TXT_IP_ADDRESS"), new Object[0]));
            this.panelWPA.add(aastraLabel9);
            this.panelWPA.add(this.getTextFieldRadiusIpAddress());
            AastraLabel aastraLabel10 = new AastraLabel();
            aastraLabel10.setBounds(370, 120, 100, 16);
            aastraLabel10.setText(String.format(UtilLocale.getString("TXT_PORT"), new Object[0]));
            this.panelWPA.add(aastraLabel10);
            this.panelWPA.add(this.getTextFieldRadiusPort());
            AastraLabel aastraLabel11 = new AastraLabel();
            aastraLabel11.setBounds(370, 150, 100, 16);
            aastraLabel11.setText(String.format(UtilLocale.getString("TXT_SECRET"), new Object[0]));
            this.panelWPA.add(aastraLabel11);
            this.panelWPA.add(this.getTextFieldRadiusSecret());
            if (this.isConfigurable) {
                this.wlanProfileDetailPanel.errorCompPut(OmiMessage.SSIDProfileType.distributionIntval.name() + (this.instance + 1), aastraLabel3, this.textFieldDistributionInterval, this.tabTitle);
                this.wlanProfileDetailPanel.errorCompPut(OmiMessage.SSIDProfileType.psk.name() + (this.instance + 1), aastraLabel7, this.textFieldPreSharedKey, this.tabTitle);
                this.wlanProfileDetailPanel.errorCompPut(OmiMessage.SSIDProfileType.radiusAddr.name() + (this.instance + 1), aastraLabel9, this.textFieldRadiusIpAddress, this.tabTitle);
                this.wlanProfileDetailPanel.errorCompPut(OmiMessage.SSIDProfileType.radiusPort.name() + (this.instance + 1), aastraLabel10, this.textFieldRadiusPort, this.tabTitle);
                this.wlanProfileDetailPanel.errorCompPut(OmiMessage.SSIDProfileType.radiusSecret.name() + (this.instance + 1), aastraLabel11, this.textFieldRadiusSecret, this.tabTitle);
            }
        }
        return this.panelWPA;
    }

    private GuiUtilComboBox getComboBoxWPAType() {
        if (this.comboBoxWPAType == null) {
            this.comboBoxWPAType = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxWPAType.setBounds(210, 60, 80, 20);
            Integer n = 0;
            while (n < OmiMessage.WPATypeType.values().length) {
                this.comboBoxWPAType.addItem(OmiMessage.WPATypeType.values()[n]);
                Integer n2 = n;
                Integer n3 = n = Integer.valueOf(n + 1);
            }
            this.comboBoxWPAType.activateActionListener();
        }
        return this.comboBoxWPAType;
    }

    private GuiUtilTextFieldFS getTextFieldDistributionInterval() {
        if (this.textFieldDistributionInterval == null) {
            this.textFieldDistributionInterval = new GuiUtilTextFieldFS(210, 90, AastraCommon.TextFieldSizeType.xs, this.utilChangeHandler);
            this.textFieldDistributionInterval.setToolTipText(UtilLocale.getString("TXT_DISTRIBUTION_INTERVAL_HELP"));
        }
        return this.textFieldDistributionInterval;
    }

    private GuiUtilComboBox getComboBoxModePskRadius() {
        if (this.comboBoxModePskRadius == null) {
            this.comboBoxModePskRadius = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxModePskRadius.setBounds(210, 120, 120, 20);
            this.comboBoxModePskRadius.addItem(UtilLocale.getString("TXT_PRE_SHARED_KEY_20"));
            this.comboBoxModePskRadius.addItem(UtilLocale.getString("TXT_RADIUS_SERVER_20"));
            if (this.isConfigurable) {
                this.comboBoxModePskRadius.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (((GuiUtilComboBox)actionEvent.getSource()).getSelectedIndex() == 0) {
                            WlanProfileSSIDSecurityDetailPanel.this.comboBoxPreSharedKeyFormat.setSelectedIndex(0);
                            WlanProfileSSIDSecurityDetailPanel.this.comboBoxPreSharedKeyFormat.setEnabled(true);
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldPreSharedKey.setEditable(true);
                            WlanProfileSSIDSecurityDetailPanel.this.buttonPreSharedKeyGenerate.setEnabled(true);
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldRadiusIpAddress.setText(null);
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldRadiusIpAddress.setEditable(false);
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldRadiusPort.setText(null);
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldRadiusPort.setEditable(false);
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldRadiusSecret.setText(null);
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldRadiusSecret.setEditable(false);
                        } else {
                            WlanProfileSSIDSecurityDetailPanel.this.comboBoxPreSharedKeyFormat.setSelectedItem(null);
                            WlanProfileSSIDSecurityDetailPanel.this.comboBoxPreSharedKeyFormat.setEnabled(false);
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldPreSharedKey.setText(null);
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldPreSharedKey.setEditable(false);
                            WlanProfileSSIDSecurityDetailPanel.this.wlanProfileDetailPanel.getUtilErrorComp().clearComponent(WlanProfileSSIDSecurityDetailPanel.this.textFieldPreSharedKey);
                            WlanProfileSSIDSecurityDetailPanel.this.buttonPreSharedKeyGenerate.setEnabled(false);
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldRadiusIpAddress.setText("0.0.0.0");
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldRadiusIpAddress.setEditable(true);
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldRadiusPort.setText(String.valueOf(1812));
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldRadiusPort.setEditable(true);
                            WlanProfileSSIDSecurityDetailPanel.this.textFieldRadiusSecret.setEditable(true);
                        }
                    }
                });
            }
            this.comboBoxModePskRadius.activateActionListener();
        }
        return this.comboBoxModePskRadius;
    }

    private GuiUtilComboBox getComboBoxPreSharedKeyFormat() {
        if (this.comboBoxPreSharedKeyFormat == null) {
            this.comboBoxPreSharedKeyFormat = new GuiUtilComboBox(this.utilChangeHandler);
            this.comboBoxPreSharedKeyFormat.setBounds(210, 150, 80, 20);
            this.comboBoxPreSharedKeyFormat.addItem(UtilLocale.getString("TXT_TEXT_20"));
            this.comboBoxPreSharedKeyFormat.addItem(UtilLocale.getString("TXT_HEX_VALUE_20"));
            this.comboBoxPreSharedKeyFormat.setEnabled(false);
            this.comboBoxPreSharedKeyFormat.activateActionListener();
        }
        return this.comboBoxPreSharedKeyFormat;
    }

    private GuiUtilTextFieldFSGuiMode getTextFieldPreSharedKey() {
        if (this.textFieldPreSharedKey == null) {
            this.textFieldPreSharedKey = new GuiUtilTextFieldFSGuiMode(30, 200, AastraCommon.TextFieldSizeType.l, this.utilChangeHandler, this.isConfigurable);
            this.textFieldPreSharedKey.setEditable(false);
        }
        return this.textFieldPreSharedKey;
    }

    private AastraButton getButtonPreSharedKeyGenerate() {
        if (this.buttonPreSharedKeyGenerate == null) {
            this.buttonPreSharedKeyGenerate = new AastraButton();
            this.buttonPreSharedKeyGenerate.setBounds(30, 230, 90, 25);
            this.buttonPreSharedKeyGenerate.setText(UtilLocale.getString("TXT_GENERATE_20"));
            this.buttonPreSharedKeyGenerate.setEnabled(false);
            this.buttonPreSharedKeyGenerate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WlanProfileSSIDSecurityDetailPanel.this.textFieldPreSharedKey.setText(WlanProfileSSIDSecurityDetailPanel.this.GeneratePreSharedKey());
                    WlanProfileSSIDSecurityDetailPanel.this.utilChangeHandler.activate();
                }
            });
        }
        return this.buttonPreSharedKeyGenerate;
    }

    private String GeneratePreSharedKey() {
        int n;
        boolean bl;
        if (this.comboBoxPreSharedKeyFormat.getSelectedIndex() == 1) {
            bl = true;
            n = 64;
        } else {
            bl = false;
            n = 20;
        }
        return this.GenerateKey(bl, n);
    }

    private GuiUtilTextFieldFSGuiMode getTextFieldRadiusIpAddress() {
        if (this.textFieldRadiusIpAddress == null) {
            this.textFieldRadiusIpAddress = new GuiUtilTextFieldFSGuiMode(470, 90, AastraCommon.TextFieldSizeType.s, this.utilChangeHandler, this.isConfigurable);
            this.textFieldRadiusIpAddress.setEditable(false);
        }
        return this.textFieldRadiusIpAddress;
    }

    private GuiUtilTextFieldFSGuiMode getTextFieldRadiusPort() {
        if (this.textFieldRadiusPort == null) {
            this.textFieldRadiusPort = new GuiUtilTextFieldFSGuiMode(470, 120, AastraCommon.TextFieldSizeType.s, this.utilChangeHandler, this.isConfigurable);
            this.textFieldRadiusPort.setEditable(false);
        }
        return this.textFieldRadiusPort;
    }

    private GuiUtilTextFieldFSGuiMode getTextFieldRadiusSecret() {
        if (this.textFieldRadiusSecret == null) {
            this.textFieldRadiusSecret = new GuiUtilTextFieldFSGuiMode(470, 150, AastraCommon.TextFieldSizeType.sm, this.utilChangeHandler, this.isConfigurable);
            this.textFieldRadiusSecret.setEditable(false);
        }
        return this.textFieldRadiusSecret;
    }

    protected void setData(WLANProfileHandler.SSIDProfile sSIDProfile) {
        this.getPanelWEP();
        this.setDataWEP(sSIDProfile);
        this.getPanelWPA();
        this.setDataWPA(sSIDProfile);
    }

    protected WLANProfileHandler.SSIDProfile getData(OmiMessage.WLANSecurityType wLANSecurityType) {
        switch (wLANSecurityType) {
            case WEP: {
                return this.getDataWEP();
            }
            case WPA: {
                return this.getDataWPA();
            }
        }
        return null;
    }

    private void setDataWEP(WLANProfileHandler.SSIDProfile sSIDProfile) {
        if (sSIDProfile != null) {
            if (sSIDProfile.privacy != null) {
                this.checkBoxPrivacy.setSelected(sSIDProfile.privacy);
            } else {
                this.checkBoxPrivacy.setSelected(false);
            }
            if (sSIDProfile.wepKeyHex != null && sSIDProfile.wepKeyHex.booleanValue()) {
                this.comboBoxWEPKeyFormat.setSelectedIndex(1);
            } else {
                this.comboBoxWEPKeyFormat.setSelectedIndex(0);
            }
            if (sSIDProfile.keyLength != null) {
                this.comboBoxWEPKeyLength.setSelectedItem((Object)sSIDProfile.keyLength);
            } else {
                this.comboBoxWEPKeyLength.setSelectedItem((Object)OmiMessage.WEPKeyLengthType.LEN_64);
            }
            int n = 1;
            if (sSIDProfile.wepKey1 != null) {
                this.textFieldWEPKey[0].setText(sSIDProfile.wepKey1);
            }
            if (sSIDProfile.wepKey2 != null) {
                this.textFieldWEPKey[1].setEditable(true);
                this.textFieldWEPKey[1].setText(sSIDProfile.wepKey2);
                ++n;
            }
            if (sSIDProfile.wepKey3 != null) {
                this.textFieldWEPKey[2].setEditable(true);
                this.textFieldWEPKey[2].setText(sSIDProfile.wepKey3);
                ++n;
            }
            if (sSIDProfile.wepKey4 != null) {
                this.textFieldWEPKey[3].setEditable(true);
                this.textFieldWEPKey[3].setText(sSIDProfile.wepKey4);
                ++n;
            }
            this.comboBoxNumberOfWEPKeys.setSelectedItem(n);
            this.comboBoxDefaultWEPKey.removeAllItems();
            for (int i = 0; i < n; ++i) {
                this.comboBoxDefaultWEPKey.addItem(i + 1);
            }
            if (sSIDProfile.defaultWepKey == null) {
                this.comboBoxDefaultWEPKey.setSelectedItem(1);
            } else {
                this.comboBoxDefaultWEPKey.setSelectedItem(sSIDProfile.defaultWepKey);
            }
        } else {
            this.checkBoxPrivacy.setSelected(false);
            this.comboBoxWEPKeyFormat.setSelectedIndex(0);
            this.comboBoxWEPKeyLength.setSelectedItem((Object)OmiMessage.WEPKeyLengthType.LEN_64);
            this.textFieldWEPKey[0].setText(null);
            this.comboBoxNumberOfWEPKeys.setSelectedItem(1);
            this.comboBoxDefaultWEPKey.removeAllItems();
            this.comboBoxDefaultWEPKey.addItem(1);
            this.comboBoxDefaultWEPKey.setSelectedItem(1);
        }
    }

    protected void setProfileRFPTypeDependencies(OmiMessage.WLANProfileRFPType wLANProfileRFPType) {
        this.getPanelWEP();
        this.comboBoxWEPKeyLength.removeAllItems();
        this.comboBoxWEPKeyLength.addItem(OmiMessage.WEPKeyLengthType.LEN_64);
        this.comboBoxWEPKeyLength.addItem(OmiMessage.WEPKeyLengthType.LEN_128);
        this.getComboBoxWPAType().setSelectedItem((Object)OmiMessage.WPATypeType.WPA2);
        if (wLANProfileRFPType == OmiMessage.WLANProfileRFPType.RFP42) {
            this.comboBoxWEPKeyLength.addItem(OmiMessage.WEPKeyLengthType.LEN_256);
        }
    }

    protected void setModeTypeDependencies(OmiMessage.WLANModeType wLANModeType) {
        if (this.isConfigurable) {
            if (wLANModeType == OmiMessage.WLANModeType.N) {
                this.comboBoxWPAType.setSelectedItem((Object)OmiMessage.WPATypeType.WPA2);
                this.comboBoxWPAType.setEnabled(false);
            } else {
                this.comboBoxWPAType.setEnabled(true);
            }
        }
    }

    private WLANProfileHandler.SSIDProfile getDataWEP() {
        WLANProfileHandler.SSIDProfile sSIDProfile = new WLANProfileHandler.SSIDProfile();
        sSIDProfile.privacy = this.checkBoxPrivacy.isSelected();
        sSIDProfile.wepKeyHex = new Integer(this.comboBoxWEPKeyFormat.getSelectedIndex()) == 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
        sSIDProfile.keyLength = OmiMessage.WEPKeyLengthType.guiValueToEnum(this.comboBoxWEPKeyLength.getSelectedItem().toString());
        sSIDProfile.defaultWepKey = new Integer(this.comboBoxDefaultWEPKey.getSelectedItem().toString());
        sSIDProfile.wepKey1 = this.getWEPKey(sSIDProfile, 0);
        if (sSIDProfile.wepKey1 == null) {
            return null;
        }
        if (this.textFieldWEPKey[1].isEditable()) {
            sSIDProfile.wepKey2 = this.getWEPKey(sSIDProfile, 1);
            if (sSIDProfile.wepKey2 == null) {
                return null;
            }
        } else {
            sSIDProfile.wepKey2 = null;
        }
        if (this.textFieldWEPKey[2].isEditable()) {
            sSIDProfile.wepKey3 = this.getWEPKey(sSIDProfile, 2);
            if (sSIDProfile.wepKey3 == null) {
                return null;
            }
        } else {
            sSIDProfile.wepKey3 = null;
        }
        if (this.textFieldWEPKey[3].isEditable()) {
            sSIDProfile.wepKey4 = this.getWEPKey(sSIDProfile, 3);
            if (sSIDProfile.wepKey4 == null) {
                return null;
            }
        } else {
            sSIDProfile.wepKey4 = null;
        }
        return sSIDProfile;
    }

    private void setDataWPA(WLANProfileHandler.SSIDProfile sSIDProfile) {
        if (sSIDProfile != null) {
            if (sSIDProfile.wpaType != null) {
                this.comboBoxWPAType.setSelectedItem((Object)sSIDProfile.wpaType);
            } else {
                this.comboBoxWPAType.setSelectedItem((Object)OmiMessage.WPATypeType.WPA2);
            }
            if (sSIDProfile.distributionIntval != null) {
                this.textFieldDistributionInterval.setText(String.valueOf(sSIDProfile.distributionIntval));
            } else {
                this.textFieldDistributionInterval.setText(String.valueOf(600));
            }
            if (sSIDProfile.useRadius != null && sSIDProfile.useRadius.booleanValue()) {
                this.comboBoxModePskRadius.setSelectedIndex(1);
                this.comboBoxPreSharedKeyFormat.setSelectedItem(null);
                if (this.isConfigurable) {
                    this.comboBoxPreSharedKeyFormat.setEnabled(false);
                }
                this.textFieldPreSharedKey.setText(null);
                this.textFieldPreSharedKey.setEditable(false);
                if (this.isConfigurable) {
                    this.buttonPreSharedKeyGenerate.setEnabled(false);
                }
                this.textFieldRadiusIpAddress.setEditable(true);
                if (sSIDProfile.radiusAddr == null) {
                    this.textFieldRadiusIpAddress.setText("0.0.0.0");
                } else {
                    this.textFieldRadiusIpAddress.setText(sSIDProfile.radiusAddr);
                }
                this.textFieldRadiusPort.setEditable(true);
                if (sSIDProfile.radiusPort == null) {
                    this.textFieldRadiusPort.setText(String.valueOf(1812));
                } else {
                    this.textFieldRadiusPort.setText(String.valueOf(sSIDProfile.radiusPort));
                }
                this.textFieldRadiusSecret.setEditable(true);
                this.textFieldRadiusSecret.setText(sSIDProfile.radiusSecret);
            } else {
                this.comboBoxModePskRadius.setSelectedIndex(0);
                if (this.isConfigurable) {
                    this.comboBoxPreSharedKeyFormat.setEnabled(true);
                }
                if (sSIDProfile.pskHex != null && sSIDProfile.pskHex.booleanValue()) {
                    this.comboBoxPreSharedKeyFormat.setSelectedIndex(1);
                } else {
                    this.comboBoxPreSharedKeyFormat.setSelectedIndex(0);
                }
                this.textFieldPreSharedKey.setEditable(true);
                this.textFieldPreSharedKey.setText(sSIDProfile.psk);
                if (this.isConfigurable) {
                    this.buttonPreSharedKeyGenerate.setEnabled(true);
                }
                this.textFieldRadiusIpAddress.setEditable(false);
                this.textFieldRadiusIpAddress.setText(null);
                this.textFieldRadiusPort.setEditable(false);
                this.textFieldRadiusPort.setText(null);
                this.textFieldRadiusSecret.setEditable(false);
                this.textFieldRadiusSecret.setText(null);
            }
        } else {
            this.comboBoxWPAType.setSelectedItem((Object)OmiMessage.WPATypeType.WPA2);
            this.textFieldDistributionInterval.setText(String.valueOf(600));
            this.comboBoxModePskRadius.setSelectedIndex(0);
            if (this.isConfigurable) {
                this.comboBoxPreSharedKeyFormat.setEnabled(true);
            }
            this.comboBoxPreSharedKeyFormat.setSelectedIndex(0);
            this.textFieldPreSharedKey.setEditable(true);
            this.textFieldPreSharedKey.setText(null);
            if (this.isConfigurable) {
                this.buttonPreSharedKeyGenerate.setEnabled(true);
            }
            this.textFieldRadiusIpAddress.setEditable(false);
            this.textFieldRadiusIpAddress.setText(null);
            this.textFieldRadiusPort.setEditable(false);
            this.textFieldRadiusPort.setText(null);
            this.textFieldRadiusSecret.setEditable(false);
            this.textFieldRadiusSecret.setText(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private WLANProfileHandler.SSIDProfile getDataWPA() {
        WLANProfileHandler.SSIDProfile sSIDProfile = new WLANProfileHandler.SSIDProfile();
        sSIDProfile.wpaType = OmiMessage.WPATypeType.valueOf(this.comboBoxWPAType.getSelectedItem().toString());
        sSIDProfile.distributionIntval = this.wlanProfileDetailPanel.getIntFromOtherWlanProfilePanelTextField(this.textFieldDistributionInterval, UtilLocale.getString("TXT_DISTRIBUTION_INTERVAL"), OmiMessage.SSIDProfileType.distributionIntval.name() + (this.instance + 1));
        if (sSIDProfile.distributionIntval == null) {
            return null;
        }
        if (this.comboBoxModePskRadius.getSelectedIndex() == 1) {
            sSIDProfile.useRadius = true;
            String string = this.textFieldRadiusIpAddress.getText();
            if (string.equals("0.0.0.0")) {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_IP_ADDRESS_NOT_CONFIGURED"));
                this.wlanProfileDetailPanel.markErrorComponent(OmiMessage.SSIDProfileType.radiusAddr.name() + (this.instance + 1));
                return null;
            }
            if (!UtilMisc.validateIPAddress(string)) {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_IP_ADDRESS_FORMAT_INVALID"));
                this.wlanProfileDetailPanel.markErrorComponent(OmiMessage.SSIDProfileType.radiusAddr.name() + (this.instance + 1));
                return null;
            }
            sSIDProfile.radiusAddr = string;
            sSIDProfile.radiusPort = this.wlanProfileDetailPanel.getIntFromOtherWlanProfilePanelTextField(this.textFieldRadiusPort, UtilLocale.getString("TXT_PORT"), OmiMessage.SSIDProfileType.radiusPort.name() + (this.instance + 1));
            if (sSIDProfile.radiusPort == null) {
                return null;
            }
            string = this.textFieldRadiusSecret.getText();
            if (string.length() > 0) {
                sSIDProfile.radiusSecret = string;
                return sSIDProfile;
            }
            GuiInfoConsole.showError(UtilLocale.getString("TXT_SECRET_INVALID"));
            this.wlanProfileDetailPanel.markErrorComponent(OmiMessage.SSIDProfileType.radiusSecret.name() + (this.instance + 1));
            return null;
        }
        sSIDProfile.useRadius = false;
        sSIDProfile.pskHex = this.comboBoxPreSharedKeyFormat.getSelectedIndex() == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        String string = this.textFieldPreSharedKey.getText();
        int n = string.length();
        if (n == 0) {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), UtilLocale.getString("TXT_PRE_SHARED_KEY")));
            this.wlanProfileDetailPanel.markErrorComponent(OmiMessage.SSIDProfileType.psk.name() + (this.instance + 1));
            return null;
        }
        if (sSIDProfile.pskHex.booleanValue()) {
            if (n != 64) {
                GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PRE_SHARED_KEY_LENGTH_INVALID_ENTER_*_CHARACTERS"), 64));
                this.wlanProfileDetailPanel.markErrorComponent(OmiMessage.SSIDProfileType.psk.name() + (this.instance + 1));
                return null;
            }
            if (!string.matches("\\p{XDigit}+")) {
                GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_CONTAINS_INVALID_CHARS"), UtilLocale.getString("TXT_PRE_SHARED_KEY")));
                this.wlanProfileDetailPanel.markErrorComponent(OmiMessage.SSIDProfileType.psk.name() + (this.instance + 1));
                return null;
            }
        } else if (n < 8 || n > 63) {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PRE_SHARED_KEY_LENGTH_INVALID_ENTER_*_TO_*_CHARACTERS"), 8, 63));
            this.wlanProfileDetailPanel.markErrorComponent(OmiMessage.SSIDProfileType.psk.name() + (this.instance + 1));
            return null;
        }
        sSIDProfile.psk = string;
        return sSIDProfile;
    }

    private String getWEPKey(WLANProfileHandler.SSIDProfile sSIDProfile, int n) {
        String string;
        block11: {
            int n2;
            String string2;
            block13: {
                int n3;
                block14: {
                    block12: {
                        block7: {
                            int n4;
                            block9: {
                                block10: {
                                    block8: {
                                        string = this.textFieldWEPKey[n].getText();
                                        n3 = string.length();
                                        string2 = OmiMessage.SSIDProfileType.values()[OmiMessage.SSIDProfileType.wepKey1.ordinal() + n].name() + (this.instance + 1);
                                        if (n3 == 0) {
                                            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), this.labelWEPKey[n].getText()));
                                            this.wlanProfileDetailPanel.markErrorComponent(string2);
                                            return null;
                                        }
                                        if (!sSIDProfile.wepKeyHex.booleanValue()) break block7;
                                        if (sSIDProfile.keyLength != OmiMessage.WEPKeyLengthType.LEN_64) break block8;
                                        n4 = 10;
                                        if (10 != n3) break block9;
                                    }
                                    if (sSIDProfile.keyLength != OmiMessage.WEPKeyLengthType.LEN_128) break block10;
                                    n4 = 26;
                                    if (26 != n3) break block9;
                                }
                                if (sSIDProfile.keyLength != OmiMessage.WEPKeyLengthType.LEN_256) break block11;
                                n4 = 58;
                                if (58 == n3) break block11;
                            }
                            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_WEP_KEY_*_FORMAT_*_LENGTH_INVALID_REQUIRED_*_CHARACTERS"), this.labelWEPKey[n].getText(), UtilLocale.getString("TXT_HEX_VALUE_20"), n4));
                            this.wlanProfileDetailPanel.markErrorComponent(string2);
                            return null;
                        }
                        if (sSIDProfile.keyLength != OmiMessage.WEPKeyLengthType.LEN_64) break block12;
                        n2 = 5;
                        if (5 != n3) break block13;
                    }
                    if (sSIDProfile.keyLength != OmiMessage.WEPKeyLengthType.LEN_128) break block14;
                    n2 = 13;
                    if (13 != n3) break block13;
                }
                if (sSIDProfile.keyLength != OmiMessage.WEPKeyLengthType.LEN_256) break block11;
                n2 = 29;
                if (29 == n3) break block11;
            }
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_WEP_KEY_*_FORMAT_*_LENGTH_INVALID_REQUIRED_*_CHARACTERS"), this.labelWEPKey[n].getText(), UtilLocale.getString("TXT_TEXT_20"), n2));
            this.wlanProfileDetailPanel.markErrorComponent(string2);
            return null;
        }
        return string;
    }

    private String GenerateKey(boolean bl, int n) {
        String string = null;
        String string2 = "";
        string = bl ? "0123456789ABCDEF" : "0123456789ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
        for (int i = 0; i < n; ++i) {
            int n2 = (int)Math.floor(Math.random() * (double)string.length());
            String string3 = string.substring(n2, n2 + 1);
            string2 = string2.concat(string3);
        }
        return string2;
    }
}

