/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.SummaryHandler;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class AccountSummaryHandler
extends SummaryHandler {
    private AccountSummaryClass summary = null;
    private LinkedList<AccountSummaryNotificationInterface> listenerList = new LinkedList();

    public void registerAccountSummaryNotificationListener(AccountSummaryNotificationInterface accountSummaryNotificationInterface) {
        this.listenerList.add(accountSummaryNotificationInterface);
    }

    public void deregisterAccountSummaryNotificationListener(AccountSummaryNotificationInterface accountSummaryNotificationInterface) {
        this.listenerList.remove(accountSummaryNotificationInterface);
    }

    @Override
    protected void GenerateSummaryNotification() {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating account summary notification: No listener");
        }
        AccountSummaryClass accountSummaryClass = this.summary.clone();
        for (AccountSummaryNotificationInterface accountSummaryNotificationInterface : this.listenerList) {
            if (accountSummaryNotificationInterface == null) continue;
            accountSummaryNotificationInterface.processAccountSummaryNotification(accountSummaryClass);
        }
    }

    @Override
    protected void GenerateSummaryErrorNotification(OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating account summary error notification: No listener");
        }
        for (AccountSummaryNotificationInterface accountSummaryNotificationInterface : this.listenerList) {
            if (accountSummaryNotificationInterface == null) continue;
            accountSummaryNotificationInterface.processAccountSummaryErrorNotification(omiMessage);
        }
    }

    public AccountSummaryHandler(OmiManagement omiManagement) {
        super(omiManagement, OmiMessage.elemIds.GetAccountSummary, OmiMessage.elemIds.GetAccountSummaryResp, OmiMessage.elemIds.EventAccountSummary, OmiMessage.EventType.AccountSummary);
    }

    public AccountSummaryClass getSummary() {
        if (this.summary == null) {
            this.summary = new AccountSummaryClass();
        }
        return this.summary.clone();
    }

    @Override
    protected void initSummary() {
        if (this.summary == null) {
            this.summary = new AccountSummaryClass();
        } else {
            this.summary.clear();
        }
        this.GenerateSummaryNotification();
    }

    @Override
    protected boolean processSummary(OmiMessage omiMessage) {
        int n;
        boolean bl = false;
        if (omiMessage.getAttribVal(OmiMessage.attribIds.nRecords.name()) != null && this.summary.nRecords != (n = omiMessage.getAttribValInt(OmiMessage.attribIds.nRecords.name()))) {
            this.summary.nRecords = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.attribIds.idFirst.name()) != null && this.summary.idFirst != (n = omiMessage.getAttribValInt(OmiMessage.attribIds.idFirst.name()))) {
            this.summary.idFirst = n;
            bl = true;
        }
        return bl;
    }

    public static interface AccountSummaryNotificationInterface {
        public void processAccountSummaryNotification(AccountSummaryClass var1);

        public void processAccountSummaryErrorNotification(OmiMessage var1);
    }

    public static class AccountSummaryClass {
        public int nRecords = 0;
        public int idFirst = 0;

        public void clear() {
            this.nRecords = 0;
            this.idFirst = 0;
        }

        public AccountSummaryClass clone() {
            AccountSummaryClass accountSummaryClass = new AccountSummaryClass();
            accountSummaryClass.nRecords = this.nRecords;
            accountSummaryClass.idFirst = this.idFirst;
            return accountSummaryClass;
        }
    }
}

