/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.SummaryHandler;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class BluetoothBeaconSummaryHandler
extends SummaryHandler {
    private static final OmiMessage.EventType[] eventType = new OmiMessage.EventType[]{OmiMessage.EventType.BluetoothBeaconSumCnf, OmiMessage.EventType.BluetoothBeaconSumState};
    private BluetoothBeaconSummaryClass summary = null;
    private LinkedList<BluetoothBeaconSummaryNotificationInterface> listenerList = new LinkedList();

    public void registerBluetoothBeaconSummaryNotificationListener(BluetoothBeaconSummaryNotificationInterface bluetoothBeaconSummaryNotificationInterface) {
        this.listenerList.add(bluetoothBeaconSummaryNotificationInterface);
    }

    public void deregisterBluetoothBeaconSummaryNotificationListener(BluetoothBeaconSummaryNotificationInterface bluetoothBeaconSummaryNotificationInterface) {
        this.listenerList.remove(bluetoothBeaconSummaryNotificationInterface);
    }

    public BluetoothBeaconSummaryHandler(OmiManagement omiManagement) {
        super(omiManagement, OmiMessage.elemIds.GetBluetoothBeaconSummary, OmiMessage.elemIds.GetBluetoothBeaconSummaryResp, OmiMessage.elemIds.EventBluetoothBeaconSummary, eventType);
    }

    @Override
    protected void initSummary() {
        if (this.summary == null) {
            this.summary = new BluetoothBeaconSummaryClass();
        } else {
            this.summary.clear();
        }
        this.GenerateSummaryNotification();
    }

    public BluetoothBeaconSummaryClass getSummary() {
        if (this.summary == null) {
            this.summary = new BluetoothBeaconSummaryClass();
        }
        return this.summary.clone();
    }

    @Override
    protected boolean processSummary(OmiMessage omiMessage) {
        boolean bl = false;
        Integer n = omiMessage.getAttribValIntNotMandatory(OmiMessage.BluetoothSummaryType.nRecords.name());
        if (n != null && this.summary.nRecords != n) {
            this.summary.nRecords = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.BluetoothSummaryType.idFirst.name())) != null && this.summary.idFirst != n) {
            this.summary.idFirst = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.BluetoothSummaryType.checkpointNum.name())) != null && this.summary.checkpointNum != n) {
            this.summary.checkpointNum = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.BluetoothSummaryType.stateUnpluggedNum.name())) != null && this.summary.stateUnpluggedNum != n) {
            this.summary.stateUnpluggedNum = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.BluetoothSummaryType.statePluggedNum.name())) != null && this.summary.statePluggedNum != n) {
            this.summary.statePluggedNum = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.BluetoothSummaryType.stateFailedNum.name())) != null && this.summary.stateFailedNum != n) {
            this.summary.stateFailedNum = n;
            bl = true;
        }
        return bl;
    }

    @Override
    protected void GenerateSummaryNotification() {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating bluetooth beacon summary notification: No listener");
            return;
        }
        BluetoothBeaconSummaryClass bluetoothBeaconSummaryClass = this.summary.clone();
        for (BluetoothBeaconSummaryNotificationInterface bluetoothBeaconSummaryNotificationInterface : this.listenerList) {
            if (bluetoothBeaconSummaryNotificationInterface == null) continue;
            bluetoothBeaconSummaryNotificationInterface.processBluetoothBeaconSummaryNotification(bluetoothBeaconSummaryClass);
        }
    }

    @Override
    protected void GenerateSummaryErrorNotification(OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating bluetooth beacon summary error notification: No listener");
            return;
        }
        for (BluetoothBeaconSummaryNotificationInterface bluetoothBeaconSummaryNotificationInterface : this.listenerList) {
            if (bluetoothBeaconSummaryNotificationInterface == null) continue;
            bluetoothBeaconSummaryNotificationInterface.processBluetoothBeaconSummaryErrorNotification(omiMessage);
        }
    }

    public static interface BluetoothBeaconSummaryNotificationInterface {
        public void processBluetoothBeaconSummaryNotification(BluetoothBeaconSummaryClass var1);

        public void processBluetoothBeaconSummaryErrorNotification(OmiMessage var1);
    }

    public static class BluetoothBeaconSummaryClass {
        public int nRecords = 0;
        public int idFirst = 0;
        public int checkpointNum = 0;
        public int stateUnpluggedNum = 0;
        public int statePluggedNum = 0;
        public int stateFailedNum = 0;

        public void clear() {
            this.nRecords = 0;
            this.idFirst = 0;
            this.checkpointNum = 0;
            this.stateUnpluggedNum = 0;
            this.statePluggedNum = 0;
            this.stateFailedNum = 0;
        }

        public BluetoothBeaconSummaryClass clone() {
            BluetoothBeaconSummaryClass bluetoothBeaconSummaryClass = new BluetoothBeaconSummaryClass();
            bluetoothBeaconSummaryClass.nRecords = this.nRecords;
            bluetoothBeaconSummaryClass.idFirst = this.idFirst;
            bluetoothBeaconSummaryClass.checkpointNum = this.checkpointNum;
            bluetoothBeaconSummaryClass.stateUnpluggedNum = this.stateUnpluggedNum;
            bluetoothBeaconSummaryClass.statePluggedNum = this.statePluggedNum;
            bluetoothBeaconSummaryClass.stateFailedNum = this.stateFailedNum;
            return bluetoothBeaconSummaryClass;
        }
    }
}

