/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.Base64Coder;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.OmiRSA;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class ConferenceRoomHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    private static final int BUILTIN_MAX_CONFERENCE_ROOMS = 100;
    private static final int MAX_BULK_RECORDS = 20;
    private static final int INVALID_ID = -1;
    private OmiHandler omiHandler = null;
    CommonDataHandler commonDataHandler = null;
    private ConferenceRoomDatabase confRoomDb = new ConferenceRoomDatabase(100);
    private boolean getBulkInProgress = false;
    private FreeConferenceChannels freeConferenceChannels = new FreeConferenceChannels();
    private LinkedList<ConferenceRoomDataNotificationInterface> listenerList = new LinkedList();
    private LinkedList<FreeConferenceChannelsDataNotificationInterface> listenerListConfChannels = new LinkedList();

    public void registerDataNotificationListener(ConferenceRoomDataNotificationInterface conferenceRoomDataNotificationInterface) {
        this.listenerList.add(conferenceRoomDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(ConferenceRoomDataNotificationInterface conferenceRoomDataNotificationInterface) {
        this.listenerList.remove(conferenceRoomDataNotificationInterface);
    }

    private void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating conference room notification: No listener");
        }
        for (ConferenceRoomDataNotificationInterface conferenceRoomDataNotificationInterface : this.listenerList) {
            if (conferenceRoomDataNotificationInterface == null) continue;
            conferenceRoomDataNotificationInterface.processConferenceRoomDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating conference room error notification: No listener");
        }
        for (ConferenceRoomDataNotificationInterface conferenceRoomDataNotificationInterface : this.listenerList) {
            if (conferenceRoomDataNotificationInterface == null) continue;
            conferenceRoomDataNotificationInterface.processConferenceRoomDataErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public ConferenceRoomHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        omiManagement.registerManagementEventListener(this);
        OmiMessage.elemIds.CreateConferenceRoomResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteConferenceRoomResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetConferenceRoomResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetConferenceRoomResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventConferenceRoomCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetFreeConferenceChannelsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventFreeConferenceChannels.registerDataNotificationListener(this);
    }

    public Database getDb() {
        return this.confRoomDb;
    }

    public ConferenceRoom getConferenceRoomById(int n) {
        return this.confRoomDb.getRecordById(n);
    }

    public ConferenceRoom getConferenceRoomByTableIdx(int n) {
        return this.confRoomDb.getRecordByIdx(n);
    }

    public int getNumberOfConferenceRooms() {
        return this.confRoomDb.getRecordNumber();
    }

    public void sendGetConferenceRoom(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetConferenceRoom);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendGetConferenceRoomBulk(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetConferenceRoom);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
        if (n2 > 1) {
            this.getBulkInProgress = true;
        }
    }

    public void sendCreateConferenceRoom(ConferenceRoom conferenceRoom) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreateConferenceRoom);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.room);
        if (conferenceRoom.id != -1) {
            omiMessage2.addAttrib(OmiMessage.ConferenceRoomType.id.name(), conferenceRoom.id);
        }
        if (conferenceRoom.name != null) {
            omiMessage2.addAttrib(OmiMessage.ConferenceRoomType.name.name(), conferenceRoom.name);
        }
        if (conferenceRoom.conferenceId != null) {
            omiMessage2.addAttrib(OmiMessage.ConferenceRoomType.conferenceId.name(), conferenceRoom.conferenceId);
        }
        if (conferenceRoom.sipAuthId != null) {
            omiMessage2.addAttrib(OmiMessage.ConferenceRoomType.sipAuthId.name(), conferenceRoom.sipAuthId);
        }
        if (conferenceRoom.sipPassword != null) {
            byte[] byArray = OmiRSA.encrypt(conferenceRoom.sipPassword);
            if (byArray != null) {
                char[] cArray = Base64Coder.encode(byArray);
                omiMessage2.addAttrib(OmiMessage.ConferenceRoomType.sipPw.name(), new String(cArray));
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "Conference room: Encryption failed");
            }
        }
        if (conferenceRoom.fixedSipPort != null) {
            omiMessage2.addAttrib(OmiMessage.ConferenceRoomType.fixedSipPort.name(), conferenceRoom.fixedSipPort);
        }
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendSetConferenceRoom(ConferenceRoom conferenceRoom) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetConferenceRoom);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), conferenceRoom.id);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.room);
        omiMessage2.addAttrib(OmiMessage.ConferenceRoomType.id.name(), conferenceRoom.id);
        if (conferenceRoom.name != null) {
            omiMessage2.addAttrib(OmiMessage.ConferenceRoomType.name.name(), conferenceRoom.name);
        }
        if (conferenceRoom.conferenceId != null) {
            omiMessage2.addAttrib(OmiMessage.ConferenceRoomType.conferenceId.name(), conferenceRoom.conferenceId);
        }
        if (conferenceRoom.sipAuthId != null) {
            omiMessage2.addAttrib(OmiMessage.ConferenceRoomType.sipAuthId.name(), conferenceRoom.sipAuthId);
        }
        if (conferenceRoom.sipPassword != null) {
            byte[] byArray = OmiRSA.encrypt(conferenceRoom.sipPassword);
            if (byArray != null) {
                char[] cArray = Base64Coder.encode(byArray);
                omiMessage2.addAttrib(OmiMessage.ConferenceRoomType.sipPw.name(), new String(cArray));
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "Conference room: Encryption failed");
            }
        }
        if (conferenceRoom.fixedSipPort != null) {
            omiMessage2.addAttrib(OmiMessage.ConferenceRoomType.fixedSipPort.name(), conferenceRoom.fixedSipPort);
        }
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendDeleteConferenceRoom(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteConferenceRoom);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        omiMessage.addAttrib(OmiMessage.SiteType.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            this.confRoomDb.clearAll();
            this.GenerateDataNotification(0, DataNotificationEnum.DATA_DELETED_ALL);
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.ConferenceCnf, null, null);
            this.sendGetConferenceRoomBulk(0, 20);
            this.freeConferenceChannels.clear();
            this.GenerateConfChannelsDataNotification(DataNotificationEnum.DATA_DELETED);
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.Conference, null, null);
            this.sendGetFreeConferenceChannels();
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        String string = null;
        switch (omiMessage.id) {
            case GetConferenceRoomResp: {
                int n = this.processGetConferenceRoomResp(omiMessage);
                if (!this.getBulkInProgress) break;
                if (n > 0) {
                    this.sendGetConferenceRoomBulk(n + 1, 20);
                    break;
                }
                this.getBulkInProgress = false;
                this.GenerateDataNotification(this.confRoomDb.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
                break;
            }
            case CreateConferenceRoomResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                OmiMessage omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null && this.processConferenceRoomElem(omiMessage2, DataNotificationEnum.NEW_DATA)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "CreateConferenceRoomResp - no ConferenceRoom elem");
                break;
            }
            case SetConferenceRoomResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                OmiMessage omiMessage3 = omiMessage.getSubElement();
                if (omiMessage3 != null && this.processConferenceRoomElem(omiMessage3, DataNotificationEnum.DATA_CHANGED)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetConferenceRoomResp - no ConferenceRoom elem");
                break;
            }
            case DeleteConferenceRoomResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_DELETED, omiMessage);
                    break;
                }
                int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                this.confRoomDb.deleteConfRoom(n);
                this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                break;
            }
            case EventConferenceRoomCnf: {
                OmiMessage omiMessage4 = omiMessage.getSubElement();
                if (omiMessage4 != null) {
                    boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                    if (bl) {
                        if (omiMessage4.id == OmiMessage.elemIds.room) {
                            int n = omiMessage4.getAttribValInt(OmiMessage.ConferenceRoomType.id.name());
                            this.confRoomDb.deleteConfRoom(n);
                            this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                            break;
                        }
                    } else if (this.processConferenceRoomElem(omiMessage4, DataNotificationEnum.DATA_CHANGED)) break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventConferenceRoomCnf - no ConferenceRoom elem");
                break;
            }
            case GetFreeConferenceChannelsResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateConfChannelsErrorNotification(DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                this.processFreeConferenceChannelsElem(omiMessage);
                this.GenerateConfChannelsDataNotification(DataNotificationEnum.NEW_DATA);
                break;
            }
            case EventFreeConferenceChannels: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateConfChannelsErrorNotification(DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                if (!this.processFreeConferenceChannelsElem(omiMessage)) break;
                this.GenerateConfChannelsDataNotification(DataNotificationEnum.DATA_CHANGED);
                break;
            }
        }
    }

    private int processGetConferenceRoomResp(OmiMessage omiMessage) {
        ConferenceRoom conferenceRoom;
        int n = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (!this.processConferenceRoomElem(omiMessage2, DataNotificationEnum.NEW_DATA)) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetConferenceRoomResp - no ConferenceRoom elem");
                continue;
            }
            ++n;
        }
        if (n == 20 && (conferenceRoom = this.confRoomDb.getRecordByIdx(this.confRoomDb.getRecordNumber() - 1)) != null) {
            return (Integer)conferenceRoom.getField(0);
        }
        return 0;
    }

    private boolean processConferenceRoomElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum) {
        if (omiMessage.id == OmiMessage.elemIds.room) {
            int n = omiMessage.getAttribValInt(OmiMessage.ConferenceRoomType.id.name());
            ConferenceRoom conferenceRoom = this.confRoomDb.getRecordById(n);
            if (conferenceRoom == null) {
                conferenceRoom = new ConferenceRoom(n);
            } else {
                conferenceRoom.commitChanges();
            }
            conferenceRoom.name = this.updateStringAttrib(omiMessage.getAttribVal(OmiMessage.ConferenceRoomType.name.name()), conferenceRoom.name);
            conferenceRoom.conferenceId = this.updateStringAttrib(omiMessage.getAttribVal(OmiMessage.ConferenceRoomType.conferenceId.name()), conferenceRoom.conferenceId);
            conferenceRoom.sipAuthId = this.updateStringAttrib(omiMessage.getAttribVal(OmiMessage.ConferenceRoomType.sipAuthId.name()), conferenceRoom.sipAuthId);
            conferenceRoom.sipPassword = this.updateStringAttrib(omiMessage.getAttribVal(OmiMessage.ConferenceRoomType.sipPw.name()), conferenceRoom.sipPassword);
            Integer n2 = omiMessage.getAttribValIntNotMandatory(OmiMessage.ConferenceRoomType.fixedSipPort.name());
            if (n2 != null && conferenceRoom.fixedSipPort != n2) {
                conferenceRoom.fixedSipPort = n2;
            }
            if ((n2 = omiMessage.getAttribValIntNotMandatory(OmiMessage.ConferenceRoomType.calculatedSipPort.name())) != null && conferenceRoom.calculatedSipPort != n2) {
                conferenceRoom.calculatedSipPort = n2;
            }
            this.confRoomDb.addConfRoom(conferenceRoom);
            this.GenerateDataNotification(n, dataNotificationEnum);
            return true;
        }
        return false;
    }

    private String updateStringAttrib(String string, String string2) {
        if (string2 != null) {
            if (string != null && !string.equals(string2)) {
                string2 = string;
            }
        } else if (string != null) {
            string2 = string;
        }
        return string2;
    }

    public FreeConferenceChannels getFreeConferenceChannels() {
        return this.freeConferenceChannels;
    }

    private boolean processFreeConferenceChannelsElem(OmiMessage omiMessage) {
        FreeConferenceChannels freeConferenceChannels = new FreeConferenceChannels();
        boolean bl = false;
        if (omiMessage.getAttribVal(OmiMessage.attribIds.freeChannels.name()) != null) {
            freeConferenceChannels.freeChannels = omiMessage.getAttribValInt(OmiMessage.attribIds.freeChannels.name());
            if (this.freeConferenceChannels.freeChannels != freeConferenceChannels.freeChannels) {
                this.freeConferenceChannels.freeChannels = freeConferenceChannels.freeChannels;
                bl = true;
            }
        }
        if (omiMessage.getAttribVal(OmiMessage.attribIds.totalChannels.name()) != null) {
            freeConferenceChannels.totalChannels = omiMessage.getAttribValInt(OmiMessage.attribIds.totalChannels.name());
            if (this.freeConferenceChannels.totalChannels != freeConferenceChannels.totalChannels) {
                this.freeConferenceChannels.totalChannels = freeConferenceChannels.totalChannels;
                bl = true;
            }
        }
        return bl;
    }

    private void sendGetFreeConferenceChannels() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetFreeConferenceChannels);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void registerDataNotificationListener(FreeConferenceChannelsDataNotificationInterface freeConferenceChannelsDataNotificationInterface) {
        this.listenerListConfChannels.add(freeConferenceChannelsDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(FreeConferenceChannelsDataNotificationInterface freeConferenceChannelsDataNotificationInterface) {
        this.listenerListConfChannels.remove(freeConferenceChannelsDataNotificationInterface);
    }

    private void GenerateConfChannelsDataNotification(DataNotificationEnum dataNotificationEnum) {
        if (this.listenerListConfChannels.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating free conference channels notification: No listener");
        }
        for (FreeConferenceChannelsDataNotificationInterface freeConferenceChannelsDataNotificationInterface : this.listenerListConfChannels) {
            if (freeConferenceChannelsDataNotificationInterface == null) continue;
            freeConferenceChannelsDataNotificationInterface.processFreeConferenceChannelsDataNotification(dataNotificationEnum);
        }
    }

    private void GenerateConfChannelsErrorNotification(DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerListConfChannels.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating free conference channels error notification: No listener");
        }
        for (FreeConferenceChannelsDataNotificationInterface freeConferenceChannelsDataNotificationInterface : this.listenerListConfChannels) {
            if (freeConferenceChannelsDataNotificationInterface == null) continue;
            freeConferenceChannelsDataNotificationInterface.processFreeConferenceChannelsDataErrorNotification(dataNotificationEnum, omiMessage);
        }
    }

    public static interface FreeConferenceChannelsDataNotificationInterface {
        public void processFreeConferenceChannelsDataNotification(DataNotificationEnum var1);

        public void processFreeConferenceChannelsDataErrorNotification(DataNotificationEnum var1, OmiMessage var2);
    }

    public static interface ConferenceRoomDataNotificationInterface {
        public void processConferenceRoomDataNotification(int var1, DataNotificationEnum var2);

        public void processConferenceRoomDataErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }

    public static class ConferenceRoomDatabase
    extends Database {
        public static int maxConfRooms = 0;
        ConferenceRoom[] confRooms = null;
        int[] idxConfRooms = null;
        int nbOfConfRooms = 0;

        public ConferenceRoomDatabase(int n) {
            maxConfRooms = n;
            this.confRooms = new ConferenceRoom[maxConfRooms];
            this.idxConfRooms = new int[maxConfRooms];
        }

        @Override
        public ConferenceRoom getRecordByIdx(int n) {
            if (n >= 0 && n < this.nbOfConfRooms) {
                return this.confRooms[this.idxConfRooms[n]];
            }
            return null;
        }

        public ConferenceRoom getRecordById(int n) {
            if (n >= 0 && n < maxConfRooms) {
                return this.confRooms[n];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.nbOfConfRooms;
        }

        @Override
        public void updateIndex() {
            this.nbOfConfRooms = 0;
            for (int i = 0; i < maxConfRooms; ++i) {
                if (this.confRooms[i] == null) continue;
                this.idxConfRooms[this.nbOfConfRooms++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public void addConfRoom(ConferenceRoom conferenceRoom) {
            if (conferenceRoom.id >= 0 && conferenceRoom.id < maxConfRooms) {
                this.confRooms[conferenceRoom.id] = conferenceRoom;
                this.updateIndex();
            }
        }

        public void deleteConfRoom(int n) {
            if (n >= 0 && n < maxConfRooms) {
                this.confRooms[n] = null;
                this.updateIndex();
            }
        }

        public void clearAll() {
            for (int i = 0; i < maxConfRooms; ++i) {
                this.confRooms[i] = null;
            }
            this.nbOfConfRooms = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        @Override
        public String[] getFieldNames() {
            return ConferenceRoom.getFieldNames();
        }
    }

    public static class ConferenceRoom
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_NAME = 1;
        public static final int IDX_CONFERENCE_ID = 2;
        public static final int IDX_SIP_AUTH_ID = 3;
        public static final int IDX_SIP_PASSWORD = 4;
        public static final int IDX_FIXED_SIP_PORT = 5;
        public static final int IDX_CALCULATED_SIP_PORT = 6;
        public static final int NUMBER_OF_FIELDS = 7;
        public int id = -1;
        public String name = null;
        public String conferenceId = null;
        public String sipAuthId = null;
        public String sipPassword = null;
        public Integer fixedSipPort = 0;
        public Integer calculatedSipPort = 0;
        boolean changed = false;
        private static String[] fieldNames = new String[]{"conferenceRoomId", "name", "conferenceId", "sipAuthId", "sipPassword", "fixedSipPort", "calcSipPort"};

        public ConferenceRoom() {
        }

        public ConferenceRoom(int n) {
            this.id = n;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 7) {
                ConferenceRoom.fieldNames[n] = string;
            }
        }

        public static String[] getFieldNames() {
            return fieldNames;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.name;
                }
                case 2: {
                    return this.conferenceId;
                }
                case 3: {
                    return this.sipAuthId;
                }
                case 4: {
                    return this.sipPassword;
                }
                case 5: {
                    return this.fixedSipPort;
                }
                case 6: {
                    return this.calculatedSipPort;
                }
            }
            return null;
        }

        @Override
        public void setField(int n, Object object) {
            int n2 = 0;
            String string = null;
            try {
                switch (n) {
                    case 0: 
                    case 5: {
                        n2 = (Integer)object;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = (String)object;
                    }
                }
            }
            catch (Exception exception) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "Cannot set field with idx '%d" + n + "'");
                return;
            }
            switch (n) {
                case 0: {
                    if (this.id == n2) break;
                    this.changed = true;
                    this.id = n2;
                    break;
                }
                case 1: {
                    if (string != null && this.name != null) {
                        if (this.name.equals(string)) break;
                        this.changed = true;
                        this.name = string;
                        break;
                    }
                    if (string == null && this.name == null) break;
                    this.changed = true;
                    this.name = string;
                    break;
                }
                case 2: {
                    if (string != null && this.conferenceId != null) {
                        if (this.conferenceId.equals(string)) break;
                        this.changed = true;
                        this.conferenceId = string;
                        break;
                    }
                    if (string == null && this.conferenceId == null) break;
                    this.changed = true;
                    this.conferenceId = string;
                    break;
                }
                case 3: {
                    if (string != null && this.sipAuthId != null) {
                        if (this.sipAuthId.equals(string)) break;
                        this.changed = true;
                        this.sipAuthId = string;
                        break;
                    }
                    if (string == null && this.sipAuthId == null) break;
                    this.changed = true;
                    this.sipAuthId = string;
                    break;
                }
                case 4: {
                    if (string != null && this.sipPassword != null) {
                        if (this.sipPassword.equals(string)) break;
                        this.changed = true;
                        this.sipPassword = string;
                        break;
                    }
                    if (string == null && this.sipPassword == null) break;
                    this.changed = true;
                    this.sipPassword = string;
                    break;
                }
                case 5: {
                    if (this.fixedSipPort == n2) break;
                    this.changed = true;
                    this.fixedSipPort = n2;
                }
            }
        }

        public boolean getRecordChanged() {
            return this.changed;
        }

        public void commitChanges() {
            this.changed = false;
        }

        @Override
        public ConferenceRoom clone() {
            ConferenceRoom conferenceRoom = new ConferenceRoom();
            conferenceRoom.id = this.id;
            conferenceRoom.name = this.name;
            conferenceRoom.conferenceId = this.conferenceId;
            conferenceRoom.sipAuthId = this.sipAuthId;
            conferenceRoom.sipPassword = this.sipPassword;
            conferenceRoom.fixedSipPort = this.fixedSipPort;
            conferenceRoom.calculatedSipPort = this.calculatedSipPort;
            return conferenceRoom;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class FreeConferenceChannels {
        public int freeChannels = 0;
        public int totalChannels = 0;

        private void clear() {
            this.freeChannels = 0;
            this.totalChannels = 0;
        }
    }
}

