/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataRecord;
import com.aastra.omilib.DatabaseChangeEvent;
import java.util.LinkedList;

public class Database {
    public static final int MAX_FIELD = 125;
    public static final int MAX_FILTER_ITEMS = 3;
    private FilterItem[] filterArray = null;
    private String[] format = null;
    protected LinkedList<DatabaseChangeNotificationInterface> listenerList = new LinkedList();

    public void registerChangeNotificationListener(DatabaseChangeNotificationInterface databaseChangeNotificationInterface) {
        this.listenerList.add(databaseChangeNotificationInterface);
    }

    public void deregisterChangeNotificationListener(DatabaseChangeNotificationInterface databaseChangeNotificationInterface) {
        this.listenerList.remove(databaseChangeNotificationInterface);
    }

    protected void generateChangeNotification(DatabaseChangeEvent databaseChangeEvent) {
        if (this.listenerList.size() == 0) {
            return;
        }
        for (DatabaseChangeNotificationInterface databaseChangeNotificationInterface : this.listenerList) {
            if (databaseChangeNotificationInterface == null) continue;
            databaseChangeNotificationInterface.databaseChangeNotification(databaseChangeEvent);
        }
    }

    protected void generateChangeNotification(DatabaseChangeEnum databaseChangeEnum) {
        this.generateChangeNotification(new DatabaseChangeEvent(databaseChangeEnum, 0, DatabaseChangeEvent.DatabaseChangeType.ALL));
    }

    public static String wildcardToRegex(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append('^');
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': {
                    stringBuffer.append(".*");
                    continue block5;
                }
                case '?': {
                    stringBuffer.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    stringBuffer.append("\\");
                    stringBuffer.append(c);
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append('$');
        return stringBuffer.toString();
    }

    public int getRecordNumber() {
        return 0;
    }

    public DataRecord getRecordByIdx(int n) {
        return null;
    }

    public String[] getFieldNames() {
        return null;
    }

    public int[][] getFieldDetailCoordinates() {
        return null;
    }

    public void setFieldFormatString(int n, String string) {
        if (n >= 0 && n < 125) {
            if (this.format == null) {
                this.format = new String[125];
            }
            this.format[n] = string;
        }
    }

    public String getFieldFormatString(int n) {
        if (n < 0 || n >= 125) {
            return null;
        }
        if (this.format == null) {
            return null;
        }
        return this.format[n];
    }

    private FilterItem[] getFilterArray() {
        if (this.filterArray == null) {
            this.filterArray = new FilterItem[3];
            for (int i = 0; i < 3; ++i) {
                this.filterArray[i] = new FilterItem();
            }
        }
        return this.filterArray;
    }

    public void setFilter(int[] nArray, String string, int n) {
        this.getFilterArray();
        this.filterArray[n].filterActive = false;
        this.filterArray[n].filterColumArr = nArray;
        this.filterArray[n].filterString = string;
        if ((string != null || nArray != null) && string.length() > 0 && nArray.length > 0) {
            this.filterArray[n].filterActive = true;
        }
    }

    public String getFilterString() {
        return this.getFilterString(0);
    }

    public String getFilterString(int n) {
        return this.getFilterArray()[n].filterString;
    }

    public int[] getFilterColumnArray() {
        return this.getFilterColumnArray(0);
    }

    public int[] getFilterColumnArray(int n) {
        return this.getFilterArray()[n].filterColumArr;
    }

    public boolean getFilterActive() {
        return this.getFilterActive(0);
    }

    public boolean getFilterActive(int n) {
        return this.getFilterArray()[n].filterActive;
    }

    public void updateIndex() {
        this.generateChangeNotification(DatabaseChangeEnum.INDEX_UPDATE);
    }

    protected String getFilterCmpString(Object object, String string) {
        if (object != null) {
            if (object.getClass() == Boolean.class) {
                if (((Boolean)object).booleanValue()) {
                    return "1";
                }
                return "0";
            }
            if (object.getClass() == Enum.class) {
                return ((Enum)object).name();
            }
            if (object.getClass() == Integer.class) {
                if (string != null) {
                    if (string.equals("0x%03X")) {
                        return this.getHexFormatString((Integer)object);
                    }
                    return String.format(string, object);
                }
                return object.toString();
            }
            return object.toString();
        }
        return null;
    }

    protected boolean filterMatch(DataRecord dataRecord) {
        boolean bl = false;
        if (this.filterMatchSingle(0, dataRecord)) {
            if (this.getFilterActive(1)) {
                if (this.filterMatchSingle(1, dataRecord)) {
                    bl = this.getFilterActive(2) ? this.filterMatchSingle(2, dataRecord) : true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    protected boolean filterMatchSingle(int n, DataRecord dataRecord) {
        for (int i = 0; i < this.getFilterColumnArray(n).length; ++i) {
            if (!this.matchObjectWithFilter(dataRecord.getField(this.getFilterColumnArray(n)[i]), this.getFilterColumnArray(n)[i], n)) continue;
            return true;
        }
        return false;
    }

    protected boolean matchObjectWithFilter(Object object, int n) {
        return this.matchObjectWithFilter(object, n, 0);
    }

    protected boolean matchObjectWithFilter(Object object, int n, int n2) {
        String string = this.getFilterCmpString(object, this.getFieldFormatString(n));
        return string != null && string.contains(this.getFilterArray()[n2].filterString);
    }

    private String getHexFormatString(Integer n) {
        String string = Integer.toHexString(n).toUpperCase();
        switch (string.length()) {
            case 1: {
                return "0x00" + string;
            }
            case 2: {
                return "0x0" + string;
            }
        }
        return "0x" + string;
    }

    public static interface DatabaseChangeNotificationInterface {
        public void databaseChangeNotification(DatabaseChangeEvent var1);
    }

    public static enum DatabaseChangeEnum {
        RECORD_ADDED,
        RECORD_CHANGED,
        RECORD_DELETED,
        INDEX_UPDATE;

    }

    public static class FilterItem {
        public String filterString = null;
        public int[] filterColumArr = null;
        public boolean filterActive = false;
    }
}

