/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.Base64Coder;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.OmiRSA;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class LDAPDataHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    private LDAPDatabase ldapDb = new LDAPDatabase();
    private OmiHandler omiHandler = null;
    private boolean listener = true;
    private LinkedList<LDAPCnfDataNotificationInterface> listenerList = new LinkedList();
    private static final int noOrder = -1;
    private static String[] fieldNames = new String[]{"id", "name", "active", "order", "server", "port", "base", "username", "password", "searchType", "displayType", "timeout"};

    public LDAPDataHandler(OmiManagement omiManagement) {
        this.initialize(omiManagement);
    }

    public LDAPDataHandler(OmiManagement omiManagement, boolean bl) {
        this.listener = bl;
        this.initialize(omiManagement);
    }

    private void initialize(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        omiManagement.registerManagementEventListener(this);
        OmiMessage.elemIds.GetLDAPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreateLDAPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetLDAPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventLDAPCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteLDAPResp.registerDataNotificationListener(this);
    }

    public void registerDataNotificationListener(LDAPCnfDataNotificationInterface lDAPCnfDataNotificationInterface) {
        this.listenerList.add(lDAPCnfDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(LDAPCnfDataNotificationInterface lDAPCnfDataNotificationInterface) {
        this.listenerList.remove(lDAPCnfDataNotificationInterface);
    }

    private void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listener & this.listenerList.size() == 0) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generate LDAP DataNotification - no Device Listener");
        }
        for (LDAPCnfDataNotificationInterface lDAPCnfDataNotificationInterface : this.listenerList) {
            if (lDAPCnfDataNotificationInterface == null) continue;
            lDAPCnfDataNotificationInterface.processLDAPDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listener & this.listenerList.size() == 0) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generate LDAP ErrorNotification - no Device Listener");
        }
        for (LDAPCnfDataNotificationInterface lDAPCnfDataNotificationInterface : this.listenerList) {
            if (lDAPCnfDataNotificationInterface == null) continue;
            lDAPCnfDataNotificationInterface.processLDAPErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public Database getDb() {
        return this.ldapDb;
    }

    public int getNumberOfLDAP() {
        return this.ldapDb.getRecordNumber();
    }

    public LDAPRecord getLDAPRecordById(int n) {
        LDAPRecord lDAPRecord = this.ldapDb.getRecordById(n);
        return lDAPRecord;
    }

    public LDAPRecord getLDAPRecordByTableIdx(int n) {
        LDAPRecord lDAPRecord = this.ldapDb.getRecordByIdx(n);
        return lDAPRecord;
    }

    public void sendGetLDAP(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetLDAP);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendGetLDAPAll() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetLDAP);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendCreateLDAP(LDAPRecord lDAPRecord) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreateLDAP);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.ldap);
        this.addAttribsLDAP(lDAPRecord, omiMessage2);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendSetLDAP(LDAPRecord lDAPRecord) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetLDAP);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), lDAPRecord.id);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.ldap);
        omiMessage2.addAttrib(OmiMessage.LDAPNewType.id.name(), lDAPRecord.id);
        this.addAttribsLDAP(lDAPRecord, omiMessage2);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    private void addAttribsLDAP(LDAPRecord lDAPRecord, OmiMessage omiMessage) {
        byte[] byArray;
        if (lDAPRecord.name != null) {
            omiMessage.addAttrib(OmiMessage.LDAPNewType.name.name(), lDAPRecord.name);
        }
        omiMessage.addAttrib(OmiMessage.LDAPNewType.active.name(), lDAPRecord.active);
        if (lDAPRecord.order != -1) {
            omiMessage.addAttrib(OmiMessage.LDAPNewType.order.name(), lDAPRecord.order);
        }
        if (lDAPRecord.server != null) {
            omiMessage.addAttrib(OmiMessage.LDAPNewType.server.name(), lDAPRecord.server);
        }
        omiMessage.addAttrib(OmiMessage.LDAPNewType.port.name(), lDAPRecord.port);
        if (lDAPRecord.searchBase != null) {
            omiMessage.addAttrib(OmiMessage.LDAPNewType.searchBase.name(), lDAPRecord.searchBase);
        }
        if (lDAPRecord.username != null) {
            omiMessage.addAttrib(OmiMessage.LDAPNewType.username.name(), lDAPRecord.username);
        }
        if (lDAPRecord.password != null && (byArray = OmiRSA.encrypt(lDAPRecord.password)) != null) {
            char[] cArray = Base64Coder.encode(byArray);
            omiMessage.addAttrib(OmiMessage.LDAPNewType.password.name(), new String(cArray));
        }
        if (lDAPRecord.searchType != null) {
            omiMessage.addAttrib(OmiMessage.LDAPNewType.searchType.name(), lDAPRecord.searchType.name());
        }
        if (lDAPRecord.displayType != null) {
            omiMessage.addAttrib(OmiMessage.LDAPNewType.displayType.name(), lDAPRecord.displayType.getStringFromEnum());
        }
        omiMessage.addAttrib(OmiMessage.LDAPNewType.timeout.name(), lDAPRecord.timeout);
    }

    public void sendDeleteLDAP(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteLDAP);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        omiMessage.addAttrib(OmiMessage.LDAPNewType.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    private void processGetLDAPResp(OmiMessage omiMessage) {
        int n = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (this.processLDAPElem(omiMessage2, DataNotificationEnum.NEW_DATA)) {
                ++n;
                continue;
            }
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetLDAPResp no LDAP elem");
        }
        if (n > 5) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetLDAPResp contains more LDAP elems than allowed");
        }
    }

    private boolean processLDAPElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum) {
        if (omiMessage.id == OmiMessage.elemIds.ldap) {
            Integer n;
            Boolean bl;
            int n2 = omiMessage.getAttribValInt(OmiMessage.LDAPNewType.id.name());
            LDAPRecord lDAPRecord = this.ldapDb.getRecordById(n2);
            if (lDAPRecord == null) {
                lDAPRecord = new LDAPRecord(n2);
            }
            lDAPRecord.id = omiMessage.getAttribValInt(OmiMessage.LDAPNewType.id.name());
            String string = omiMessage.getAttribVal(OmiMessage.LDAPNewType.name.name());
            if (string != null) {
                lDAPRecord.name = string;
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.LDAPNewType.active.name())) != null) {
                lDAPRecord.active = bl;
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.LDAPNewType.order.name())) != null) {
                lDAPRecord.order = n;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.LDAPNewType.server.name())) != null) {
                lDAPRecord.server = string;
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.LDAPNewType.port.name())) != null) {
                lDAPRecord.port = n;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.LDAPNewType.searchBase.name())) != null) {
                lDAPRecord.searchBase = string;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.LDAPNewType.username.name())) != null) {
                lDAPRecord.username = string;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.LDAPNewType.password.name())) != null) {
                lDAPRecord.password = string;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.LDAPNewType.searchType.name())) != null) {
                lDAPRecord.searchType = OmiMessage.SearchNewType.valueOf(string);
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.LDAPNewType.displayType.name())) != null) {
                lDAPRecord.displayType = OmiMessage.DisplayNewType.getEnumFromString(string);
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.LDAPNewType.timeout.name())) != null) {
                lDAPRecord.timeout = n;
            }
            this.ldapDb.addLDAP(lDAPRecord);
            this.GenerateDataNotification(n2, dataNotificationEnum);
            return true;
        }
        return false;
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            this.ldapDb.clearAll();
            this.sendGetLDAPAll();
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        String string = null;
        switch (omiMessage.id) {
            case GetLDAPResp: {
                this.processGetLDAPResp(omiMessage);
                break;
            }
            case CreateLDAPResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                OmiMessage omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null && this.processLDAPElem(omiMessage2, DataNotificationEnum.NEW_DATA)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "CreateLDAPResp no LDAP elem");
                break;
            }
            case DeleteLDAPResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_DELETED, omiMessage);
                    break;
                }
                int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                this.ldapDb.deleteLDAP(n);
                this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                break;
            }
            case SetLDAPResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                OmiMessage omiMessage3 = omiMessage.getSubElement();
                if (omiMessage3 != null && this.processLDAPElem(omiMessage3, DataNotificationEnum.DATA_CHANGED)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetLDAPResp no LDAP elem");
                break;
            }
            case EventLDAPCnf: {
                OmiMessage omiMessage4 = omiMessage.getSubElement();
                if (omiMessage4 != null) {
                    boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                    if (bl) {
                        if (omiMessage4.id == OmiMessage.elemIds.ldap) {
                            int n = omiMessage4.getAttribValInt(OmiMessage.LDAPNewType.id.name());
                            this.ldapDb.deleteLDAP(n);
                            this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                            break;
                        }
                    } else if (this.processLDAPElem(omiMessage4, DataNotificationEnum.DATA_CHANGED)) break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventLDAPCnf no LDAP elem");
                break;
            }
        }
    }

    public static interface LDAPCnfDataNotificationInterface {
        public void processLDAPDataNotification(int var1, DataNotificationEnum var2);

        public void processLDAPErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }

    public static class LDAPDatabase
    extends Database {
        public static final int MAX_ENTRIES = 5;
        LDAPRecord[] ldapRecords = new LDAPRecord[5];
        int[] ldapIdx = new int[5];
        int noOfLDAPs = 0;

        @Override
        public LDAPRecord getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfLDAPs) {
                return this.ldapRecords[this.ldapIdx[n]];
            }
            return null;
        }

        public LDAPRecord getRecordById(int n) {
            if (n >= 0 && n < 5) {
                return this.ldapRecords[n];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfLDAPs;
        }

        @Override
        public void updateIndex() {
            this.noOfLDAPs = 0;
            for (int i = 0; i < 5; ++i) {
                if (this.ldapRecords[i] == null) continue;
                this.ldapIdx[this.noOfLDAPs++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public void addLDAP(LDAPRecord lDAPRecord) {
            if (lDAPRecord.id >= 0 && lDAPRecord.id < 5) {
                this.ldapRecords[lDAPRecord.id] = lDAPRecord;
                this.updateIndex();
            }
        }

        public void deleteLDAP(int n) {
            this.ldapRecords[n] = null;
            this.updateIndex();
        }

        public void clearAll() {
            for (int i = 0; i < this.noOfLDAPs; ++i) {
                this.ldapRecords[i] = null;
            }
            this.noOfLDAPs = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        @Override
        public String[] getFieldNames() {
            return fieldNames;
        }
    }

    public static class LDAPRecord
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_NAME = 1;
        public static final int IDX_ACTIVE = 2;
        public static final int IDX_ORDER = 3;
        public static final int IDX_SERVER = 4;
        public static final int IDX_PORT = 5;
        public static final int IDX_SEARCH_BASE = 6;
        public static final int IDX_USERNAME = 7;
        public static final int IDX_PASSWORD = 8;
        public static final int IDX_SEARCH_TYPE = 9;
        public static final int IDX_DISPLAY_TYPE = 10;
        public static final int IDX_TIMEOUT = 11;
        public static final int NUMBER_OF_FIELDS = 12;
        public int id;
        public String name = null;
        public boolean active = false;
        public int order = 0;
        public String server = null;
        public int port = 0;
        public String searchBase = null;
        public String username = null;
        public String password = null;
        public OmiMessage.SearchNewType searchType = null;
        public OmiMessage.DisplayNewType displayType = null;
        public int timeout = 0;

        public LDAPRecord() {
        }

        public LDAPRecord(int n) {
            this.id = n;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.name;
                }
                case 2: {
                    return this.active;
                }
                case 3: {
                    return this.order;
                }
                case 4: {
                    return this.server;
                }
                case 5: {
                    return this.port;
                }
                case 6: {
                    return this.searchBase;
                }
                case 7: {
                    return this.username;
                }
                case 8: {
                    return this.password;
                }
                case 9: {
                    return this.searchType;
                }
                case 10: {
                    return this.displayType;
                }
                case 11: {
                    return this.timeout;
                }
            }
            return null;
        }

        @Override
        public DataRecord clone() {
            LDAPRecord lDAPRecord = new LDAPRecord();
            lDAPRecord.id = this.id;
            lDAPRecord.name = this.name;
            lDAPRecord.active = this.active;
            lDAPRecord.order = this.order;
            lDAPRecord.server = this.server;
            lDAPRecord.port = this.port;
            lDAPRecord.searchBase = this.searchBase;
            lDAPRecord.username = this.username;
            lDAPRecord.password = this.password;
            lDAPRecord.searchType = this.searchType;
            lDAPRecord.displayType = this.displayType;
            lDAPRecord.timeout = this.timeout;
            return lDAPRecord;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 12) {
                fieldNames[n] = string;
            }
        }
    }
}

