/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;

public class LocatingHandler
implements OmiManagementEventInterface {
    private OmiHandler omiHandler = null;

    public LocatingHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        omiManagement.registerManagementEventListener(this);
    }

    public void registerListener(OmiMessageInterface omiMessageInterface) {
        OmiMessage.elemIds.RequestPositionInfoResp.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventPositionInfo.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventPositionTrack.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventAlarmTrigger.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventPositionHistory.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventAlarmCallProgress.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.SetPPUserTrackingResp.registerDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventPositionRequest.registerDataNotificationListener(omiMessageInterface);
    }

    public void deregisterListener(OmiMessageInterface omiMessageInterface) {
        OmiMessage.elemIds.RequestPositionInfoResp.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventPositionInfo.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventPositionTrack.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventAlarmTrigger.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventPositionHistory.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventAlarmCallProgress.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.SetPPUserTrackingResp.deregisterDataNotificationListener(omiMessageInterface);
        OmiMessage.elemIds.EventPositionRequest.deregisterDataNotificationListener(omiMessageInterface);
    }

    public void sendRequestPositionInfo(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.RequestPositionInfo);
        omiMessage.addAttrib(OmiMessage.attribIds.ppn.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendSetPPUserTracking(int n, int n2, boolean bl) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetPPUserTracking);
        omiMessage.addAttrib(OmiMessage.attribIds.uid.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n2);
        omiMessage.addAttrib(OmiMessage.attribIds.trackingActive.name(), bl);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendSubscribePositionTrack(int n) {
        OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.PositionTrack, OmiMessage.EventFilterItems.ppn, "" + n);
    }

    public void sendUnsubscribePositionTrack(int n) {
        OmiMessage.sendResetEventSubscription(this.omiHandler, OmiMessage.EventType.PositionTrack, OmiMessage.EventFilterItems.ppn, "" + n);
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.AlarmTrigger, OmiMessage.EventFilterItems.trigger, "SOS");
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.AlarmTrigger, OmiMessage.EventFilterItems.trigger, "MANDOWN");
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.AlarmTrigger, OmiMessage.EventFilterItems.trigger, "LOC-*");
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.AlarmCallProgress, OmiMessage.EventFilterItems.ppn, "-1");
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.Locating, OmiMessage.EventFilterItems.ppn, "-1");
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.LocatingBluetooth, null, null);
        }
    }
}

