/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.OmiFileTransfer;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.OmiRSA;
import com.aastra.util.UtilSpy;
import java.awt.EventQueue;
import java.util.LinkedList;

public class OmiManagement
implements OmiMessageInterface {
    public static final int MAX_EVENT_LISTENER = 10;
    private OmiHandler omiHandler = null;
    private String username = null;
    private String password = null;
    private String ommAddress = null;
    private OmiMessage.OmmStbStateType ommStbState = OmiMessage.OmmStbStateType.Unknown;
    private String ommStbAddr = null;
    private OmiMessage.errorCodes openError = null;
    private OmiMessage lastOpenResp = null;
    private String ommVersion = "";
    private String ommProtocolVersion = "";
    private String ommAxiSpecVersion = "";
    private Integer ommUptime = null;
    private OmiMessage.PermissionType[] ommPermissions = null;
    private OmiMessage.AccountState[] ommAccountStates = null;
    private CommonDataHandler.PublicKeyClass ommPublicKey = null;
    private boolean useIntEventLinkReady = false;
    private boolean processingLinkClosed = false;
    public static final String OMILIB_PROTOCOL_VERSION = "44";
    private boolean omiHandlerRunning = false;
    private boolean omiLinkEstablished = false;
    private boolean sendNotificationActive = false;
    private LinkedList<OmiManagementEventInterface> listenerList = new LinkedList();
    private LinkedList<OmiManagementEventInterface> registerList = new LinkedList();
    private LinkedList<OmiManagementEventInterface> deregisterList = new LinkedList();
    private ExceptionInfo exceptionInfo = null;

    public ExceptionInfo getExceptionInfo() {
        return this.exceptionInfo;
    }

    public void setExceptionInfo(ExceptionInfo exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    public void buildMsgInternalEventException(ExceptionType exceptionType, Exception exception) {
        exception.printStackTrace();
        this.setExceptionInfo(new ExceptionInfo(exceptionType, exception.getMessage()));
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.internalEvent_Exception);
        omiMessage.id.processMessage(omiMessage);
    }

    public OmiManagement(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.initialize(string, string2, string3, bl, bl2, null);
    }

    public OmiManagement(String string, String string2, String string3, boolean bl, boolean bl2, Integer n) {
        this.initialize(string, string2, string3, bl, bl2, n);
    }

    public OmiManagement(String string, String string2, String string3) {
        this.initialize(string, string2, string3, true, false, null);
    }

    private void initialize(String string, String string2, String string3, boolean bl, boolean bl2, Integer n) {
        this.username = string2;
        this.password = string3;
        this.ommAddress = string;
        this.omiHandler = new OmiHandler(string, bl, bl2, n, this);
        this.omiHandler.setName("Omilib_OmiHandler");
        OmiFileTransfer.setOmiManagement(this);
        OmiMessage.elemIds.internalEvent_Exception.registerDataNotificationListener(this);
        OmiMessage.elemIds.internalEvent_LinkOpen.registerDataNotificationListener(this);
        OmiMessage.elemIds.internalEvent_LinkOpenFailed.registerDataNotificationListener(this);
        OmiMessage.elemIds.internalEvent_LinkReleased.registerDataNotificationListener(this);
        OmiMessage.elemIds.internalEvent_LinkReady.registerDataNotificationListener(this);
        OmiMessage.elemIds.OpenResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.AuthenticateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventStbStateChange.registerDataNotificationListener(this);
        OmiMessage.elemIds.PingResp.registerDataNotificationListener(this);
    }

    public void changeOmmParams(String string, String string2, String string3) {
        if (string == null) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "changeOmmParams: IP address is null. Replying link establish failed");
            OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.internalEvent_LinkOpenFailed);
            omiMessage.id.processMessage(omiMessage);
            return;
        }
        this.username = string2;
        this.password = string3;
        this.ommAddress = string;
        this.omiHandler.setOmmAddress(string);
        this.omiHandler.closeLink();
        this.omiHandler.enableLinkEstablish();
    }

    public void changeOmmParams(String string, Integer n, String string2, String string3) {
        if (string == null) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "changeOmmParams: IP address is null. Replying link establish failed");
            OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.internalEvent_LinkOpenFailed);
            omiMessage.id.processMessage(omiMessage);
            return;
        }
        this.username = string2;
        this.password = string3;
        this.ommAddress = string;
        this.omiHandler.setOmmAddress(string, n);
        this.omiHandler.closeLink();
        this.omiHandler.enableLinkEstablish();
    }

    public void startOMI() {
        if (!this.omiHandlerRunning) {
            this.omiHandler.start();
            this.omiHandlerRunning = true;
        }
    }

    public OmiHandler getOmiHandler() {
        return this.omiHandler;
    }

    public void release() {
        this.omiHandler.terminateIpThread();
        this.sendNotification(OmiManagementEventEnum.LINK_CLOSED);
    }

    private void sendNotification(OmiManagementEventEnum omiManagementEventEnum) {
        if (this.sendNotificationActive) {
            EventQueue.invokeLater(new OmiManagementSendNotificationSynchronizer(omiManagementEventEnum));
            return;
        }
        this.sendNotificationActive = true;
        this.sendNotificationToListener(omiManagementEventEnum);
        this.sendNotificationActive = false;
        for (OmiManagementEventInterface omiManagementEventInterface : this.deregisterList) {
            if (omiManagementEventInterface == null) continue;
            this.listenerList.remove(omiManagementEventInterface);
        }
        this.deregisterList.removeAll(this.deregisterList);
        for (OmiManagementEventInterface omiManagementEventInterface : this.registerList) {
            if (omiManagementEventInterface == null) continue;
            this.listenerList.add(omiManagementEventInterface);
        }
        this.registerList.removeAll(this.registerList);
    }

    private void sendNotificationToListener(OmiManagementEventEnum omiManagementEventEnum) {
        for (OmiManagementEventInterface omiManagementEventInterface : this.listenerList) {
            if (omiManagementEventInterface == null) continue;
            omiManagementEventInterface.processManagementEvent(omiManagementEventEnum);
        }
    }

    public void registerManagementEventListener(OmiManagementEventInterface omiManagementEventInterface) {
        if (this.sendNotificationActive) {
            this.registerList.add(omiManagementEventInterface);
        } else {
            this.listenerList.add(omiManagementEventInterface);
        }
    }

    public void deregisterManagementEventListener(OmiManagementEventInterface omiManagementEventInterface) {
        if (this.sendNotificationActive) {
            this.deregisterList.add(omiManagementEventInterface);
        } else {
            this.listenerList.remove(omiManagementEventInterface);
        }
    }

    public void ppBulkReady() {
        this.sendNotification(OmiManagementEventEnum.PP_BULK_READY);
    }

    public boolean getOmiLinkState() {
        return this.omiLinkEstablished;
    }

    public OmiMessage.OmmStbStateType getOmmStbState() {
        return this.ommStbState;
    }

    public String getOmmStbAddr() {
        return this.ommStbAddr;
    }

    public OmiMessage.errorCodes getOpenErrorCode() {
        return this.openError;
    }

    public OmiMessage getOpenRespMessage() {
        return this.lastOpenResp;
    }

    public String getOmmVersion() {
        return this.ommVersion;
    }

    public String getOmmProtocolVersion() {
        return this.ommProtocolVersion;
    }

    public String getOmmAxiSpecVersion() {
        return this.ommAxiSpecVersion;
    }

    public Integer getOmmUptime() {
        return this.ommUptime;
    }

    public boolean isAxiProtocolVersionMismatch() {
        return !OMILIB_PROTOCOL_VERSION.equals(this.ommProtocolVersion);
    }

    public OmiMessage.PermissionType[] getOmmPermissions() {
        return this.ommPermissions;
    }

    public boolean isPermissionSet(OmiMessage.PermissionType permissionType) {
        for (int i = 0; i < this.ommPermissions.length; ++i) {
            if (permissionType != this.ommPermissions[i]) continue;
            return true;
        }
        return false;
    }

    public OmiMessage.AccountState[] getOmmAccountState() {
        return this.ommAccountStates;
    }

    public CommonDataHandler.PublicKeyClass getOmmPublicKey() {
        return this.ommPublicKey;
    }

    public boolean getOmmAttribBool(OmiMessage.OpenRespAttribType openRespAttribType) {
        if (openRespAttribType.type != Boolean.class) {
            return false;
        }
        if (this.lastOpenResp != null) {
            if (openRespAttribType == OmiMessage.OpenRespAttribType.haveSIP) {
                boolean bl = false;
                boolean bl2 = false;
                if (this.lastOpenResp.getAttribVal(OmiMessage.OpenRespAttribType.haveSIP.name()) != null) {
                    bl = this.lastOpenResp.getAttribValBool(OmiMessage.OpenRespAttribType.haveSIP.name());
                }
                if (this.lastOpenResp.getAttribVal(OmiMessage.OpenRespAttribType.haveSIPStimulus.name()) != null) {
                    bl2 = this.lastOpenResp.getAttribValBool(OmiMessage.OpenRespAttribType.haveSIPStimulus.name());
                }
                return bl | bl2;
            }
            if (this.lastOpenResp.getAttribVal(openRespAttribType.name()) != null) {
                return this.lastOpenResp.getAttribValBool(openRespAttribType.name());
            }
        }
        return (Boolean)openRespAttribType.defValue;
    }

    public String getOmmAttribString(OmiMessage.OpenRespAttribType openRespAttribType) {
        String string;
        if (openRespAttribType.type != String.class) {
            return null;
        }
        if (this.lastOpenResp != null && (string = this.lastOpenResp.getAttribVal(openRespAttribType.name())) != null) {
            return string;
        }
        return (String)openRespAttribType.defValue;
    }

    private OmiMessage.PermissionType[] getPermissions(OmiMessage omiMessage) {
        OmiMessage omiMessage2;
        OmiMessage.PermissionType[] permissionTypeArray = null;
        int n = 0;
        for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (omiMessage2.id != OmiMessage.elemIds.permission) continue;
            try {
                OmiMessage.PermissionType.valueOf(omiMessage2.getBodyText());
                ++n;
                continue;
            }
            catch (Exception exception) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "Received unsupported permission type '" + omiMessage2.getBodyText() + "' - ignore it");
            }
        }
        if (n > 0) {
            permissionTypeArray = new OmiMessage.PermissionType[n];
            n = 0;
            for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                if (omiMessage2.id != OmiMessage.elemIds.permission) continue;
                try {
                    permissionTypeArray[n] = OmiMessage.PermissionType.valueOf(omiMessage2.getBodyText());
                    ++n;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return permissionTypeArray;
    }

    private OmiMessage.AccountState[] getAccountStates(OmiMessage omiMessage) {
        OmiMessage omiMessage2;
        OmiMessage.AccountState[] accountStateArray = null;
        int n = 0;
        for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (omiMessage2.id != OmiMessage.elemIds.accountState) continue;
            ++n;
        }
        if (n > 0) {
            accountStateArray = new OmiMessage.AccountState[n];
            n = 0;
            for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                if (omiMessage2.id != OmiMessage.elemIds.accountState) continue;
                try {
                    int n2 = omiMessage2.getAttribValInt(OmiMessage.AccountStateType.id.name());
                    accountStateArray[n2] = new OmiMessage.AccountState();
                    accountStateArray[n2].id = n2;
                    accountStateArray[n2].username = omiMessage2.getAttribVal(OmiMessage.AccountStateType.username.name());
                    accountStateArray[n2].passwordState = OmiMessage.AccountPasswordStateType.valueOf(omiMessage2.getAttribVal(OmiMessage.AccountStateType.state.name()));
                    ++n;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return accountStateArray;
    }

    private CommonDataHandler.PublicKeyClass getPublicKey(OmiMessage omiMessage) {
        CommonDataHandler.PublicKeyClass publicKeyClass = null;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (omiMessage2.id != OmiMessage.elemIds.publicKey) continue;
            try {
                publicKeyClass = new CommonDataHandler.PublicKeyClass();
                publicKeyClass.modulus = omiMessage2.getAttribVal(OmiMessage.PublicKeyType.modulus.name());
                publicKeyClass.exponent = omiMessage2.getAttribVal(OmiMessage.PublicKeyType.exponent.name());
                return publicKeyClass;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return publicKeyClass;
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        switch (omiMessage.id) {
            case internalEvent_LinkOpen: {
                OmiMessage omiMessage2 = new OmiMessage(OmiMessage.elemIds.Open.name());
                omiMessage2.addAttrib(OmiMessage.attribIds.protocolVersion.name(), OMILIB_PROTOCOL_VERSION);
                omiMessage2.addAttrib(OmiMessage.attribIds.username.name(), this.username);
                omiMessage2.addAttrib(OmiMessage.attribIds.password.name(), this.password);
                omiMessage2.addAttrib(OmiMessage.attribIds.OMPClient.name(), true);
                this.omiHandler.sendOmiMessage(omiMessage2);
                this.omiLinkEstablished = true;
                break;
            }
            case internalEvent_LinkOpenFailed: {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "Establishing link to " + this.ommAddress + " failed");
                this.sendNotification(OmiManagementEventEnum.LINK_ESTABLISH_FAILED);
                this.omiLinkEstablished = false;
                this.ommStbState = OmiMessage.OmmStbStateType.Unknown;
                break;
            }
            case internalEvent_LinkReleased: {
                if (!this.processingLinkClosed) {
                    this.processingLinkClosed = true;
                    UtilSpy.spyEvent(UtilSpy.SpyIdEnum.OMI_LINK, this, "Link to " + this.ommAddress + " released");
                    this.sendNotification(OmiManagementEventEnum.LINK_CLOSED);
                    this.omiLinkEstablished = false;
                    this.ommStbState = OmiMessage.OmmStbStateType.Unknown;
                    this.processingLinkClosed = false;
                    break;
                }
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_LINK, this, "Ignoring additional event 'internalEvent_LinkReleased'");
                break;
            }
            case internalEvent_LinkReady: {
                this.sendNotification(OmiManagementEventEnum.LINK_READY);
                break;
            }
            case internalEvent_Exception: {
                this.sendNotification(OmiManagementEventEnum.EXCEPTION);
                break;
            }
            case PingResp: {
                this.omiHandler.handlePingResp();
                break;
            }
            case OpenResp: {
                this.lastOpenResp = omiMessage;
                String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                String string2 = omiMessage.getAttribVal(OmiMessage.OpenRespAttribType.ommStbState.name());
                this.ommVersion = omiMessage.getAttribVal(OmiMessage.OpenRespAttribType.ommVersion.name());
                this.ommProtocolVersion = omiMessage.getAttribVal(OmiMessage.OpenRespAttribType.protocolVersion.name());
                this.ommAxiSpecVersion = omiMessage.getAttribVal(OmiMessage.OpenRespAttribType.ommAxiSpecVersion.name());
                this.ommUptime = omiMessage.getAttribValIntNotMandatory(OmiMessage.OpenRespAttribType.uptime.name());
                this.ommPermissions = this.getPermissions(omiMessage);
                this.ommAccountStates = this.getAccountStates(omiMessage);
                this.ommPublicKey = this.getPublicKey(omiMessage);
                this.setProtTypes(omiMessage);
                if (this.ommPublicKey != null) {
                    OmiRSA.setKey(this.ommPublicKey.modulus, this.ommPublicKey.exponent);
                }
                if (this.ommVersion == null) {
                    this.ommVersion = "";
                }
                if (string2 != null) {
                    try {
                        this.ommStbState = OmiMessage.OmmStbStateType.valueOf(string2);
                        this.ommStbAddr = omiMessage.getAttribVal(OmiMessage.OpenRespAttribType.ommStbAddr.name());
                    }
                    catch (Exception exception) {
                        this.ommStbState = OmiMessage.OmmStbStateType.Unknown;
                    }
                }
                if (string == null) {
                    UtilSpy.spyEvent(UtilSpy.SpyIdEnum.OMI_LINK, this, "Link to " + this.ommAddress + " established");
                    OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.SystemState, null, null);
                    if (this.useIntEventLinkReady) {
                        this.sendNotification(OmiManagementEventEnum.RCV_OPEN_RESP);
                    } else {
                        this.sendNotification(OmiManagementEventEnum.LINK_READY);
                    }
                    this.openError = null;
                    break;
                }
                try {
                    this.openError = OmiMessage.errorCodes.valueOf(string);
                }
                catch (Exception exception) {
                    this.openError = null;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_LINK, this, "Link to " + this.ommAddress + " not established: Login failed");
                this.omiHandler.closeLink();
                this.sendNotification(OmiManagementEventEnum.LOGIN_FAILED);
                this.ommStbState = OmiMessage.OmmStbStateType.Unknown;
                break;
            }
            case EventStbStateChange: {
                String string = omiMessage.getAttribVal(OmiMessage.OpenRespAttribType.ommStbState.name());
                if (string == null) break;
                try {
                    this.ommStbState = OmiMessage.OmmStbStateType.valueOf(string);
                    this.ommStbAddr = omiMessage.getAttribVal(OmiMessage.OpenRespAttribType.ommStbAddr.name());
                    this.sendNotification(OmiManagementEventEnum.STANDBY_PARAMS_CHANGED);
                }
                catch (Exception exception) {
                    this.ommStbState = OmiMessage.OmmStbStateType.Unknown;
                }
                break;
            }
            case AuthenticateResp: {
                this.sendNotification(OmiManagementEventEnum.LINK_READY);
                break;
            }
        }
    }

    public void useInternalEventLinkReady() {
        this.useIntEventLinkReady = true;
    }

    public void generateInternalEventLinkReady() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.internalEvent_LinkReady);
        omiMessage.id.processMessage(omiMessage);
    }

    private void setProtTypes(OmiMessage omiMessage) {
        OmiMessage.ProtType.FTP.setValid(omiMessage.getAttribValBool(OmiMessage.OpenRespAttribType.haveProtFTP.name()));
        OmiMessage.ProtType.FTPS.setValid(omiMessage.getAttribValBool(OmiMessage.OpenRespAttribType.haveProtFTPS.name()));
        OmiMessage.ProtType.HTTP.setValid(omiMessage.getAttribValBool(OmiMessage.OpenRespAttribType.haveProtHTTP.name()));
        OmiMessage.ProtType.HTTPS.setValid(omiMessage.getAttribValBool(OmiMessage.OpenRespAttribType.haveProtHTTPS.name()));
        OmiMessage.ProtType.SCP.setValid(omiMessage.getAttribValBool(OmiMessage.OpenRespAttribType.haveProtSCP.name()));
        OmiMessage.ProtType.SFTP.setValid(omiMessage.getAttribValBool(OmiMessage.OpenRespAttribType.haveProtSFTP.name()));
        OmiMessage.ProtType.TFTP.setValid(omiMessage.getAttribValBool(OmiMessage.OpenRespAttribType.haveProtTFTP.name()));
    }

    private class OmiManagementSendNotificationSynchronizer
    implements Runnable {
        OmiManagementEventEnum ev;

        public OmiManagementSendNotificationSynchronizer(OmiManagementEventEnum omiManagementEventEnum) {
            this.ev = omiManagementEventEnum;
        }

        @Override
        public void run() {
            OmiManagement.this.sendNotificationToListener(this.ev);
        }
    }

    public static class ExceptionInfo {
        public ExceptionType type;
        public String description;

        public ExceptionInfo(ExceptionType exceptionType, String string) {
            this.type = exceptionType;
            this.description = string;
        }
    }

    public static enum ExceptionType {
        XmlStreamException,
        InvalidEnumConst;

    }
}

