/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.Hex;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class OmiRSA {
    private static RSAPublicKey key = null;
    private static Cipher cipher = null;
    private static int maxInputLenPerBlock = 0;
    private static int OutputLenPerBlock = 0;

    public static void setKey(String string, String string2) {
        try {
            key = OmiRSA.generatePublicKey(string, string2);
            cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            invalidKeySpecException.printStackTrace();
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
        }
    }

    public static byte[] encrypt(String string) {
        block17: {
            if (key != null && cipher != null) {
                try {
                    byte[] byArray = string.getBytes("UTF-8");
                    int n = byArray.length;
                    int n2 = n / maxInputLenPerBlock;
                    if (n % maxInputLenPerBlock > 0) {
                        ++n2;
                    }
                    if (n == 0) {
                        n2 = 1;
                    }
                    if (n2 == 1) {
                        try {
                            cipher.init(1, key);
                            byte[] byArray2 = cipher.doFinal(byArray);
                            return byArray2;
                        }
                        catch (InvalidKeyException invalidKeyException) {
                            invalidKeyException.printStackTrace();
                            break block17;
                        }
                        catch (IllegalBlockSizeException illegalBlockSizeException) {
                            illegalBlockSizeException.printStackTrace();
                            break block17;
                        }
                        catch (BadPaddingException badPaddingException) {
                            badPaddingException.printStackTrace();
                            break block17;
                        }
                    }
                    byte[] byArray3 = new byte[n2 * OutputLenPerBlock];
                    for (int i = 0; i < n2; ++i) {
                        try {
                            int n3;
                            int n4 = i == n2 - 1 ? n % maxInputLenPerBlock : maxInputLenPerBlock;
                            byte[] byArray4 = new byte[n4];
                            for (n3 = 0; n3 < n4; ++n3) {
                                byArray4[n3] = byArray[i * maxInputLenPerBlock + n3];
                            }
                            cipher.init(1, key);
                            byte[] byArray5 = cipher.doFinal(byArray4);
                            for (n3 = 0; n3 < byArray5.length; ++n3) {
                                byArray3[i * OmiRSA.OutputLenPerBlock + n3] = byArray5[n3];
                            }
                            continue;
                        }
                        catch (InvalidKeyException invalidKeyException) {
                            invalidKeyException.printStackTrace();
                            continue;
                        }
                        catch (IllegalBlockSizeException illegalBlockSizeException) {
                            illegalBlockSizeException.printStackTrace();
                            continue;
                        }
                        catch (BadPaddingException badPaddingException) {
                            badPaddingException.printStackTrace();
                        }
                    }
                    return byArray3;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
        }
        return null;
    }

    private static RSAPublicKey generatePublicKey(String string, String string2) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] byArray = Hex.decodeHex(string.toLowerCase().toCharArray());
        byte[] byArray2 = Hex.decodeHex(string2.toLowerCase().toCharArray());
        maxInputLenPerBlock = byArray.length - 11;
        OutputLenPerBlock = byArray.length;
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
    }
}

