/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.PpDataNotificationInterface;
import com.aastra.omilib.PpDataRecord;
import com.aastra.omilib.PpDatabase;
import com.aastra.omilib.PpDevDataRecord;
import com.aastra.omilib.PpDevDatabase;
import com.aastra.omilib.PpEventEnum;
import com.aastra.omilib.PpUmoDataRecord;
import com.aastra.omilib.PpUmoDatabase;
import com.aastra.omilib.PpUserDataRecord;
import com.aastra.omilib.PpUserDatabase;
import com.aastra.util.UtilSpy;
import java.awt.EventQueue;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class PpDataHandler
extends DataHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    private static int MAX_BULK_RECORDS = 20;
    private OmiHandler omiHandler = null;
    private OmiManagement omiManagement = null;
    private PpDevDatabase ppDevDb = new PpDevDatabase();
    private PpDevDatabase ppDevDbOrig = null;
    private PpUserDatabase ppUserDb = new PpUserDatabase();
    private PpUserDatabase ppUserDbOrig = null;
    private PpUmoDatabase ppUmoDb = new PpUmoDatabase();
    private PpDatabase ppDb = new PpDatabase(this.ppUserDb, this.ppDevDb);
    private List<PpTimerAction> timerList = Collections.synchronizedList(new LinkedList());
    private boolean useTimer = true;
    private Timer monitorTimer = null;
    private boolean getDevBulkInProgress = false;
    private boolean getUserBulkInProgress = false;
    private boolean getFwUpdStatusBulkInProgress = false;
    private boolean devDataNotificationOnTransactionEvent = true;
    private boolean ppStateActive = false;
    private DataRecord[] bulkModifyPPs = null;
    private LinkedList<PpDataNotificationInterface> devListenerList = new LinkedList();
    private LinkedList<PpDataNotificationInterface> userListenerList = new LinkedList();
    private LinkedList<PpDataNotificationInterface> umoListenerList = new LinkedList();
    private static final int MAX_SEQ_NUM = 10002;
    private Transaction[] transArr = new Transaction[10002];
    private int nextSequenceNumber = 0;
    private boolean fetchLastPpDevAction = false;
    private boolean fetchActivePpDev = false;

    private void initTimerPpMonitor() {
        this.monitorTimer = new Timer("Omilib_PpDataHandlerMonitorTimer");
        this.monitorTimer.schedule((TimerTask)new TimerPpMonitor(), 1000L, 1000L);
    }

    private int getNewSequenceNumber() {
        int n = this.nextSequenceNumber++;
        if (this.nextSequenceNumber >= 10002) {
            this.nextSequenceNumber = 0;
        }
        return n;
    }

    public PpDataHandler(OmiManagement omiManagement) {
        this.PpDataHandlerInit(omiManagement, true);
    }

    public PpDataHandler(OmiManagement omiManagement, boolean bl) {
        this.PpDataHandlerInit(omiManagement, bl);
    }

    private void PpDataHandlerInit(OmiManagement omiManagement, boolean bl) {
        this.omiManagement = omiManagement;
        this.omiHandler = omiManagement.getOmiHandler();
        this.useTimer = bl;
        omiManagement.registerManagementEventListener(this);
        OmiMessage.elemIds.SubscribeResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPPTransaction.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetPPDevResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreatePPDevResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreateFixedPPResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeletePPDevResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetPPDevResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetPPUserResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreatePPUserResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeletePPUserResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetPPUserResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPPDevCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPPUserCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetActivePPDevResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetLastPPDevActionResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetPPFirmwareUpdateStatusResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPPFirmwareUpdateStatus.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetPPUserDevRelationResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetPPStateResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPPState.registerDataNotificationListener(this);
        if (this.useTimer) {
            this.initTimerPpMonitor();
        }
    }

    public PpDatabase getDatabase() {
        return this.ppDb;
    }

    public PpDevDataRecord getPpDevData(int n) {
        return this.ppDevDb.getPpByPpn(n);
    }

    public PpDevDataRecord getPpDevDataByIdx(int n) {
        return this.ppDevDb.getRecordByIdx(n);
    }

    public PpDevDatabase getDevDatabase() {
        return this.ppDevDb;
    }

    public PpUserDataRecord getPpUserData(int n) {
        return this.ppUserDb.getUserByUid(n);
    }

    public PpUserDataRecord getPpUserDataByIdx(int n) {
        return this.ppUserDb.getRecordByIdx(n);
    }

    public PpUserDatabase getUserDatabase() {
        return this.ppUserDb;
    }

    public PpUmoDataRecord getPpUmoData(int n) {
        return this.ppUmoDb.getRecordByUid(n);
    }

    public PpUmoDataRecord getPpUmoDataByIdx(int n) {
        return this.ppUmoDb.getRecordByIdx(n);
    }

    public PpUmoDatabase getPpUmoDatabase() {
        return this.ppUmoDb;
    }

    public OmiHandler getOmiHandler() {
        return this.omiHandler;
    }

    public void registerDevDataNotificationListener(PpDataNotificationInterface ppDataNotificationInterface) {
        this.devListenerList.add(ppDataNotificationInterface);
    }

    public void registerUserDataNotificationListener(PpDataNotificationInterface ppDataNotificationInterface) {
        this.userListenerList.add(ppDataNotificationInterface);
    }

    public void registerUmoDataNotificationListener(PpDataNotificationInterface ppDataNotificationInterface) {
        this.umoListenerList.add(ppDataNotificationInterface);
    }

    public void deregisterDevDataNotificationListener(PpDataNotificationInterface ppDataNotificationInterface) {
        this.devListenerList.remove(ppDataNotificationInterface);
    }

    public void deregisterUserDataNotificationListener(PpDataNotificationInterface ppDataNotificationInterface) {
        this.userListenerList.remove(ppDataNotificationInterface);
    }

    public void deregisterUmoDataNotificationListener(PpDataNotificationInterface ppDataNotificationInterface) {
        this.umoListenerList.remove(ppDataNotificationInterface);
    }

    private void GenerateDeviceDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.devListenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating PP device notification: No listener");
        }
        for (PpDataNotificationInterface ppDataNotificationInterface : this.devListenerList) {
            if (ppDataNotificationInterface == null) continue;
            ppDataNotificationInterface.processDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateUserDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.userListenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating PP user notification: No listener");
        }
        for (PpDataNotificationInterface ppDataNotificationInterface : this.userListenerList) {
            if (ppDataNotificationInterface == null) continue;
            ppDataNotificationInterface.processDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateUmoDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.umoListenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating PP umo notification: No listener");
        }
        for (PpDataNotificationInterface ppDataNotificationInterface : this.umoListenerList) {
            if (ppDataNotificationInterface == null) continue;
            ppDataNotificationInterface.processDataNotification(n, dataNotificationEnum);
        }
    }

    private void GeneratePpEventNotification(int n, int n2, PpEventEnum ppEventEnum, Object[] objectArray) {
        if (this.devListenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating PP notification: No listener");
        }
        for (PpDataNotificationInterface ppDataNotificationInterface : this.devListenerList) {
            if (ppDataNotificationInterface == null) continue;
            ppDataNotificationInterface.processStatusEvent(n, n2, ppEventEnum, objectArray);
        }
    }

    private void GenerateDeviceErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.devListenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating PP device error notification: No listener");
        }
        for (PpDataNotificationInterface ppDataNotificationInterface : this.devListenerList) {
            if (ppDataNotificationInterface == null) continue;
            ppDataNotificationInterface.processErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    private void GenerateUserErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.userListenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating PP user error notification: No listener");
        }
        for (PpDataNotificationInterface ppDataNotificationInterface : this.userListenerList) {
            if (ppDataNotificationInterface == null) continue;
            ppDataNotificationInterface.processErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public void sendGetPpDev(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetPPDev);
        omiMessage.addAttrib(OmiMessage.PPDevType.ppn.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendGetPpDevBulk(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetPPDev);
        omiMessage.addAttrib(OmiMessage.PPDevType.ppn.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendCreatePpDev(PpDevDataRecord ppDevDataRecord) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreatePPDev);
        int n = this.getNewSequenceNumber();
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.pp);
        ppDevDataRecord.addChangedAttribsToMsg(omiMessage2);
        this.transArr[n] = new Transaction(n, actionEnum.ACTION_CREATE_PP, ppDevDataRecord);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendDeletePpDev(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeletePPDev);
        int n2 = this.getNewSequenceNumber();
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n2);
        omiMessage.addAttrib(OmiMessage.PPDevType.ppn.name(), n);
        this.transArr[n2] = new Transaction(n2, actionEnum.ACTION_DELETE_PP, n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public boolean sendSetPpDev(PpDevDataRecord ppDevDataRecord) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetPPDev);
        int n = this.getNewSequenceNumber();
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.pp);
        if (ppDevDataRecord.addChangedAttribsToMsg(omiMessage2) > 0) {
            this.transArr[n] = new Transaction(n, actionEnum.ACTION_SET_PP, ppDevDataRecord);
            this.omiHandler.sendOmiMessage(omiMessage);
            return true;
        }
        return false;
    }

    public void sendGetPpUser(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetPPUser);
        omiMessage.addAttrib(OmiMessage.PPUserType.uid.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendGetPpUserBulk(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetPPUser);
        omiMessage.addAttrib(OmiMessage.PPUserType.uid.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendCreatePpUser(PpUserDataRecord ppUserDataRecord) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreatePPUser);
        int n = this.getNewSequenceNumber();
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.user);
        ppUserDataRecord.addChangedAttribsToMsg(omiMessage2);
        this.transArr[n] = new Transaction(n, actionEnum.ACTION_CREATE_USER, ppUserDataRecord);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendDeletePpUser(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeletePPUser);
        int n2 = this.getNewSequenceNumber();
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n2);
        omiMessage.addAttrib(OmiMessage.PPUserType.uid.name(), n);
        this.transArr[n2] = new Transaction(n2, actionEnum.ACTION_DELETE_PP, n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public boolean sendSetPpUser(PpUserDataRecord ppUserDataRecord) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetPPUser);
        int n = this.getNewSequenceNumber();
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.user);
        if (ppUserDataRecord.addChangedAttribsToMsg(omiMessage2) > 0) {
            this.transArr[n] = new Transaction(n, actionEnum.ACTION_SET_PP, ppUserDataRecord);
            this.omiHandler.sendOmiMessage(omiMessage);
            return true;
        }
        return false;
    }

    public void sendCreatePp(PpDataRecord ppDataRecord) {
        if (ppDataRecord == null) {
            return;
        }
        if (ppDataRecord.ppDev == null) {
            return;
        }
        if (ppDataRecord.ppUser == null) {
            return;
        }
        int n = this.getNewSequenceNumber();
        this.transArr[n] = new Transaction(n, actionEnum.ACTION_CREATE_USER_AND_DEVICE, ppDataRecord);
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreateFixedPP);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.user);
        ppDataRecord.ppUser.addChangedAttribsToMsg(omiMessage2);
        omiMessage2 = omiMessage2.addElement(OmiMessage.elemIds.pp);
        ppDataRecord.ppDev.addChangedAttribsToMsg(omiMessage2);
        if (omiMessage2.getAttribVal(OmiMessage.PPDevType.ipei.name()) == null) {
            omiMessage2.addAttrib(OmiMessage.PPDevType.ipei.name(), "");
        }
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendGetPpState(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetPPState);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        omiMessage.addAttrib(OmiMessage.PPDevType.ppn.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendGetPPFirmwareUpdateStatus(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetPPFirmwareUpdateStatus);
        omiMessage.addAttrib(OmiMessage.PPDevType.ppn.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void startGetPPFirmwareUpdateStatusBulk() {
        this.sendGetPPFirmwareUpdateStatusBulk(1, MAX_BULK_RECORDS);
    }

    private void sendGetPPFirmwareUpdateStatusBulk(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetPPFirmwareUpdateStatus);
        omiMessage.addAttrib(OmiMessage.PPDevType.ppn.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
        if (n2 > 1) {
            this.getFwUpdStatusBulkInProgress = true;
        }
    }

    public void setPPFirmwareUpdateStatusToUnknown() {
        int n = this.ppDevDb.getRecordNumber();
        for (int i = 0; i < n; ++i) {
            PpDevDataRecord ppDevDataRecord = this.ppDevDb.getRecordByIdx(i);
            if (ppDevDataRecord == null) continue;
            int n2 = (Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_PPN);
            ppDevDataRecord.setField(PpDevDataRecord.IDX_FW_UPDATE_STATE, (Object)OmiMessage.PPFirmwareUpdateStatusStateType.barred);
            this.ppDevDb.createPp(ppDevDataRecord);
            this.GenerateDeviceDataNotification(n2, DataNotificationEnum.DATA_CHANGED);
        }
    }

    public boolean sendSetPPUserDevRelation(int n, OmiMessage.PPRelTypeType pPRelTypeType) {
        OmiMessage.PPRelTypeType pPRelTypeType2;
        PpUserDataRecord ppUserDataRecord = this.ppUserDb.getUserByUid(n);
        if (ppUserDataRecord != null && ((pPRelTypeType2 = (OmiMessage.PPRelTypeType)((Object)ppUserDataRecord.getField(PpUserDataRecord.IDX_REL_TYPE))) == OmiMessage.PPRelTypeType.Fixed && pPRelTypeType == OmiMessage.PPRelTypeType.Dynamic || pPRelTypeType2 == OmiMessage.PPRelTypeType.Dynamic && pPRelTypeType == OmiMessage.PPRelTypeType.Fixed)) {
            int n2 = this.getNewSequenceNumber();
            this.transArr[n2] = new Transaction(n2, actionEnum.ACTION_CHANGE_RELATION_TYPE, ppUserDataRecord);
            OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetPPUserDevRelation);
            omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n2);
            omiMessage.addAttrib(OmiMessage.PPDevType.uid.name(), n);
            omiMessage.addAttrib(OmiMessage.PPDevType.relType.name(), pPRelTypeType.name());
            this.omiHandler.sendOmiMessage(omiMessage);
            return true;
        }
        return false;
    }

    public void setPpUserInternalAttrib(int n, int n2, Object object) {
        PpUserDataRecord ppUserDataRecord = this.ppUserDb.getUserByUid(n);
        if (ppUserDataRecord != null) {
            Object object2 = ppUserDataRecord.getField(n2);
            if (object2 != null && object2.equals(object)) {
                return;
            }
            ppUserDataRecord.setField(n2, object);
            ppUserDataRecord.commitChanges();
            this.ppUserDb.createUser(ppUserDataRecord);
        }
    }

    private void sendCnfEventNotificationReq() {
        OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.PPDevCnf, OmiMessage.EventFilterItems.ppn, "-1");
        OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.PPUserCnf, OmiMessage.EventFilterItems.uid, "-1");
    }

    public boolean subscribeEventPPState() {
        return this.sendPPStateSubscription(OmiMessage.EventType.PPState);
    }

    public boolean subscribeEventPPCallState() {
        return this.sendPPStateSubscription(OmiMessage.EventType.PPCallState);
    }

    public boolean subscribeEventPPCallStateDetail(OmiMessage.EventType eventType) {
        switch (eventType) {
            case PPCallStateRinging: 
            case PPCallStateCalling: 
            case PPCallStatePaging: 
            case PPCallStateConnected: 
            case PPCallStateIdle: 
            case PPCallStateNone: {
                return this.sendPPStateSubscription(eventType);
            }
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, String.format("subscribeEventPPCallStateDetail: wrong EventType '%s'", new Object[]{eventType}));
        return false;
    }

    public boolean subscribeEventPPDevState() {
        return this.sendPPStateSubscription(OmiMessage.EventType.PPDevState);
    }

    public boolean subscribeEventPPDevStateDetail(OmiMessage.EventType eventType) {
        switch (eventType) {
            case PPDevStateOnHook: 
            case PPDevStateSilentCharging: 
            case PPDevStateBatteryLevel: 
            case PPDevStateSwVersion: {
                return this.sendPPStateSubscription(eventType);
            }
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, String.format("subscribeEventPPDevStateDetail: wrong EventType '%s'", new Object[]{eventType}));
        return false;
    }

    public boolean subscribeEventPPBtState() {
        return this.sendPPStateSubscription(OmiMessage.EventType.PPBtState);
    }

    public boolean subscribeEventPPSipState() {
        return this.sendPPStateSubscription(OmiMessage.EventType.PPSipState);
    }

    public boolean subscribeEventPPSipStateDetail(OmiMessage.EventType eventType) {
        switch (eventType) {
            case PPSipStateRegEvent: 
            case PPSipStateEndEvent: 
            case PPSipStateNotifyEvent: 
            case PPSipStateRegistered: 
            case PPSipStateServerType: 
            case PPSipStateServerAddr: 
            case PPSipStateServerPort: {
                return this.sendPPStateSubscription(eventType);
            }
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, String.format("subscribeEventPPSipStateDetail: wrong EventType '%s'", new Object[]{eventType}));
        return false;
    }

    private boolean sendPPStateSubscription(OmiMessage.EventType eventType) {
        if (!this.omiManagement.isPermissionSet(OmiMessage.PermissionType.Monitoring)) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, String.format("Can not subscribe to EventType '%s' - no permission", new Object[]{eventType}));
            return false;
        }
        OmiMessage.sendSetEventSubscription(this.omiHandler, eventType, OmiMessage.EventFilterItems.ppn, "-1");
        this.ppStateActive = true;
        return true;
    }

    public boolean sendTransactionEventSubscription() {
        return this.subscribeEventPPTransaction();
    }

    public boolean subscribeEventPPTransaction() {
        return this.sendPPTransactionSubscription(OmiMessage.EventType.PPTransaction);
    }

    public boolean subscribePPTransactionDetailEvent(OmiMessage.EventType eventType) {
        switch (eventType) {
            case PPTransactionLinkEstablish: 
            case PPTransactionRelease: 
            case PPTransactionEstablish: 
            case PPTransactionPPNotFound: 
            case PPTransactionPagingStarted: 
            case PPTransactionReleaseFromPP: 
            case PPTransactionPPSetupRejected: 
            case PPTransactionComsRelease: 
            case PPTransactionComsEstablish: 
            case PPTransactionSsFac: 
            case PPTransactionSsRelease: 
            case PPTransactionSsEstablish: 
            case PPTransactionConnHandover: 
            case PPTransactionLocReg: 
            case PPTransactionDetach: {
                return this.sendPPTransactionSubscription(eventType);
            }
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, String.format("sendTransactionDetailEventSubscription: wrong EventType '%s'", new Object[]{eventType}));
        return false;
    }

    private boolean sendPPTransactionSubscription(OmiMessage.EventType eventType) {
        if (!(this.omiManagement.isPermissionSet(OmiMessage.PermissionType.Monitoring) || this.omiManagement.isPermissionSet(OmiMessage.PermissionType.Locating))) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, String.format("Can not subscribe to EventType '%s' - no permission", new Object[]{eventType}));
            return false;
        }
        OmiMessage.sendSetEventSubscription(this.omiHandler, eventType, OmiMessage.EventFilterItems.ppn, "-1");
        return true;
    }

    public void sendFirmwareUpdateStateEventSubscription(Integer n) {
        OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.PPFirmwareUpdateState, OmiMessage.EventFilterItems.ppn, n.toString());
    }

    public void sendFirmwareStateEventSubscription() {
        OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.PPFirmwareState, null, null);
    }

    private int processGetPpDevResp(OmiMessage omiMessage) {
        int n = 0;
        int n2 = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (omiMessage2.id == OmiMessage.elemIds.pp) {
                ++n2;
                n = Integer.parseInt(omiMessage2.getAttribVal(OmiMessage.PPDevType.ppn.name()));
                PpDevDataRecord ppDevDataRecord = this.ppDevDb.getPpByPpn(n);
                if (ppDevDataRecord == null) {
                    ppDevDataRecord = new PpDevDataRecord(n);
                }
                this.setDevAttribsFromMsg(ppDevDataRecord, omiMessage2);
                this.ppDevDb.createPp(ppDevDataRecord);
                this.GenerateDeviceDataNotification(n, DataNotificationEnum.NEW_DATA);
                if (!this.ppStateActive) continue;
                this.sendGetPpState(n);
                continue;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "PP device notification with wrong element id=" + (Object)((Object)omiMessage2.id));
        }
        if (n2 < MAX_BULK_RECORDS) {
            return 0;
        }
        return n;
    }

    private void setDevAttribsFromMsg(PpDevDataRecord ppDevDataRecord, OmiMessage omiMessage) {
        String string = omiMessage.getFirstAttribName();
        while (string != null) {
            if (string.equals(OmiMessage.PPDevType.s.name())) {
                ppDevDataRecord.setField(string, (Object)OmiMessage.DECTSubscriptionStateType.valueOf(omiMessage.getAttribVal(string)));
            } else if (string.equals(OmiMessage.PPDevType.relType.name())) {
                OmiMessage.PPRelTypeType pPRelTypeType = OmiMessage.PPRelTypeType.valueOf(omiMessage.getAttribVal(string));
                ppDevDataRecord.setField(string, (Object)pPRelTypeType);
                if (pPRelTypeType == OmiMessage.PPRelTypeType.Unbound) {
                    ppDevDataRecord.setField(PpDevDataRecord.IDX_UID, (Object)-1);
                }
            } else if (string.equals(OmiMessage.PPDevType.roaming.name())) {
                ppDevDataRecord.setField(string, (Object)OmiMessage.PPDevRoamingStateType.valueOf(omiMessage.getAttribVal(string)));
            } else {
                ppDevDataRecord.setField(string, (Object)omiMessage.getAttribVal(string));
            }
            string = omiMessage.getNextAttribName();
        }
        ppDevDataRecord.commitChanges();
    }

    private int processGetPpUserResp(OmiMessage omiMessage) {
        int n = 0;
        int n2 = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (omiMessage2.id == OmiMessage.elemIds.user) {
                PpUmoDataRecord ppUmoDataRecord;
                ++n2;
                n = Integer.parseInt(omiMessage2.getAttribVal(OmiMessage.PPUserType.uid.name()));
                PpUserDataRecord ppUserDataRecord = this.ppUserDb.getUserByUid(n);
                if (ppUserDataRecord == null) {
                    ppUserDataRecord = new PpUserDataRecord(n);
                }
                this.setUserAttribsFromMsg(ppUserDataRecord, omiMessage2);
                this.ppUserDb.createUser(ppUserDataRecord);
                this.GenerateUserDataNotification(n, DataNotificationEnum.NEW_DATA);
                if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO) || (ppUmoDataRecord = this.ppUmoDb.updateUmoRecord(ppUserDataRecord)) == null) continue;
                ppUmoDataRecord.commitChanges();
                this.GenerateUmoDataNotification(n, DataNotificationEnum.NEW_DATA);
                continue;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "PP user notification with wrong element id=" + (Object)((Object)omiMessage2.id));
        }
        if (n2 < MAX_BULK_RECORDS) {
            return 0;
        }
        return n;
    }

    private void setUserAttribsFromMsg(PpUserDataRecord ppUserDataRecord, OmiMessage omiMessage) {
        String string = omiMessage.getFirstAttribName();
        while (string != null) {
            if (string.equals(OmiMessage.PPUserType.relType.name())) {
                OmiMessage.PPRelTypeType pPRelTypeType = OmiMessage.PPRelTypeType.valueOf(omiMessage.getAttribVal(string));
                ppUserDataRecord.setField(string, (Object)pPRelTypeType);
                if (pPRelTypeType == OmiMessage.PPRelTypeType.Unbound) {
                    ppUserDataRecord.setField(PpUserDataRecord.IDX_PPN, (Object)-1);
                }
            } else if (string.equals(OmiMessage.PPUserType.forwardState.name())) {
                ppUserDataRecord.setField(string, (Object)OmiMessage.CallForwardStateType.valueOf(omiMessage.getAttribVal(string)));
            } else if (string.equals(OmiMessage.PPUserType.monitoringMode.name())) {
                ppUserDataRecord.setField(string, (Object)OmiMessage.PPMonitoringModeType.valueOf(omiMessage.getAttribVal(string)));
            } else if (string.equals(OmiMessage.PPUserType.autoAnswer.name()) || string.equals(OmiMessage.PPUserType.microphoneMute.name()) || string.equals(OmiMessage.PPUserType.warningTone.name()) || string.equals(OmiMessage.PPUserType.allowBargeIn.name())) {
                ppUserDataRecord.setField(string, (Object)OmiMessage.GlobalOnOffType.valueOf(omiMessage.getAttribVal(string)));
            } else if (string.equals(OmiMessage.PPUserType.conferenceServerType.name())) {
                ppUserDataRecord.setField(string, (Object)OmiMessage.ConferenceServerPPUserTypeType.valueOf(omiMessage.getAttribVal(string)));
            } else if (string.equals(OmiMessage.PPUserType.BTsensitivity.name())) {
                ppUserDataRecord.setField(string, (Object)OmiMessage.BTSensitivityType.valueOf(omiMessage.getAttribVal(string)));
            } else if (string.equals(OmiMessage.PPUserType.lang.name())) {
                try {
                    ppUserDataRecord.setField(string, (Object)OmiMessage.PPUserLanguageType.valueOf(omiMessage.getAttribVal(string)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ppUserDataRecord.setField(string, (Object)OmiMessage.PPUserLanguageType.English);
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "Wrong value for PPUserLanguageType: '" + omiMessage.getAttribVal(string) + "'");
                }
            } else if (string.equals(OmiMessage.PPUserType.HAS.name()) || string.equals(OmiMessage.PPUserType.HSS.name()) || string.equals(OmiMessage.PPUserType.HRS.name()) || string.equals(OmiMessage.PPUserType.HCS.name()) || string.equals(OmiMessage.PPUserType.SRS.name()) || string.equals(OmiMessage.PPUserType.SCS.name()) || string.equals(OmiMessage.PPUserType.CDS.name()) || string.equals(OmiMessage.PPUserType.HBS.name()) || string.equals(OmiMessage.PPUserType.BTS.name()) || string.equals(OmiMessage.PPUserType.SWS.name()) || string.equals(OmiMessage.PPUserType.CUS.name())) {
                ppUserDataRecord.setField(string, (Object)OmiMessage.MonitoringStateType.valueOf(omiMessage.getAttribVal(string)));
            } else {
                ppUserDataRecord.setField(string, (Object)omiMessage.getAttribVal(string));
            }
            string = omiMessage.getNextAttribName();
        }
        ppUserDataRecord.commitChanges();
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            this.ppDevDb.clearAll();
            this.ppUserDb.clearAll();
            this.ppDb.clearAll();
            this.ppUmoDb.clearAll();
            this.GenerateDeviceDataNotification(0, DataNotificationEnum.DATA_DELETED_ALL);
            this.GenerateUserDataNotification(0, DataNotificationEnum.DATA_DELETED_ALL);
            this.GenerateUmoDataNotification(0, DataNotificationEnum.DATA_DELETED_ALL);
            this.sendCnfEventNotificationReq();
            this.sendGetPpDevBulk(0, MAX_BULK_RECORDS);
            this.getDevBulkInProgress = true;
        }
    }

    private String getTimeStamp(Calendar calendar) {
        String string = null;
        Formatter formatter = new Formatter();
        formatter.format("%02d.%02d. %02d:%02d", calendar.get(5), calendar.get(2) + 1, calendar.get(11), calendar.get(12));
        string = formatter.toString();
        formatter.close();
        return string;
    }

    private void setLastAction(PpDevDataRecord ppDevDataRecord, OmiMessage.ppTransEvent ppTransEvent2, int n, int n2) {
        if (ppTransEvent2 == OmiMessage.ppTransEvent.Detach) {
            ppDevDataRecord.setField(PpDevDataRecord.IDX_ACTIVITIES, (Object)"detached");
        }
        ppDevDataRecord.setField(PpDevDataRecord.IDX_RFP, (Object)n);
        Date date = new Date();
        long l = date.getTime() - (long)n2 * 1000L;
        Calendar calendar = Calendar.getInstance();
        date.setTime(l);
        calendar.setTime(date);
        ppDevDataRecord.setField(PpDevDataRecord.IDX_LAST_ACTION_TIME, (Object)this.getTimeStamp(calendar));
    }

    private void setActivity(PpDevDataRecord ppDevDataRecord, OmiMessage omiMessage, int n) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.trType.name());
        if (string != null) {
            try {
                OmiMessage.ppTransEvent ppTransEvent2 = OmiMessage.ppTransEvent.valueOf(string);
                int n2 = -1;
                String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.rfpId.name());
                if (string2 != null) {
                    try {
                        n2 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "setActivity() received invalid RFP id format");
                    }
                }
                boolean bl = false;
                switch (ppTransEvent2) {
                    case Establish: 
                    case CcEstablish: {
                        if (n2 == -1) break;
                        this.setLastAction(ppDevDataRecord, ppTransEvent2, n2, 0);
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_CC_ACTIVE, (Object)true);
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_ACTIVITIES, (Object)"");
                        bl = true;
                        break;
                    }
                    case Cc: {
                        if (n2 == -1) break;
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_CC_ACTIVE, (Object)true);
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_ACTIVITIES, (Object)"");
                        bl = true;
                        break;
                    }
                    case Release: 
                    case CcRelease: {
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_CC_ACTIVE, (Object)false);
                        if (n2 != -1) {
                            this.setLastAction(ppDevDataRecord, ppTransEvent2, n2, 0);
                        }
                        bl = true;
                        break;
                    }
                    case SsEstablish: {
                        if (n2 == -1) break;
                        this.setLastAction(ppDevDataRecord, ppTransEvent2, n2, 0);
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_SS_ACTIVE, (Object)true);
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_ACTIVITIES, (Object)"");
                        bl = true;
                        break;
                    }
                    case Ss: {
                        if (n2 == -1) break;
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_SS_ACTIVE, (Object)true);
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_ACTIVITIES, (Object)"");
                        bl = true;
                        break;
                    }
                    case SsRelease: {
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_SS_ACTIVE, (Object)false);
                        if (n2 != -1) {
                            this.setLastAction(ppDevDataRecord, ppTransEvent2, n2, 0);
                        }
                        bl = true;
                        break;
                    }
                    case ComsEstablish: {
                        if (n2 == -1) break;
                        this.setLastAction(ppDevDataRecord, ppTransEvent2, n2, 0);
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_COMS_ACTIVE, (Object)true);
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_ACTIVITIES, (Object)"");
                        bl = true;
                        break;
                    }
                    case Coms: {
                        if (n2 == -1) break;
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_COMS_ACTIVE, (Object)true);
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_ACTIVITIES, (Object)"");
                        bl = true;
                        break;
                    }
                    case ComsRelease: {
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_COMS_ACTIVE, (Object)false);
                        if (n2 != -1) {
                            this.setLastAction(ppDevDataRecord, ppTransEvent2, n2, 0);
                        }
                        bl = true;
                        break;
                    }
                    case ConnHandover: {
                        if (n2 == -1) break;
                        this.setLastAction(ppDevDataRecord, ppTransEvent2, n2, 0);
                        bl = true;
                        break;
                    }
                    case LinkEstablish: {
                        if (n2 == -1) break;
                        this.setLastAction(ppDevDataRecord, ppTransEvent2, n2, 0);
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_ACTIVITIES, (Object)"");
                        bl = true;
                        break;
                    }
                    case LocReg: {
                        if (n2 == -1) break;
                        if (this.useTimer) {
                            ppDevDataRecord.setField(PpDevDataRecord.IDX_MM_ACTIVE, (Object)true);
                            ppDevDataRecord.setField(PpDevDataRecord.IDX_ACTIVITIES, (Object)"LocReg");
                            this.setLastAction(ppDevDataRecord, ppTransEvent2, n2, 0);
                            bl = true;
                            this.setTimerPpn(n, ppTransEvent2, 2);
                            break;
                        }
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_ACTIVITIES, (Object)"");
                        break;
                    }
                    case SsFac: {
                        break;
                    }
                    case Detach: {
                        if (n2 == -1) break;
                        this.setLastAction(ppDevDataRecord, ppTransEvent2, n2, 0);
                        bl = true;
                        break;
                    }
                    case PagingStarted: 
                    case CcPagingStarted: 
                    case ReleaseFromPP: 
                    case CcReleaseFromPP: 
                    case PPSetupRejected: 
                    case CcSetupRejected: 
                    case PPNotFound: 
                    case CcPPNotFound: {
                        break;
                    }
                }
                if (ppTransEvent2 != OmiMessage.ppTransEvent.Cc && ppTransEvent2 != OmiMessage.ppTransEvent.Ss && ppTransEvent2 != OmiMessage.ppTransEvent.Coms) {
                    this.GeneratePpEventNotification(n, n2, PpEventEnum.getInternalEventFromOmiEvent(ppTransEvent2), null);
                }
                if (this.devDataNotificationOnTransactionEvent) {
                    this.GenerateDeviceDataNotification(n, DataNotificationEnum.DATA_CHANGED);
                }
                if (bl) {
                    this.ppDevDb.createPp(ppDevDataRecord);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        int n = -1;
        Transaction transaction = null;
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.seq.name());
        if (string != null && (n = Integer.parseInt(string)) != -1) {
            transaction = this.transArr[n];
        }
        switch (omiMessage.id) {
            case GetPPDevResp: {
                int n2 = this.processGetPpDevResp(omiMessage);
                if (!this.getDevBulkInProgress) break;
                if (n2 > 0) {
                    this.sendGetPpDevBulk(n2 + 1, MAX_BULK_RECORDS);
                    break;
                }
                this.sendGetPpUserBulk(0, MAX_BULK_RECORDS);
                this.getDevBulkInProgress = false;
                this.getUserBulkInProgress = true;
                this.GenerateDeviceDataNotification(this.ppDevDb.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
                break;
            }
            case CreatePPDevResp: {
                if (transaction == null) break;
                String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string2 != null) {
                    this.GenerateDeviceErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                OmiMessage omiMessage2 = omiMessage.getSubElement();
                PpDevDataRecord ppDevDataRecord = transaction.action == actionEnum.ACTION_CREATE_USER_AND_DEVICE ? ((PpDataRecord)transaction.object).ppDev : (PpDevDataRecord)transaction.object;
                int n3 = Integer.parseInt(omiMessage2.getAttribVal(OmiMessage.PPDevType.ppn.name()));
                ppDevDataRecord.setField(PpDevDataRecord.IDX_PPN, (Object)("" + n3));
                this.setDevAttribsFromMsg(ppDevDataRecord, omiMessage2);
                this.ppDevDb.createPp(ppDevDataRecord);
                this.GenerateDeviceDataNotification(n3, DataNotificationEnum.NEW_DATA);
                if (!this.ppStateActive) break;
                this.sendGetPpState(n3);
                break;
            }
            case DeletePPDevResp: {
                this.checkSendBulk();
                if (transaction == null) break;
                int n4 = (Integer)transaction.object;
                String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string3 == null) break;
                this.GenerateDeviceErrorNotification(n4, DataNotificationEnum.DATA_DELETED, omiMessage);
                break;
            }
            case SetPPDevResp: {
                this.checkSendBulk();
                if (transaction == null) break;
                PpDevDataRecord ppDevDataRecord = (PpDevDataRecord)transaction.object;
                String string4 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string4 != null) {
                    this.GenerateDeviceErrorNotification((Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_PPN), DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                OmiMessage omiMessage3 = omiMessage.getSubElement();
                int n5 = Integer.parseInt(omiMessage3.getAttribVal(OmiMessage.PPDevType.ppn.name()));
                ppDevDataRecord.setField(PpDevDataRecord.IDX_PPN, (Object)("" + n5));
                this.setDevAttribsFromMsg(ppDevDataRecord, omiMessage3);
                this.ppDevDb.createPp(ppDevDataRecord);
                this.GenerateDeviceDataNotification(n5, DataNotificationEnum.DATA_CHANGED);
                break;
            }
            case GetPPUserResp: {
                int n6 = this.processGetPpUserResp(omiMessage);
                if (!this.getUserBulkInProgress) break;
                if (n6 > 0) {
                    this.sendGetPpUserBulk(n6 + 1, MAX_BULK_RECORDS);
                    break;
                }
                this.omiManagement.ppBulkReady();
                this.getUserBulkInProgress = false;
                this.GenerateUserDataNotification(this.ppUserDb.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
                this.GenerateUmoDataNotification(this.ppUserDb.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
                break;
            }
            case CreatePPUserResp: {
                PpUmoDataRecord ppUmoDataRecord;
                if (transaction == null) break;
                String string5 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string5 != null) {
                    this.GenerateUserErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                OmiMessage omiMessage4 = omiMessage.getSubElement();
                PpUserDataRecord ppUserDataRecord = (PpUserDataRecord)transaction.object;
                int n7 = Integer.parseInt(omiMessage4.getAttribVal(OmiMessage.PPUserType.uid.name()));
                ppUserDataRecord.setField(PpUserDataRecord.IDX_UID, (Object)n7);
                this.setUserAttribsFromMsg(ppUserDataRecord, omiMessage4);
                this.ppUserDb.createUser(ppUserDataRecord);
                this.GenerateUserDataNotification(n7, DataNotificationEnum.NEW_DATA);
                if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO) || (ppUmoDataRecord = this.ppUmoDb.updateUmoRecord(ppUserDataRecord)) == null) break;
                ppUmoDataRecord.commitChanges();
                this.GenerateUmoDataNotification(n7, DataNotificationEnum.NEW_DATA);
                break;
            }
            case DeletePPUserResp: {
                this.checkSendBulk();
                if (transaction == null) break;
                int n8 = (Integer)transaction.object;
                String string6 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string6 == null) break;
                this.GenerateUserErrorNotification(n8, DataNotificationEnum.DATA_DELETED, omiMessage);
                break;
            }
            case SetPPUserResp: {
                this.checkSendBulk();
                if (transaction == null) break;
                PpUserDataRecord ppUserDataRecord = (PpUserDataRecord)transaction.object;
                String string7 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string7 != null) {
                    this.GenerateUserErrorNotification((Integer)ppUserDataRecord.getField(PpUserDataRecord.IDX_UID), DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                OmiMessage omiMessage5 = omiMessage.getSubElement();
                int n9 = Integer.parseInt(omiMessage5.getAttribVal(OmiMessage.PPUserType.uid.name()));
                ppUserDataRecord.setField(PpUserDataRecord.IDX_UID, (Object)("" + n9));
                this.setUserAttribsFromMsg(ppUserDataRecord, omiMessage5);
                this.ppUserDb.createUser(ppUserDataRecord);
                this.GenerateUserDataNotification(n9, DataNotificationEnum.DATA_CHANGED);
                if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) break;
                DataNotificationEnum dataNotificationEnum = null;
                PpUmoDataRecord ppUmoDataRecord = this.ppUmoDb.getRecordByUid(n9);
                PpUmoDataRecord ppUmoDataRecord2 = this.ppUmoDb.updateUmoRecord(ppUserDataRecord);
                if (ppUmoDataRecord2 != null) {
                    if (ppUmoDataRecord != null) {
                        if (ppUmoDataRecord2.getRecordChanged()) {
                            ppUmoDataRecord2.commitChanges();
                            dataNotificationEnum = DataNotificationEnum.DATA_CHANGED;
                        }
                    } else {
                        ppUmoDataRecord2.commitChanges();
                        dataNotificationEnum = DataNotificationEnum.NEW_DATA;
                    }
                } else if (ppUmoDataRecord != null) {
                    dataNotificationEnum = DataNotificationEnum.DATA_DELETED;
                }
                if (dataNotificationEnum == null) break;
                this.GenerateUmoDataNotification(n9, dataNotificationEnum);
                break;
            }
            case CreateFixedPPResp: {
                if (transaction == null) break;
                String string8 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string8 != null) {
                    this.GenerateUserErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                PpDataRecord ppDataRecord = (PpDataRecord)transaction.object;
                for (OmiMessage omiMessage6 = omiMessage.getSubElement(); omiMessage6 != null; omiMessage6 = omiMessage6.getNext()) {
                    PpUmoDataRecord ppUmoDataRecord;
                    int n10;
                    DataRecord dataRecord;
                    if (omiMessage6.id == OmiMessage.elemIds.pp) {
                        dataRecord = ppDataRecord.ppDev;
                        n10 = Integer.parseInt(omiMessage6.getAttribVal(OmiMessage.PPUserType.ppn.name()));
                        ppDataRecord.setField(PpDevDataRecord.IDX_PPN, n10);
                        this.setDevAttribsFromMsg((PpDevDataRecord)dataRecord, omiMessage6);
                        this.ppDevDb.createPp((PpDevDataRecord)dataRecord);
                        this.GenerateDeviceDataNotification(n10, DataNotificationEnum.NEW_DATA);
                        if (!this.ppStateActive) continue;
                        this.sendGetPpState(n10);
                        continue;
                    }
                    if (omiMessage6.id != OmiMessage.elemIds.user) continue;
                    dataRecord = ppDataRecord.ppUser;
                    n10 = Integer.parseInt(omiMessage6.getAttribVal(OmiMessage.PPUserType.uid.name()));
                    ((PpUserDataRecord)dataRecord).setField(PpUserDataRecord.IDX_UID, n10);
                    this.setUserAttribsFromMsg((PpUserDataRecord)dataRecord, omiMessage6);
                    this.ppUserDb.createUser((PpUserDataRecord)dataRecord);
                    this.GenerateUserDataNotification(n10, DataNotificationEnum.NEW_DATA);
                    if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO) || (ppUmoDataRecord = this.ppUmoDb.updateUmoRecord((PpUserDataRecord)dataRecord)) == null) continue;
                    ppUmoDataRecord.commitChanges();
                    this.GenerateUmoDataNotification(n10, DataNotificationEnum.NEW_DATA);
                }
                break;
            }
            case SubscribeResp: {
                this.processSubscribeResp(omiMessage);
                break;
            }
            case GetLastPPDevActionResp: {
                this.processGetLastPpDevActionResp(omiMessage);
                break;
            }
            case GetActivePPDevResp: {
                this.processGetActivePpDevResp(omiMessage);
                break;
            }
            case EventPPDevCnf: {
                OmiMessage omiMessage7 = omiMessage.getSubElement();
                if (omiMessage7 == null || omiMessage7.id != OmiMessage.elemIds.pp) break;
                int n11 = omiMessage7.getAttribValInt(OmiMessage.PPDevType.ppn.name());
                boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                DataNotificationEnum dataNotificationEnum = DataNotificationEnum.DATA_CHANGED;
                if (bl) {
                    this.ppDevDb.deletePp(n11);
                    dataNotificationEnum = DataNotificationEnum.DATA_DELETED;
                } else {
                    PpDevDataRecord ppDevDataRecord = this.ppDevDb.getPpByPpn(n11);
                    if (ppDevDataRecord == null) {
                        ppDevDataRecord = new PpDevDataRecord(n11);
                        dataNotificationEnum = DataNotificationEnum.NEW_DATA;
                    }
                    this.setDevAttribsFromMsg(ppDevDataRecord, omiMessage7);
                    this.ppDevDb.createPp(ppDevDataRecord);
                    if (dataNotificationEnum == DataNotificationEnum.NEW_DATA && this.ppStateActive) {
                        this.sendGetPpState(n11);
                    }
                }
                this.GenerateDeviceDataNotification(n11, dataNotificationEnum);
                break;
            }
            case EventPPUserCnf: {
                OmiMessage omiMessage8 = omiMessage.getSubElement();
                if (omiMessage8 == null || omiMessage8.id != OmiMessage.elemIds.user) break;
                int n12 = omiMessage8.getAttribValInt(OmiMessage.PPUserType.uid.name());
                DataNotificationEnum dataNotificationEnum = DataNotificationEnum.DATA_CHANGED;
                DataNotificationEnum dataNotificationEnum2 = null;
                boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                if (bl) {
                    this.ppUserDb.deleteUser(n12);
                    dataNotificationEnum = DataNotificationEnum.DATA_DELETED;
                    if (this.ppUmoDb.getRecordByUid(n12) != null) {
                        this.ppUmoDb.deleteUmoRecord(n12);
                        dataNotificationEnum2 = DataNotificationEnum.DATA_DELETED;
                    }
                } else {
                    PpUserDataRecord ppUserDataRecord = this.ppUserDb.getUserByUid(n12);
                    if (ppUserDataRecord == null) {
                        ppUserDataRecord = new PpUserDataRecord(n12);
                        dataNotificationEnum = DataNotificationEnum.NEW_DATA;
                    }
                    this.setUserAttribsFromMsg(ppUserDataRecord, omiMessage8);
                    this.ppUserDb.createUser(ppUserDataRecord);
                    if (this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO)) {
                        PpUmoDataRecord ppUmoDataRecord = this.ppUmoDb.getRecordByUid(n12);
                        PpUmoDataRecord ppUmoDataRecord3 = this.ppUmoDb.updateUmoRecord(ppUserDataRecord);
                        if (ppUmoDataRecord3 != null) {
                            if (ppUmoDataRecord != null) {
                                if (ppUmoDataRecord3.getRecordChanged()) {
                                    ppUmoDataRecord3.commitChanges();
                                    dataNotificationEnum2 = DataNotificationEnum.DATA_CHANGED;
                                }
                            } else {
                                ppUmoDataRecord3.commitChanges();
                                dataNotificationEnum2 = DataNotificationEnum.NEW_DATA;
                            }
                        } else if (ppUmoDataRecord != null) {
                            dataNotificationEnum2 = DataNotificationEnum.DATA_DELETED;
                        }
                    }
                }
                this.GenerateUserDataNotification(n12, dataNotificationEnum);
                if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUMO) || dataNotificationEnum2 == null) break;
                this.GenerateUmoDataNotification(n12, dataNotificationEnum2);
                break;
            }
            case EventPPTransaction: {
                int n13 = Integer.parseInt(omiMessage.getAttribVal(OmiMessage.PPDevType.ppn.name()));
                PpDevDataRecord ppDevDataRecord = this.ppDevDb.getPpByPpn(n13);
                if (ppDevDataRecord == null) break;
                this.setActivity(ppDevDataRecord, omiMessage, n13);
                break;
            }
            case GetPPFirmwareUpdateStatusResp: {
                if (this.getFwUpdStatusBulkInProgress) {
                    int n14 = this.processGetPPFirmwareUpdateStatusResp(omiMessage);
                    if (n14 > 0) {
                        this.sendGetPPFirmwareUpdateStatusBulk(n14 + 1, MAX_BULK_RECORDS);
                        break;
                    }
                    this.getFwUpdStatusBulkInProgress = false;
                    break;
                }
                this.processGetPPFirmwareUpdateStatusResp(omiMessage);
                break;
            }
            case EventPPFirmwareUpdateStatus: {
                OmiMessage omiMessage9 = omiMessage.getSubElement();
                if (omiMessage9 == null) break;
                if (omiMessage9.id == OmiMessage.elemIds.ppFwSt) {
                    PpDevDataRecord ppDevDataRecord = this.getPPFirmwareUpdateStatusValues(omiMessage9);
                    if (ppDevDataRecord != null) {
                        this.ppDevDb.createPp(ppDevDataRecord);
                        this.GenerateDeviceDataNotification((Integer)ppDevDataRecord.getField(PpDevDataRecord.IDX_PPN), DataNotificationEnum.DATA_CHANGED);
                    } else {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventPPFirmwareUpdateStatus - PP dev record does not exist");
                    }
                } else {
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventPPFirmwareUpdateStatus with wrong element id=" + (Object)((Object)omiMessage9.id));
                }
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventPPFirmwareUpdateStatus without element");
                break;
            }
            case SetPPUserDevRelationResp: {
                if (transaction == null) break;
                PpUserDataRecord ppUserDataRecord = (PpUserDataRecord)transaction.object;
                String string9 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string9 == null) break;
                this.GenerateUserErrorNotification((Integer)ppUserDataRecord.getField(PpUserDataRecord.IDX_UID), DataNotificationEnum.DATA_CHANGED, omiMessage);
                break;
            }
            case GetPPStateResp: {
                String string10 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string10 != null) break;
                if (omiMessage.getAttribVal(OmiMessage.PPDevType.ppn.name()) != null) {
                    int n15 = omiMessage.getAttribValInt(OmiMessage.PPDevType.ppn.name());
                    PpDevDataRecord ppDevDataRecord = this.getPPStateValues(omiMessage);
                    if (ppDevDataRecord == null) break;
                    this.ppDevDb.createPp(ppDevDataRecord);
                    this.GenerateDeviceDataNotification(n15, DataNotificationEnum.DATA_CHANGED);
                    break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetPPStateResp -  no 'ppn' elem");
                break;
            }
            case EventPPState: {
                if (omiMessage.getAttribVal(OmiMessage.PPDevType.ppn.name()) != null) {
                    int n16 = omiMessage.getAttribValInt(OmiMessage.PPDevType.ppn.name());
                    PpDevDataRecord ppDevDataRecord = this.getPPStateValues(omiMessage);
                    if (ppDevDataRecord == null) break;
                    this.ppDevDb.createPp(ppDevDataRecord);
                    this.GenerateDeviceDataNotification(n16, DataNotificationEnum.DATA_CHANGED);
                    break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventPPState -  no 'ppn' elem");
                break;
            }
        }
        if (transaction != null) {
            this.transArr[n] = null;
        }
    }

    private PpDevDataRecord getPPStateValues(OmiMessage omiMessage) {
        int n = omiMessage.getAttribValInt(OmiMessage.PPDevType.ppn.name());
        PpDevDataRecord ppDevDataRecord = this.ppDevDb.getPpByPpn(n);
        if (ppDevDataRecord != null) {
            if (omiMessage.getAttribVal(OmiMessage.PPDevType.onHook.name()) != null) {
                ppDevDataRecord.setField(PpDevDataRecord.IDX_ST_ON_HOOK, (Object)omiMessage.getAttribValBool(OmiMessage.PPDevType.onHook.name()));
            }
            if (omiMessage.getAttribVal(OmiMessage.PPDevType.silentCharging.name()) != null) {
                ppDevDataRecord.setField(PpDevDataRecord.IDX_ST_SILENT_CHARGING, (Object)omiMessage.getAttribValBool(OmiMessage.PPDevType.silentCharging.name()));
            }
            if (omiMessage.getAttribVal(OmiMessage.PPDevType.callState.name()) != null) {
                ppDevDataRecord.setField(PpDevDataRecord.IDX_ST_CALL_STATE, (Object)OmiMessage.PPUserCallStateType.valueOf(omiMessage.getAttribVal(OmiMessage.PPDevType.callState.name())));
            }
            if (omiMessage.getAttribVal(OmiMessage.PPDevType.registered.name()) != null) {
                ppDevDataRecord.setField(PpDevDataRecord.IDX_ST_REGISTERED, (Object)omiMessage.getAttribValBool(OmiMessage.PPDevType.registered.name()));
            }
            if (omiMessage.getAttribVal(OmiMessage.PPDevType.batteryLevel.name()) != null) {
                ppDevDataRecord.setField(PpDevDataRecord.IDX_ST_BATTERY_LEVEL, (Object)omiMessage.getAttribValInt(OmiMessage.PPDevType.batteryLevel.name()));
            }
            if (omiMessage.getAttribVal(OmiMessage.PPDevType.bluetooth.name()) != null) {
                ppDevDataRecord.setField(PpDevDataRecord.IDX_ST_BLUETOOTH, (Object)omiMessage.getAttribValBool(OmiMessage.PPDevType.bluetooth.name()));
            }
            if (omiMessage.getAttribVal(OmiMessage.PPDevType.swVersion.name()) != null) {
                ppDevDataRecord.setField(PpDevDataRecord.IDX_ST_SW_VERSION, (Object)omiMessage.getAttribVal(OmiMessage.PPDevType.swVersion.name()));
            }
            if (omiMessage.getAttribVal(OmiMessage.PPDevType.regServerType.name()) != null) {
                ppDevDataRecord.setField(PpDevDataRecord.IDX_ST_REG_SERVER_TYPE, (Object)OmiMessage.RegServerTypeType.valueOf(omiMessage.getAttribVal(OmiMessage.PPDevType.regServerType.name())));
            }
            if (ppDevDataRecord.getField(PpDevDataRecord.IDX_ST_REG_SERVER_TYPE) == OmiMessage.RegServerTypeType.None) {
                ppDevDataRecord.setField(PpDevDataRecord.IDX_ST_REG_SERVER_ADDR, (Object)"-");
                ppDevDataRecord.setField(PpDevDataRecord.IDX_ST_REG_SERVER_PORT, (Object)-1);
            } else {
                if (omiMessage.getAttribVal(OmiMessage.PPDevType.regServerAddr.name()) != null) {
                    ppDevDataRecord.setField(PpDevDataRecord.IDX_ST_REG_SERVER_ADDR, (Object)omiMessage.getAttribVal(OmiMessage.PPDevType.regServerAddr.name()));
                }
                if (omiMessage.getAttribVal(OmiMessage.PPDevType.regServerPort.name()) != null) {
                    ppDevDataRecord.setField(PpDevDataRecord.IDX_ST_REG_SERVER_PORT, (Object)omiMessage.getAttribValInt(OmiMessage.PPDevType.regServerPort.name()));
                }
            }
        } else {
            this.PrintPPDevRecordDoesNotExist(n);
        }
        return ppDevDataRecord;
    }

    private int processGetPPFirmwareUpdateStatusResp(OmiMessage omiMessage) {
        int n = 0;
        int n2 = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (omiMessage2.id == OmiMessage.elemIds.ppFwSt) {
                ++n2;
                n = omiMessage2.getAttribValInt(OmiMessage.PPDevType.ppn.name());
                PpDevDataRecord ppDevDataRecord = this.getPPFirmwareUpdateStatusValues(omiMessage2);
                if (ppDevDataRecord != null) {
                    this.ppDevDb.createPp(ppDevDataRecord);
                    this.GenerateDeviceDataNotification(n, DataNotificationEnum.DATA_CHANGED);
                    continue;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetPPFirmwareUpdateStatusResp - PP dev record does not exist");
                continue;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetPPFirmwareUpdateStatusResp with wrong element id=" + (Object)((Object)omiMessage2.id));
        }
        if (n2 < MAX_BULK_RECORDS) {
            return 0;
        }
        return n;
    }

    private PpDevDataRecord getPPFirmwareUpdateStatusValues(OmiMessage omiMessage) {
        int n = omiMessage.getAttribValInt(OmiMessage.PPDevType.ppn.name());
        PpDevDataRecord ppDevDataRecord = this.ppDevDb.getPpByPpn(n);
        if (ppDevDataRecord != null) {
            OmiMessage.PPFirmwareUpdateStatusStateType pPFirmwareUpdateStatusStateType = OmiMessage.PPFirmwareUpdateStatusStateType.valueOf(omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateStatusType.state.name()));
            ppDevDataRecord.setField(PpDevDataRecord.IDX_FW_UPDATE_STATE, (Object)pPFirmwareUpdateStatusStateType);
            if (omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateStatusType.cause.name()) != null) {
                OmiMessage.PPFirmwareUpdateStatusCauseType pPFirmwareUpdateStatusCauseType = OmiMessage.PPFirmwareUpdateStatusCauseType.valueOf(omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateStatusType.cause.name()));
                ppDevDataRecord.setField(PpDevDataRecord.IDX_FW_UPDATE_CAUSE, (Object)pPFirmwareUpdateStatusCauseType);
            }
            if (omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateStatusType.bytes.name()) != null) {
                ppDevDataRecord.setField(PpDevDataRecord.IDX_FW_UPDATE_BYTES, (Object)omiMessage.getAttribValInt(OmiMessage.PPFirmwareUpdateStatusType.bytes.name()));
            }
            if (omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateStatusType.version.name()) != null) {
                ppDevDataRecord.setField(PpDevDataRecord.IDX_FW_VERSION, (Object)omiMessage.getAttribVal(OmiMessage.PPFirmwareUpdateStatusType.version.name()));
            }
        } else {
            this.PrintPPDevRecordDoesNotExist(n);
        }
        return ppDevDataRecord;
    }

    public void replacePpDevDb(PpDevDatabase ppDevDatabase) {
        if (this.ppDevDbOrig == null) {
            this.ppDevDbOrig = this.ppDevDb;
        }
        this.ppDevDb = ppDevDatabase;
        this.GenerateDeviceDataNotification(-1, DataNotificationEnum.DATABASE_CHANGED);
    }

    public void replacePpUserDb(PpUserDatabase ppUserDatabase) {
        if (this.ppUserDbOrig == null) {
            this.ppUserDbOrig = this.ppUserDb;
        }
        this.ppUserDb = ppUserDatabase;
        this.GenerateUserDataNotification(-1, DataNotificationEnum.DATABASE_CHANGED);
    }

    public void reactivateOldDbs() {
        if (this.ppDevDbOrig != null) {
            this.ppDevDb = this.ppDevDbOrig;
            this.ppDevDbOrig = null;
            this.GenerateDeviceDataNotification(-1, DataNotificationEnum.DATABASE_CHANGED);
        }
        if (this.ppUserDbOrig != null) {
            this.ppUserDb = this.ppUserDbOrig;
            this.ppUserDbOrig = null;
            this.GenerateUserDataNotification(-1, DataNotificationEnum.DATABASE_CHANGED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimerPpn(int n, OmiMessage.ppTransEvent ppTransEvent2, int n2) {
        List<PpTimerAction> list = this.timerList;
        synchronized (list) {
            this.timerList.add(new PpTimerAction(n, ppTransEvent2, 2));
        }
    }

    private void sendGetLastPpDevAction(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetLastPPDevAction);
        omiMessage.addAttrib(OmiMessage.PPDevType.ppn.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendGetLastPpDevAction(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetLastPPDevAction);
        omiMessage.addAttrib(OmiMessage.PPDevType.ppn.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), 0);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void updateLastPpDevAction() {
        if (this.fetchLastPpDevAction) {
            return;
        }
        this.sendGetLastPpDevAction(0, MAX_BULK_RECORDS);
        this.fetchLastPpDevAction = true;
    }

    private void processGetLastPpDevActionResp(OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        if (string != null) {
            this.fetchLastPpDevAction = false;
        } else {
            int n = -1;
            for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                String string2;
                PpDevDataRecord ppDevDataRecord;
                if (omiMessage2.id != OmiMessage.elemIds.pp || (ppDevDataRecord = this.ppDevDb.getPpByPpn(n = Integer.parseInt(omiMessage2.getAttribVal(OmiMessage.LastPPActionType.ppn.name())))) == null || (string2 = omiMessage2.getAttribVal(OmiMessage.LastPPActionType.trType.name())) == null) continue;
                try {
                    OmiMessage.ppTransEvent ppTransEvent2 = OmiMessage.ppTransEvent.valueOf(string2);
                    if (ppTransEvent2 == OmiMessage.ppTransEvent.None) continue;
                    int n2 = -1;
                    String string3 = omiMessage2.getAttribVal(OmiMessage.LastPPActionType.rfpId.name());
                    if (string3 != null) {
                        n2 = Integer.parseInt(string3);
                    }
                    if (n2 == -1) continue;
                    int n3 = 0;
                    string3 = omiMessage2.getAttribVal(OmiMessage.LastPPActionType.relTime.name());
                    if (string3 != null) {
                        n3 = Integer.parseInt(string3);
                    }
                    this.setLastAction(ppDevDataRecord, ppTransEvent2, n2, n3);
                    this.ppDevDb.createPp(ppDevDataRecord);
                    Object[] objectArray = new Object[]{n3};
                    this.GeneratePpEventNotification(n, n2, PpEventEnum.getInternalEventFromOmiEvent(ppTransEvent2), objectArray);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (n != -1) {
                this.sendGetLastPpDevAction(n + 1, MAX_BULK_RECORDS);
            } else {
                this.fetchLastPpDevAction = false;
            }
        }
    }

    private void sendGetActivePpDev(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetActivePPDev);
        omiMessage.addAttrib(OmiMessage.PPDevType.ppn.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void updateActivePpDev() {
        if (this.fetchActivePpDev) {
            return;
        }
        this.sendGetActivePpDev(0, MAX_BULK_RECORDS);
        this.fetchActivePpDev = true;
    }

    private void processGetActivePpDevResp(OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        if (string != null) {
            this.fetchActivePpDev = false;
        } else {
            int n = -1;
            int n2 = -1;
            for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                if (omiMessage2.id != OmiMessage.elemIds.pp) continue;
                n = Integer.parseInt(omiMessage2.getAttribVal(OmiMessage.PPDevType.ppn.name()));
                PpDevDataRecord ppDevDataRecord = this.ppDevDb.getPpByPpn(n);
                if (ppDevDataRecord != null) {
                    this.setActivity(ppDevDataRecord, omiMessage2, n);
                }
                for (int i = n2 + 1; i < n; ++i) {
                    String string2;
                    ppDevDataRecord = this.ppDevDb.getPpByPpn(i);
                    if (ppDevDataRecord == null || (string2 = (String)ppDevDataRecord.getField(PpDevDataRecord.IDX_ACTIVITIES)) == null || string2.equals("")) continue;
                    ppDevDataRecord.setField(PpDevDataRecord.IDX_ACTIVITIES, (Object)"");
                }
                n2 = n;
            }
            if (n != -1) {
                this.sendGetActivePpDev(n + 1, MAX_BULK_RECORDS);
            } else {
                this.fetchActivePpDev = false;
            }
        }
    }

    public void setDevDataNotificationOnTransactionEvent(boolean bl) {
        this.devDataNotificationOnTransactionEvent = bl;
    }

    public boolean getDevDataNotificationOnTransactionEvent() {
        return this.devDataNotificationOnTransactionEvent;
    }

    private void processSubscribeResp(OmiMessage omiMessage) {
        String string;
        if (omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name()) != null && (string = omiMessage.getAttribVal(OmiMessage.attribIds.info.name())) != null && (string.contains(OmiMessage.EventType.PPBtState.name()) || string.contains(OmiMessage.EventType.PPCallState.name()) || string.contains(OmiMessage.EventType.PPDevState.name()) || string.contains(OmiMessage.EventType.PPSipState.name()))) {
            this.subscribeEventPPState();
        }
    }

    private void PrintPPDevRecordDoesNotExist(int n) {
        String string = String.format("PPDevRecord with ppn '0x%03x' does not exist", n);
        if (this.getDevBulkInProgress) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_DB, this, string);
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, string);
        }
    }

    public boolean sendChangeDeletePPs(DataHandler.SendBulkActionType sendBulkActionType, DataRecord[] dataRecordArray, DataHandler.DataHandlerSendBulkInterface dataHandlerSendBulkInterface) {
        if (dataRecordArray == null || dataRecordArray.length == 0) {
            return false;
        }
        this.bulkModifyPPs = (DataRecord[])dataRecordArray.clone();
        return this.startSendBulk(sendBulkActionType, this.bulkModifyPPs.length, dataHandlerSendBulkInterface);
    }

    public void cancelChangeDeletePPs() {
        this.stopSendBulk();
    }

    @Override
    protected void sendNextChange(int n) {
        if (this.bulkModifyPPs[n] instanceof PpUserDataRecord) {
            this.sendSetPpUser((PpUserDataRecord)this.bulkModifyPPs[n]);
            return;
        }
        if (this.bulkModifyPPs[n] instanceof PpDevDataRecord) {
            this.sendSetPpDev((PpDevDataRecord)this.bulkModifyPPs[n]);
            return;
        }
    }

    @Override
    protected void sendNextDelete(int n) {
        if (this.bulkModifyPPs[n] instanceof PpUserDataRecord) {
            this.sendDeletePpUser((Integer)((PpUserDataRecord)this.bulkModifyPPs[n]).getField(PpUserDataRecord.IDX_UID));
            return;
        }
        if (this.bulkModifyPPs[n] instanceof PpDevDataRecord) {
            this.sendDeletePpDev((Integer)((PpDevDataRecord)this.bulkModifyPPs[n]).getField(PpDevDataRecord.IDX_PPN));
            return;
        }
    }

    private class Transaction {
        public actionEnum action = null;
        public Object object = null;

        public Transaction(int n, actionEnum actionEnum2, Object object) {
            this.action = actionEnum2;
            this.object = object;
        }
    }

    public static enum actionEnum {
        ACTION_CREATE_PP,
        ACTION_SET_PP,
        ACTION_DELETE_PP,
        ACTION_PP_BULK_REQ,
        ACTION_GET_PP,
        ACTION_SET_SUBSCRIPTION_MODE,
        ACTION_CREATE_USER,
        ACTION_SET_USER,
        ACTION_DELETE_USER,
        ACTION_CREATE_USER_AND_DEVICE,
        ACTION_GET_USER,
        ACTION_CHANGE_RELATION_TYPE;

    }

    private class TimerPpMonitor
    extends TimerTask {
        private TimerPpMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (PpDataHandler.this.timerList.size() == 0) {
                return;
            }
            List list = PpDataHandler.this.timerList;
            synchronized (list) {
                Iterator iterator = PpDataHandler.this.timerList.iterator();
                while (iterator.hasNext()) {
                    PpTimerAction ppTimerAction = (PpTimerAction)iterator.next();
                    if (ppTimerAction == null || !ppTimerAction.timerAction()) continue;
                    iterator.remove();
                }
            }
        }
    }

    private class PpTimerAction
    implements Runnable {
        int time;
        int ppn;
        OmiMessage.ppTransEvent event;

        public PpTimerAction(int n, OmiMessage.ppTransEvent ppTransEvent2, int n2) {
            this.ppn = n;
            this.event = ppTransEvent2;
            this.time = n2;
        }

        public boolean timerAction() {
            if (this.time > 0) {
                --this.time;
            }
            if (this.time == 0) {
                EventQueue.invokeLater(this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            PpDevDataRecord ppDevDataRecord = PpDataHandler.this.ppDevDb.getPpByPpn(this.ppn);
            if (ppDevDataRecord != null) {
                ppDevDataRecord.setField(PpDevDataRecord.IDX_ACTIVITIES, (Object)"");
                switch (this.event) {
                    case LocReg: {
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_MM_ACTIVE, (Object)false);
                        break;
                    }
                    case SsFac: {
                        ppDevDataRecord.setField(PpDevDataRecord.IDX_SS_ACTIVE, (Object)false);
                        break;
                    }
                }
                PpDataHandler.this.ppDevDb.createPp(ppDevDataRecord);
            }
        }
    }
}

