/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataRecord;
import com.aastra.omilib.PpDevDataRecord;
import com.aastra.omilib.PpUserDataRecord;

public class PpDataRecord
extends DataRecord {
    public static final int numberOfAttribs = PpUserDataRecord.ppUserNumberOfAttribs + PpDevDataRecord.ppDevNumberOfAttribs;
    public PpDevDataRecord ppDev = null;
    public PpUserDataRecord ppUser = null;
    private static String[] fieldNames = PpDataRecord.initFieldNames();

    public static void check() {
        assert (numberOfAttribs <= 125) : System.out.printf("Assertion in PpDataRecord: numberOfAttribs (%d) > Database.MAX_FIELD (%d)\n", numberOfAttribs, 125);
    }

    public PpDataRecord(PpUserDataRecord ppUserDataRecord, PpDevDataRecord ppDevDataRecord) {
        this.ppDev = ppDevDataRecord;
        this.ppUser = ppUserDataRecord;
    }

    public static int devDataIdx(int n) {
        return PpUserDataRecord.ppUserNumberOfAttribs + n;
    }

    @Override
    public String[] getFieldNameArray() {
        return fieldNames;
    }

    @Override
    public Object getField(int n) {
        if (n < PpUserDataRecord.ppUserNumberOfAttribs) {
            if (this.ppUser != null) {
                return this.ppUser.getField(n);
            }
            return null;
        }
        if (n < PpDevDataRecord.ppDevNumberOfAttribs + PpUserDataRecord.ppUserNumberOfAttribs) {
            if (this.ppDev != null) {
                return this.ppDev.getField(n - PpUserDataRecord.ppUserNumberOfAttribs);
            }
            return null;
        }
        return null;
    }

    @Override
    public DataRecord clone() {
        PpUserDataRecord ppUserDataRecord = (PpUserDataRecord)this.ppUser.clone();
        PpDevDataRecord ppDevDataRecord = (PpDevDataRecord)this.ppDev.clone();
        PpDataRecord ppDataRecord = new PpDataRecord(ppUserDataRecord, ppDevDataRecord);
        return ppDataRecord;
    }

    public static String[] getFieldNames() {
        return fieldNames;
    }

    public static void setTableHeaderTextUser(int n, String string) {
        if (n >= 0 && n < PpUserDataRecord.ppUserNumberOfAttribs) {
            PpDataRecord.fieldNames[n] = string;
        }
    }

    public static void setTableHeaderTextDevice(int n, String string) {
        if (n >= 0 && n < PpDevDataRecord.ppDevNumberOfAttribs) {
            PpDataRecord.fieldNames[n + PpUserDataRecord.ppUserNumberOfAttribs] = string;
        }
    }

    private static String[] initFieldNames() {
        int n;
        fieldNames = new String[numberOfAttribs];
        for (n = 0; n < PpUserDataRecord.ppUserNumberOfAttribs; ++n) {
            PpDataRecord.fieldNames[n] = PpUserDataRecord.getFieldNames()[n];
        }
        for (n = 0; n < PpDevDataRecord.ppDevNumberOfAttribs; ++n) {
            PpDataRecord.fieldNames[n + PpUserDataRecord.ppUserNumberOfAttribs] = PpDevDataRecord.getFieldNames()[n];
        }
        return fieldNames;
    }
}

