/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpDataRecord;
import com.aastra.omilib.PpDevDataRecord;
import com.aastra.omilib.PpDevDatabase;
import com.aastra.omilib.PpUserDataRecord;
import com.aastra.omilib.PpUserDatabase;

public class PpDatabase
extends Database
implements Database.DatabaseChangeNotificationInterface {
    private int[] ppIdxArray = new int[10001];
    private int AnzRecords = 0;
    private PpDevDatabase ppDevDb = null;
    private PpUserDatabase ppUserDb = null;
    private PpDataRecord pp = new PpDataRecord(null, null);

    public PpDatabase(PpUserDatabase ppUserDatabase, PpDevDatabase ppDevDatabase) {
        this.ppDevDb = ppDevDatabase;
        this.ppUserDb = ppUserDatabase;
        this.ppUserDb.registerChangeNotificationListener(this);
        this.ppDevDb.registerChangeNotificationListener(this);
    }

    @Override
    public PpDataRecord getRecordByIdx(int n) {
        if (n < this.AnzRecords && this.ppIdxArray[n] != -1) {
            Object object;
            this.pp.ppUser = this.ppUserDb.getUserByUid(this.ppIdxArray[n]);
            if (this.pp.ppUser != null && (object = this.pp.ppUser.getField(PpUserDataRecord.IDX_PPN)) instanceof Integer) {
                this.pp.ppDev = this.ppDevDb.getPpByPpn((Integer)object);
                if (this.pp.ppDev != null) {
                    return this.pp;
                }
            }
        }
        return null;
    }

    @Override
    public void updateIndex() {
        this.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.INDEX_UPDATE, 0, DatabaseChangeEvent.DatabaseChangeType.PP_DEV));
    }

    private void updateIndex(DatabaseChangeEvent databaseChangeEvent) {
        int n = -1;
        int n2 = this.AnzRecords;
        int n3 = -1;
        this.AnzRecords = 0;
        int n4 = -1;
        for (int i = 0; i <= this.ppUserDb.getMaxUserId(); ++i) {
            PpDevDataRecord ppDevDataRecord;
            Object object;
            PpUserDataRecord ppUserDataRecord = this.ppUserDb.getUserByUid(i);
            if (ppUserDataRecord == null || (object = ppUserDataRecord.getField(PpUserDataRecord.IDX_REL_TYPE)) == null || !(object instanceof Enum) || object.equals((Object)OmiMessage.PPRelTypeType.Unbound) || !((object = ppUserDataRecord.getField(PpUserDataRecord.IDX_PPN)) instanceof Integer) || (ppDevDataRecord = this.ppDevDb.getPpByPpn(n = ((Integer)object).intValue())) == null) continue;
            if (this.getFilterActive()) {
                if (!this.filterMatch(ppUserDataRecord, ppDevDataRecord)) continue;
                if (i == databaseChangeEvent.recordId && databaseChangeEvent.type == DatabaseChangeEvent.DatabaseChangeType.PP_USER) {
                    n4 = this.AnzRecords;
                } else if (Integer.valueOf(n) == databaseChangeEvent.recordId && databaseChangeEvent.type == DatabaseChangeEvent.DatabaseChangeType.PP_DEV) {
                    n4 = this.AnzRecords;
                }
                this.ppIdxArray[this.AnzRecords++] = i;
                continue;
            }
            if (i == databaseChangeEvent.recordId && databaseChangeEvent.type == DatabaseChangeEvent.DatabaseChangeType.PP_USER) {
                n4 = this.AnzRecords;
            } else if (n == databaseChangeEvent.recordId && databaseChangeEvent.type == DatabaseChangeEvent.DatabaseChangeType.PP_DEV) {
                n4 = this.AnzRecords;
            }
            if (this.ppIdxArray[this.AnzRecords] != i && n3 == -1) {
                n3 = this.AnzRecords;
            }
            this.ppIdxArray[this.AnzRecords++] = i;
        }
        if (this.AnzRecords < n2) {
            databaseChangeEvent.cause = Database.DatabaseChangeEnum.RECORD_DELETED;
            n4 = n3;
            this.generateChangeNotification(databaseChangeEvent);
        } else if (this.AnzRecords > n2) {
            if (n4 != -1) {
                databaseChangeEvent.modelId = n4;
            }
            databaseChangeEvent.cause = Database.DatabaseChangeEnum.RECORD_ADDED;
            this.generateChangeNotification(databaseChangeEvent);
        } else if (n4 != -1) {
            databaseChangeEvent.modelId = n4;
            this.generateChangeNotification(databaseChangeEvent);
        }
    }

    @Override
    public int getRecordNumber() {
        return this.AnzRecords;
    }

    @Override
    public String[] getFieldNames() {
        return PpDataRecord.getFieldNames();
    }

    public void clearAll() {
        this.updateIndex();
    }

    @Override
    public void databaseChangeNotification(DatabaseChangeEvent databaseChangeEvent) {
        DatabaseChangeEvent databaseChangeEvent2 = new DatabaseChangeEvent(databaseChangeEvent.cause, databaseChangeEvent.recordId, databaseChangeEvent.type);
        databaseChangeEvent2.modelId = databaseChangeEvent.modelId;
        this.updateIndex(databaseChangeEvent2);
    }

    private boolean filterMatch(PpUserDataRecord ppUserDataRecord, PpDevDataRecord ppDevDataRecord) {
        boolean bl = false;
        if (this.filterMatchSingle(0, ppUserDataRecord, ppDevDataRecord)) {
            if (this.getFilterActive(1)) {
                if (this.filterMatchSingle(1, ppUserDataRecord, ppDevDataRecord)) {
                    bl = this.getFilterActive(2) ? this.filterMatchSingle(2, ppUserDataRecord, ppDevDataRecord) : true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private boolean filterMatchSingle(int n, PpUserDataRecord ppUserDataRecord, PpDevDataRecord ppDevDataRecord) {
        for (int i = 0; i < this.getFilterColumnArray(n).length; ++i) {
            int n2 = this.getFilterColumnArray(n)[i];
            if (!(n2 < PpUserDataRecord.ppUserNumberOfAttribs ? this.matchObjectWithFilter(ppUserDataRecord.getField(n2), n2, n) : n2 < PpDevDataRecord.ppDevNumberOfAttribs + PpUserDataRecord.ppUserNumberOfAttribs && this.matchObjectWithFilter(ppDevDataRecord.getField(n2 -= PpUserDataRecord.ppUserNumberOfAttribs), n2, n))) continue;
            return true;
        }
        return false;
    }
}

