/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.OmilibUtil;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;
import java.util.Vector;

public class PpProfilesHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    public static final int MAX_PROFILES = 21;
    public static final int DEFAULT_PROFILE_ID = 0;
    public static final int INVALID_PROFILE_ID = -1;
    protected PpProfilesDatabase ppProfilesDb = new PpProfilesDatabase();
    protected OmiHandler omiHandler = null;
    private boolean getInProgress = false;
    private int actualGetIdx;
    private LinkedList<PpProfilesDataNotificationInterface> listenerList = new LinkedList();
    private static String[] fieldNames = new String[]{"id", "time stamp", "name", "content", "state"};

    public PpProfilesHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        omiManagement.registerManagementEventListener(this);
        OmiMessage.elemIds.GetPpProfileResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetPpProfileResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventPpProfileCnf.registerDataNotificationListener(this);
    }

    public Database getDb() {
        return this.ppProfilesDb;
    }

    public void registerDataNotificationListener(PpProfilesDataNotificationInterface ppProfilesDataNotificationInterface) {
        this.listenerList.add(ppProfilesDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(PpProfilesDataNotificationInterface ppProfilesDataNotificationInterface) {
        this.listenerList.remove(ppProfilesDataNotificationInterface);
    }

    protected void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generate PpProfiles DataNotification - no Device Listener");
        }
        for (PpProfilesDataNotificationInterface ppProfilesDataNotificationInterface : this.listenerList) {
            if (ppProfilesDataNotificationInterface == null) continue;
            ppProfilesDataNotificationInterface.processDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generate PpProfiles ErrorNotification - no Device Listener");
        }
        for (PpProfilesDataNotificationInterface ppProfilesDataNotificationInterface : this.listenerList) {
            if (ppProfilesDataNotificationInterface == null) continue;
            ppProfilesDataNotificationInterface.processErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public void startGetAllPpProfiles() {
        if (this.getInProgress) {
            return;
        }
        this.actualGetIdx = 0;
        this.getInProgress = true;
        this.sendGetPpProfile(this.actualGetIdx);
    }

    public void sendGetPpProfile(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetPpProfile);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), this.actualGetIdx);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendSetPpProfile(PpProfileRec ppProfileRec) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetPpProfile);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.ppProfile);
        if (ppProfileRec.id != -1) {
            omiMessage2.addAttrib(OmiMessage.PpProfileDataSetType.id.name(), ppProfileRec.id);
        }
        if (ppProfileRec.name != null) {
            omiMessage2.addAttrib(OmiMessage.PpProfileDataSetType.name.name(), ppProfileRec.name);
        }
        if (ppProfileRec.data != null) {
            omiMessage2.addAttrib(OmiMessage.PpProfileDataSetType.ppData.name(), ppProfileRec.data);
        }
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public Vector<PpProfileRec> getPpProfilesVector() {
        Vector<PpProfileRec> vector = new Vector<PpProfileRec>();
        for (int i = 0; i < 21; ++i) {
            PpProfileRec ppProfileRec = this.ppProfilesDb.profileArray[i];
            if (ppProfileRec == null) continue;
            vector.add(ppProfileRec);
        }
        return vector;
    }

    private void nextInitialGet() {
        ++this.actualGetIdx;
        if (this.actualGetIdx < 21) {
            this.sendGetPpProfile(this.actualGetIdx);
        } else {
            this.getInProgress = false;
            this.GenerateDataNotification(0, DataNotificationEnum.DATA_BULK_READY);
        }
    }

    private int processPpProfileResp(OmiMessage omiMessage) {
        boolean bl = false;
        if (omiMessage.getAttribVal(OmiMessage.attribIds.deleted.name()) != null) {
            bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
        }
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (bl) {
                int n = omiMessage2.getAttribValInt(OmiMessage.PpProfileDataSetType.id.name());
                if (this.ppProfilesDb.getRecordById(n) == null) continue;
                this.ppProfilesDb.deletePpProfile(n);
                this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                continue;
            }
            if (this.processPpProfileElem(omiMessage2)) continue;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "PpProfileResp elem error");
        }
        if (this.getInProgress) {
            this.nextInitialGet();
        }
        return 0;
    }

    private boolean processPpProfileElem(OmiMessage omiMessage) {
        DataNotificationEnum dataNotificationEnum;
        PpProfileRec ppProfileRec;
        if (omiMessage.id != OmiMessage.elemIds.ppProfile) {
            return false;
        }
        Integer n = omiMessage.getAttribValIntNotMandatory(OmiMessage.PpProfileDataSetType.id.name());
        if (n != null) {
            this.actualGetIdx = n;
            ppProfileRec = new PpProfileRec();
            ppProfileRec.id = n;
            String string = omiMessage.getAttribVal(OmiMessage.PpProfileDataSetType.timeStamp.name());
            if (string != null) {
                ppProfileRec.timeStamp = OmilibUtil.buildFormattedDate(string);
            }
            ppProfileRec.name = omiMessage.getAttribVal(OmiMessage.PpProfileDataSetType.name.name());
            ppProfileRec.data = omiMessage.getAttribVal(OmiMessage.PpProfileDataSetType.ppData.name());
            String string2 = omiMessage.getAttribVal(OmiMessage.PpProfileDataSetType.healthState.name());
            if (string2 != null) {
                ppProfileRec.state = string2.equals(OmiMessage.SeverityType.OK.name()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            dataNotificationEnum = DataNotificationEnum.DATA_CHANGED;
            if (this.ppProfilesDb.getRecordById(n) == null) {
                dataNotificationEnum = DataNotificationEnum.NEW_DATA;
            }
        } else {
            return false;
        }
        this.ppProfilesDb.addPpProfile(ppProfileRec);
        this.GenerateDataNotification(n, dataNotificationEnum);
        return true;
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        String string = null;
        switch (omiMessage.id) {
            case GetPpProfileResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    if (this.getInProgress) {
                        this.nextInitialGet();
                        break;
                    }
                    this.GenerateErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                this.processPpProfileResp(omiMessage);
                break;
            }
            case SetPpProfileResp: 
            case EventPpProfileCnf: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateErrorNotification(-1, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                this.processPpProfileResp(omiMessage);
                break;
            }
        }
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            this.ppProfilesDb.clearAll();
            this.GenerateDataNotification(0, DataNotificationEnum.DATA_DELETED_ALL);
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.PPHCM, null, null);
            this.startGetAllPpProfiles();
        }
    }

    public static class PpProfilesDatabase
    extends Database {
        PpProfileRec[] profileArray = new PpProfileRec[21];
        int[] idxArray = new int[21];
        int NoOfProfiles;

        @Override
        public PpProfileRec getRecordByIdx(int n) {
            if (n >= 0 && n < this.NoOfProfiles) {
                return this.profileArray[this.idxArray[n]];
            }
            return null;
        }

        public PpProfileRec getRecordById(int n) {
            if (n >= 0 && n < 21) {
                return this.profileArray[n];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.NoOfProfiles;
        }

        @Override
        public void updateIndex() {
            this.NoOfProfiles = 0;
            for (int i = 0; i < 21; ++i) {
                if (this.profileArray[i] == null) continue;
                this.idxArray[this.NoOfProfiles++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public void addPpProfile(PpProfileRec ppProfileRec) {
            if (ppProfileRec.id >= 0 && ppProfileRec.id < 21) {
                if (this.profileArray[ppProfileRec.id] == null) {
                    this.profileArray[ppProfileRec.id] = ppProfileRec;
                } else {
                    if (ppProfileRec.timeStamp != null) {
                        this.profileArray[ppProfileRec.id].timeStamp = ppProfileRec.timeStamp;
                    }
                    if (ppProfileRec.name != null) {
                        this.profileArray[ppProfileRec.id].name = ppProfileRec.name;
                    }
                    if (ppProfileRec.data != null) {
                        this.profileArray[ppProfileRec.id].data = ppProfileRec.data;
                    }
                    if (ppProfileRec.state != null) {
                        this.profileArray[ppProfileRec.id].state = ppProfileRec.state;
                    }
                }
                this.updateIndex();
            }
        }

        public void deletePpProfile(int n) {
            this.profileArray[n] = null;
            this.updateIndex();
        }

        public void clearAll() {
            for (int i = 0; i < 21; ++i) {
                this.profileArray[i] = null;
            }
            this.NoOfProfiles = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        @Override
        public String[] getFieldNames() {
            return fieldNames;
        }
    }

    public static class PpProfileRec
    extends DataRecord {
        public static final int MAX_DATA_LEN = 4096;
        public static final int IDX_ID = 0;
        public static final int IDX_TIME_STAMP = 1;
        public static final int IDX_NAME = 2;
        public static final int IDX_DATA = 3;
        public static final int IDX_STATE = 4;
        public static final int NUMBER_OF_FIELDS = 5;
        public int id;
        public String timeStamp = null;
        public String name = null;
        public String data = null;
        public Boolean state = null;

        public PpProfileRec() {
            this.id = -1;
        }

        public PpProfileRec(int n) {
            this.id = n;
        }

        public String toString() {
            return "" + this.id + " - " + this.name;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.timeStamp;
                }
                case 2: {
                    return this.name;
                }
                case 3: {
                    return this.data;
                }
                case 4: {
                    return this.state;
                }
            }
            return null;
        }

        @Override
        public DataRecord clone() {
            PpProfileRec ppProfileRec = new PpProfileRec();
            ppProfileRec.id = this.id;
            ppProfileRec.timeStamp = this.timeStamp;
            ppProfileRec.name = this.name;
            ppProfileRec.data = this.data;
            ppProfileRec.state = this.state;
            return ppProfileRec;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 5) {
                fieldNames[n] = string;
            }
        }
    }

    public static interface PpProfilesDataNotificationInterface {
        public void processDataNotification(int var1, DataNotificationEnum var2);

        public void processErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }
}

