/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.PpUserDataRecord;
import java.util.HashSet;

public class PpUserDatabase
extends Database {
    public static final int MAX_USER = 10001;
    private PpUserDataRecord[] userArray = new PpUserDataRecord[10001];
    private int[] userIdxArray = new int[10001];
    private int AnzRecords = 0;
    private int maxUid = 0;
    private HashSet<Integer> filterUID = new HashSet();

    public PpUserDataRecord getUserByUid(int n) {
        if (n >= 0 && n < 10001) {
            return this.userArray[n];
        }
        return null;
    }

    @Override
    public PpUserDataRecord getRecordByIdx(int n) {
        if (n >= 0 && n < this.AnzRecords) {
            return this.userArray[this.userIdxArray[n]];
        }
        return null;
    }

    public PpUserDataRecord createUser(PpUserDataRecord ppUserDataRecord) {
        int n = (Integer)ppUserDataRecord.getField(PpUserDataRecord.IDX_UID);
        DatabaseChangeEvent databaseChangeEvent = new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_ADDED, n, DatabaseChangeEvent.DatabaseChangeType.PP_USER);
        if (n < 10001) {
            if (this.userArray[n] != null) {
                databaseChangeEvent.cause = Database.DatabaseChangeEnum.RECORD_CHANGED;
            }
            this.userArray[n] = ppUserDataRecord;
            if (n > this.maxUid) {
                this.maxUid = n;
            }
            this.updateIndex(databaseChangeEvent);
            return this.userArray[n];
        }
        return null;
    }

    public void deleteUser(int n) {
        if (n >= 0 && n < 10001 && this.userArray[n] != null) {
            this.userArray[n].deleted = true;
            this.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_DELETED, n, DatabaseChangeEvent.DatabaseChangeType.PP_USER));
        }
    }

    @Override
    public void updateIndex() {
        this.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.INDEX_UPDATE, 0, DatabaseChangeEvent.DatabaseChangeType.PP_USER));
    }

    private void updateIndex(DatabaseChangeEvent databaseChangeEvent) {
        this.AnzRecords = 0;
        int n = -1;
        for (int i = 0; i <= this.maxUid; ++i) {
            if (this.userArray[i] == null) continue;
            if (this.userArray[i].deleted) {
                this.userArray[i] = null;
                continue;
            }
            if (this.getFilterActive()) {
                if (this.filterMatch(this.userArray[i])) {
                    if (i == databaseChangeEvent.recordId) {
                        n = this.AnzRecords;
                    }
                    this.userIdxArray[this.AnzRecords++] = i;
                    if (this.filterUID.contains(i)) continue;
                    this.filterUID.add(i);
                    if (i != databaseChangeEvent.recordId || databaseChangeEvent.cause != Database.DatabaseChangeEnum.RECORD_CHANGED) continue;
                    databaseChangeEvent.cause = Database.DatabaseChangeEnum.RECORD_ADDED;
                    continue;
                }
                if (!this.filterUID.contains(i)) continue;
                this.filterUID.remove(i);
                if (i != databaseChangeEvent.recordId || databaseChangeEvent.cause != Database.DatabaseChangeEnum.RECORD_CHANGED) continue;
                databaseChangeEvent.cause = Database.DatabaseChangeEnum.RECORD_DELETED;
                continue;
            }
            if (!this.filterUID.isEmpty()) {
                this.filterUID.clear();
            }
            if (i == databaseChangeEvent.recordId) {
                n = this.AnzRecords;
            }
            this.userIdxArray[this.AnzRecords++] = i;
        }
        if (n != -1) {
            databaseChangeEvent.modelId = n;
        }
        if (databaseChangeEvent.cause != Database.DatabaseChangeEnum.RECORD_CHANGED || databaseChangeEvent.modelId != -1) {
            this.generateChangeNotification(databaseChangeEvent);
        }
    }

    @Override
    public int getRecordNumber() {
        return this.AnzRecords;
    }

    @Override
    public String[] getFieldNames() {
        return PpUserDataRecord.getFieldNames();
    }

    public void clearAll() {
        for (int i = 0; i <= this.maxUid; ++i) {
            this.userArray[i] = null;
        }
        this.maxUid = 0;
        this.AnzRecords = 0;
    }

    public int getMaxUserId() {
        return this.maxUid;
    }

    public void updateTransientFields(PpUserDataRecord ppUserDataRecord) {
        int n = (Integer)ppUserDataRecord.getField(PpUserDataRecord.IDX_UID);
        PpUserDataRecord ppUserDataRecord2 = this.getUserByUid(n);
        if (ppUserDataRecord2 != null) {
            for (int i = 0; i < PpUserDataRecord.ppUserNumberOfAttribs; ++i) {
                if ((i >= PpUserDataRecord.ppUserNumberOfOmiAttribs || !OmiMessage.PPUserType.values()[i].isClassReadOnly()) && i < PpUserDataRecord.ppUserNumberOfOmiAttribs || ppUserDataRecord.getField(i).equals(ppUserDataRecord2.getField(i))) continue;
                ppUserDataRecord.setField(i, ppUserDataRecord2.getField(i));
                ppUserDataRecord.commitChangeOfField(i);
            }
        }
    }
}

