/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class RfpCaptureHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    private RfpCaptureDatabase rfpCaptureDb = new RfpCaptureDatabase();
    private OmiManagement omiManagement = null;
    private OmiHandler omiHandler = null;
    private LinkedList<RfpCaptureDataNotificationInterface> listenerList = new LinkedList();

    public RfpCaptureHandler(OmiManagement omiManagement) {
        this.omiManagement = omiManagement;
        this.omiHandler = this.omiManagement.getOmiHandler();
        this.omiManagement.registerManagementEventListener(this);
        OmiMessage.elemIds.GetRFPCaptureListResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteRFPCaptureListResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteRFPCaptureListElemResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRFPCapture.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventRFPConnectAttempt.registerDataNotificationListener(this);
    }

    public void registerDataNotificationListener(RfpCaptureDataNotificationInterface rfpCaptureDataNotificationInterface) {
        this.listenerList.add(rfpCaptureDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(RfpCaptureDataNotificationInterface rfpCaptureDataNotificationInterface) {
        this.listenerList.remove(rfpCaptureDataNotificationInterface);
    }

    private void GenerateDataNotification(String string, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating RfpCapture notification: No listener");
        }
        for (RfpCaptureDataNotificationInterface rfpCaptureDataNotificationInterface : this.listenerList) {
            if (rfpCaptureDataNotificationInterface == null) continue;
            rfpCaptureDataNotificationInterface.processRfpCaptureDataNotification(string, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(String string, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating RfpCapture error notification: No listener");
        }
        for (RfpCaptureDataNotificationInterface rfpCaptureDataNotificationInterface : this.listenerList) {
            if (rfpCaptureDataNotificationInterface == null) continue;
            rfpCaptureDataNotificationInterface.processRfpCaptureDataErrorNotification(string, dataNotificationEnum, omiMessage);
        }
    }

    public RfpCaptureDatabase getDb() {
        return this.rfpCaptureDb;
    }

    public RfpCaptureRecord getCapturedRfpById(int n) {
        return this.rfpCaptureDb.getRecordById(n);
    }

    public RfpCaptureRecord getCapturedRfpByTableIdx(int n) {
        return this.rfpCaptureDb.getRecordByIdx(n);
    }

    public RfpCaptureRecord getCapturedRfpByEthAddr(String string) {
        return this.rfpCaptureDb.getRecordByEthAddr(string);
    }

    public void sendGetRfpCaptureList() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetRFPCaptureList);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendDeleteRfpCaptureList() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteRFPCaptureList);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendDeleteRfpCaptureListElem(String string) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteRFPCaptureListElem);
        omiMessage.addAttrib(OmiMessage.CapturedRFPType.ethAddr.name(), string);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        switch (omiManagementEventEnum) {
            case LINK_READY: {
                this.rfpCaptureDb.clearAll();
                this.GenerateDataNotification("", DataNotificationEnum.DATA_DELETED_ALL);
                this.sendGetRfpCaptureList();
                break;
            }
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        switch (omiMessage.id) {
            case GetRFPCaptureListResp: {
                this.processGetRfpCaptureListResp(omiMessage);
                break;
            }
            case DeleteRFPCaptureListResp: 
            case DeleteRFPCaptureListElemResp: {
                this.processDeleteRFPCaptureListResp(omiMessage);
                break;
            }
            case EventRFPCapture: {
                this.processEventRfpCapture(omiMessage);
                break;
            }
            case EventRFPConnectAttempt: {
                this.processRfpConnectAttempt(omiMessage);
                break;
            }
        }
    }

    private void processGetRfpCaptureListResp(OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        if (string != null) {
            OmiMessage.errorCodes errorCodes2 = OmiMessage.errorCodes.valueOf(string);
            if (errorCodes2 == OmiMessage.errorCodes.ENoEnt) {
                this.GenerateDataNotification("", DataNotificationEnum.RFP_CAPTURE_LIST_RESP);
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, String.format("CapturedRFPTypeResp error '%s'", string));
                this.GenerateErrorNotification("", DataNotificationEnum.RFP_CAPTURE_LIST_RESP, omiMessage);
            }
            return;
        }
        OmiMessage omiMessage2 = omiMessage.getSubElement();
        if (omiMessage2 == null) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetRfpCaptureListResp - no CapturedRFPType elem");
        }
        while (omiMessage2 != null) {
            this.processCapturedRfp(omiMessage2);
            omiMessage2 = omiMessage2.getNext();
        }
    }

    private void processDeleteRFPCaptureListResp(OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        if (string != null) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, String.format("%s error '%s'", omiMessage.id.name(), string));
            this.GenerateErrorNotification("", DataNotificationEnum.DELETE_RFP_CAPTURE_LIST_RESP, omiMessage);
        }
    }

    private void processEventRfpCapture(OmiMessage omiMessage) {
        OmiMessage omiMessage2 = omiMessage.getSubElement();
        if (omiMessage2 != null) {
            boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
            if (bl) {
                if (omiMessage2.id == OmiMessage.elemIds.rfp) {
                    String string = omiMessage2.getAttribVal(OmiMessage.CapturedRFPType.ethAddr.name());
                    if (string != null) {
                        this.rfpCaptureDb.delete(string);
                    }
                    this.GenerateDataNotification(string, DataNotificationEnum.DATA_DELETED);
                }
            } else {
                this.processCapturedRfp(omiMessage2);
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventRfpCapture - no CapturedRFPType elem");
        }
    }

    private void processRfpConnectAttempt(OmiMessage omiMessage) {
        this.processCapturedRfp(omiMessage);
    }

    private void processCapturedRfp(OmiMessage omiMessage) {
        Boolean bl;
        Enum enum_;
        DataNotificationEnum dataNotificationEnum;
        boolean bl2 = false;
        String string = omiMessage.getAttribVal(OmiMessage.CapturedRFPType.ethAddr.name());
        if (string == null) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "CapturedRFPType elem does no contain field 'ethAddr'");
            return;
        }
        RfpCaptureRecord rfpCaptureRecord = this.rfpCaptureDb.getRecordByEthAddr(string);
        if (rfpCaptureRecord == null) {
            rfpCaptureRecord = new RfpCaptureRecord(string);
            bl2 = true;
            dataNotificationEnum = DataNotificationEnum.NEW_DATA;
        } else {
            dataNotificationEnum = DataNotificationEnum.DATA_CHANGED;
        }
        string = omiMessage.getAttribVal(OmiMessage.CapturedRFPType.ipAddr.name());
        if (string != null && rfpCaptureRecord.ipAddr != string) {
            rfpCaptureRecord.ipAddr = string;
            bl2 = true;
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.CapturedRFPType.hwType.name())) != null) {
            try {
                enum_ = OmiMessage.RFPHwTypeType.getTypeFromStrRealHw(string);
                if (rfpCaptureRecord.hwType != enum_) {
                    rfpCaptureRecord.hwType = (OmiMessage.RFPHwTypeType)enum_;
                    bl2 = true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.CapturedRFPType.hasWlan.name())) != null && rfpCaptureRecord.hasWlan != bl) {
            rfpCaptureRecord.hasWlan = bl;
            bl2 = true;
        }
        if ((string = omiMessage.getAttribVal(OmiMessage.CapturedRFPType.radioType.name())) != null) {
            try {
                enum_ = OmiMessage.RFPRadioTypeType.valueOf(string);
                if (rfpCaptureRecord.radioType != enum_) {
                    rfpCaptureRecord.radioType = (OmiMessage.RFPRadioTypeType)enum_;
                    bl2 = true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.CapturedRFPType.outdoorType.name())) != null && rfpCaptureRecord.outdoorType != bl) {
            rfpCaptureRecord.outdoorType = bl;
            bl2 = true;
        }
        if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.CapturedRFPType.hasFreqShift.name())) != null && rfpCaptureRecord.hasFreqShift != bl) {
            rfpCaptureRecord.hasFreqShift = bl;
            bl2 = true;
        }
        if (bl2 && this.rfpCaptureDb.add(rfpCaptureRecord) != null) {
            this.GenerateDataNotification(rfpCaptureRecord.ethAddr, dataNotificationEnum);
        }
    }

    public void setConfigState(String string, boolean bl) {
        RfpCaptureRecord rfpCaptureRecord = null;
        rfpCaptureRecord = this.getCapturedRfpByEthAddr(string);
        if (rfpCaptureRecord != null) {
            rfpCaptureRecord.configFailed = bl;
            this.rfpCaptureDb.add(rfpCaptureRecord);
        }
    }

    public static interface RfpCaptureDataNotificationInterface {
        public void processRfpCaptureDataNotification(String var1, DataNotificationEnum var2);

        public void processRfpCaptureDataErrorNotification(String var1, DataNotificationEnum var2, OmiMessage var3);
    }

    public static class RfpCaptureDatabase
    extends Database {
        public static final int MAX_RFP_CAPTURE = 4096;
        RfpCaptureRecord[] rfps = new RfpCaptureRecord[4096];
        int[] rfpIdx = new int[4096];
        int noOfRfps = 0;

        @Override
        public RfpCaptureRecord getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfRfps) {
                return this.rfps[this.rfpIdx[n]];
            }
            return null;
        }

        public RfpCaptureRecord getRecordById(int n) {
            return this.rfps[n];
        }

        public RfpCaptureRecord getRecordByEthAddr(String string) {
            for (int i = 0; i < this.noOfRfps; ++i) {
                if (!this.rfps[this.rfpIdx[i]].ethAddr.equals(string)) continue;
                return this.rfps[this.rfpIdx[i]];
            }
            return null;
        }

        public Integer getIdByEthAddr(String string) {
            for (int i = 0; i < this.noOfRfps; ++i) {
                if (!this.rfps[this.rfpIdx[i]].ethAddr.equals(string)) continue;
                return this.rfpIdx[i];
            }
            return null;
        }

        public Integer getIdxByEthAddr(String string) {
            for (int i = 0; i < this.noOfRfps; ++i) {
                if (!this.rfps[this.rfpIdx[i]].ethAddr.equals(string)) continue;
                return i;
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfRfps;
        }

        @Override
        public void updateIndex() {
            this.noOfRfps = 0;
            for (int i = 0; i < 4096; ++i) {
                if (this.rfps[i] == null) continue;
                this.rfpIdx[this.noOfRfps++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public Integer add(RfpCaptureRecord rfpCaptureRecord) {
            Integer n = this.getIdByEthAddr(rfpCaptureRecord.ethAddr);
            if (n == null) {
                for (int i = 0; i < 4096; ++i) {
                    if (this.rfps[i] != null) continue;
                    this.rfps[i] = rfpCaptureRecord;
                    this.updateIndex();
                    return i;
                }
            } else {
                this.rfps[n.intValue()] = rfpCaptureRecord;
                this.updateIndex();
                return n;
            }
            return null;
        }

        public void delete(String string) {
            for (int i = 0; i < this.noOfRfps; ++i) {
                if (!this.rfps[this.rfpIdx[i]].ethAddr.equals(string)) continue;
                this.rfps[this.rfpIdx[i]] = null;
                this.updateIndex();
                return;
            }
        }

        public void clearAll() {
            for (int i = 0; i < this.noOfRfps; ++i) {
                this.rfps[this.rfpIdx[i]] = null;
            }
            this.noOfRfps = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        @Override
        public String[] getFieldNames() {
            return RfpCaptureRecord.getFieldNames();
        }
    }

    public static class RfpCaptureRecord
    extends DataRecord {
        public static final int IDX_ETH_ADDR = 0;
        public static final int IDX_IP_ADDR = 1;
        public static final int IDX_HWTYPE = 2;
        public static final int IDX_HAS_WLAN = 3;
        public static final int IDX_RADIO_TYPE = 4;
        public static final int IDX_OUTDOOR_TYPE = 5;
        public static final int IDX_HAS_FREQ_SHIFT = 6;
        public static final int IDX_CONFIG_FAILED = 7;
        public static final int NUMBER_OF_FIELDS = 8;
        private static String[] fieldNames = new String[]{"Eth Address", "IP Address", "HW Type", "WLAN avail", "Radio Type", "Outdoor", "Freq. shift", "Config. failed"};
        private String ethAddr = null;
        private String ipAddr = "";
        private OmiMessage.RFPHwTypeType hwType = OmiMessage.RFPHwTypeType.UNKNOWN;
        private boolean hasWlan = false;
        private OmiMessage.RFPRadioTypeType radioType = OmiMessage.RFPRadioTypeType.None;
        private boolean outdoorType = false;
        private boolean hasFreqShift = false;
        private boolean configFailed = false;

        public RfpCaptureRecord() {
        }

        public RfpCaptureRecord(String string) {
            this.ethAddr = string;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 8) {
                RfpCaptureRecord.fieldNames[n] = string;
            }
        }

        public static String[] getFieldNames() {
            return fieldNames;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.ethAddr;
                }
                case 1: {
                    return this.ipAddr;
                }
                case 2: {
                    return this.hwType;
                }
                case 3: {
                    return this.hasWlan;
                }
                case 4: {
                    return this.radioType;
                }
                case 5: {
                    return this.outdoorType;
                }
                case 6: {
                    return this.hasFreqShift;
                }
                case 7: {
                    return this.configFailed;
                }
            }
            return null;
        }

        @Override
        public RfpCaptureRecord clone() {
            RfpCaptureRecord rfpCaptureRecord = new RfpCaptureRecord();
            rfpCaptureRecord.ethAddr = this.ethAddr;
            rfpCaptureRecord.ipAddr = this.ipAddr;
            rfpCaptureRecord.hwType = this.hwType;
            rfpCaptureRecord.hasWlan = this.hasWlan;
            rfpCaptureRecord.outdoorType = this.outdoorType;
            rfpCaptureRecord.hasFreqShift = this.hasFreqShift;
            rfpCaptureRecord.configFailed = this.configFailed;
            return rfpCaptureRecord;
        }
    }
}

