/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiMessage;
import com.aastra.util.UtilSpy;
import java.util.EnumSet;

public class RfpDataRecord
extends DataRecord {
    public static final int INVALID_RFP = -1;
    public static final int UNASSIGNED_PA = -1;
    public static final int MAX_SYNC_RELS = 64;
    public static final int IDX_RFP_ID = OmiMessage.RFPType.id.ordinal();
    public static final int IDX_ETH_ADDR = OmiMessage.RFPType.ethAddr.ordinal();
    public static final int IDX_DECT_ON = OmiMessage.RFPType.dectOn.ordinal();
    public static final int IDX_WLAN_ON = OmiMessage.RFPType.wlanOn.ordinal();
    public static final int IDX_LICENSE_RFP = OmiMessage.RFPType.licenseRfp.ordinal();
    public static final int IDX_NAME = OmiMessage.RFPType.name.ordinal();
    public static final int IDX_SITE = OmiMessage.RFPType.site.ordinal();
    public static final int IDX_HIERARCHY1 = OmiMessage.RFPType.hierarchy1.ordinal();
    public static final int IDX_HIERARCHY2 = OmiMessage.RFPType.hierarchy2.ordinal();
    public static final int IDX_HIERARCHY3 = OmiMessage.RFPType.hierarchy3.ordinal();
    public static final int IDX_HIERARCHY4 = OmiMessage.RFPType.hierarchy4.ordinal();
    public static final int IDX_RPN = OmiMessage.RFPType.rpn.ordinal();
    public static final int IDX_PAGING_AREA = OmiMessage.RFPType.pagingArea.ordinal();
    public static final int IDX_CLUSTER = OmiMessage.RFPType.cluster.ordinal();
    public static final int IDX_PREFERRED_SYNC = OmiMessage.RFPType.preferredSync.ordinal();
    public static final int IDX_REFLECTIVE_ENV = OmiMessage.RFPType.reflectiveEnv.ordinal();
    public static final int IDX_CONFERENCE_CHANNELS = OmiMessage.RFPType.conferenceChannels.ordinal();
    public static final int IDX_XPOS = OmiMessage.RFPType.x.ordinal();
    public static final int IDX_YPOS = OmiMessage.RFPType.y.ordinal();
    public static final int IDX_WLAN_PROFILE = OmiMessage.RFPType.wlanProfile.ordinal();
    public static final int IDX_WLAN_ANTENNA_DIV = OmiMessage.RFPType.wlanAntennaDiv.ordinal();
    public static final int IDX_WLAN_ANTENNA = OmiMessage.RFPType.wlanAntenna.ordinal();
    public static final int IDX_WLAN_HIGH_THROUGHPUT = OmiMessage.RFPType.wlanHighThroughput.ordinal();
    public static final int IDX_WLAN_CHANNEL = OmiMessage.RFPType.wlanChannel.ordinal();
    public static final int IDX_WLAN_POWER = OmiMessage.RFPType.wlanPower.ordinal();
    public static final int IDX_CONNECTED = OmiMessage.RFPType.connected.ordinal();
    public static final int IDX_IP_ADDR = OmiMessage.RFPType.ipAddr.ordinal();
    public static final int IDX_DECT_RUNNING = OmiMessage.RFPType.dectRunning.ordinal();
    public static final int IDX_WLAN_RUNNING = OmiMessage.RFPType.wlanRunning.ordinal();
    public static final int IDX_OMM_RUNNING = OmiMessage.RFPType.ommRunning.ordinal();
    public static final int IDX_OMM_STB_RUNNING = OmiMessage.RFPType.ommStbRunning.ordinal();
    public static final int IDX_HWTYPE = OmiMessage.RFPType.hwType.ordinal();
    public static final int IDX_HWTYPE_LOCKED = OmiMessage.RFPType.hwTypeLocked.ordinal();
    public static final int IDX_HAS_WLAN = OmiMessage.RFPType.hasWlan.ordinal();
    public static final int IDX_SYNC_STATE = OmiMessage.RFPType.syncState.ordinal();
    public static final int IDX_SW_VERSION = OmiMessage.RFPType.swVersion.ordinal();
    public static final int IDX_NEW_SW_REQUEST = OmiMessage.RFPType.newSoftwareRequest.ordinal();
    public static final int IDX_BRANDING_MISMATCH = OmiMessage.RFPType.brandingMismatch.ordinal();
    public static final int IDX_VERSION_MISMATCH = OmiMessage.RFPType.versionMismatch.ordinal();
    public static final int IDX_STANDBY_OMM_MISMATCH = OmiMessage.RFPType.stbMismatch.ordinal();
    public static final int IDX_WLAN_LINK_NOK = OmiMessage.RFPType.wlanLinkNok.ordinal();
    public static final int IDX_RADIO_TYPE = OmiMessage.RFPType.radioType.ordinal();
    public static final int IDX_OUTDOOR_TYPE = OmiMessage.RFPType.outdoorType.ordinal();
    public static final int IDX_HAS_FREQ_SHIFT = OmiMessage.RFPType.hasFreqShift.ordinal();
    public static final int IDX_HAS_ENCRYPTION = OmiMessage.RFPType.hasEncryption.ordinal();
    public static final int IDX_HAS_ADVANCED_FEAT = OmiMessage.RFPType.hasAdvancedFeatures.ordinal();
    public static final int IDX_NSYNC_RELS = OmiMessage.RFPType.nSyncRels.ordinal();
    public static final int IDX_WLAN_CHANNEL_USED = OmiMessage.RFPType.wlanChannelUsed.ordinal();
    public static final int IDX_WLAN_HIGH_THROUGHPUT_TYPE_USED = OmiMessage.RFPType.wlanHighThroughputTypeUsed.ordinal();
    public static final int IDX_WLAN_POWER_USED = OmiMessage.RFPType.wlanPowerUsed.ordinal();
    public static final int numberOfRFPTypeAttribs;
    public static final int IDX_GUI_ATTRIB1;
    public static final int IDX_GUI_ATTRIB2;
    public static final int IDX_ERROR_MSG;
    public static final int IDX_SITE_TEXT;
    public static final int IDX_HWTYPE_TEXT;
    public static final int IDX_POSITIONED;
    public static final int IDX_ENCRYPTION_STATE;
    public static final int IDX_ADVANCED_FEATURES_STATE;
    public static final int numberOfFields;
    private static String[] fieldNames;
    private DataRecord.DataElem[] members = new DataRecord.DataElem[numberOfFields];
    public SyncRelType[] forwardRels = null;
    public int maxForwardRelNumber = 0;
    public SyncRelType[] backwardRels = new SyncRelType[64];
    public int maxBackwardRelNumber = 0;
    public boolean selectedBySyncView = false;
    public int locatingXPos = 0;
    public int locatingYPos = 0;
    public int locatingImageId = -1;

    public int deleteSyncRels() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.maxForwardRelNumber; ++n) {
            if (this.forwardRels[n] != null) {
                ++n2;
            }
            this.forwardRels[n] = null;
        }
        this.maxForwardRelNumber = 0;
        for (n = 0; n < this.maxBackwardRelNumber; ++n) {
            if (this.backwardRels[n] != null) {
                ++n2;
            }
            this.backwardRels[n] = null;
        }
        this.maxBackwardRelNumber = 0;
        return n2;
    }

    private int addRel(SyncRelType[] syncRelTypeArray, int n, int n2, int n3, int n4) {
        int n5 = -1;
        for (int i = 0; i < n; ++i) {
            if (syncRelTypeArray[i] != null) {
                if (syncRelTypeArray[i].id != n2) continue;
                syncRelTypeArray[i].rssi = n3;
                syncRelTypeArray[i].offset = n4;
                return n;
            }
            n5 = i;
        }
        if (n5 != -1) {
            syncRelTypeArray[n5] = new SyncRelType(n2, n3, n4);
        } else if (n < 64) {
            syncRelTypeArray[n++] = new SyncRelType(n2, n3, n4);
        }
        return n;
    }

    private int removeRel(SyncRelType[] syncRelTypeArray, int n, int n2) {
        if (syncRelTypeArray == null) {
            return n;
        }
        for (int i = 0; i < n; ++i) {
            if (syncRelTypeArray[i] == null || syncRelTypeArray[i].id != n2) continue;
            syncRelTypeArray[i] = null;
            if (i == n - 1) {
                --n;
            }
            return n;
        }
        return n;
    }

    public void addForwardRel(int n, int n2, int n3) {
        if (this.forwardRels == null) {
            this.forwardRels = new SyncRelType[64];
        }
        this.maxForwardRelNumber = this.addRel(this.forwardRels, this.maxForwardRelNumber, n, n2, n3);
    }

    public void addBackwardRel(int n, int n2, int n3) {
        if (this.backwardRels == null) {
            this.backwardRels = new SyncRelType[64];
        }
        this.maxBackwardRelNumber = this.addRel(this.backwardRels, this.maxBackwardRelNumber, n, n2, n3);
    }

    public void removeForwardRel(int n) {
        this.maxForwardRelNumber = this.removeRel(this.forwardRels, this.maxForwardRelNumber, n);
    }

    public void removeBackwardRel(int n) {
        this.maxBackwardRelNumber = this.removeRel(this.backwardRels, this.maxBackwardRelNumber, n);
    }

    public RfpDataRecord() {
        this.setField(IDX_RFP_ID, (Object)-1);
        this.initialize();
    }

    public RfpDataRecord(int n) {
        this.setField(IDX_RFP_ID, (Object)n);
        this.initialize();
    }

    public RfpDataRecord(boolean bl) {
        if (!bl) {
            this.setField(IDX_RFP_ID, (Object)-1);
            this.initialize();
        }
    }

    private void initialize() {
        this.initField(IDX_DECT_ON, false);
        this.initField(IDX_DECT_RUNNING, false);
        this.initField(IDX_PAGING_AREA, -1);
        this.initField(IDX_CLUSTER, 1);
        this.initField(IDX_SITE, 1);
        this.initField(IDX_NAME, "");
        this.initField(IDX_HWTYPE_LOCKED, false);
        this.initField(IDX_ETH_ADDR, "00:00:00:00:00:00");
        this.initField(IDX_WLAN_ON, false);
        this.initField(IDX_LICENSE_RFP, false);
        this.initField(IDX_HIERARCHY1, "");
        this.initField(IDX_HIERARCHY2, "");
        this.initField(IDX_HIERARCHY3, "");
        this.initField(IDX_HIERARCHY4, "");
        this.initField(IDX_RPN, 65535);
        this.initField(IDX_PREFERRED_SYNC, false);
        this.initField(IDX_REFLECTIVE_ENV, false);
        this.initField(IDX_CONFERENCE_CHANNELS, false);
        this.initField(IDX_XPOS, 0);
        this.initField(IDX_YPOS, 0);
        this.initField(IDX_WLAN_PROFILE, 1);
        this.initField(IDX_WLAN_ANTENNA_DIV, false);
        this.initField(IDX_WLAN_ANTENNA, 1);
        this.initField(IDX_WLAN_HIGH_THROUGHPUT, false);
        this.initField(IDX_WLAN_CHANNEL, 0);
        this.initField(IDX_WLAN_POWER, 100);
        this.initField(IDX_CONNECTED, false);
        this.initField(IDX_IP_ADDR, "0.0.0.0");
        this.initField(IDX_WLAN_RUNNING, false);
        this.initField(IDX_OMM_RUNNING, false);
        this.initField(IDX_OMM_STB_RUNNING, false);
        this.initField(IDX_HWTYPE, (Object)OmiMessage.RFPHwTypeType.UNKNOWN);
        this.initField(IDX_HAS_WLAN, false);
        this.initField(IDX_SYNC_STATE, (Object)OmiMessage.RFPSyncStateType.Inactive);
        this.initField(IDX_SW_VERSION, "");
        this.initField(IDX_NEW_SW_REQUEST, false);
        this.initField(IDX_BRANDING_MISMATCH, false);
        this.initField(IDX_VERSION_MISMATCH, false);
        this.initField(IDX_STANDBY_OMM_MISMATCH, false);
        this.initField(IDX_WLAN_LINK_NOK, false);
        this.initField(IDX_RADIO_TYPE, (Object)OmiMessage.RFPRadioTypeType.None);
        this.initField(IDX_OUTDOOR_TYPE, false);
        this.initField(IDX_HAS_FREQ_SHIFT, false);
        this.initField(IDX_HAS_ENCRYPTION, false);
        this.initField(IDX_HAS_ADVANCED_FEAT, false);
        this.initField(IDX_NSYNC_RELS, 0);
        this.initField(IDX_WLAN_CHANNEL_USED, 0);
        this.initField(IDX_WLAN_HIGH_THROUGHPUT_TYPE_USED, (Object)OmiMessage.RFPWlanHTUsedType.None);
        this.initField(IDX_WLAN_POWER_USED, 0);
        this.setField(IDX_GUI_ATTRIB1, (Object)RfpActiveTypeEnum.RFP_DECT_NOT_ACTIVATED);
        this.setField(IDX_POSITIONED, (Object)false);
        this.setField(IDX_ENCRYPTION_STATE, (Object)OmiMessage.RfpCapabilityStateType.NotSupportedInactive);
        this.setField(IDX_ADVANCED_FEATURES_STATE, (Object)OmiMessage.RfpCapabilityStateType.NotSupportedInactive);
    }

    @Override
    public String[] getFieldNameArray() {
        return fieldNames;
    }

    @Override
    public Object getField(int n) {
        if (n >= 0 && n < numberOfFields) {
            if (this.members[n] != null) {
                return this.members[n].getValue();
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "RFP:getField: idx=" + n + " out of range");
        }
        return null;
    }

    @Override
    public boolean getFieldChanged(int n) {
        if (n >= 0 && n < numberOfFields) {
            if (this.members[n] != null) {
                return this.members[n].getChanged();
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "RFP:getFieldChanged: idx=" + n + " out of range");
        }
        return false;
    }

    public boolean getRecordChanged() {
        for (int i = 0; i < numberOfFields; ++i) {
            if (this.members[i] == null || !this.members[i].getChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setField(int n, Object object) {
        if (object != null) {
            if (n >= 0 && n < numberOfFields) {
                if (this.members[n] == null) {
                    if (n < numberOfRFPTypeAttribs) {
                        OmiMessage.RFPType rFPType = OmiMessage.RFPType.values()[n];
                        this.members[n] = new DataRecord.DataElem(this, rFPType.type);
                    } else {
                        this.members[n] = new DataRecord.DataElem(this, object.getClass());
                    }
                }
                this.members[n].changeValue(object);
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "RFP:setField: idx=" + n + " out of range");
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "RFP:setField: idx=" + n + " value==null");
        }
    }

    public void setField(String string, Object object) {
        try {
            OmiMessage.RFPType rFPType = OmiMessage.RFPType.valueOf(string);
            this.setField(rFPType.ordinal(), object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "RFP:setField: Wrong attrib name " + string);
        }
    }

    public void commitChanges() {
        for (int i = 0; i < numberOfFields; ++i) {
            if (this.members[i] == null) continue;
            this.members[i].commitChange();
        }
    }

    public void commitChangeOfField(int n) {
        if (n < numberOfFields) {
            this.members[n].commitChange();
        }
    }

    public void initField(int n, Object object) {
        if (object != null) {
            if (n >= 0 && n < numberOfRFPTypeAttribs) {
                this.setField(n, object);
                OmiMessage.RFPType rFPType = OmiMessage.RFPType.values()[n];
                if (rFPType.cl == OmiMessage.DataClass.ClassReadOnly) {
                    this.members[n].commitChange();
                }
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "RFP:initField: idx=" + n + " out of range");
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, "RFP:initField: idx=" + n + " value==null");
        }
    }

    public int addChangedAttribsToMsg(OmiMessage omiMessage) {
        int n = 0;
        EnumSet<OmiMessage.RFPType> enumSet = EnumSet.allOf(OmiMessage.RFPType.class);
        for (OmiMessage.RFPType rFPType : enumSet) {
            Object object;
            int n2 = rFPType.ordinal();
            if (this.members[n2] == null) continue;
            if (n2 == IDX_RFP_ID) {
                if ((Integer)this.members[IDX_RFP_ID].getValue() == -1) continue;
                omiMessage.addAttrib(rFPType.name(), this.members[n2].getString());
                continue;
            }
            if (n2 == IDX_HWTYPE) {
                if (!this.members[n2].getChanged()) continue;
                object = OmiMessage.RFPHwTypeType.valueOf(this.members[n2].getString());
                omiMessage.addAttrib(rFPType.name(), ((OmiMessage.RFPHwTypeType)((Object)object)).strRealHw);
                ++n;
                continue;
            }
            object = OmiMessage.RFPHwTypeType.valueOf((String)this.members[RfpDataRecord.IDX_HWTYPE].getString()).strPreselect;
            if (n2 == IDX_WLAN_ON || n2 == IDX_WLAN_PROFILE || n2 == IDX_WLAN_CHANNEL || n2 == IDX_WLAN_POWER) {
                if (!((String)object).equals(OmiMessage.RFPHwTypeType.RFP42.strPreselect) && !((String)object).equals(OmiMessage.RFPHwTypeType.RFP43.strPreselect) || !this.members[n2].getChanged()) continue;
                omiMessage.addAttrib(rFPType.name(), this.members[n2].getString());
                ++n;
                continue;
            }
            if (n2 == IDX_WLAN_ANTENNA_DIV || n2 == IDX_WLAN_ANTENNA) {
                if (!((String)object).equals(OmiMessage.RFPHwTypeType.RFP42.strPreselect) || !this.members[n2].getChanged()) continue;
                omiMessage.addAttrib(rFPType.name(), this.members[n2].getString());
                ++n;
                continue;
            }
            if (n2 == IDX_WLAN_HIGH_THROUGHPUT) {
                if (!((String)object).equals(OmiMessage.RFPHwTypeType.RFP43.strPreselect) || !this.members[n2].getChanged()) continue;
                omiMessage.addAttrib(rFPType.name(), this.members[n2].getString());
                ++n;
                continue;
            }
            if (!this.members[n2].getChanged()) continue;
            omiMessage.addAttrib(rFPType.name(), this.members[n2].getString());
            ++n;
        }
        return n;
    }

    @Override
    public DataRecord clone() {
        RfpDataRecord rfpDataRecord = new RfpDataRecord(true);
        for (int i = 0; i < this.members.length; ++i) {
            if (this.members[i] == null) continue;
            rfpDataRecord.members[i] = this.members[i].clone();
        }
        rfpDataRecord.locatingXPos = this.locatingXPos;
        rfpDataRecord.locatingYPos = this.locatingYPos;
        rfpDataRecord.locatingImageId = this.locatingImageId;
        return rfpDataRecord;
    }

    public static String[] getFieldNames() {
        return fieldNames;
    }

    private static String[] initFieldNames() {
        int n;
        String[] stringArray = new String[]{"gui attrib1", "gui attrib2", "err msg", "site name", "hw text", "positioned", "encryption state", "adv. feat. state"};
        fieldNames = new String[numberOfFields];
        for (n = 0; n < OmiMessage.RFPType.values().length; ++n) {
            RfpDataRecord.fieldNames[n] = OmiMessage.RFPType.values()[n].getText();
        }
        n = OmiMessage.RFPType.values().length;
        int n2 = 0;
        while (n < numberOfFields) {
            RfpDataRecord.fieldNames[n] = stringArray[n2];
            ++n;
            ++n2;
        }
        return fieldNames;
    }

    public static void setTableHeaderText(int n, String string) {
        if (n >= 0 && n < numberOfFields) {
            RfpDataRecord.fieldNames[n] = string;
        }
    }

    static {
        IDX_GUI_ATTRIB1 = numberOfRFPTypeAttribs = OmiMessage.RFPType.values().length;
        IDX_GUI_ATTRIB2 = numberOfRFPTypeAttribs + 1;
        IDX_ERROR_MSG = numberOfRFPTypeAttribs + 2;
        IDX_SITE_TEXT = numberOfRFPTypeAttribs + 3;
        IDX_HWTYPE_TEXT = numberOfRFPTypeAttribs + 4;
        IDX_POSITIONED = numberOfRFPTypeAttribs + 5;
        IDX_ENCRYPTION_STATE = numberOfRFPTypeAttribs + 6;
        IDX_ADVANCED_FEATURES_STATE = numberOfRFPTypeAttribs + 7;
        numberOfFields = numberOfRFPTypeAttribs + 8;
        fieldNames = RfpDataRecord.initFieldNames();
    }

    public static class SyncRelType {
        public int id;
        public int rssi;
        public int offset;

        public SyncRelType(int n, int n2, int n3) {
            this.id = n;
            this.rssi = n2;
            this.offset = n3;
        }
    }

    public static enum RfpActiveTypeEnum {
        RFP_DECT_NOT_ACTIVATED,
        RFP_DECT_INACTIVE,
        RFP_NOT_SYNCED,
        RFP_SEARCHING,
        RFP_SYNCED;

    }
}

