/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.SummaryHandler;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class RfpSummaryHandler
extends SummaryHandler {
    private LinkedList<RfpSummaryNotificationInterface> listenerList = new LinkedList();
    private RfpSummaryClass summary = null;

    public void registerRfpSummaryNotificationListener(RfpSummaryNotificationInterface rfpSummaryNotificationInterface) {
        this.listenerList.add(rfpSummaryNotificationInterface);
    }

    public void deregisterRfpSummaryNotificationListener(RfpSummaryNotificationInterface rfpSummaryNotificationInterface) {
        this.listenerList.remove(rfpSummaryNotificationInterface);
    }

    @Override
    protected void GenerateSummaryNotification() {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating Rfp summary notification: No listener");
        }
        RfpSummaryClass rfpSummaryClass = this.summary.clone();
        for (RfpSummaryNotificationInterface rfpSummaryNotificationInterface : this.listenerList) {
            if (rfpSummaryNotificationInterface == null) continue;
            rfpSummaryNotificationInterface.processRfpSummaryNotification(rfpSummaryClass);
        }
    }

    @Override
    protected void GenerateSummaryErrorNotification(OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating Rfp summary error notification: No listener");
        }
        for (RfpSummaryNotificationInterface rfpSummaryNotificationInterface : this.listenerList) {
            if (rfpSummaryNotificationInterface == null) continue;
            rfpSummaryNotificationInterface.processRfpSummaryErrorNotification(omiMessage);
        }
    }

    public RfpSummaryHandler(OmiManagement omiManagement) {
        super(omiManagement, OmiMessage.elemIds.GetRFPSummary, OmiMessage.elemIds.GetRFPSummaryResp, OmiMessage.elemIds.EventRFPSummary, OmiMessage.EventType.RFPSummary);
    }

    public RfpSummaryClass getRfpSummary() {
        if (this.summary == null) {
            this.summary = new RfpSummaryClass();
        }
        return this.summary.clone();
    }

    @Override
    protected void initSummary() {
        if (this.summary == null) {
            this.summary = new RfpSummaryClass();
        } else {
            this.summary.clear();
        }
        this.GenerateSummaryNotification();
    }

    @Override
    protected boolean processSummary(OmiMessage omiMessage) {
        int n;
        boolean bl = false;
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.nRFPs.name()) != null && this.summary.nRFPs != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.nRFPs.name()))) {
            this.summary.nRFPs = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.idFirst.name()) != null && this.summary.idFirst != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.idFirst.name()))) {
            this.summary.idFirst = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.nConnected.name()) != null && this.summary.nConnected != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.nConnected.name()))) {
            this.summary.nConnected = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.wrongBrandedRFPs.name()) != null && this.summary.nWrongBranded != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.wrongBrandedRFPs.name()))) {
            this.summary.nWrongBranded = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.wrongStandbyRFPs.name()) != null && this.summary.nWrongStandby != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.wrongStandbyRFPs.name()))) {
            this.summary.nWrongStandby = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.wrongVersionedRFPs.name()) != null && this.summary.nWrongSWVersion != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.wrongVersionedRFPs.name()))) {
            this.summary.nWrongSWVersion = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.newAvailSWRFPs.name()) != null && this.summary.nNewSWAvailable != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.newAvailSWRFPs.name()))) {
            this.summary.nNewSWAvailable = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.advancedFeaturesErrorRFPs.name()) != null && this.summary.nAdvancedFeatError != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.advancedFeaturesErrorRFPs.name()))) {
            this.summary.nAdvancedFeatError = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.DecryptedDECTRFPs.name()) != null && this.summary.nNoEncryption != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.DecryptedDECTRFPs.name()))) {
            this.summary.nNoEncryption = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.DECTactivatedRFPs.name()) != null && this.summary.nDECTActivated != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.DECTactivatedRFPs.name()))) {
            this.summary.nDECTActivated = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.DECTactiveRFPs.name()) != null && this.summary.nDECTRunning != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.DECTactiveRFPs.name()))) {
            this.summary.nDECTRunning = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.WLANactivatedRFPs.name()) != null && this.summary.nWLANActivated != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.WLANactivatedRFPs.name()))) {
            this.summary.nWLANActivated = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.WLANrunningRFPs.name()) != null && this.summary.nWLANRunning != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.WLANrunningRFPs.name()))) {
            this.summary.nWLANRunning = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.usedDECTclusters.name()) != null && this.summary.nUsedDECTClusters != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.usedDECTclusters.name()))) {
            this.summary.nUsedDECTClusters = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.usedPagingAreas.name()) != null && this.summary.nUsedPagingAreas != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.usedPagingAreas.name()))) {
            this.summary.nUsedPagingAreas = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.usedWLANprofiles.name()) != null && this.summary.nUsedWLANProfiles != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.usedWLANprofiles.name()))) {
            this.summary.nUsedWLANProfiles = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.RFPSummaryType.usbOverloads.name()) != null && this.summary.nUsbOverloads != (n = omiMessage.getAttribValInt(OmiMessage.RFPSummaryType.usbOverloads.name()))) {
            this.summary.nUsbOverloads = n;
            bl = true;
        }
        return bl;
    }

    public static interface RfpSummaryNotificationInterface {
        public void processRfpSummaryNotification(RfpSummaryClass var1);

        public void processRfpSummaryErrorNotification(OmiMessage var1);
    }

    public static class RfpSummaryClass {
        public int nRFPs = 0;
        public int idFirst = 0;
        public int nConnected = 0;
        public int nWrongBranded = 0;
        public int nWrongStandby = 0;
        public int nWrongSWVersion = 0;
        public int nNewSWAvailable = 0;
        public int nAdvancedFeatError = 0;
        public int nNoEncryption = 0;
        public int nDECTActivated = 0;
        public int nDECTRunning = 0;
        public int nWLANActivated = 0;
        public int nWLANRunning = 0;
        public int nUsedDECTClusters = 0;
        public int nUsedPagingAreas = 0;
        public int nUsedWLANProfiles = 0;
        public int nUsbOverloads = 0;

        public void clear() {
            this.nRFPs = 0;
            this.idFirst = 0;
            this.nConnected = 0;
            this.nWrongBranded = 0;
            this.nWrongStandby = 0;
            this.nWrongSWVersion = 0;
            this.nNewSWAvailable = 0;
            this.nAdvancedFeatError = 0;
            this.nNoEncryption = 0;
            this.nDECTActivated = 0;
            this.nDECTRunning = 0;
            this.nWLANActivated = 0;
            this.nWLANRunning = 0;
            this.nUsedDECTClusters = 0;
            this.nUsedPagingAreas = 0;
            this.nUsedWLANProfiles = 0;
            this.nUsbOverloads = 0;
        }

        public RfpSummaryClass clone() {
            RfpSummaryClass rfpSummaryClass = new RfpSummaryClass();
            rfpSummaryClass.nRFPs = this.nRFPs;
            rfpSummaryClass.idFirst = this.idFirst;
            rfpSummaryClass.nConnected = this.nConnected;
            rfpSummaryClass.nWrongBranded = this.nWrongBranded;
            rfpSummaryClass.nWrongStandby = this.nWrongStandby;
            rfpSummaryClass.nWrongSWVersion = this.nWrongSWVersion;
            rfpSummaryClass.nNewSWAvailable = this.nNewSWAvailable;
            rfpSummaryClass.nAdvancedFeatError = this.nAdvancedFeatError;
            rfpSummaryClass.nNoEncryption = this.nNoEncryption;
            rfpSummaryClass.nDECTActivated = this.nDECTActivated;
            rfpSummaryClass.nDECTRunning = this.nDECTRunning;
            rfpSummaryClass.nWLANActivated = this.nWLANActivated;
            rfpSummaryClass.nWLANRunning = this.nWLANRunning;
            rfpSummaryClass.nUsedDECTClusters = this.nUsedDECTClusters;
            rfpSummaryClass.nUsedPagingAreas = this.nUsedPagingAreas;
            rfpSummaryClass.nUsedWLANProfiles = this.nUsedWLANProfiles;
            rfpSummaryClass.nUsbOverloads = this.nUsbOverloads;
            return rfpSummaryClass;
        }
    }
}

