/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class SiteDataHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    private static final int MAX_BULK_RECORDS = 20;
    public static final int INVALID_SITE_ID = 0;
    private SiteDatabase siteDb = new SiteDatabase();
    private OmiManagement om = null;
    private OmiHandler omiHandler = null;
    private boolean getBulkInProgress = false;
    private RfpDataHandler rfpDataHandler = null;
    private LinkedList<SiteDataNotificationInterface> listenerList = new LinkedList();

    public SiteDataHandler() {
    }

    public SiteDataHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        this.om = omiManagement;
        this.om.registerManagementEventListener(this);
        OmiMessage.elemIds.GetSiteResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreateSiteResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetSiteResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventSiteCnf.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteSiteResp.registerDataNotificationListener(this);
    }

    public void registerDataNotificationListener(SiteDataNotificationInterface siteDataNotificationInterface) {
        this.listenerList.add(siteDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(SiteDataNotificationInterface siteDataNotificationInterface) {
        this.listenerList.remove(siteDataNotificationInterface);
    }

    private void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating site notification: No listener");
        }
        for (SiteDataNotificationInterface siteDataNotificationInterface : this.listenerList) {
            if (siteDataNotificationInterface == null) continue;
            siteDataNotificationInterface.processSiteDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating site error notification: No listener");
        }
        for (SiteDataNotificationInterface siteDataNotificationInterface : this.listenerList) {
            if (siteDataNotificationInterface == null) continue;
            siteDataNotificationInterface.processSiteDataErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public Database getDb() {
        return this.siteDb;
    }

    public Site getSiteBySiteId(int n) {
        return this.siteDb.getRecordById(n);
    }

    public Site getSiteByTableIdx(int n) {
        return (Site)this.siteDb.getRecordByIdx(n);
    }

    public void sendGetSite(int n) {
        this.sendGetSiteBulk(n, 1);
    }

    public void sendGetSiteBulk(int n, int n2) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetSite);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), n2);
        this.omiHandler.sendOmiMessage(omiMessage);
        if (n2 > 1) {
            this.getBulkInProgress = true;
        }
    }

    public void sendCreateSite(Site site) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreateSite);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.site);
        omiMessage2.addAttrib(OmiMessage.SiteType.id.name(), site.id);
        if (site.name != null) {
            omiMessage2.addAttrib(OmiMessage.SiteType.name.name(), site.name);
        }
        omiMessage2.addAttrib(OmiMessage.SiteType.wideband.name(), site.wideband);
        if (this.om.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSRTP)) {
            omiMessage2.addAttrib(OmiMessage.SiteType.srtp.name(), site.srtp.name());
        }
        omiMessage2.addAttrib(OmiMessage.SiteType.dectSecurity.name(), site.dectSecurity);
        if (this.om.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
            omiMessage2.addAttrib(OmiMessage.SiteType.videoStreaming.name(), site.videoStreaming);
        }
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendSetSite(Site site) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetSite);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), site.id);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.site);
        omiMessage2.addAttrib(OmiMessage.SiteType.id.name(), site.id);
        omiMessage2.addAttrib(OmiMessage.SiteType.name.name(), site.name);
        omiMessage2.addAttrib(OmiMessage.SiteType.wideband.name(), site.wideband);
        if (this.om.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSRTP)) {
            omiMessage2.addAttrib(OmiMessage.SiteType.srtp.name(), site.srtp.name());
        }
        omiMessage2.addAttrib(OmiMessage.SiteType.dectSecurity.name(), site.dectSecurity);
        if (this.om.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo)) {
            omiMessage2.addAttrib(OmiMessage.SiteType.videoStreaming.name(), site.videoStreaming);
        }
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendDeleteSite(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteSite);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        omiMessage.addAttrib(OmiMessage.SiteType.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    private int processGetSiteResp(OmiMessage omiMessage) {
        Site site;
        int n = 0;
        for (OmiMessage omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
            if (!this.processSiteElem(omiMessage2, DataNotificationEnum.NEW_DATA)) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetSiteResp no Site elem");
                continue;
            }
            ++n;
        }
        if (n == 20 && (site = (Site)this.siteDb.getRecordByIdx(this.siteDb.getRecordNumber() - 1)) != null) {
            return (Integer)site.getField(0);
        }
        return 0;
    }

    private boolean processSiteElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum) {
        if (omiMessage.id == OmiMessage.elemIds.site) {
            Object object;
            Object object2;
            Boolean bl;
            Integer n;
            int n2 = omiMessage.getAttribValInt(OmiMessage.SiteType.id.name());
            Site site = this.siteDb.getRecordById(n2);
            boolean bl2 = false;
            if (site == null) {
                site = new Site(n2);
                if (dataNotificationEnum == DataNotificationEnum.DATA_CHANGED) {
                    dataNotificationEnum = DataNotificationEnum.NEW_DATA;
                }
            }
            String string = omiMessage.getAttribVal(OmiMessage.SiteType.name.name());
            if (site.name != null) {
                if (string != null && !string.equals(site.name)) {
                    bl2 = true;
                    site.name = string;
                }
            } else if (string != null) {
                site.name = string;
            }
            if (bl2 && this.rfpDataHandler != null) {
                this.rfpDataHandler.changeSiteName(site.id, site.name);
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.SiteType.nRFPs.name())) != null && site.nRFPs != n) {
                site.nRFPs = n;
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.SiteType.wideband.name())) != null && site.wideband != bl) {
                site.wideband = bl;
                if (this.rfpDataHandler != null) {
                    this.rfpDataHandler.updateSiteAdvancedFeaturesState(site);
                }
            }
            if (this.om.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveSRTP) && (object2 = omiMessage.getAttribVal(OmiMessage.SiteType.srtp.name())) != null) {
                try {
                    object = OmiMessage.SrtpStateType.valueOf((String)object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    object = OmiMessage.SrtpStateType.Disabled;
                }
                if (site.srtp != object) {
                    site.srtp = object;
                }
            }
            if ((object2 = omiMessage.getAttribValBoolNotMandatory(OmiMessage.SiteType.dectSecurity.name())) != null && site.dectSecurity != (Boolean)object2) {
                site.dectSecurity = (Boolean)object2;
            }
            if (this.om.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveVideo) && (object = omiMessage.getAttribValBoolNotMandatory(OmiMessage.SiteType.videoStreaming.name())) != null && site.videoStreaming != (Boolean)object) {
                site.videoStreaming = (Boolean)object;
            }
            this.siteDb.addSite(site);
            if (dataNotificationEnum == DataNotificationEnum.DATA_CHANGED) {
                dataNotificationEnum = bl2 ? DataNotificationEnum.DATA_SITE_CHANGED_NAME : DataNotificationEnum.DATA_SITE_CHANGED_OTHER;
            }
            this.GenerateDataNotification(n2, dataNotificationEnum);
            return true;
        }
        return false;
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY) {
            this.siteDb.clearAll();
            this.GenerateDataNotification(0, DataNotificationEnum.DATA_DELETED_ALL);
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.SiteCnf, null, null);
            this.sendGetSiteBulk(0, 20);
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        String string = null;
        switch (omiMessage.id) {
            case GetSiteResp: {
                int n = this.processGetSiteResp(omiMessage);
                if (!this.getBulkInProgress) break;
                if (n > 0) {
                    this.sendGetSiteBulk(n + 1, 20);
                    break;
                }
                this.getBulkInProgress = false;
                this.GenerateDataNotification(this.siteDb.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
                if (this.rfpDataHandler == null) break;
                this.rfpDataHandler.allSitesReceived();
                break;
            }
            case CreateSiteResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                OmiMessage omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null && this.processSiteElem(omiMessage2, DataNotificationEnum.NEW_DATA)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "CreateSiteResp no Site elem");
                break;
            }
            case DeleteSiteResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string == null) break;
                int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                this.GenerateErrorNotification(n, DataNotificationEnum.DATA_DELETED, omiMessage);
                break;
            }
            case SetSiteResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                OmiMessage omiMessage3 = omiMessage.getSubElement();
                if (omiMessage3 != null && this.processSiteElem(omiMessage3, DataNotificationEnum.DATA_CHANGED)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetSiteResp no site elem");
                break;
            }
            case EventSiteCnf: {
                OmiMessage omiMessage4 = omiMessage.getSubElement();
                if (omiMessage4 != null) {
                    boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                    if (bl) {
                        if (omiMessage4.id == OmiMessage.elemIds.site) {
                            int n = omiMessage4.getAttribValInt(OmiMessage.SiteType.id.name());
                            this.siteDb.deleteSite(n);
                            this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                            break;
                        }
                    } else if (this.processSiteElem(omiMessage4, DataNotificationEnum.DATA_CHANGED)) break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventSiteCnf no site elem");
                break;
            }
        }
    }

    public int getNumberOfSites() {
        return this.siteDb.getRecordNumber();
    }

    protected void setRfpDataHandler(RfpDataHandler rfpDataHandler) {
        this.rfpDataHandler = rfpDataHandler;
    }

    protected boolean getAdvancedFeaturesActive(int n) {
        Site site = this.getSiteBySiteId(n);
        return site.wideband || site.dectSecurity || site.videoStreaming || site.srtp != OmiMessage.SrtpStateType.Disabled;
    }

    public static interface SiteDataNotificationInterface {
        public void processSiteDataNotification(int var1, DataNotificationEnum var2);

        public void processSiteDataErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }

    public static class SiteDatabase
    extends Database {
        public static final int MAX_SITES = 250;
        Site[] sites = new Site[250];
        int[] siteIdx = new int[250];
        int noOfSites = 0;

        @Override
        public DataRecord getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfSites) {
                return this.sites[this.siteIdx[n] - 1];
            }
            return null;
        }

        public Site getRecordById(int n) {
            if (n > 0 && n <= 250) {
                return this.sites[n - 1];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfSites;
        }

        @Override
        public void updateIndex() {
            this.noOfSites = 0;
            for (int i = 1; i <= 250; ++i) {
                if (this.sites[i - 1] == null) continue;
                this.siteIdx[this.noOfSites++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public void addSite(Site site) {
            if (site.id > 0 && site.id <= 250) {
                this.sites[site.id - 1] = site;
                this.updateIndex();
            }
        }

        public void deleteSite(int n) {
            if (n > 0 && n <= 250) {
                this.sites[n - 1] = null;
                this.updateIndex();
            }
        }

        public void clearAll() {
            for (int i = 0; i < 250; ++i) {
                this.sites[i] = null;
            }
            this.noOfSites = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        @Override
        public String[] getFieldNames() {
            return Site.getFieldNames();
        }
    }

    public static class Site
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_NAME = 1;
        public static final int IDX_NRFP = 2;
        public static final int IDX_WIDEBAND = 3;
        public static final int IDX_SRTP = 4;
        public static final int IDX_DECT_SECURITY = 5;
        public static final int IDX_VIDEO_STREAMING = 6;
        public static final int NUMBER_OF_FIELDS = 7;
        private static String[] fieldNames = new String[]{"id", "name", "number of RFP", "wideband", "srtp", "dect security", "video streaming"};
        public int id = 0;
        public String name = null;
        public int nRFPs = 0;
        public boolean wideband = false;
        public OmiMessage.SrtpStateType srtp = OmiMessage.SrtpStateType.Disabled;
        public boolean dectSecurity = false;
        public boolean videoStreaming = false;

        public Site() {
        }

        public Site(int n) {
            this.id = n;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 7) {
                Site.fieldNames[n] = string;
            }
        }

        public static String[] getFieldNames() {
            return fieldNames;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.name;
                }
                case 2: {
                    return this.nRFPs;
                }
                case 3: {
                    return this.wideband;
                }
                case 4: {
                    return this.srtp;
                }
                case 5: {
                    return this.dectSecurity;
                }
                case 6: {
                    return this.videoStreaming;
                }
            }
            return null;
        }

        @Override
        public DataRecord clone() {
            Site site = new Site();
            site.id = this.id;
            site.name = this.name;
            site.nRFPs = this.nRFPs;
            site.wideband = this.wideband;
            site.srtp = this.srtp;
            site.dectSecurity = this.dectSecurity;
            site.videoStreaming = this.videoStreaming;
            return site;
        }

        public String toString() {
            return this.name;
        }
    }
}

