/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.SummaryHandler;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class SiteSummaryHandler
extends SummaryHandler {
    private SiteSummaryClass summary = null;
    private LinkedList<SiteSummaryNotificationInterface> listenerList = new LinkedList();

    public void registerSiteSummaryNotificationListener(SiteSummaryNotificationInterface siteSummaryNotificationInterface) {
        this.listenerList.add(siteSummaryNotificationInterface);
    }

    public void deregisterSiteSummaryNotificationListener(SiteSummaryNotificationInterface siteSummaryNotificationInterface) {
        this.listenerList.remove(siteSummaryNotificationInterface);
    }

    @Override
    protected void GenerateSummaryNotification() {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating site summary notification: No listener");
        }
        SiteSummaryClass siteSummaryClass = this.summary.clone();
        for (SiteSummaryNotificationInterface siteSummaryNotificationInterface : this.listenerList) {
            if (siteSummaryNotificationInterface == null) continue;
            siteSummaryNotificationInterface.processSiteSummaryNotification(siteSummaryClass);
        }
    }

    @Override
    protected void GenerateSummaryErrorNotification(OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating site summary error notification: No listener");
        }
        for (SiteSummaryNotificationInterface siteSummaryNotificationInterface : this.listenerList) {
            if (siteSummaryNotificationInterface == null) continue;
            siteSummaryNotificationInterface.processSiteSummaryErrorNotification(omiMessage);
        }
    }

    public SiteSummaryHandler(OmiManagement omiManagement) {
        super(omiManagement, OmiMessage.elemIds.GetSiteSummary, OmiMessage.elemIds.GetSiteSummaryResp, OmiMessage.elemIds.EventSiteSummary, OmiMessage.EventType.SiteSummary);
    }

    public SiteSummaryClass getSummary() {
        if (this.summary == null) {
            this.summary = new SiteSummaryClass();
        }
        return this.summary.clone();
    }

    @Override
    protected void initSummary() {
        if (this.summary == null) {
            this.summary = new SiteSummaryClass();
        } else {
            this.summary.clear();
        }
        this.GenerateSummaryNotification();
    }

    @Override
    protected boolean processSummary(OmiMessage omiMessage) {
        int n;
        boolean bl = false;
        if (omiMessage.getAttribVal(OmiMessage.SiteSummaryType.nRecords.name()) != null && this.summary.nRecords != (n = omiMessage.getAttribValInt(OmiMessage.SiteSummaryType.nRecords.name()))) {
            this.summary.nRecords = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.SiteSummaryType.idFirst.name()) != null && this.summary.idFirst != (n = omiMessage.getAttribValInt(OmiMessage.SiteSummaryType.idFirst.name()))) {
            this.summary.idFirst = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.SiteSummaryType.rfpSiteNum.name()) != null && this.summary.rfpSiteNum != (n = omiMessage.getAttribValInt(OmiMessage.SiteSummaryType.rfpSiteNum.name()))) {
            this.summary.rfpSiteNum = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.SiteSummaryType.g722SiteNum.name()) != null && this.summary.g722SiteNum != (n = omiMessage.getAttribValInt(OmiMessage.SiteSummaryType.g722SiteNum.name()))) {
            this.summary.g722SiteNum = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.SiteSummaryType.dectSecuritySiteNum.name()) != null && this.summary.dectSecuritySiteNum != (n = omiMessage.getAttribValInt(OmiMessage.SiteSummaryType.dectSecuritySiteNum.name()))) {
            this.summary.dectSecuritySiteNum = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.SiteSummaryType.videoStreamingSiteNum.name()) != null && this.summary.videoStreamingSiteNum != (n = omiMessage.getAttribValInt(OmiMessage.SiteSummaryType.videoStreamingSiteNum.name()))) {
            this.summary.videoStreamingSiteNum = n;
            bl = true;
        }
        if (omiMessage.getAttribVal(OmiMessage.SiteSummaryType.srtpSiteNum.name()) != null && this.summary.srtpSiteNum != (n = omiMessage.getAttribValInt(OmiMessage.SiteSummaryType.srtpSiteNum.name()))) {
            this.summary.srtpSiteNum = n;
            bl = true;
        }
        return bl;
    }

    public static interface SiteSummaryNotificationInterface {
        public void processSiteSummaryNotification(SiteSummaryClass var1);

        public void processSiteSummaryErrorNotification(OmiMessage var1);
    }

    public static class SiteSummaryClass {
        public int nRecords = 0;
        public int idFirst = 0;
        public int rfpSiteNum = 0;
        public int g722SiteNum = 0;
        public int dectSecuritySiteNum = 0;
        public int videoStreamingSiteNum = 0;
        public int srtpSiteNum = 0;

        public void clear() {
            this.nRecords = 0;
            this.idFirst = 0;
            this.rfpSiteNum = 0;
            this.g722SiteNum = 0;
            this.dectSecuritySiteNum = 0;
            this.videoStreamingSiteNum = 0;
            this.srtpSiteNum = 0;
        }

        public SiteSummaryClass clone() {
            SiteSummaryClass siteSummaryClass = new SiteSummaryClass();
            siteSummaryClass.nRecords = this.nRecords;
            siteSummaryClass.idFirst = this.idFirst;
            siteSummaryClass.rfpSiteNum = this.rfpSiteNum;
            siteSummaryClass.g722SiteNum = this.g722SiteNum;
            siteSummaryClass.dectSecuritySiteNum = this.dectSecuritySiteNum;
            siteSummaryClass.videoStreamingSiteNum = this.videoStreamingSiteNum;
            siteSummaryClass.srtpSiteNum = this.srtpSiteNum;
            return siteSummaryClass;
        }
    }
}

