/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class VideoDevHandler
extends DataHandler
implements OmiMessageInterface,
OmiManagementEventInterface {
    public static final int VIDEO_DEV_INVALID_ID = -1;
    public static final int MAX_VIDEO_DEV_PER_RFP = 3;
    public static final int MAX_VIDEO_DEV = 12288;
    public static final int MAX_PPN_COUNT_PER_VIDEO_DEVICE = 10;
    private static final int MAX_DEVICE_PER_REQ = 20;
    private OmiHandler omiHandler = null;
    private VideoDevDatabase database = null;
    private boolean bulkRequestInProgress = false;
    private boolean startFlag = false;
    private boolean autoMode = false;
    private VideoDevRec[] changeDeleteDevs = null;
    private final LinkedList<VideoDevNotificationInterface> listenerList = new LinkedList();

    public VideoDevHandler(OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        omiManagement.registerManagementEventListener(this);
        this.initialize();
    }

    public VideoDevHandler(OmiManagement omiManagement, boolean bl) {
        this.omiHandler = omiManagement.getOmiHandler();
        omiManagement.registerManagementEventListener(this);
        this.autoMode = bl;
        this.initialize();
    }

    private void initialize() {
        this.database = new VideoDevDatabase();
        OmiMessage.elemIds.GetVideoDevResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.CreateVideoDevResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetVideoDevResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteVideoDevResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventVideoDevCnf.registerDataNotificationListener(this);
    }

    public void start() {
        if (!this.startFlag) {
            this.database.clearAll();
            OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.VideoDev, null, null);
            this.sendGetVideoDevBulk(0);
            this.bulkRequestInProgress = true;
            this.startFlag = true;
        }
    }

    public void stop() {
        this.bulkRequestInProgress = false;
        OmiMessage.sendResetEventSubscription(this.omiHandler, OmiMessage.EventType.VideoDev, null, null);
    }

    public void registerDataNotificationListener(VideoDevNotificationInterface videoDevNotificationInterface) {
        this.listenerList.add(videoDevNotificationInterface);
    }

    public void deregisterDataNotificationListener(VideoDevNotificationInterface videoDevNotificationInterface) {
        this.listenerList.remove(videoDevNotificationInterface);
    }

    private void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating video dev notification: No listener");
        }
        for (VideoDevNotificationInterface videoDevNotificationInterface : this.listenerList) {
            if (videoDevNotificationInterface == null) continue;
            videoDevNotificationInterface.processVideoDevDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating video dev error notification: No listener");
        }
        for (VideoDevNotificationInterface videoDevNotificationInterface : this.listenerList) {
            if (videoDevNotificationInterface == null) continue;
            videoDevNotificationInterface.processVideoDevErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public VideoDevDatabase getDb() {
        return this.database;
    }

    public VideoDevRec getVideoDevById(int n) {
        return this.database.getRecordById(n);
    }

    public VideoDevRec getVideoDevByTableIdx(int n) {
        return this.database.getRecordByIdx(n);
    }

    private void sendGetVideoDevBulk(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetVideoDev);
        omiMessage.addAttrib(OmiMessage.VideoDevType.id.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), 20);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendGetVideoDev(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetVideoDev);
        omiMessage.addAttrib(OmiMessage.VideoDevType.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendCreateVideoDev(VideoDevRec videoDevRec) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreateVideoDev);
        this.addVideoDevElem(omiMessage, videoDevRec);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public boolean sendSetVideoDev(VideoDevRec videoDevRec) {
        if (videoDevRec.getRecordChanged()) {
            OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetVideoDev);
            omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), videoDevRec.id);
            this.addVideoDevElem(omiMessage, videoDevRec);
            this.omiHandler.sendOmiMessage(omiMessage);
            return true;
        }
        return false;
    }

    public void sendDeleteVideoDev(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteVideoDev);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public boolean sendChangeDeleteDevs(DataHandler.SendBulkActionType sendBulkActionType, VideoDevRec[] videoDevRecArray, DataHandler.DataHandlerSendBulkInterface dataHandlerSendBulkInterface) {
        if (videoDevRecArray == null || videoDevRecArray.length == 0) {
            return false;
        }
        this.changeDeleteDevs = (VideoDevRec[])videoDevRecArray.clone();
        return this.startSendBulk(sendBulkActionType, this.changeDeleteDevs.length, dataHandlerSendBulkInterface);
    }

    public void cancelChangeDeleteDevs() {
        this.stopSendBulk();
    }

    @Override
    protected void sendNextChange(int n) {
        this.sendSetVideoDev(this.changeDeleteDevs[n]);
    }

    @Override
    protected void sendNextDelete(int n) {
        this.sendDeleteVideoDev(this.changeDeleteDevs[n].id);
    }

    private void addVideoDevElem(OmiMessage omiMessage, VideoDevRec videoDevRec) {
        if (videoDevRec == null) {
            return;
        }
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.videoDev);
        if (videoDevRec.id != -1) {
            omiMessage2.addAttrib(OmiMessage.VideoDevType.id.name(), videoDevRec.id);
        }
        if (videoDevRec.tag != null) {
            omiMessage2.addAttrib(OmiMessage.VideoDevType.tag.name(), videoDevRec.tag);
        }
        if (videoDevRec.rfpId != -1) {
            omiMessage2.addAttrib(OmiMessage.VideoDevType.rfpId.name(), videoDevRec.rfpId);
        }
        if (videoDevRec.usbPath != null) {
            omiMessage2.addAttrib(OmiMessage.VideoDevType.usbPath.name(), videoDevRec.usbPath);
        }
        if (videoDevRec.active != null) {
            omiMessage2.addAttrib(OmiMessage.VideoDevType.active.name(), videoDevRec.active);
        }
        if (videoDevRec.name != null) {
            omiMessage2.addAttrib(OmiMessage.VideoDevType.name.name(), videoDevRec.name);
        }
        if (videoDevRec.hierarchy1 != null) {
            omiMessage2.addAttrib(OmiMessage.VideoDevType.hierarchy1.name(), videoDevRec.hierarchy1);
        }
        if (videoDevRec.hierarchy2 != null) {
            omiMessage2.addAttrib(OmiMessage.VideoDevType.hierarchy2.name(), videoDevRec.hierarchy2);
        }
        if (videoDevRec.hierarchy3 != null) {
            omiMessage2.addAttrib(OmiMessage.VideoDevType.hierarchy3.name(), videoDevRec.hierarchy3);
        }
        if (videoDevRec.hierarchy4 != null) {
            omiMessage2.addAttrib(OmiMessage.VideoDevType.hierarchy4.name(), videoDevRec.hierarchy4);
        }
        if (videoDevRec.resolution != null) {
            omiMessage2.addAttrib(OmiMessage.VideoDevType.resolution.name(), videoDevRec.resolution.name());
        }
        if (videoDevRec.frameRate != null) {
            omiMessage2.addAttrib(OmiMessage.VideoDevType.frameRate.name(), videoDevRec.frameRate.getAxiVal());
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        int n = 0;
        OmiMessage omiMessage2 = null;
        int n2 = 0;
        switch (omiMessage.id) {
            case GetVideoDevResp: {
                for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                    VideoDevRec videoDevRec = this.convertVideoDevElem(omiMessage2);
                    if (videoDevRec != null) {
                        n = videoDevRec.id;
                        ++n2;
                        videoDevRec.commitChanges();
                        this.database.add(videoDevRec);
                        continue;
                    }
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetVideoDevResp sub element error");
                }
                if (n2 == 20) {
                    if (!this.bulkRequestInProgress) break;
                    this.sendGetVideoDevBulk(n + 1);
                    break;
                }
                if (!this.bulkRequestInProgress) break;
                this.bulkRequestInProgress = false;
                this.GenerateDataNotification(this.database.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
                break;
            }
            case CreateVideoDevResp: {
                String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null) {
                    VideoDevRec videoDevRec = this.convertVideoDevElem(omiMessage2);
                    if (videoDevRec != null) {
                        videoDevRec.commitChanges();
                        this.database.add(videoDevRec);
                        this.GenerateDataNotification(videoDevRec.id, DataNotificationEnum.NEW_DATA);
                        break;
                    }
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "CreateVideoDevResp sub element error");
                    break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "CreateVideoDevResp no sub element ");
                break;
            }
            case SetVideoDevResp: {
                this.checkSendBulk();
                String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null) {
                    VideoDevRec videoDevRec = this.convertVideoDevElem(omiMessage2);
                    if (videoDevRec != null) {
                        videoDevRec.commitChanges();
                        this.database.add(videoDevRec);
                        this.GenerateDataNotification(videoDevRec.id, DataNotificationEnum.DATA_CHANGED_RESP);
                        break;
                    }
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetVideoDevResp sub element error");
                    break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetVideoDevResp no sub element");
                break;
            }
            case DeleteVideoDevResp: {
                this.checkSendBulk();
                String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string == null) break;
                n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                this.GenerateErrorNotification(n, DataNotificationEnum.DATA_DELETED, omiMessage);
                break;
            }
            case EventVideoDevCnf: {
                boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null) {
                    if (bl) {
                        n = omiMessage2.getAttribValInt(OmiMessage.VideoDevType.id.name());
                        this.database.delete(n);
                        this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                        break;
                    }
                    VideoDevRec videoDevRec = this.convertVideoDevElem(omiMessage2);
                    if (videoDevRec != null) {
                        videoDevRec.commitChanges();
                        DataNotificationEnum dataNotificationEnum = this.database.getRecordById(videoDevRec.id) != null ? DataNotificationEnum.DATA_CHANGED_CNF : DataNotificationEnum.NEW_DATA;
                        this.database.add(videoDevRec);
                        this.GenerateDataNotification(videoDevRec.id, dataNotificationEnum);
                        break;
                    }
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventVideoDevCnf sub element error");
                    break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventVideoDevCnf no sub element");
                break;
            }
        }
    }

    private VideoDevRec convertVideoDevElem(OmiMessage omiMessage) {
        if (omiMessage.id == OmiMessage.elemIds.videoDev) {
            VideoDevRec videoDevRec = new VideoDevRec();
            Integer n = null;
            String string = null;
            Boolean bl = null;
            videoDevRec.setField(0, omiMessage.getAttribValInt(OmiMessage.VideoDevType.id.name()));
            videoDevRec.setField(1, omiMessage.getAttribVal(OmiMessage.VideoDevType.tag.name()));
            Integer n2 = omiMessage.getAttribValIntNotMandatory(OmiMessage.VideoDevType.rfpId.name());
            if (n2 != null) {
                videoDevRec.setField(2, n2);
            }
            videoDevRec.setField(3, omiMessage.getAttribVal(OmiMessage.VideoDevType.usbPath.name()));
            bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.VideoDevType.active.name());
            if (bl != null) {
                videoDevRec.setField(4, bl);
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.VideoDevType.state.name())) != null) {
                videoDevRec.setField(5, (Object)OmiMessage.VideoDevStateType.valueOf(string));
            }
            videoDevRec.setField(6, omiMessage.getAttribVal(OmiMessage.VideoDevType.name.name()));
            string = omiMessage.getAttribVal(OmiMessage.VideoDevType.siteId.name());
            if (string != null) {
                videoDevRec.setField(7, Integer.valueOf(string));
            }
            videoDevRec.setField(8, omiMessage.getAttribVal(OmiMessage.VideoDevType.siteName.name()));
            videoDevRec.setField(9, omiMessage.getAttribVal(OmiMessage.VideoDevType.hierarchy1.name()));
            videoDevRec.setField(10, omiMessage.getAttribVal(OmiMessage.VideoDevType.hierarchy2.name()));
            videoDevRec.setField(11, omiMessage.getAttribVal(OmiMessage.VideoDevType.hierarchy3.name()));
            videoDevRec.setField(12, omiMessage.getAttribVal(OmiMessage.VideoDevType.hierarchy4.name()));
            string = omiMessage.getAttribVal(OmiMessage.VideoDevType.resolution.name());
            if (string != null) {
                videoDevRec.setField(13, (Object)OmiMessage.VideoDevResolutionType.valueOf(string));
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.VideoDevType.frameRate.name())) != null) {
                videoDevRec.setField(14, (Object)OmiMessage.VideoDevFrameRateType.axiValueToEnum(string));
            }
            if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.VideoDevType.ppnNum.name())) != null) {
                videoDevRec.setField(15, n);
                if (n > 0) {
                    int[] nArray = new int[10];
                    OmiMessage omiMessage2 = omiMessage.getSubElement();
                    n2 = 0;
                    while (n2 < n) {
                        if (omiMessage2 == null || omiMessage2.id != OmiMessage.elemIds.ppList) {
                            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, String.format("VideoDevType missing sub element '%s'\n", OmiMessage.elemIds.ppList.name()));
                            break;
                        }
                        nArray[n2.intValue()] = omiMessage2.getAttribValInt(OmiMessage.attribIds.ppn.name());
                        omiMessage2 = omiMessage2.getNext();
                        Integer n3 = n2;
                        Integer n4 = n2 = Integer.valueOf(n2 + 1);
                    }
                    videoDevRec.setField(16, nArray);
                }
            }
            return videoDevRec;
        }
        return null;
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        if (omiManagementEventEnum == OmiManagementEventEnum.LINK_READY && (this.startFlag || this.autoMode)) {
            this.startFlag = false;
            this.start();
        }
    }

    public static class VideoDevDatabase
    extends Database {
        public static int maxVideoDevs = 12288;
        VideoDevRec[] videoDev;
        int[] videoDevIdx;
        int noOfVideoDevs = 0;
        int maxVideoDevId = -1;

        public VideoDevDatabase() {
            this.initialize();
        }

        public VideoDevDatabase(int n) {
            maxVideoDevs = n;
            this.initialize();
        }

        private void initialize() {
            this.videoDev = new VideoDevRec[maxVideoDevs];
            this.videoDevIdx = new int[maxVideoDevs];
        }

        @Override
        public VideoDevRec getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfVideoDevs) {
                return this.videoDev[this.videoDevIdx[n]];
            }
            return null;
        }

        public VideoDevRec getRecordById(int n) {
            if (n >= 0 && n < maxVideoDevs) {
                return this.videoDev[n];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfVideoDevs;
        }

        @Override
        public void updateIndex() {
            this.updateIndex(new DatabaseChangeEvent(Database.DatabaseChangeEnum.INDEX_UPDATE, 0, DatabaseChangeEvent.DatabaseChangeType.VIDEO_DEV));
        }

        public void updateIndex(DatabaseChangeEvent databaseChangeEvent) {
            int n = -1;
            this.noOfVideoDevs = 0;
            for (int i = 0; i <= this.maxVideoDevId; ++i) {
                if (this.videoDev[i] == null) continue;
                if (this.getFilterActive()) {
                    if (!this.filterMatch(this.videoDev[i])) continue;
                    if (databaseChangeEvent.recordId == i) {
                        n = this.noOfVideoDevs;
                    }
                    this.videoDevIdx[this.noOfVideoDevs++] = i;
                    continue;
                }
                if (databaseChangeEvent.recordId == i) {
                    n = this.noOfVideoDevs;
                }
                this.videoDevIdx[this.noOfVideoDevs++] = i;
            }
            if (n != -1) {
                databaseChangeEvent.modelId = n;
            }
            this.generateChangeNotification(databaseChangeEvent);
        }

        public void add(VideoDevRec videoDevRec) {
            DatabaseChangeEvent databaseChangeEvent = null;
            int n = videoDevRec.id;
            if (n < 0 || n >= maxVideoDevs) {
                return;
            }
            if (this.videoDev[n] != null) {
                databaseChangeEvent = new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_CHANGED, n, DatabaseChangeEvent.DatabaseChangeType.VIDEO_DEV);
                if (videoDevRec.tag != null) {
                    this.videoDev[n].tag = videoDevRec.tag;
                }
                if (videoDevRec.rfpId != -1) {
                    this.videoDev[n].rfpId = videoDevRec.rfpId;
                }
                if (videoDevRec.usbPath != null) {
                    this.videoDev[n].usbPath = videoDevRec.usbPath;
                }
                if (videoDevRec.active != null) {
                    this.videoDev[n].active = videoDevRec.active;
                }
                if (videoDevRec.state != null) {
                    this.videoDev[n].state = videoDevRec.state;
                }
                if (videoDevRec.name != null) {
                    this.videoDev[n].name = videoDevRec.name;
                }
                if (videoDevRec.siteId != 0) {
                    this.videoDev[n].siteId = videoDevRec.siteId;
                }
                if (videoDevRec.siteName != null) {
                    this.videoDev[n].siteName = videoDevRec.siteName;
                }
                if (videoDevRec.hierarchy1 != null) {
                    this.videoDev[n].hierarchy1 = videoDevRec.hierarchy1;
                }
                if (videoDevRec.hierarchy2 != null) {
                    this.videoDev[n].hierarchy2 = videoDevRec.hierarchy2;
                }
                if (videoDevRec.hierarchy3 != null) {
                    this.videoDev[n].hierarchy3 = videoDevRec.hierarchy3;
                }
                if (videoDevRec.hierarchy4 != null) {
                    this.videoDev[n].hierarchy4 = videoDevRec.hierarchy4;
                }
                if (videoDevRec.resolution != null) {
                    this.videoDev[n].resolution = videoDevRec.resolution;
                }
                if (videoDevRec.frameRate != null) {
                    this.videoDev[n].frameRate = videoDevRec.frameRate;
                }
                if (videoDevRec.ppnNum != null) {
                    this.videoDev[n].ppnNum = videoDevRec.ppnNum;
                    for (int i = 0; i < videoDevRec.ppnNum; ++i) {
                        ((VideoDevRec)this.videoDev[n]).ppnList[i] = videoDevRec.ppnList[i];
                    }
                }
            } else {
                databaseChangeEvent = new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_ADDED, n, DatabaseChangeEvent.DatabaseChangeType.VIDEO_DEV);
                this.videoDev[n] = videoDevRec;
            }
            if (n > this.maxVideoDevId) {
                this.maxVideoDevId = n;
            }
            this.updateIndex(databaseChangeEvent);
        }

        public void delete(int n) {
            if (n >= 0 && n < maxVideoDevs) {
                this.videoDev[n] = null;
                if (n == this.maxVideoDevId) {
                    while (this.maxVideoDevId >= 0 && this.videoDev[this.maxVideoDevId] == null) {
                        --this.maxVideoDevId;
                    }
                }
            }
            DatabaseChangeEvent databaseChangeEvent = new DatabaseChangeEvent(Database.DatabaseChangeEnum.RECORD_DELETED, n, DatabaseChangeEvent.DatabaseChangeType.BTD);
            this.updateIndex(databaseChangeEvent);
        }

        public void clearAll() {
            for (int i = 0; i <= this.maxVideoDevId; ++i) {
                this.videoDev[i] = null;
            }
            this.maxVideoDevId = -1;
            this.updateIndex();
        }

        @Override
        public String[] getFieldNames() {
            return VideoDevRec.getFieldNames();
        }
    }

    public static class VideoDevRec
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_TAG = 1;
        public static final int IDX_RFP_ID = 2;
        public static final int IDX_USB_PATH = 3;
        public static final int IDX_ACTIVE = 4;
        public static final int IDX_STATE = 5;
        public static final int IDX_NAME = 6;
        public static final int IDX_SITE_ID = 7;
        public static final int IDX_SITE_NAME = 8;
        public static final int IDX_HIERARCHY1 = 9;
        public static final int IDX_HIERARCHY2 = 10;
        public static final int IDX_HIERARCHY3 = 11;
        public static final int IDX_HIERARCHY4 = 12;
        public static final int IDX_RESOLUTION = 13;
        public static final int IDX_FRAME_RATE = 14;
        public static final int IDX_PPN_NUM = 15;
        public static final int IDX_PPN_LIST = 16;
        public static final int NUMBER_OF_FIELDS = 17;
        private int id = -1;
        private String tag = null;
        private int rfpId = -1;
        private String usbPath = null;
        private Boolean active = null;
        private OmiMessage.VideoDevStateType state = null;
        private String name = null;
        private int siteId = 0;
        private String siteName = null;
        private String hierarchy1 = null;
        private String hierarchy2 = null;
        private String hierarchy3 = null;
        private String hierarchy4 = null;
        private OmiMessage.VideoDevResolutionType resolution = null;
        private OmiMessage.VideoDevFrameRateType frameRate = null;
        private Integer ppnNum = null;
        private int[] ppnList = new int[10];
        private boolean changed = false;
        private static String[] fieldNames = new String[]{"id", "tag", "rfpId", "usbPath", "active", "state", "name", "site id", "site name", "hierarchy1", "hierarchy2", "hierarchy3", "hierarchy4", "resolution", "frameRate", "ppn num", "ppn list"};

        public VideoDevRec() {
            for (int i = 0; i < 10; ++i) {
                this.ppnList[i] = 0;
            }
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 17) {
                VideoDevRec.fieldNames[n] = string;
            }
        }

        public static String[] getFieldNames() {
            return fieldNames;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.tag;
                }
                case 2: {
                    if (this.rfpId == -1) {
                        return null;
                    }
                    return this.rfpId;
                }
                case 3: {
                    return this.usbPath;
                }
                case 4: {
                    return this.active;
                }
                case 5: {
                    return this.state;
                }
                case 6: {
                    return this.name;
                }
                case 7: {
                    return this.siteId;
                }
                case 8: {
                    return this.siteName;
                }
                case 9: {
                    return this.hierarchy1;
                }
                case 10: {
                    return this.hierarchy2;
                }
                case 11: {
                    return this.hierarchy3;
                }
                case 12: {
                    return this.hierarchy4;
                }
                case 13: {
                    return this.resolution;
                }
                case 14: {
                    return this.frameRate;
                }
                case 15: {
                    return this.ppnNum;
                }
                case 16: {
                    if (this.ppnNum == null || this.ppnNum == 0) {
                        return "-";
                    }
                    String string = String.format("0x%03x", this.ppnList[0]);
                    for (int i = 1; i < this.ppnNum; ++i) {
                        string = string.concat(String.format(", 0x%03X", this.ppnList[i]));
                    }
                    return string;
                }
            }
            return null;
        }

        @Override
        public void setField(int n, Object object) {
            int n2 = 0;
            Integer n3 = null;
            int[] nArray = null;
            String string = null;
            Boolean bl = false;
            OmiMessage.VideoDevStateType videoDevStateType = null;
            OmiMessage.VideoDevResolutionType videoDevResolutionType = null;
            OmiMessage.VideoDevFrameRateType videoDevFrameRateType = null;
            try {
                switch (n) {
                    case 0: 
                    case 2: 
                    case 7: {
                        n2 = (Integer)object;
                        break;
                    }
                    case 4: {
                        bl = (Boolean)object;
                        break;
                    }
                    case 5: {
                        videoDevStateType = (OmiMessage.VideoDevStateType)((Object)object);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        string = (String)object;
                        break;
                    }
                    case 13: {
                        videoDevResolutionType = (OmiMessage.VideoDevResolutionType)((Object)object);
                        break;
                    }
                    case 14: {
                        videoDevFrameRateType = (OmiMessage.VideoDevFrameRateType)((Object)object);
                        break;
                    }
                    case 15: {
                        n3 = (Integer)object;
                        break;
                    }
                    case 16: {
                        nArray = (int[])object;
                    }
                }
            }
            catch (Exception exception) {
                return;
            }
            block11 : switch (n) {
                case 0: {
                    if (this.id == n2) break;
                    this.changed = true;
                    this.id = n2;
                    break;
                }
                case 1: {
                    if (string != null && this.tag != null) {
                        if (this.tag.equals(string)) {
                            return;
                        }
                        this.changed = true;
                        this.tag = string;
                        return;
                    }
                    if (string == null && this.tag == null) {
                        return;
                    }
                    this.changed = true;
                    this.tag = string;
                    break;
                }
                case 2: {
                    if (this.rfpId == n2) break;
                    this.changed = true;
                    this.rfpId = n2;
                    break;
                }
                case 3: {
                    if (string != null && this.usbPath != null) {
                        if (this.usbPath.equals(string)) {
                            return;
                        }
                        this.changed = true;
                        this.usbPath = string;
                        return;
                    }
                    if (string == null && this.tag == null) {
                        return;
                    }
                    this.changed = true;
                    this.usbPath = string;
                    break;
                }
                case 4: {
                    if (this.active == bl) break;
                    this.changed = true;
                    this.active = bl;
                    break;
                }
                case 5: {
                    if (this.state == videoDevStateType) break;
                    this.changed = true;
                    this.state = videoDevStateType;
                    break;
                }
                case 6: {
                    if (string != null && this.name != null) {
                        if (this.name.equals(string)) {
                            return;
                        }
                        this.changed = true;
                        this.name = string;
                        return;
                    }
                    if (string == null && this.name == null) {
                        return;
                    }
                    this.changed = true;
                    this.name = string;
                    break;
                }
                case 7: {
                    if (this.siteId == n2) break;
                    this.changed = true;
                    this.siteId = n2;
                    break;
                }
                case 8: {
                    if (string != null && this.siteName != null) {
                        if (this.siteName.equals(string)) {
                            return;
                        }
                        this.changed = true;
                        this.siteName = string;
                        return;
                    }
                    if (string == null && this.siteName == null) {
                        return;
                    }
                    this.changed = true;
                    this.siteName = string;
                    break;
                }
                case 9: {
                    if (string != null && this.hierarchy1 != null) {
                        if (this.hierarchy1.equals(string)) {
                            return;
                        }
                        this.changed = true;
                        this.hierarchy1 = string;
                        return;
                    }
                    if (string == null && this.hierarchy1 == null) {
                        return;
                    }
                    this.changed = true;
                    this.hierarchy1 = string;
                    break;
                }
                case 10: {
                    if (string != null && this.hierarchy2 != null) {
                        if (this.hierarchy2.equals(string)) {
                            return;
                        }
                        this.changed = true;
                        this.hierarchy2 = string;
                        return;
                    }
                    if (string == null && this.hierarchy2 == null) {
                        return;
                    }
                    this.changed = true;
                    this.hierarchy2 = string;
                    break;
                }
                case 11: {
                    if (string != null && this.hierarchy3 != null) {
                        if (this.hierarchy3.equals(string)) {
                            return;
                        }
                        this.changed = true;
                        this.hierarchy3 = string;
                        return;
                    }
                    if (string == null && this.hierarchy3 == null) {
                        return;
                    }
                    this.changed = true;
                    this.hierarchy3 = string;
                    break;
                }
                case 12: {
                    if (string != null && this.hierarchy4 != null) {
                        if (this.hierarchy4.equals(string)) {
                            return;
                        }
                        this.changed = true;
                        this.hierarchy4 = string;
                        return;
                    }
                    if (string == null && this.hierarchy4 == null) {
                        return;
                    }
                    this.changed = true;
                    this.hierarchy4 = string;
                    break;
                }
                case 13: {
                    if (this.resolution == videoDevResolutionType) break;
                    this.changed = true;
                    this.resolution = videoDevResolutionType;
                    break;
                }
                case 14: {
                    if (this.frameRate == videoDevFrameRateType) break;
                    this.changed = true;
                    this.frameRate = videoDevFrameRateType;
                    break;
                }
                case 15: {
                    if (this.ppnNum != null && n3 != null) {
                        if (this.ppnNum == n3) break;
                        this.changed = true;
                        this.ppnNum = n3;
                        break;
                    }
                    if (this.ppnNum == null && n3 == null) {
                        return;
                    }
                    this.changed = true;
                    this.ppnNum = n3;
                    break;
                }
                case 16: {
                    if (this.ppnList != null && nArray != null) {
                        for (int i = 0; i < 10; ++i) {
                            if (this.ppnList[i] == nArray[i]) continue;
                            this.changed = true;
                            this.ppnList = nArray;
                            break block11;
                        }
                        break;
                    }
                    if (this.ppnList == null && nArray == null) {
                        return;
                    }
                    this.changed = true;
                    this.ppnList = nArray;
                }
            }
        }

        public boolean getRecordChanged() {
            return this.changed;
        }

        public void commitChanges() {
            this.changed = false;
        }

        @Override
        public VideoDevRec clone() {
            VideoDevRec videoDevRec = new VideoDevRec();
            videoDevRec.id = this.id;
            videoDevRec.tag = this.tag;
            videoDevRec.rfpId = this.rfpId;
            videoDevRec.usbPath = this.usbPath;
            videoDevRec.active = this.active;
            videoDevRec.state = this.state;
            videoDevRec.name = this.name;
            videoDevRec.siteId = this.siteId;
            videoDevRec.siteName = this.siteName;
            videoDevRec.hierarchy1 = this.hierarchy1;
            videoDevRec.hierarchy2 = this.hierarchy2;
            videoDevRec.hierarchy3 = this.hierarchy3;
            videoDevRec.hierarchy4 = this.hierarchy4;
            videoDevRec.resolution = this.resolution;
            videoDevRec.frameRate = this.frameRate;
            videoDevRec.ppnNum = this.ppnNum;
            videoDevRec.ppnList = this.ppnList;
            return videoDevRec;
        }

        public String getHierarchyName() {
            String string = (String)this.getField(9) + "/" + (String)this.getField(10) + "/" + (String)this.getField(11) + "/" + (String)this.getField(12) + "/" + (String)this.getField(6);
            return string;
        }

        public int[] getPPNList() {
            return this.ppnList;
        }
    }

    public static interface VideoDevNotificationInterface {
        public void processVideoDevDataNotification(int var1, DataNotificationEnum var2);

        public void processVideoDevErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }
}

