/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.SummaryHandler;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class VideoDevSummaryHandler
extends SummaryHandler {
    private static final OmiMessage.EventType[] eventType = new OmiMessage.EventType[]{OmiMessage.EventType.VideoDevSumCnf, OmiMessage.EventType.VideoDevSumState};
    private VideoDevSummaryClass summary = null;
    private LinkedList<VideoDevSummaryNotificationInterface> listenerList = new LinkedList();

    public void registerVideoDevSummaryNotificationListener(VideoDevSummaryNotificationInterface videoDevSummaryNotificationInterface) {
        this.listenerList.add(videoDevSummaryNotificationInterface);
    }

    public void deregisterVideoDevSummaryNotificationListener(VideoDevSummaryNotificationInterface videoDevSummaryNotificationInterface) {
        this.listenerList.remove(videoDevSummaryNotificationInterface);
    }

    public VideoDevSummaryHandler(OmiManagement omiManagement) {
        super(omiManagement, OmiMessage.elemIds.GetVideoDevSummary, OmiMessage.elemIds.GetVideoDevSummaryResp, OmiMessage.elemIds.EventVideoDevSummary, eventType);
    }

    @Override
    protected void initSummary() {
        if (this.summary == null) {
            this.summary = new VideoDevSummaryClass();
        } else {
            this.summary.clear();
        }
        this.GenerateSummaryNotification();
    }

    public VideoDevSummaryClass getSummary() {
        if (this.summary == null) {
            this.summary = new VideoDevSummaryClass();
        }
        return this.summary.clone();
    }

    @Override
    protected boolean processSummary(OmiMessage omiMessage) {
        boolean bl = false;
        Integer n = omiMessage.getAttribValIntNotMandatory(OmiMessage.VideoDevSummaryType.nRecords.name());
        if (n != null && this.summary.nRecords != n) {
            this.summary.nRecords = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.VideoDevSummaryType.idFirst.name())) != null && this.summary.idFirst != n) {
            this.summary.idFirst = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.VideoDevSummaryType.enabledNum.name())) != null && this.summary.enabledNum != n) {
            this.summary.enabledNum = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.VideoDevSummaryType.stateActiveNum.name())) != null && this.summary.stateActiveNum != n) {
            this.summary.stateActiveNum = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.VideoDevSummaryType.stateUnpluggedNum.name())) != null && this.summary.stateUnpluggedNum != n) {
            this.summary.stateUnpluggedNum = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.VideoDevSummaryType.stateInactiveNum.name())) != null && this.summary.stateInactiveNum != n) {
            this.summary.stateInactiveNum = n;
            bl = true;
        }
        if ((n = omiMessage.getAttribValIntNotMandatory(OmiMessage.VideoDevSummaryType.stateFailedNum.name())) != null && this.summary.stateFailedNum != n) {
            this.summary.stateFailedNum = n;
            bl = true;
        }
        return bl;
    }

    @Override
    protected void GenerateSummaryNotification() {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating video dev summary notification: No listener");
            return;
        }
        VideoDevSummaryClass videoDevSummaryClass = this.summary.clone();
        for (VideoDevSummaryNotificationInterface videoDevSummaryNotificationInterface : this.listenerList) {
            if (videoDevSummaryNotificationInterface == null) continue;
            videoDevSummaryNotificationInterface.processVideoDevSummaryNotification(videoDevSummaryClass);
        }
    }

    @Override
    protected void GenerateSummaryErrorNotification(OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating video dev summary error notification: No listener");
            return;
        }
        for (VideoDevSummaryNotificationInterface videoDevSummaryNotificationInterface : this.listenerList) {
            if (videoDevSummaryNotificationInterface == null) continue;
            videoDevSummaryNotificationInterface.processVideoDevSummaryErrorNotification(omiMessage);
        }
    }

    public static interface VideoDevSummaryNotificationInterface {
        public void processVideoDevSummaryNotification(VideoDevSummaryClass var1);

        public void processVideoDevSummaryErrorNotification(OmiMessage var1);
    }

    public static class VideoDevSummaryClass {
        public int nRecords = 0;
        public int idFirst = 0;
        public int enabledNum = 0;
        public int stateUnpluggedNum = 0;
        public int stateInactiveNum = 0;
        public int stateActiveNum = 0;
        public int stateFailedNum = 0;

        public void clear() {
            this.nRecords = 0;
            this.idFirst = 0;
            this.enabledNum = 0;
            this.stateUnpluggedNum = 0;
            this.stateInactiveNum = 0;
            this.stateActiveNum = 0;
            this.stateFailedNum = 0;
        }

        public VideoDevSummaryClass clone() {
            VideoDevSummaryClass videoDevSummaryClass = new VideoDevSummaryClass();
            videoDevSummaryClass.nRecords = this.nRecords;
            videoDevSummaryClass.idFirst = this.idFirst;
            videoDevSummaryClass.enabledNum = this.enabledNum;
            videoDevSummaryClass.stateUnpluggedNum = this.stateUnpluggedNum;
            videoDevSummaryClass.stateInactiveNum = this.stateInactiveNum;
            videoDevSummaryClass.stateActiveNum = this.stateActiveNum;
            videoDevSummaryClass.stateFailedNum = this.stateFailedNum;
            return videoDevSummaryClass;
        }
    }
}

