/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.OmilibUtil;
import com.aastra.omilib.RfpDataHandler;
import com.aastra.omilib.RfpDataRecord;
import com.aastra.omilib.RfpDatabase;

public class WLANClientMonitoring
implements OmiMessageInterface,
OmiManagementEventInterface {
    private static final int MAX_CLIENT_PER_REQ = 20;
    private boolean linkReady = false;
    private boolean activated = false;
    private boolean getClientsInProgress = false;
    private OmiHandler omiHandler = null;
    private WLANClientDatabase clientDb = null;
    private RfpDatabase rfpDb;

    public WLANClientMonitoring(RfpDataHandler rfpDataHandler, OmiManagement omiManagement) {
        this.omiHandler = omiManagement.getOmiHandler();
        this.rfpDb = rfpDataHandler.getDatabase();
        this.clientDb = new WLANClientDatabase();
        omiManagement.registerManagementEventListener(this);
        OmiMessage.elemIds.GetWLANClientsResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventWLANClient.registerDataNotificationListener(this);
    }

    public WLANClientDatabase getDb() {
        return this.clientDb;
    }

    private void sendGetWLANClients(int n, String string) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetWLANClients);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.rfpId.name(), n);
        omiMessage.addAttrib(OmiMessage.WLANClientType.ethAddr.name(), string);
        omiMessage.addAttrib(OmiMessage.attribIds.maxRecords.name(), 20);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public boolean startMonitoring() {
        this.activated = true;
        if (this.linkReady) {
            this.start();
            return true;
        }
        return false;
    }

    private void start() {
        this.clientDb.clearAll();
        OmiMessage.sendSetEventSubscription(this.omiHandler, OmiMessage.EventType.WLANClient, null, null);
        if (this.sendGetWlanClientsForNextRfp(0) != 0) {
            this.getClientsInProgress = true;
        }
    }

    public void stopMonitoring() {
        if (this.activated && this.linkReady) {
            this.stop();
        }
        this.activated = false;
    }

    private void stop() {
        this.getClientsInProgress = false;
        OmiMessage.sendResetEventSubscription(this.omiHandler, OmiMessage.EventType.WLANClient, null, null);
    }

    private int sendGetWlanClientsForNextRfp(int n) {
        while (n < RfpDatabase.maxRfp) {
            boolean bl;
            RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(n);
            if (rfpDataRecord != null && (bl = ((Boolean)rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_ON)).booleanValue())) {
                this.sendGetWLANClients(n, "00:00:00:00:00:00");
                return 1;
            }
            ++n;
        }
        return 0;
    }

    private void newClient(int n, String string) {
        WLANClient wLANClient = new WLANClient();
        wLANClient.rfpId = n;
        wLANClient.ethAddr = string;
        RfpDataRecord rfpDataRecord = this.rfpDb.getRfpByRfpId(n);
        wLANClient.profile = rfpDataRecord != null ? (Integer)rfpDataRecord.getField(RfpDataRecord.IDX_WLAN_PROFILE) : 0;
        this.clientDb.addClient(wLANClient);
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        OmiMessage omiMessage2 = null;
        String string = null;
        switch (omiMessage.id) {
            case GetWLANClientsResp: {
                int n = omiMessage.getAttribValInt(OmiMessage.attribIds.rfpId.name());
                int n2 = 0;
                for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                    string = omiMessage2.getAttribVal(OmiMessage.WLANClientType.ethAddr.name());
                    if (string == null) continue;
                    this.newClient(n, string);
                    ++n2;
                }
                if (n2 == 20) {
                    string = OmilibUtil.incrementMACAddr(string);
                    this.sendGetWLANClients(n, string);
                    break;
                }
                if (!this.getClientsInProgress || this.sendGetWlanClientsForNextRfp(n + 1) != 0) break;
                this.getClientsInProgress = false;
                break;
            }
            case EventWLANClient: {
                int n = omiMessage.getAttribValInt(OmiMessage.attribIds.rfpId.name());
                boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                boolean bl2 = omiMessage.getAttribValBool(OmiMessage.attribIds.deletedAll.name());
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null) {
                    string = omiMessage2.getAttribVal(OmiMessage.WLANClientType.ethAddr.name());
                }
                if (bl) {
                    if (string == null) break;
                    this.clientDb.deleteClient(string);
                    break;
                }
                if (bl2) {
                    this.clientDb.deleteClientsOnRfp(n);
                    break;
                }
                if (string == null) break;
                this.newClient(n, string);
                break;
            }
        }
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        switch (omiManagementEventEnum) {
            case LINK_READY: {
                this.linkReady = true;
                if (!this.activated) break;
                this.start();
                break;
            }
            case LINK_CLOSED: {
                this.linkReady = false;
                break;
            }
        }
    }

    public static class WLANClientDatabase
    extends Database {
        public static int MAX_CLIENTS = 1024;
        WLANClient[] clients = new WLANClient[MAX_CLIENTS];
        int[] clientIdx = new int[MAX_CLIENTS];
        int noOfClients = 0;
        int maxClientIdx = -1;

        @Override
        public String[] getFieldNames() {
            return WLANClient.getFieldNames();
        }

        @Override
        public DataRecord getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfClients) {
                return this.clients[this.clientIdx[n]];
            }
            return null;
        }

        public WLANClient getRecordById(int n) {
            if (n > 0 && n <= this.noOfClients) {
                return this.clients[n];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfClients;
        }

        @Override
        public void updateIndex() {
            this.noOfClients = 0;
            for (int i = 0; i <= this.maxClientIdx; ++i) {
                if (this.clients[i] == null) continue;
                if (this.getFilterActive()) {
                    boolean bl = false;
                    for (int j = 0; j < this.getFilterColumnArray().length; ++j) {
                        if (!this.matchObjectWithFilter(this.clients[i].getField(this.getFilterColumnArray()[j]), this.getFilterColumnArray()[j])) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    this.clientIdx[this.noOfClients++] = i;
                    continue;
                }
                this.clientIdx[this.noOfClients++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public void addClient(WLANClient wLANClient) {
            int n;
            int n2 = -1;
            for (n = 0; n <= this.maxClientIdx; ++n) {
                if (this.clients[n] == null || !wLANClient.ethAddr.equals(this.clients[n].ethAddr)) continue;
                this.clients[n].rfpId = wLANClient.rfpId;
                this.clients[n].profile = wLANClient.profile;
                this.updateIndex();
                return;
            }
            for (n = 0; n <= this.maxClientIdx; ++n) {
                if (this.clients[n] != null) continue;
                n2 = n;
                break;
            }
            if (n2 == -1) {
                ++this.maxClientIdx;
                n2 = this.maxClientIdx;
            }
            wLANClient.id = n2;
            this.clients[n2] = wLANClient;
            this.updateIndex();
        }

        public void deleteClient(int n) {
            if (n >= 0 && n < MAX_CLIENTS) {
                this.clients[n] = null;
                if (n == this.maxClientIdx) {
                    while (this.maxClientIdx >= 0 && this.clients[this.maxClientIdx] == null) {
                        --this.maxClientIdx;
                    }
                }
            }
            this.updateIndex();
        }

        public void deleteClient(String string) {
            for (int i = 0; i <= this.maxClientIdx; ++i) {
                if (this.clients[i] == null || !string.equals(this.clients[i].ethAddr)) continue;
                this.deleteClient(i);
                return;
            }
        }

        public void deleteClientsOnRfp(int n) {
            for (int i = 0; i <= this.maxClientIdx; ++i) {
                if (this.clients[i] == null || this.clients[i].rfpId != n) continue;
                this.deleteClient(i);
            }
        }

        public void clearAll() {
            for (int i = 0; i <= this.maxClientIdx; ++i) {
                this.clients[i] = null;
            }
            this.maxClientIdx = -1;
            this.updateIndex();
        }
    }

    public static class WLANClient
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_RFP_ID = 1;
        public static final int IDX_ETH_ADDR = 2;
        public static final int IDX_PROFILE = 3;
        public static final int NUMBER_OF_FIELDS = 4;
        int id;
        int rfpId;
        String ethAddr;
        int profile;
        private static String[] fieldNames = new String[]{"id", "rfpId", "MAC address", "WLAN Profile ID"};

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 4) {
                WLANClient.fieldNames[n] = string;
            }
        }

        public static String[] getFieldNames() {
            return fieldNames;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.rfpId;
                }
                case 2: {
                    return this.ethAddr;
                }
                case 3: {
                    return this.profile;
                }
            }
            return null;
        }
    }
}

