/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omilib;

import com.aastra.omilib.Base64Coder;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.OmiHandler;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.OmiManagementEventEnum;
import com.aastra.omilib.OmiManagementEventInterface;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilib.OmiMessageInterface;
import com.aastra.omilib.OmiRSA;
import com.aastra.util.UtilSpy;
import java.util.LinkedList;

public class XMLApplicationHandler
implements OmiManagementEventInterface,
OmiMessageInterface {
    private XMLApplDatabase db = new XMLApplDatabase();
    private OmiHandler omiHandler = null;
    private OmiManagement omiManagement = null;
    private boolean getAllInProgress = false;
    private LinkedList<XMLApplDataNotificationInterface> listenerList = new LinkedList();
    private static String[] fieldNames = new String[]{"id", "name", "enable", "type", "corpDirOrder", OmiMessage.URLType.protocol.name(), OmiMessage.URLType.host.name(), OmiMessage.URLType.path.name(), OmiMessage.URLType.username.name(), OmiMessage.URLType.password.name()};

    public XMLApplicationHandler(OmiManagement omiManagement) {
        this.omiManagement = omiManagement;
        this.omiHandler = this.omiManagement.getOmiHandler();
        this.omiManagement.registerManagementEventListener(this);
        OmiMessage.elemIds.CreateXMLApplicationResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.DeleteXMLApplicationResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.SetXMLApplicationResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.GetXMLApplicationResp.registerDataNotificationListener(this);
        OmiMessage.elemIds.EventXMLApplicationCnf.registerDataNotificationListener(this);
    }

    public void registerDataNotificationListener(XMLApplDataNotificationInterface xMLApplDataNotificationInterface) {
        this.listenerList.add(xMLApplDataNotificationInterface);
    }

    public void deregisterDataNotificationListener(XMLApplDataNotificationInterface xMLApplDataNotificationInterface) {
        this.listenerList.remove(xMLApplDataNotificationInterface);
    }

    private void GenerateDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating XML application data notification: No listener");
        }
        for (XMLApplDataNotificationInterface xMLApplDataNotificationInterface : this.listenerList) {
            if (xMLApplDataNotificationInterface == null) continue;
            xMLApplDataNotificationInterface.processXMLApplDataNotification(n, dataNotificationEnum);
        }
    }

    private void GenerateErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        if (this.listenerList.size() == 0) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "Generating XML application error notification: No listener");
        }
        for (XMLApplDataNotificationInterface xMLApplDataNotificationInterface : this.listenerList) {
            if (xMLApplDataNotificationInterface == null) continue;
            xMLApplDataNotificationInterface.processXMLApplErrorNotification(n, dataNotificationEnum, omiMessage);
        }
    }

    public Database getXMLApplDb() {
        return this.db;
    }

    public int getNumberOfXMLApplEntries() {
        return this.db.getRecordNumber();
    }

    public XMLApplRec getXMLApplRecordById(int n) {
        XMLApplRec xMLApplRec = this.db.getRecordById(n);
        return xMLApplRec;
    }

    public XMLApplRec getXMLApplRecordByTableIdx(int n) {
        XMLApplRec xMLApplRec = this.db.getRecordByIdx(n);
        return xMLApplRec;
    }

    public void sendGetXMLAppl(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetXMLApplication);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendGetXMLApplAll() {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.GetXMLApplication);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendCreateXMLAppl(XMLApplRec xMLApplRec) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.CreateXMLApplication);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.xmlAppl);
        this.addAttribsXMLAppl(xMLApplRec, omiMessage2, false);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendSetXMLAppl(XMLApplRec xMLApplRec) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.SetXMLApplication);
        OmiMessage omiMessage2 = omiMessage.addSubElement(OmiMessage.elemIds.xmlAppl);
        this.addAttribsXMLAppl(xMLApplRec, omiMessage2, true);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    public void sendDeleteXMLAppl(int n) {
        OmiMessage omiMessage = new OmiMessage(OmiMessage.elemIds.DeleteXMLApplication);
        omiMessage.addAttrib(OmiMessage.attribIds.seq.name(), n);
        omiMessage.addAttrib(OmiMessage.attribIds.id.name(), n);
        this.omiHandler.sendOmiMessage(omiMessage);
    }

    private void addAttribsXMLAppl(XMLApplRec xMLApplRec, OmiMessage omiMessage, boolean bl) {
        Object object;
        Object object2;
        omiMessage.addAttrib(OmiMessage.XMLApplicationType.enable.name(), xMLApplRec.enable);
        if (bl) {
            omiMessage.addAttrib(OmiMessage.XMLApplicationType.id.name(), xMLApplRec.id);
        }
        if (xMLApplRec.name != null) {
            object2 = OmiMessage.BuiltInApplicationType.getValFromTxt(xMLApplRec.name);
            object = object2 != null ? object2.name() : xMLApplRec.name;
            omiMessage.addAttrib(OmiMessage.XMLApplicationType.name.name(), (String)object);
        }
        if (xMLApplRec.type != null) {
            omiMessage.addAttrib(OmiMessage.XMLApplicationType.type.name(), xMLApplRec.type.name());
        }
        if (xMLApplRec.corpDirOrder != 0) {
            omiMessage.addAttrib(OmiMessage.XMLApplicationType.corpDirOrder.name(), xMLApplRec.corpDirOrder);
        }
        if (xMLApplRec.url != null) {
            if (xMLApplRec.url.password != null && (object = (Object)OmiRSA.encrypt(xMLApplRec.url.password)) != null) {
                object2 = Base64Coder.encode((byte[])object);
                xMLApplRec.url.password = new String((char[])object2);
            }
            xMLApplRec.url.addUrlToMsg(omiMessage);
        }
    }

    @Override
    public void processManagementEvent(OmiManagementEventEnum omiManagementEventEnum) {
        switch (omiManagementEventEnum) {
            case LINK_READY: {
                this.db.clearAll();
                if (!this.omiManagement.getOmmAttribBool(OmiMessage.OpenRespAttribType.haveXML)) break;
                this.getAllInProgress = true;
                this.sendGetXMLApplAll();
                break;
            }
        }
    }

    @Override
    public void processOmiMessage(OmiMessage omiMessage) {
        OmiMessage omiMessage2 = null;
        String string = null;
        switch (omiMessage.id) {
            case GetXMLApplicationResp: {
                int n = 0;
                for (omiMessage2 = omiMessage.getSubElement(); omiMessage2 != null; omiMessage2 = omiMessage2.getNext()) {
                    if (this.processXMLApplElem(omiMessage2, DataNotificationEnum.NEW_DATA)) {
                        ++n;
                        continue;
                    }
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetXMLApplicationResp contains no element");
                }
                if (n > 30) {
                    UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "GetXMLApplicationResp contains more elements than allowed");
                }
                if (!this.getAllInProgress) break;
                this.getAllInProgress = false;
                this.GenerateDataNotification(this.db.getRecordNumber(), DataNotificationEnum.DATA_BULK_READY);
                break;
            }
            case CreateXMLApplicationResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    this.GenerateErrorNotification(-1, DataNotificationEnum.NEW_DATA, omiMessage);
                    break;
                }
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null && this.processXMLApplElem(omiMessage2, DataNotificationEnum.NEW_DATA)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "CreateXMLApplicationResp contains no elements");
                break;
            }
            case DeleteXMLApplicationResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string == null) break;
                int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                this.GenerateErrorNotification(n, DataNotificationEnum.DATA_DELETED, omiMessage);
                break;
            }
            case SetXMLApplicationResp: {
                string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
                if (string != null) {
                    int n = omiMessage.getAttribValInt(OmiMessage.attribIds.seq.name());
                    this.GenerateErrorNotification(n, DataNotificationEnum.DATA_CHANGED, omiMessage);
                    break;
                }
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null && this.processXMLApplElem(omiMessage2, DataNotificationEnum.DATA_CHANGED)) break;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "SetXMLApplicationResp contains no elements");
                break;
            }
            case EventXMLApplicationCnf: {
                omiMessage2 = omiMessage.getSubElement();
                if (omiMessage2 != null) {
                    boolean bl = omiMessage.getAttribValBool(OmiMessage.attribIds.deleted.name());
                    if (bl) {
                        int n = omiMessage2.getAttribValInt(OmiMessage.XMLApplicationType.id.name());
                        this.db.delete(n);
                        this.GenerateDataNotification(n, DataNotificationEnum.DATA_DELETED);
                        break;
                    }
                    if (this.processXMLApplElem(omiMessage2, DataNotificationEnum.DATA_CHANGED)) break;
                }
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_MSG, this, "EventXMLApplicationCnf contains no elements");
                break;
            }
        }
    }

    private boolean processXMLApplElem(OmiMessage omiMessage, DataNotificationEnum dataNotificationEnum) {
        if (omiMessage.id == OmiMessage.elemIds.xmlAppl) {
            Object object;
            String string;
            Boolean bl;
            int n = omiMessage.getAttribValInt(OmiMessage.XMLApplicationType.id.name());
            XMLApplRec xMLApplRec = this.db.getRecordById(n);
            if (xMLApplRec == null) {
                xMLApplRec = new XMLApplRec(n);
            }
            if ((bl = omiMessage.getAttribValBoolNotMandatory(OmiMessage.XMLApplicationType.enable.name())) != null) {
                xMLApplRec.enable = bl;
            }
            if ((string = omiMessage.getAttribVal(OmiMessage.XMLApplicationType.name.name())) != null) {
                try {
                    object = OmiMessage.BuiltInApplicationType.valueOf(string);
                    xMLApplRec.name = object.txt;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    xMLApplRec.name = string;
                }
            }
            if (omiMessage.getAttribVal(OmiMessage.XMLApplicationType.type.name()) != null) {
                xMLApplRec.type = OmiMessage.XMLApplicationTypeType.valueOf(omiMessage.getAttribVal(OmiMessage.XMLApplicationType.type.name()));
            }
            if (omiMessage.getAttribVal(OmiMessage.XMLApplicationType.corpDirOrder.name()) != null) {
                xMLApplRec.corpDirOrder = omiMessage.getAttribValInt(OmiMessage.XMLApplicationType.corpDirOrder.name());
            }
            if ((object = omiMessage.getSubElement()) != null) {
                xMLApplRec.url = new CommonDataHandler.UrlClass();
                xMLApplRec.url.updateFromMsg((OmiMessage)object);
            }
            this.db.add(xMLApplRec);
            this.GenerateDataNotification(n, dataNotificationEnum);
            return true;
        }
        return false;
    }

    public static interface XMLApplDataNotificationInterface {
        public void processXMLApplDataNotification(int var1, DataNotificationEnum var2);

        public void processXMLApplErrorNotification(int var1, DataNotificationEnum var2, OmiMessage var3);
    }

    public static class XMLApplDatabase
    extends Database {
        public static final int NUMBER_BUILTIN_XML_APPL = 15;
        public static final int NUMBER_DYNAMIC_XML_APPL = 10;
        public static final int NUMBER_CORP_DIR_XML_APPL = 5;
        public static final int MAX_ENTRIES = 30;
        XMLApplRec[] recs = new XMLApplRec[30];
        int[] idxRecs = new int[30];
        int noOfRecs = 0;

        @Override
        public XMLApplRec getRecordByIdx(int n) {
            if (n >= 0 && n < this.noOfRecs) {
                return this.recs[this.idxRecs[n]];
            }
            return null;
        }

        public XMLApplRec getRecordById(int n) {
            if (n >= 0 && n < 30) {
                return this.recs[n];
            }
            return null;
        }

        @Override
        public int getRecordNumber() {
            return this.noOfRecs;
        }

        @Override
        public void updateIndex() {
            this.noOfRecs = 0;
            for (int i = 0; i < 30; ++i) {
                if (this.recs[i] == null) continue;
                this.idxRecs[this.noOfRecs++] = i;
            }
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        public void add(XMLApplRec xMLApplRec) {
            if (xMLApplRec.id >= 0 && xMLApplRec.id < 30) {
                this.recs[xMLApplRec.id] = xMLApplRec;
                this.updateIndex();
            }
        }

        public void delete(int n) {
            if (this.recs[n] != null) {
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.OMI_DB, this, String.format("Deleting XML aplication[%d]\n", n));
                this.recs[n] = null;
                this.updateIndex();
            } else {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.OMI_DB, this, String.format("Deleting XML application[%d] failed: Entry does not exist.", n));
            }
        }

        public void clearAll() {
            for (int i = 0; i < this.noOfRecs; ++i) {
                if (this.recs[i] == null) continue;
                this.recs[i] = null;
            }
            this.noOfRecs = 0;
            this.generateChangeNotification(Database.DatabaseChangeEnum.INDEX_UPDATE);
        }

        @Override
        public String[] getFieldNames() {
            return fieldNames;
        }
    }

    public static class XMLApplRec
    extends DataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_NAME = 1;
        public static final int IDX_ENABLE = 2;
        public static final int IDX_TYPE = 3;
        public static final int IDX_CORP_DIR_ORDER = 4;
        public static final int IDX_URL = 5;
        public static final int IDX_URL_HOST = 6;
        public static final int NUMBER_OF_FIELDS = 7;
        public int id;
        public boolean enable = false;
        public String name = null;
        public OmiMessage.XMLApplicationTypeType type;
        public int corpDirOrder = 0;
        public CommonDataHandler.UrlClass url = new CommonDataHandler.UrlClass();

        public XMLApplRec() {
        }

        public XMLApplRec(int n) {
            this.id = n;
        }

        @Override
        public Object getField(int n) {
            switch (n) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.name;
                }
                case 2: {
                    return this.enable;
                }
                case 3: {
                    return this.type;
                }
                case 4: {
                    return this.corpDirOrder;
                }
                case 5: {
                    return this.url;
                }
                case 6: {
                    return this.url.host;
                }
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public XMLApplRec clone() {
            XMLApplRec xMLApplRec = new XMLApplRec();
            xMLApplRec.id = this.id;
            xMLApplRec.name = this.name;
            xMLApplRec.enable = this.enable;
            xMLApplRec.type = this.type;
            xMLApplRec.corpDirOrder = this.corpDirOrder;
            xMLApplRec.url = this.url.clone();
            return xMLApplRec;
        }

        public static void setTableHeaderText(int n, String string) {
            if (n >= 0 && n < 7) {
                fieldNames[n] = string;
            }
        }
    }
}

