/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.opsb;

import com.aastra.opsb.OpsbPreStorageBase;

public class OpsbInstrElem {
    public static int STR_MAC_ADDR_LEN = 17;
    public static int STR_BOOL_LEN = 5;
    public static int STR_1BYTE_LEN = 3;
    public static int STR_2BYTE_LEN = 5;
    public static int STR_4BYTE_LEN = 10;
    public static int STR_PAGING_AREA_LEN = 10;
    public static int STR_LOCATION_LEN = 20;
    public static int STR_HIERARCHY_LEN = 16;
    public static int NONE = 0;
    public static int GET_FIELD = 1;
    public static int COMMON_FIELD = 2;
    public static int INCREMENT_FIELD = 3;
    public static int INCREMENT_MAXIMUM = 4;
    public String value = "";
    public int instr = NONE;
    public String parse_info = "";
    public String identifier;
    public int param_type;
    public static final int IS_RFPMAC = 1000;
    public static final int IS_RFPADDR = 1001;
    public static final int IS_ACTIVEFLAG = 1002;
    public static final int IS_TEXT = 101;
    public static final int IS_NUMBER = 102;
    public static final int IS_LIST = 103;
    public static final int IS_BOOL = 104;
    public static final int IS_MAC = 105;
    public static final int IS_1BYTE = 106;
    public static final int IS_2BYTE = 107;
    public static final int IS_PAGING_AREA = 109;
    public static final int IS_WLAN_PROFILE = 110;
    public static final int IS_WLAN_ANTENNA = 111;
    public static final int IS_WLAN_CHANNEL_BG = 112;
    public static final int IS_WLAN_POWER = 113;
    public static final int IS_CLUSTER = 114;
    public static final int IS_SITE = 115;
    public static final int IS_HW_TYPE = 116;
    public static final String OPSB_STR_UNASSIGNED = "unassigned";
    protected boolean instruction_allowed;
    protected boolean instruction_set_ok = true;
    protected boolean mandatory_field = false;
    protected boolean mandatory_ignore = false;
    protected int max_value_len;
    protected String default_value = null;
    public static boolean system_out = false;

    public OpsbInstrElem(String string, int n, int n2) {
        this.identifier = string;
        this.param_type = n2;
        this.max_value_len = n;
        this.parse_info = " " + OpsbPreStorageBase.text.getCurrentLang("instr_not_set", OpsbPreStorageBase.language) + ": ";
        this.parse_info = this.parse_info.concat(this.identifier);
    }

    public OpsbInstrElem(String string, int n) {
        this.identifier = string;
        this.param_type = 101;
        this.max_value_len = n;
        this.parse_info = " " + OpsbPreStorageBase.text.getCurrentLang("instr_not_set", OpsbPreStorageBase.language) + ": ";
        this.parse_info = this.parse_info.concat(this.identifier);
    }

    public OpsbInstrElem(int n, int n2) {
        this.identifier = "";
        this.param_type = n2;
        this.max_value_len = n;
    }

    public OpsbInstrElem(int n) {
        this.identifier = "";
        this.param_type = 101;
        this.max_value_len = n;
    }

    public boolean setToMandatoryField(boolean bl) {
        this.mandatory_field = bl;
        return true;
    }

    public boolean ignoreMandatory(boolean bl) {
        this.mandatory_ignore = bl;
        return true;
    }

    public boolean setToCommonField() {
        this.instr = COMMON_FIELD;
        return true;
    }

    public boolean isMandatoryField() {
        return this.mandatory_field;
    }

    public void setDefaultValue(String string) {
        this.default_value = string;
    }

    public static String isInstr(String string, String string2) {
        String string3 = "";
        if (string2.length() > 0 && string.startsWith(string2)) {
            string3 = string.substring(string2.length());
            string3 = OpsbInstrElem.extractInstrValue(string3);
        }
        return string3;
    }

    public boolean instrSet(String string) {
        String string2 = "";
        boolean bl = true;
        this.value = string;
        if (this.instr != COMMON_FIELD) {
            this.parse_info = " invalid instruction type: ";
            this.instruction_set_ok = false;
        } else if (this.value.length() > 0) {
            string2 = this.valid_value(this.value);
            if (string2.length() == 0) {
                this.parse_info = " " + OpsbPreStorageBase.text.getCurrentLang("instr_ok", OpsbPreStorageBase.language) + ": ";
                bl = true;
            } else {
                this.parse_info = " " + OpsbPreStorageBase.text.getCurrentLang("instr_not_ok", OpsbPreStorageBase.language) + ": ";
                this.instruction_set_ok = false;
                bl = false;
            }
        } else {
            this.parse_info = " " + OpsbPreStorageBase.text.getCurrentLang("instr_not_ok", OpsbPreStorageBase.language) + ": ";
            this.instruction_set_ok = false;
            bl = false;
        }
        this.parse_info = this.parse_info + this.identifier + " = " + this.value + string2;
        return bl;
    }

    public String instrEvalValue() {
        if (this.instr == COMMON_FIELD) {
            if (this.value.length() > 0) {
                return this.value;
            }
            if (this.default_value != null && this.default_value.length() > 0) {
                return this.default_value;
            }
        }
        return "";
    }

    public String instrGetIdentifier() {
        return this.identifier;
    }

    public String instrGetParseInfo() {
        return this.parse_info;
    }

    public int instrGetValueLen() {
        return this.max_value_len;
    }

    public String valid_value(String string) {
        String string2;
        if (string.length() == 0 && this.mandatory_field && !this.mandatory_ignore) {
            string2 = " " + OpsbPreStorageBase.text.getCurrentLang("instr_mandatory", OpsbPreStorageBase.language);
        } else if (string.length() > this.max_value_len) {
            string2 = " " + OpsbPreStorageBase.text.getCurrentLang("instr_too_long", OpsbPreStorageBase.language);
        } else {
            switch (this.param_type) {
                case 102: {
                    string2 = this.validate_number(string);
                    break;
                }
                case 101: {
                    string2 = this.validate_string(string);
                    break;
                }
                case 103: {
                    string2 = this.validate_list(string);
                    break;
                }
                case 104: 
                case 1002: {
                    string2 = this.validate_bool(string);
                    break;
                }
                case 105: 
                case 1000: {
                    string2 = this.validate_mac(string);
                    break;
                }
                case 106: {
                    string2 = this.validate_1byte(string);
                    break;
                }
                case 107: {
                    string2 = this.validate_2byte(string);
                    break;
                }
                case 109: {
                    string2 = this.validate_paging_area(string);
                    break;
                }
                case 115: {
                    string2 = this.validate_site(string);
                    break;
                }
                case 114: {
                    string2 = this.validate_cluster(string);
                    break;
                }
                case 110: {
                    string2 = this.validate_wlan_profile(string);
                    break;
                }
                case 111: {
                    string2 = this.validate_wlan_antenna(string);
                    break;
                }
                case 112: {
                    string2 = this.validate_wlan_channel_bg(string);
                    break;
                }
                case 113: {
                    string2 = this.validate_wlan_power(string);
                    break;
                }
                case 116: {
                    string2 = this.validate_hw_type(string);
                    break;
                }
                default: {
                    string2 = " corrupt instruction definitions";
                }
            }
        }
        return string2;
    }

    public boolean singleInstrSetOk() {
        return this.instruction_set_ok;
    }

    public static String extractInstrValue(String string) {
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.length() >= 3 && string.substring(0, 3).equals(" = ")) {
            string = "=" + string.substring(3);
        }
        int n = 0;
        if (system_out) {
            System.out.println(":extractInstrValue: " + string);
        }
        if (string.length() <= 0) {
            return "";
        }
        do {
            if (string.charAt(n) != '=') continue;
            bl = true;
            if (!system_out) continue;
            System.out.println(":extractInstrValue: go on");
        } while (!bl && ++n < string.length());
        if (bl && n < string.length()) {
            do {
                if (!bl2) {
                    if (string.charAt(n) == '#') continue;
                    bl2 = true;
                    string2 = string2 + string.charAt(n);
                    if (!system_out) continue;
                    System.out.println(":extractInstrValue: collect_text==false: " + string2);
                    continue;
                }
                if (bl3) continue;
                if (string.charAt(n) == '#') {
                    bl3 = true;
                    if (!system_out) continue;
                    System.out.println(":extractInstrValue: text_comolete==true: " + string2);
                    continue;
                }
                string2 = string2 + string.charAt(n);
                if (!system_out) continue;
                System.out.println(":extractInstrValue: collect_text==true: " + string2);
            } while (++n < string.length() && !bl3);
        }
        if (system_out) {
            System.out.println(":extractInstrValue: value =" + string2);
        }
        return string2;
    }

    protected String validate_number(String string) {
        String string2 = "";
        block3: for (int i = 0; i < string.length() && string2.length() == 0; ++i) {
            switch (string.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block3;
                }
                default: {
                    string2 = " " + OpsbPreStorageBase.text.getCurrentLang("instr_number", OpsbPreStorageBase.language);
                }
            }
        }
        return string2;
    }

    protected String validate_string(String string) {
        return "";
    }

    protected String validate_list(String string) {
        return "";
    }

    protected String validate_bool(String string) {
        int n = string.length();
        if (n == 0) {
            return "";
        }
        if (n == 1 ? string.equals("0") || string.equals("1") : string.compareToIgnoreCase("true") == 0 || string.compareToIgnoreCase("false") == 0) {
            return "";
        }
        return " " + OpsbPreStorageBase.text.getCurrentLang("instr_bool", OpsbPreStorageBase.language);
    }

    protected String validate_mac(String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        while (n < string.length() && n2 < 6 && string2.length() == 0) {
            int n3 = 0;
            while (n < string.length() && string.charAt(n) != '-' && string.charAt(n) != ':' && string2.length() == 0 && n3 <= 2) {
                ++n3;
                switch (string.charAt(n)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        if (n3 != 1) break;
                        ++n2;
                        break;
                    }
                    default: {
                        string2 = " " + OpsbPreStorageBase.text.getCurrentLang("instr_mac", OpsbPreStorageBase.language);
                    }
                }
                ++n;
            }
            if (n3 > 2 && string2.length() == 0 && n < string.length()) {
                string2 = " " + OpsbPreStorageBase.text.getCurrentLang("instr_mac", OpsbPreStorageBase.language);
                continue;
            }
            if (n3 == 0 && string2.length() == 0 && n < string.length() && (string.charAt(n) == '-' || string.charAt(n) == ':')) {
                string2 = " " + OpsbPreStorageBase.text.getCurrentLang("instr_mac", OpsbPreStorageBase.language);
                continue;
            }
            if (n >= string.length() || string.charAt(n) != '-' && string.charAt(n) != ':') continue;
            ++n;
        }
        if (string.length() > 0 && n2 < 6 && string2.length() == 0) {
            string2 = " " + OpsbPreStorageBase.text.getCurrentLang("instr_mac", OpsbPreStorageBase.language);
        } else if (string.length() > n && string2.length() == 0) {
            string2 = " " + OpsbPreStorageBase.text.getCurrentLang("instr_mac", OpsbPreStorageBase.language);
        } else if (string.length() > 0 && (string.charAt(string.length() - 1) == '-' || string.charAt(string.length() - 1) == ':')) {
            string2 = " " + OpsbPreStorageBase.text.getCurrentLang("instr_mac", OpsbPreStorageBase.language);
        }
        return string2;
    }

    protected String validate_1byte(String string) {
        return "";
    }

    protected String validate_2byte(String string) {
        int n = 0;
        String string2 = "";
        for (int i = 0; i < string.length() && string2.length() == 0 && n <= 65535; ++i) {
            n = 10 * n;
            switch (string.charAt(i)) {
                case '0': {
                    break;
                }
                case '1': {
                    ++n;
                    break;
                }
                case '2': {
                    n += 2;
                    break;
                }
                case '3': {
                    n += 3;
                    break;
                }
                case '4': {
                    n += 4;
                    break;
                }
                case '5': {
                    n += 5;
                    break;
                }
                case '6': {
                    n += 6;
                    break;
                }
                case '7': {
                    n += 7;
                    break;
                }
                case '8': {
                    n += 8;
                    break;
                }
                case '9': {
                    n += 9;
                    break;
                }
                default: {
                    string2 = " " + OpsbPreStorageBase.text.getCurrentLang("instr_2byte", OpsbPreStorageBase.language);
                }
            }
            if (n <= 65535) continue;
            string2 = " " + OpsbPreStorageBase.text.getCurrentLang("instr_2byte", OpsbPreStorageBase.language);
        }
        return string2;
    }

    protected String validate_paging_area(String string) {
        if (string.length() == 0) {
            return "";
        }
        if (string.compareToIgnoreCase(OPSB_STR_UNASSIGNED) == 0) {
            return "";
        }
        try {
            int n = Integer.parseInt(string);
            if (n >= -1 && n <= 127) {
                return "";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return " " + OpsbPreStorageBase.text.getCurrentLang("instr_number", OpsbPreStorageBase.language);
    }

    protected String validate_site(String string) {
        if (string.length() == 0) {
            return "";
        }
        try {
            int n = Integer.parseInt(string);
            if (n >= 1 && n <= 250) {
                return "";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return " " + OpsbPreStorageBase.text.getCurrentLang("instr_number", OpsbPreStorageBase.language);
    }

    protected String validate_cluster(String string) {
        if (string.length() == 0) {
            return "";
        }
        try {
            int n = Integer.parseInt(string);
            if (n >= 1 && n <= 4096) {
                return "";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return " " + OpsbPreStorageBase.text.getCurrentLang("instr_number", OpsbPreStorageBase.language);
    }

    protected String validate_wlan_profile(String string) {
        if (string.length() == 0) {
            return "";
        }
        try {
            if (Integer.parseInt(string) > 0) {
                return "";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return " " + OpsbPreStorageBase.text.getCurrentLang("instr_number", OpsbPreStorageBase.language);
    }

    protected String validate_wlan_antenna(String string) {
        if (string.length() == 0) {
            return "";
        }
        try {
            switch (Integer.parseInt(string)) {
                case 0: 
                case 1: 
                case 2: {
                    return "";
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return " " + OpsbPreStorageBase.text.getCurrentLang("instr_number", OpsbPreStorageBase.language);
    }

    protected String validate_wlan_channel_bg(String string) {
        if (string.length() == 0) {
            return "";
        }
        try {
            int n = Integer.parseInt(string);
            if (n >= 1 && n <= 255) {
                return "";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return " " + OpsbPreStorageBase.text.getCurrentLang("instr_number", OpsbPreStorageBase.language);
    }

    protected String validate_wlan_power(String string) {
        if (string.length() == 0) {
            return "";
        }
        try {
            switch (Integer.parseInt(string)) {
                case 6: 
                case 12: 
                case 25: 
                case 50: 
                case 100: {
                    return "";
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return " " + OpsbPreStorageBase.text.getCurrentLang("instr_number", OpsbPreStorageBase.language);
    }

    protected String validate_hw_type(String string) {
        if (string.length() == 0) {
            return "";
        }
        try {
            int n = Integer.parseInt(string);
            if (n == 0 || n >= 31 && n <= 37 || n >= 41 && n <= 43) {
                return "";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return " " + OpsbPreStorageBase.text.getCurrentLang("instr_number", OpsbPreStorageBase.language);
    }
}

