/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.style;

import com.aastra.style.AastraCheckBox;
import com.aastra.style.AastraCommon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class AastraHeadRenderer
extends JButton
implements TableCellRenderer {
    private static final long serialVersionUID = 1774856560819543668L;
    private final AastraCheckBox cb = new AastraCheckBox();
    private final Icon ascIcon;
    private final Icon descIcon;
    private final Icon cbIcon;
    private final JLabel icon;
    private final JLabel ic;

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        RowSorter.SortKey sortKey;
        Object object2;
        Object object3;
        if (jTable != null) {
            object3 = jTable.getTableHeader();
            if (object3 != null) {
                this.setForeground(((Component)object3).getForeground());
                this.setBackground(Color.white);
                this.setFont(AastraCommon.AastraFontCommon);
                this.setForeground(AastraCommon.AastraColorTableHeader);
            }
            this.icon.setIcon(null);
            this.ic.setIcon(null);
            if (jTable.convertColumnIndexToModel(n2) == 0 && jTable.getSelectionModel().getSelectionMode() != 0) {
                this.ic.setIcon(this.cbIcon);
                this.add(this.ic);
                this.setText("");
                return this;
            }
        }
        if ((object2 = (object3 = jTable.getRowSorter().getSortKeys()).iterator()).hasNext() && (sortKey = (RowSorter.SortKey)object2.next()).getColumn() == jTable.convertColumnIndexToModel(n2)) {
            SortOrder sortOrder = sortKey.getSortOrder();
            this.icon.setIcon(sortOrder == SortOrder.ASCENDING ? this.ascIcon : this.descIcon);
        }
        Object object4 = object2 = object == null ? "" : object.toString();
        if (this.icon.getIcon() != null) {
            this.add(this.icon);
        } else {
            this.remove(this.icon);
        }
        this.setText((String)object2);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }

    TableCellEditor getCellEditor() {
        return (TableCellEditor)((Object)this.cb);
    }

    public AastraHeadRenderer(JTableHeader jTableHeader) {
        jTableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel;
                int n;
                JTable jTable = ((JTableHeader)mouseEvent.getSource()).getTable();
                int n2 = jTable.convertColumnIndexToModel(n = (tableColumnModel = jTable.getColumnModel()).getColumnIndexAtX(mouseEvent.getX()));
                if (n2 == 0 && jTable.getSelectionModel().getSelectionMode() != 0) {
                    AastraHeadRenderer.this.cb.setSelected(!AastraHeadRenderer.this.cb.isSelected());
                    Boolean bl = AastraHeadRenderer.this.cb.isSelected();
                    if (bl.booleanValue()) {
                        jTable.selectAll();
                    } else if (jTable.getRowCount() > 0) {
                        jTable.removeRowSelectionInterval(0, jTable.getRowCount() - 1);
                    }
                    ((JTableHeader)mouseEvent.getSource()).repaint();
                }
            }
        });
        this.ascIcon = UIManager.getIcon("Table.ascendingSortIcon");
        this.descIcon = UIManager.getIcon("Table.descendingSortIcon");
        this.cbIcon = new Icon(){
            Icon wrapped = AastraCheckBox.iconUnselected;
            Icon selected = AastraCheckBox.iconSelected;

            @Override
            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                graphics.fillRect(n + 4, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
                if (AastraHeadRenderer.this.cb.isSelected()) {
                    this.selected.paintIcon(AastraHeadRenderer.this.cb, graphics, n + 4, n2);
                } else {
                    this.wrapped.paintIcon(AastraHeadRenderer.this.cb, graphics, n + 4, n2);
                }
            }

            @Override
            public int getIconWidth() {
                return this.wrapped.getIconWidth() + 4;
            }

            @Override
            public int getIconHeight() {
                return this.wrapped.getIconHeight();
            }
        };
        this.icon = new JLabel();
        this.ic = new JLabel();
        this.setHorizontalAlignment(0);
    }

    public void setAllSelect(boolean bl) {
        this.cb.setSelected(bl);
    }
}

