/*
 * Decompiled with CFR 0.152.
 */
package OPSB;

import OPSB.PreStorageBase;

public class RfpLocInstrElem {
    public static int NONE = 0;
    public static int GET_FIELD = 1;
    public static int COMMON_FIELD = 2;
    public static int INCREMENT_FIELD = 3;
    public static int INCREMENT_MAXIMUM = 4;
    public String value = "";
    public int instr = NONE;
    public String parse_info = "";
    public String identifier;
    public int param_type;
    public static final int IS_RFPMAC = 1000;
    public static final int IS_RFPADDR = 1001;
    public static final int IS_ACTIVEFLAG = 1002;
    public static final int IS_IPADDR = 100;
    public static final int IS_TEXT = 101;
    public static final int IS_NUMBER = 102;
    public static final int IS_LIST = 103;
    public static final int IS_BOOL = 104;
    public static final int IS_MAC = 105;
    public static final int IS_1BYTE = 106;
    public static final int IS_2BYTE = 107;
    public static final int IS_IPADDR_LIST = 108;
    protected boolean instruction_allowed;
    protected boolean instruction_set_ok = true;
    protected boolean mandatory_field = false;
    protected boolean mandatory_ignore = false;
    protected int max_value_len;
    public static boolean system_out = false;

    public RfpLocInstrElem(String string, int n, int n2) {
        this.identifier = string;
        this.param_type = n2;
        this.max_value_len = n;
        this.parse_info = " " + PreStorageBase.text.getCurrentLang("instr_not_set", PreStorageBase.language) + ": ";
        this.parse_info = this.parse_info.concat(this.identifier);
    }

    public RfpLocInstrElem(String string, int n) {
        this.identifier = string;
        this.param_type = 101;
        this.max_value_len = n;
        this.parse_info = " " + PreStorageBase.text.getCurrentLang("instr_not_set", PreStorageBase.language) + ": ";
        this.parse_info = this.parse_info.concat(this.identifier);
    }

    public RfpLocInstrElem(int n, int n2) {
        this.identifier = "";
        this.param_type = n2;
        this.max_value_len = n;
    }

    public RfpLocInstrElem(int n) {
        this.identifier = "";
        this.param_type = 101;
        this.max_value_len = n;
    }

    public static String isInstr(String string, String string2) {
        String string3 = "";
        if (string2.length() > 0 && string.startsWith(string2)) {
            string3 = string.substring(string2.length());
            string3 = RfpLocInstrElem.extractInstrValue(string3);
        }
        return string3;
    }

    public boolean instrSet(String string) {
        String string2 = "";
        boolean bl = true;
        this.value = string;
        if (this.instr != COMMON_FIELD) {
            this.parse_info = " invalid instruction type: ";
            this.instruction_set_ok = false;
        } else if (this.value.length() > 0) {
            string2 = this.valid_value(this.value);
            if (string2.length() == 0) {
                this.parse_info = " " + PreStorageBase.text.getCurrentLang("instr_ok", PreStorageBase.language) + ": ";
                bl = true;
            } else {
                this.parse_info = " " + PreStorageBase.text.getCurrentLang("instr_not_ok", PreStorageBase.language) + ": ";
                this.instruction_set_ok = false;
                bl = false;
            }
        } else {
            this.parse_info = " " + PreStorageBase.text.getCurrentLang("instr_not_ok", PreStorageBase.language) + ": ";
            this.instruction_set_ok = false;
            bl = false;
        }
        this.parse_info = this.parse_info + this.identifier + " = " + this.value + string2;
        return bl;
    }

    public String instrEvalValue() {
        if (this.instr == COMMON_FIELD) {
            return this.value;
        }
        return "";
    }

    public int instrGetTask() {
        return this.instr;
    }

    public String instrGetValue() {
        return this.value;
    }

    public String instrGetIdentifier() {
        return this.identifier;
    }

    public String instrGetParseInfo() {
        return this.parse_info;
    }

    public int instrGetValueLen() {
        return this.max_value_len;
    }

    public String valid_value(String string) {
        String string2;
        if (string.length() == 0 && this.mandatory_field && !this.mandatory_ignore) {
            string2 = " " + PreStorageBase.text.getCurrentLang("instr_mandatory", PreStorageBase.language);
        } else if (string.length() > this.max_value_len) {
            string2 = " " + PreStorageBase.text.getCurrentLang("instr_too_long", PreStorageBase.language);
        } else {
            switch (this.param_type) {
                case 100: 
                case 1001: {
                    string2 = this.validate_ipaddr(string);
                    break;
                }
                case 102: {
                    string2 = this.validate_number(string);
                    break;
                }
                case 101: {
                    string2 = this.validate_string(string);
                    break;
                }
                case 103: {
                    string2 = this.validate_list(string);
                    break;
                }
                case 104: 
                case 1002: {
                    string2 = this.validate_bool(string);
                    break;
                }
                case 105: 
                case 1000: {
                    string2 = this.validate_mac(string);
                    break;
                }
                case 106: {
                    string2 = this.validate_1byte(string);
                    break;
                }
                case 107: {
                    string2 = this.validate_2byte(string);
                    break;
                }
                case 108: {
                    string2 = this.validate_ip_addr_list(string);
                    break;
                }
                default: {
                    string2 = " corrupt instruction definitions";
                }
            }
        }
        return string2;
    }

    public boolean setToMandatoryField(boolean bl) {
        this.mandatory_field = bl;
        return true;
    }

    public boolean ignoreMandatory(boolean bl) {
        this.mandatory_ignore = bl;
        return true;
    }

    public boolean setToCommonField() {
        this.instr = COMMON_FIELD;
        return true;
    }

    public boolean isMandatoryField() {
        return this.mandatory_field;
    }

    public boolean singleInstrSetOk() {
        return this.instruction_set_ok;
    }

    public static String extractInstrValue(String string) {
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        if (system_out) {
            System.out.println(":extractInstrValue: " + string);
        }
        if (string.length() <= 0) {
            return "";
        }
        do {
            if (string.charAt(n) != '=') continue;
            bl = true;
            if (!system_out) continue;
            System.out.println(":extractInstrValue: go on");
        } while (!bl && ++n < string.length());
        if (bl && n < string.length()) {
            do {
                if (!bl2) {
                    if (string.charAt(n) == ' ' || string.charAt(n) == '#') continue;
                    bl2 = true;
                    string2 = string2 + string.charAt(n);
                    if (!system_out) continue;
                    System.out.println(":extractInstrValue: collect_text==false: " + string2);
                    continue;
                }
                if (bl3) continue;
                if (string.charAt(n) == ' ' || string.charAt(n) == '#') {
                    bl3 = true;
                    if (!system_out) continue;
                    System.out.println(":extractInstrValue: text_comolete==true: " + string2);
                    continue;
                }
                string2 = string2 + string.charAt(n);
                if (!system_out) continue;
                System.out.println(":extractInstrValue: collect_text==true: " + string2);
            } while (++n < string.length() && !bl3);
        }
        if (system_out) {
            System.out.println(":extractInstrValue: value =" + string2);
        }
        return string2;
    }

    protected String validate_ipaddr(String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        while (n < string.length() && n2 < 4 && string2.length() == 0) {
            int n3 = 0;
            while (n < string.length() && string.charAt(n) != '.' && string2.length() == 0 && n3 <= 3) {
                ++n3;
                switch (string.charAt(n)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (n3 != 1) break;
                        ++n2;
                        break;
                    }
                    default: {
                        string2 = " " + PreStorageBase.text.getCurrentLang("instr_ip_addr", PreStorageBase.language);
                    }
                }
                ++n;
            }
            if (n3 > 3 && string2.length() == 0 && n < string.length()) {
                string2 = " " + PreStorageBase.text.getCurrentLang("instr_ip_addr", PreStorageBase.language);
                continue;
            }
            if (n3 == 0 && string2.length() == 0 && n < string.length() && string.charAt(n) == '.') {
                string2 = " " + PreStorageBase.text.getCurrentLang("instr_ip_addr", PreStorageBase.language);
                continue;
            }
            if (n >= string.length() || string.charAt(n) != '.') continue;
            ++n;
        }
        if (string.length() > 0 && n2 < 4 && string2.length() == 0) {
            string2 = " " + PreStorageBase.text.getCurrentLang("instr_ip_addr", PreStorageBase.language);
        } else if (string.length() > n && string2.length() == 0) {
            string2 = " " + PreStorageBase.text.getCurrentLang("instr_ip_addr", PreStorageBase.language);
        } else if (string.length() > 0 && string.charAt(string.length() - 1) == '.') {
            string2 = " " + PreStorageBase.text.getCurrentLang("instr_ip_addr", PreStorageBase.language);
        }
        return string2;
    }

    protected String validate_number(String string) {
        String string2 = "";
        block3: for (int i = 0; i < string.length() && string2.length() == 0; ++i) {
            switch (string.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block3;
                }
                default: {
                    string2 = " " + PreStorageBase.text.getCurrentLang("instr_number", PreStorageBase.language);
                }
            }
        }
        return string2;
    }

    protected String validate_string(String string) {
        return "";
    }

    protected String validate_list(String string) {
        return "";
    }

    protected String validate_bool(String string) {
        String string2 = "";
        if (string.length() > 0 && string.length() == 1 && string.charAt(0) != '1' && string.charAt(0) != '0') {
            string2 = " " + PreStorageBase.text.getCurrentLang("instr_bool", PreStorageBase.language);
        }
        return string2;
    }

    protected String validate_mac(String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        while (n < string.length() && n2 < 6 && string2.length() == 0) {
            int n3 = 0;
            while (n < string.length() && string.charAt(n) != '-' && string.charAt(n) != ':' && string2.length() == 0 && n3 <= 2) {
                ++n3;
                switch (string.charAt(n)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        if (n3 != 1) break;
                        ++n2;
                        break;
                    }
                    default: {
                        string2 = " " + PreStorageBase.text.getCurrentLang("instr_mac", PreStorageBase.language);
                    }
                }
                ++n;
            }
            if (n3 > 2 && string2.length() == 0 && n < string.length()) {
                string2 = " " + PreStorageBase.text.getCurrentLang("instr_mac", PreStorageBase.language);
                continue;
            }
            if (n3 == 0 && string2.length() == 0 && n < string.length() && (string.charAt(n) == '-' || string.charAt(n) == ':')) {
                string2 = " " + PreStorageBase.text.getCurrentLang("instr_mac", PreStorageBase.language);
                continue;
            }
            if (n >= string.length() || string.charAt(n) != '-' && string.charAt(n) != ':') continue;
            ++n;
        }
        if (string.length() > 0 && n2 < 6 && string2.length() == 0) {
            string2 = " " + PreStorageBase.text.getCurrentLang("instr_mac", PreStorageBase.language);
        } else if (string.length() > n && string2.length() == 0) {
            string2 = " " + PreStorageBase.text.getCurrentLang("instr_mac", PreStorageBase.language);
        } else if (string.length() > 0 && (string.charAt(string.length() - 1) == '-' || string.charAt(string.length() - 1) == ':')) {
            string2 = " " + PreStorageBase.text.getCurrentLang("instr_mac", PreStorageBase.language);
        }
        return string2;
    }

    protected String validate_1byte(String string) {
        return "";
    }

    protected String validate_2byte(String string) {
        int n = 0;
        String string2 = "";
        for (int i = 0; i < string.length() && string2.length() == 0 && n <= 65535; ++i) {
            n = 10 * n;
            switch (string.charAt(i)) {
                case '0': {
                    break;
                }
                case '1': {
                    ++n;
                    break;
                }
                case '2': {
                    n += 2;
                    break;
                }
                case '3': {
                    n += 3;
                    break;
                }
                case '4': {
                    n += 4;
                    break;
                }
                case '5': {
                    n += 5;
                    break;
                }
                case '6': {
                    n += 6;
                    break;
                }
                case '7': {
                    n += 7;
                    break;
                }
                case '8': {
                    n += 8;
                    break;
                }
                case '9': {
                    n += 9;
                    break;
                }
                default: {
                    string2 = " " + PreStorageBase.text.getCurrentLang("instr_2byte", PreStorageBase.language);
                }
            }
            if (n <= 65535) continue;
            string2 = " " + PreStorageBase.text.getCurrentLang("instr_2byte", PreStorageBase.language);
        }
        return string2;
    }

    protected String validate_ip_addr_list(String string) {
        return "";
    }
}

