/*
 * Decompiled with CFR 0.152.
 */
package OPSB;

import OPSB.PreStorageBase;
import OPSB.RecordLocRfp;
import OPSB.RfpLocInstrFields;

public class RfpLocStorageBase
extends PreStorageBase {
    static int NO_OF_NOT_COMMON_FIELDS = 2;
    RfpLocInstrFields m_instrFields;

    public RfpLocStorageBase(String string) {
        super(string);
        this.m_max_sequence_fields = RecordLocRfp.MAX;
        this.m_max_instruction_fields = RfpLocInstrFields.MAX;
        this.m_sequenceLine = new String[this.m_max_sequence_fields];
    }

    public RfpLocStorageBase(String string, String string2) {
        super(string, string2);
        this.m_max_sequence_fields = RecordLocRfp.MAX;
        this.m_max_instruction_fields = RfpLocInstrFields.MAX;
        this.m_sequenceLine = new String[this.m_max_sequence_fields];
    }

    @Override
    protected void resetInstructions() {
        this.m_instrFields = new RfpLocInstrFields(this.m_max_instruction_fields);
    }

    @Override
    protected boolean addRecord() {
        RecordLocRfp recordLocRfp = new RecordLocRfp();
        if (this.CrossCheckMacIp(this.m_sequenceLine)) {
            if (recordLocRfp.parseAndSetFields(this.m_sequenceLine, this.writeReadPreDataProtFile, this.m_data_record_sequence_counter)) {
                this.rfpRecords.addElement(recordLocRfp);
            } else {
                this.m_error_no = 1;
            }
        } else {
            this.m_error_no = 1;
        }
        ++this.m_data_record_sequence_counter;
        return true;
    }

    @Override
    protected boolean changeRecord() {
        boolean bl = false;
        boolean bl2 = true;
        int n = RecordLocRfp.MAC_ADDR;
        if (this.rfpRecords == null) {
            return false;
        }
        for (int i = 0; i < this.rfpRecords.size() && !bl; ++i) {
            RecordLocRfp recordLocRfp = (RecordLocRfp)this.rfpRecords.get(i);
            if (this.m_sequenceLine[RecordLocRfp.MAC_ADDR].compareTo(recordLocRfp.data[RecordLocRfp.MAC_ADDR]) != 0) continue;
            bl = true;
            do {
                String string;
                if (this.m_sequenceLine[n].length() <= 0 && n >= RecordLocRfp.ACTIVE_FLAG) {
                    this.m_sequenceLine[n] = recordLocRfp.data[n];
                }
                if ((string = this.parseSequenceField(n, this.m_sequenceLine[n])).length() <= 0) continue;
                this.writeInstrProtFile.println(": " + String.valueOf(this.m_data_record_sequence_counter) + " : " + PreStorageBase.text.getCurrentLang("records_error", PreStorageBase.language) + ": " + PreStorageBase.text.getCurrentLang("parse_fields", PreStorageBase.language) + " " + String.valueOf(n + 1) + " : " + string);
                this.m_error_no = 1;
                bl2 = false;
            } while (++n < this.m_max_sequence_fields);
            if (!bl2) continue;
            recordLocRfp.parseAndChangeFields(this.m_sequenceLine, this.writeReadPreDataProtFile, this.m_data_record_sequence_counter);
        }
        if (!bl && bl2) {
            this.writeInstrProtFile.println(": " + String.valueOf(this.m_data_record_sequence_counter) + " : " + PreStorageBase.text.getCurrentLang("records_error", PreStorageBase.language) + ": " + PreStorageBase.text.getCurrentLang("records_mac", PreStorageBase.language) + this.m_sequenceLine[RecordLocRfp.MAC_ADDR] + " " + PreStorageBase.text.getCurrentLang("records_not_found", PreStorageBase.language));
            this.m_error_no = 1;
        }
        ++this.m_data_record_sequence_counter;
        return true;
    }

    @Override
    public String[] getRecord(int n) {
        if (this.rfpRecords == null) {
            return null;
        }
        if (n < this.rfpRecords.size()) {
            RecordLocRfp recordLocRfp = (RecordLocRfp)this.rfpRecords.get(n);
            return recordLocRfp.data;
        }
        return null;
    }

    @Override
    public String getField(int n, int n2) {
        if (this.rfpRecords == null || this.m_only_mac_list) {
            return "";
        }
        if (n < this.rfpRecords.size()) {
            RecordLocRfp recordLocRfp = (RecordLocRfp)this.rfpRecords.get(n);
            return recordLocRfp.getField(n2);
        }
        return "";
    }

    @Override
    public String instrGetParseInfo(int n) {
        return this.m_instrFields.elem[n].instrGetParseInfo();
    }

    @Override
    public boolean instrOk(int n) {
        return this.m_instrFields.elem[n].singleInstrSetOk();
    }

    @Override
    public String getInstrValue(int n) {
        return this.m_instrFields.elem[n].instrGetValue();
    }

    @Override
    public void setInstrValue(int n, String string) {
        this.m_instrFields.elem[n].instrSet(string);
    }

    @Override
    public String getInstrIdentifier(int n) {
        return this.m_instrFields.elem[n].instrGetIdentifier();
    }

    @Override
    public int instrGetValueLen(int n) {
        return this.m_instrFields.elem[n].instrGetValueLen();
    }

    @Override
    public String instrEvalValue(int n) {
        return this.m_instrFields.elem[n].instrEvalValue();
    }

    @Override
    public String parseSequenceField(int n, String string) {
        return this.m_instrFields.elem[n].valid_value(string);
    }

    @Override
    public int getFieldType(int n) {
        return this.m_instrFields.elem[n].param_type;
    }

    @Override
    public void proceedReviewOfMandatorySettings(String[] stringArray) {
        this.m_instrFields.reviewMandatorySettings(stringArray);
    }
}

