/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg;

import com.aastra.omcfg.GuiSpyConsole;
import com.aastra.omcfg.guiutil.GuiUtilIcon;
import com.aastra.omcfg.util.UtilLocale;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraHeaderBar;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.style.AastraTextPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;

public class GuiInfoConsole
extends AastraPanel {
    private static final long serialVersionUID = 1L;
    private static AastraTextPane textPane = null;
    private AastraScrollPane scrollPane = null;
    private AastraHeaderBar headerBar = null;
    private AastraLabel labelInfoConsole = null;

    public GuiInfoConsole() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getHeaderBar(), "North");
        this.add((Component)this.getScrollPane(), "Center");
    }

    private AastraTextPane getTextPane() {
        if (textPane == null) {
            textPane = new AastraTextPane();
            textPane.setEditable(false);
            textPane.setFont(AastraCommon.AastraFontInfoConsole);
        }
        return textPane;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new AastraScrollPane(this.getTextPane());
            this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        return this.scrollPane;
    }

    private AastraHeaderBar getHeaderBar() {
        if (this.headerBar == null) {
            this.labelInfoConsole = new AastraLabel();
            this.labelInfoConsole.setText(" " + UtilLocale.getString("TXT_INFO_CONSOLE"));
            this.labelInfoConsole.setFont(AastraCommon.AastraFontHeader);
            this.labelInfoConsole.setForeground(AastraCommon.AastraColorMenuFg);
            this.headerBar = new AastraHeaderBar();
            this.headerBar.setPreferredSize(new Dimension(0, 30));
            this.headerBar.add(this.labelInfoConsole);
        }
        return this.headerBar;
    }

    public static void showInfo(String string) {
        GuiInfoConsole.showMessage(MessageTypeEnum.InfoMessage, string);
    }

    public static void showWarning(String string) {
        GuiInfoConsole.showMessage(MessageTypeEnum.WarningMessage, string);
    }

    public static void showError(String string) {
        GuiInfoConsole.showMessage(MessageTypeEnum.ErrorMessage, string);
    }

    private static void showMessage(MessageTypeEnum messageTypeEnum, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Date date = new Date();
        ImageIcon imageIcon = null;
        switch (messageTypeEnum) {
            default: {
                imageIcon = GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium);
                break;
            }
            case WarningMessage: {
                imageIcon = GuiUtilIcon.getIconWarning(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium);
                break;
            }
            case ErrorMessage: {
                imageIcon = GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium);
            }
        }
        textPane.insertIcon(imageIcon);
        textPane.updateUI();
        String string2 = " " + simpleDateFormat.format(date) + " " + string + "\n";
        StyledDocument styledDocument = textPane.getStyledDocument();
        try {
            styledDocument.insertString(styledDocument.getLength(), string2, null);
            textPane.setCaretPosition(styledDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, GuiSpyConsole.class, "Inserting text in info console failed");
            return;
        }
        int n = 10000;
        int n2 = 500;
        int n3 = styledDocument.getLength() - n;
        if (n3 >= n2) {
            try {
                int n4 = textPane.getText(n3, styledDocument.getLength() - n3).indexOf("\n");
                styledDocument.remove(0, n3 + n4 + 1);
            }
            catch (BadLocationException badLocationException) {
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, GuiSpyConsole.class, "Removing text from info console failed");
            }
        }
    }

    private static enum MessageTypeEnum {
        InfoMessage,
        WarningMessage,
        ErrorMessage;

    }
}

