/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg;

import com.aastra.omcfg.GuiCommon;
import com.aastra.omcfg.GuiInfoConsole;
import com.aastra.omcfg.GuiMenuBar;
import com.aastra.omcfg.GuiSpyConsole;
import com.aastra.omcfg.GuiSpyFile;
import com.aastra.omcfg.GuiStatusBar;
import com.aastra.omcfg.guiutil.GuiUtilDialog;
import com.aastra.omcfg.rfpcfg.RfpPanel;
import com.aastra.omcfg.util.UtilFileHandling;
import com.aastra.omcfg.util.UtilGeneralBooleanSettings;
import com.aastra.omcfg.util.UtilLocale;
import com.aastra.omcfg.util.UtilPreferences;
import com.aastra.omcfg.util.UtilProdInfo;
import com.aastra.omcfg.util.UtilWarnings;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.style.AastraToolBar;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.BitSet;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class GuiMain
extends JFrame
implements ComponentListener {
    public static final boolean USE_LICENSE_SERVER = false;
    private static final long serialVersionUID = 1L;
    private static GuiStatusBar guiStatusBar = null;
    private static GuiMain guiMain = null;
    private static GuiSpyConsole spyConsole = null;
    private static GuiSpyFile spyFile = null;
    private AastraScrollPane guiMainScrollPane = null;
    private AastraPanel guiMainPanel = null;
    private AastraPanel guiTopPanel = null;
    private AastraPanel guiBottomPanel = null;
    private AastraPanel rfpPanel;
    private GuiMenuBar guiMenuBar = null;
    private GuiInfoConsole guiInfoConsole = null;
    private boolean uncaughtExceptionThrown = false;
    AastraToolBar guiToolBar = null;

    public static GuiMain getGuiMainObject() {
        return guiMain;
    }

    public static GuiStatusBar getGuiStatusBarObject() {
        return guiStatusBar;
    }

    private GuiMenuBar getGuiMenuBar() {
        if (this.guiMenuBar == null) {
            this.guiMenuBar = new GuiMenuBar();
        }
        return this.guiMenuBar;
    }

    private GuiStatusBar getGuiStatusBar() {
        if (guiStatusBar == null) {
            guiStatusBar = new GuiStatusBar();
        }
        return guiStatusBar;
    }

    private GuiInfoConsole getGuiInfoConsole() {
        if (this.guiInfoConsole == null) {
            this.guiInfoConsole = new GuiInfoConsole();
        }
        return this.guiInfoConsole;
    }

    private AastraPanel getGuiRfpPanel() {
        if (this.rfpPanel == null) {
            this.rfpPanel = new RfpPanel();
        }
        return this.rfpPanel;
    }

    public static GuiSpyConsole getSpyConsole() {
        if (spyConsole == null) {
            AastraCommon aastraCommon = new AastraCommon();
            spyConsole = new GuiSpyConsole();
            spyConsole.setIconImage(aastraCommon.getCompanyIcon().getImage());
        }
        return spyConsole;
    }

    public static GuiSpyFile getSpyFile() {
        if (spyFile == null) {
            spyFile = new GuiSpyFile();
        }
        return spyFile;
    }

    private AastraPanel getGuiTopPanel() {
        if (this.guiTopPanel == null) {
            this.guiTopPanel = new AastraPanel();
            this.guiTopPanel.setLayout(new BorderLayout());
            this.guiTopPanel.add((Component)this.getGuiToolBar(), "West");
            this.guiTopPanel.add((Component)this.getGuiMenuBar(), "Center");
        }
        return this.guiTopPanel;
    }

    private AastraToolBar getGuiToolBar() {
        if (this.guiToolBar == null) {
            this.guiToolBar = new AastraToolBar();
        }
        return this.guiToolBar;
    }

    private AastraPanel getGuiBottomPanel() {
        if (this.guiBottomPanel == null) {
            this.guiBottomPanel = new AastraPanel();
            this.guiBottomPanel.setPreferredSize(new Dimension(1004, 140));
            this.guiBottomPanel.setLayout(new BorderLayout());
            this.guiBottomPanel.add((Component)this.getGuiInfoConsole(), "Center");
            this.guiBottomPanel.add((Component)this.getGuiStatusBar(), "South");
        }
        return this.guiBottomPanel;
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiMain guiMain = new GuiMain();
                guiMain.setDefaultCloseOperation(0);
                guiMain.setVisible(true);
            }
        });
    }

    public GuiMain() {
        this.addWindowListener(new WindowAction());
        this.addComponentListener(this);
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtExceptionHandler());
        guiMain = this;
        this.initialize();
    }

    private void initialize() {
        UtilFileHandling.createWorkingDirectory();
        if (!UtilProdInfo.isPrivateProduction()) {
            UtilSpy.setOutputInterfaces(GuiMain.getSpyFile(), null);
        } else {
            UtilSpy.setOutputInterfaces(GuiMain.getSpyFile(), GuiMain.getSpyConsole());
        }
        UtilPreferences.readPreferences();
        Dimension dimension = UtilPreferences.getAppSize();
        if (dimension.width > 0 && dimension.height > 0) {
            this.setSize(dimension.width, dimension.height);
        } else {
            this.setSize(1024, 810);
        }
        this.setLocationRelativeTo(null);
        this.initSpy();
        UtilGeneralBooleanSettings.init();
        UtilWarnings.init();
        UtilLocale.initLocale();
        if (spyConsole != null) {
            spyConsole.setTitle();
        }
        AastraCommon aastraCommon = new AastraCommon();
        this.setIconImage(aastraCommon.getCompanyIcon().getImage());
        aastraCommon.init();
        this.setContentPane(this.getGuiMainPanel());
        this.setTitle(GuiCommon.ApplicationNameShort);
        UtilFileHandling.createAppDataDirectory();
    }

    public void initSpy() {
        BitSet bitSet;
        int n = UtilPreferences.getRemainingStarts();
        if (n > 0) {
            UtilPreferences.setRemainingStarts(n - 1);
        }
        if ((bitSet = UtilPreferences.getSpyIds()) != null) {
            UtilSpy.setSpyIds(bitSet);
            if (!UtilProdInfo.isPrivateProduction()) {
                if (n == 0) {
                    UtilSpy.activateAxiMessages(false);
                }
                UtilSpy.activateDebugLevels(false);
                UtilPreferences.setSpyIds(UtilSpy.getSpyIds());
            } else {
                UtilSpy.validateDebugLevels(true);
            }
        } else {
            UtilPreferences.setSpyIds(UtilSpy.getSpyIds());
        }
        if (!UtilProdInfo.isPrivateProduction()) {
            UtilSpy.setSpyClassInfo(false);
            UtilPreferences.setSpyClassInfo(false);
        } else {
            boolean bl = UtilPreferences.getSpyClassInfo();
            if (bl) {
                UtilSpy.setSpyClassInfo(true);
            } else {
                UtilSpy.setSpyClassInfo(false);
            }
        }
        UtilSpy.spySetOutputConfiguration(true, false);
    }

    public AastraScrollPane getGuiMainScrollPane() {
        if (this.guiMainScrollPane == null) {
            this.guiMainScrollPane = new AastraScrollPane(this.getGuiMainPanel());
        }
        return this.guiMainScrollPane;
    }

    private AastraPanel getGuiMainPanel() {
        if (this.guiMainPanel == null) {
            this.guiMainPanel = new AastraPanel();
            this.guiMainPanel.setLayout(new BorderLayout());
            this.guiMainPanel.add((Component)this.getGuiTopPanel(), "North");
            this.guiMainPanel.add((Component)this.getGuiBottomPanel(), "South");
            this.guiMainPanel.add((Component)this.getGuiRfpPanel(), "Center");
        }
        return this.guiMainPanel;
    }

    public void exitApplication(Locale locale) {
        if (spyFile != null) {
            spyFile.close();
        }
        if (locale != null) {
            UtilLocale.setLocale(locale);
        }
        UtilPreferences.collectPreferences();
        UtilPreferences.writePreferences();
        System.exit(0);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        UtilPreferences.setAppSize(this.getSize());
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void showUncaughtExceptionDlg(Thread thread, Throwable throwable) {
        String string = UtilLocale.getString("TXT_UNHANDLED_EXCEPTION_OCCURRED");
        String string2 = spyFile.getFilePath();
        if (this.uncaughtExceptionThrown) {
            return;
        }
        string = string + "<br>" + String.format(UtilLocale.getString("TXT_*_WILL_BE_TERMINATED"), GuiCommon.ApplicationName);
        if (string2 != null) {
            string = string + "<br>" + String.format(UtilLocale.getString("TXT_SEE_FILE_*_FOR_DETAILS"), string2);
        }
        this.uncaughtExceptionThrown = true;
        new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageError, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionOK, string, false);
        this.exitApplication(null);
    }

    public boolean getExceptionStatus() {
        return this.uncaughtExceptionThrown;
    }

    class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        UncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            System.err.println("Unhandled exception by " + thread + ":");
            throwable.printStackTrace();
            GuiMain.this.showUncaughtExceptionDlg(thread, throwable);
        }
    }

    class WindowAction
    extends WindowAdapter {
        WindowAction() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            GuiMain.this.exitApplication(null);
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            GuiMain.this.exitApplication(null);
        }
    }

    public static enum GuiNavPanelTypeEnum {
        GUI_NAV_PANEL_CONFIG,
        GUI_NAV_PANEL_MONITOR,
        GUI_NAV_PANEL_PLANNING;

    }
}

