/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg;

import com.aastra.omcfg.GuiCommon;
import com.aastra.omcfg.GuiMain;
import com.aastra.omcfg.guiutil.GuiUtilDialog;
import com.aastra.omcfg.rfpcfg.EthIf;
import com.aastra.omcfg.util.UtilFileHandling;
import com.aastra.omcfg.util.UtilLocale;
import com.aastra.omcfg.util.UtilPreferences;
import com.aastra.omcfg.util.UtilProdInfo;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCheckBox;
import com.aastra.style.AastraComboBox;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTextField;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class GuiOptionsDlg
extends AastraDialog {
    private static final long serialVersionUID = 1L;
    private GuiMain guiMain = null;
    private AastraPanel panelOptions = null;
    private AastraPanel panelButtonBar = null;
    private AastraPanel tabGeneral = null;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraComboBox comboBoxLanguage = null;
    private AastraComboBox comboBoxInterface = null;
    private AastraTextField textFieldUserDirectory = null;
    private AastraPanel panelGeneral = null;
    private AastraCheckBox[] checkBoxSpyIds = new AastraCheckBox[UtilSpy.SpyIdEnum.values().length];
    private AastraCheckBox checkBoxAdditionalClassInfo = null;
    private Locale currentLocale = null;
    private static String[] spyIdComment = new String[]{"TXT_OM_AXI_LINK_MANAGEMENT", "TXT_OM_AXI_MESSAGES", "TXT_GUI_MESSAGES", "TXT_GUI_DATABASE_OPERATIONS", "TXT_GUI_GENERAL_INFO", "TXT_GUI_RFP_SYNCHRONIZATION_VIEW", "TXT_GUI_STATISTICS", "TXT_GUI_RFP_TREE", "TXT_DATABASE", "TXT_TABLE_HANDLING", "TXT_OM_AXI_XML_PARSER", "TXT_GENERAL_INFO"};

    public GuiOptionsDlg() {
        super(GuiMain.getGuiMainObject());
        this.guiMain = GuiMain.getGuiMainObject();
        this.initialize();
    }

    private void initialize() {
        this.setSize(436, 214);
        this.setLocationRelativeTo(null);
        this.setTitle(UtilLocale.getString("TXT_OPTIONS"));
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setContentPane(this.getPanelOptions());
        this.getRootPane().setDefaultButton(this.getButtonCancel());
        this.addWindowListener(new WindowAction());
    }

    private JPanel getPanelOptions() {
        if (this.panelOptions == null) {
            this.panelOptions = new AastraPanel();
            this.panelOptions.setLayout(new BoxLayout(this.panelOptions, 1));
            this.panelOptions.add(this.getTabGeneral());
            this.panelOptions.add(this.getPanelButtonBar());
        }
        return this.panelOptions;
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(new BoxLayout(this.tabGeneral, 1));
            this.tabGeneral.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabGeneral.add(this.getPanelGeneral());
            this.tabGeneral.add(Box.createRigidArea(new Dimension(0, 10)));
        }
        return this.tabGeneral;
    }

    private AastraPanel getPanelGeneral() {
        if (this.panelGeneral == null) {
            this.panelGeneral = new AastraPanel();
            this.panelGeneral.setAlignmentX(0.0f);
            this.panelGeneral.setLayout(null);
            Dimension dimension = new Dimension(430, 100);
            this.panelGeneral.setPreferredSize(dimension);
            this.panelGeneral.setMaximumSize(dimension);
            this.panelGeneral.setMinimumSize(dimension);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_GENERAL"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelGeneral.setBorder(BorderFactory.createTitledBorder(titledBorder));
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(20, 25, 110, 32);
            aastraLabel.setText("<html>" + UtilLocale.getString("TXT_USER_DIRECTORY") + "</html>");
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(20, 63, 110, 20);
            aastraLabel2.setText("Network Interface");
            this.panelGeneral.add((Component)aastraLabel, null);
            this.panelGeneral.add((Component)aastraLabel2, null);
            this.panelGeneral.add((Component)this.getTextFieldUserDirectory(), null);
            this.panelGeneral.add((Component)this.getComboBoxInterface(), null);
        }
        return this.panelGeneral;
    }

    private AastraComboBox getComboBoxLanguage() {
        if (this.comboBoxLanguage == null) {
            this.comboBoxLanguage = new AastraComboBox();
            this.comboBoxLanguage.setBounds(150, 73, 150, 20);
            for (int i = 0; i < UtilLocale.languages.length; ++i) {
                this.comboBoxLanguage.addItem(UtilLocale.languages[i].getStrLanguage());
            }
            this.currentLocale = UtilPreferences.getLocale();
            UtilLocale.LanguageType languageType = UtilLocale.LanguageType.valueOf(this.currentLocale.getLanguage());
            switch (languageType) {
                default: {
                    this.comboBoxLanguage.setSelectedIndex(UtilLocale.English);
                    break;
                }
                case de: {
                    this.comboBoxLanguage.setSelectedIndex(UtilLocale.German);
                    break;
                }
                case fr: {
                    this.comboBoxLanguage.setSelectedIndex(UtilLocale.French);
                    break;
                }
                case es: {
                    this.comboBoxLanguage.setSelectedIndex(UtilLocale.Spanish);
                }
            }
        }
        return this.comboBoxLanguage;
    }

    private AastraComboBox getComboBoxInterface() {
        if (this.comboBoxInterface == null) {
            this.comboBoxInterface = new AastraComboBox();
            this.comboBoxInterface.setBounds(150, 60, 250, 20);
            Vector<EthIf> vector = EthIf.getNetworkInterfaces();
            Iterator<EthIf> iterator = vector.iterator();
            while (iterator.hasNext()) {
                this.comboBoxInterface.addItem(iterator.next());
            }
            this.comboBoxInterface.setSelectedIndex(EthIf.actualIndex);
        }
        return this.comboBoxInterface;
    }

    private AastraTextField getTextFieldUserDirectory() {
        if (this.textFieldUserDirectory == null) {
            this.textFieldUserDirectory = new AastraTextField();
            this.textFieldUserDirectory.setBounds(150, 25, 250, 20);
            this.textFieldUserDirectory.setEditable(false);
            this.textFieldUserDirectory.setText(UtilFileHandling.getWorkingDirectory());
            this.textFieldUserDirectory.setToolTipText(UtilFileHandling.getWorkingDirectory());
        }
        return this.textFieldUserDirectory;
    }

    private AastraPanel getPanelButtonBar() {
        if (this.panelButtonBar == null) {
            this.panelButtonBar = new AastraPanel();
            this.panelButtonBar.setLayout(null);
            this.panelButtonBar.setPreferredSize(new Dimension(0, 0));
            this.panelButtonBar.add((Component)this.getButtonOK(), null);
            this.panelButtonBar.add((Component)this.getButtonCancel(), null);
        }
        return this.panelButtonBar;
    }

    private JButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(110, 25, 90, 25);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilDialog guiUtilDialog;
                    Locale locale;
                    switch (GuiOptionsDlg.this.comboBoxLanguage.getSelectedIndex()) {
                        default: {
                            locale = UtilLocale.languages[UtilLocale.English].getLocale();
                            break;
                        }
                        case 1: {
                            locale = UtilLocale.languages[UtilLocale.German].getLocale();
                            break;
                        }
                        case 2: {
                            locale = UtilLocale.languages[UtilLocale.French].getLocale();
                            break;
                        }
                        case 3: {
                            locale = UtilLocale.languages[UtilLocale.Spanish].getLocale();
                        }
                    }
                    EthIf ethIf = (EthIf)GuiOptionsDlg.this.comboBoxInterface.getSelectedItem();
                    EthIf.actualAddr = ethIf.addr;
                    EthIf.actualIndex = GuiOptionsDlg.this.comboBoxInterface.getSelectedIndex();
                    GuiMain.getGuiStatusBarObject().showInterface(ethIf.name);
                    System.out.println("selected Eth-Interface: " + ethIf.name + " " + ethIf.ipAddrString);
                    int n = 0;
                    BitSet bitSet = new BitSet();
                    for (n = 0; n < UtilSpy.SpyIdEnum.values().length; ++n) {
                        if (GuiOptionsDlg.this.checkBoxSpyIds[n] == null || GuiOptionsDlg.this.checkBoxSpyIds[n].getSelectedObjects() == null) continue;
                        bitSet.set(n);
                        if (UtilProdInfo.isPrivateProduction() || n != 1) continue;
                        UtilPreferences.setRemainingStarts(1);
                        new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionOK, GuiUtilDialog.GuiUtilDialogModalityEnum.Modal, String.format(UtilLocale.getString("TXT_WARNING_SET_TRACE_LEVEL_*"), UtilLocale.getString(spyIdComment[1])), null, null, true);
                    }
                    UtilSpy.setSpyIds(bitSet);
                    UtilPreferences.setSpyIds(bitSet);
                    if (UtilProdInfo.isPrivateProduction()) {
                        boolean bl = GuiOptionsDlg.this.checkBoxAdditionalClassInfo.isSelected();
                        UtilSpy.setSpyClassInfo(bl);
                        UtilPreferences.setSpyClassInfo(bl);
                    }
                    if (!locale.equals(GuiOptionsDlg.this.currentLocale) && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageQuestion, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionOKCancel, GuiUtilDialog.GuiUtilDialogModalityEnum.Modal, String.format(UtilLocale.getString("TXT_EXIT_*_?"), GuiCommon.ApplicationName), null, null, true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionOK) {
                        GuiOptionsDlg.this.guiMain.exitApplication(locale);
                    }
                    GuiOptionsDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            this.buttonCancel.setBounds(242, 25, 90, 25);
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiOptionsDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonCancel;
    }

    class WindowAction
    extends WindowAdapter {
        WindowAction() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            GuiOptionsDlg.this.getComboBoxLanguage().requestFocusInWindow();
        }
    }
}

