/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg;

import com.aastra.omcfg.guiutil.GuiUtilIcon;
import com.aastra.omcfg.util.UtilLocale;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraStatusBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class GuiStatusBar
extends AastraStatusBar {
    private static final long serialVersionUID = 1L;
    private AastraPanel panelLeft = null;
    private AastraLabel labelInterface = null;
    private AastraLabel labelProxy = null;
    private Border borderMatteRight = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, GuiUtilIcon.getIconDivider()), BorderFactory.createEmptyBorder(3, 3, 3, 3));

    public GuiStatusBar() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanelLeft(), "West");
        this.setBackground(AastraCommon.MitelStatusBarBackground);
    }

    private AastraPanel getPanelLeft() {
        if (this.panelLeft == null) {
            this.panelLeft = new AastraPanel();
            this.panelLeft.setLayout(new FlowLayout(0, 5, 0));
            this.panelLeft.setBackground(AastraCommon.MitelStatusBarBackground);
            this.labelInterface = new AastraLabel();
            this.labelInterface.setBorder(this.borderMatteRight);
            this.labelInterface.setFont(AastraCommon.AastraFontStatusBar);
            this.labelInterface.setText(" ");
            this.labelInterface.setForeground(AastraCommon.MitelStatusBarForeground);
            this.panelLeft.add((Component)this.labelInterface, null);
            this.showInterface(null);
            this.labelProxy = new AastraLabel();
            this.labelProxy.setBorder(this.borderMatteRight);
            this.labelProxy.setFont(AastraCommon.AastraFontStatusBar);
            this.labelProxy.setForeground(AastraCommon.MitelStatusBarForeground);
            this.labelProxy.setText(" ");
            this.panelLeft.add((Component)this.labelProxy, null);
            this.showProxy(null);
        }
        return this.panelLeft;
    }

    public void showInterface(String string) {
        if (string != null && !string.isEmpty()) {
            this.labelInterface.setForeground(AastraCommon.MitelStatusBarForeground);
            this.labelInterface.setText(" Interface: " + string + " ");
        } else {
            this.labelInterface.setForeground(Color.RED);
            this.labelInterface.setText(" Interface: " + UtilLocale.getString("TXT_NONE") + " ");
        }
        this.repaint();
    }

    public void showProxy(String string) {
        if (string != null && !string.isEmpty()) {
            this.labelProxy.setForeground(AastraCommon.MitelStatusBarForeground);
            this.labelProxy.setText("Proxy: " + string + " ");
        } else {
            this.labelProxy.setForeground(Color.GRAY);
            this.labelProxy.setText(" no Proxy ");
        }
        this.repaint();
    }

    public static enum AppStateEnum {
        APP_STATE_OK,
        APP_STATE_ERROR,
        APP_STATE_BUSY,
        APP_STATE_INFO;

    }
}

