/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg.guiutil;

import com.aastra.omcfg.GuiCommon;
import com.aastra.omcfg.GuiMain;
import com.aastra.omcfg.guiutil.GuiUtilIcon;
import com.aastra.omcfg.util.UtilLocale;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class GuiUtilDialog
extends AastraDialog {
    private static final long serialVersionUID = 1L;
    private AastraPanel contentPanel = null;
    private AastraButton button1 = null;
    private AastraButton button2 = null;
    private AastraLabel labelText = null;
    private AastraLabel labelIcon = null;
    private String messageText = null;
    private String buttonText1 = null;
    private String buttonText2 = null;
    private GuiUtilDialogMessageTypeEnum messageType = null;
    private GuiUtilDialogModalityEnum modalityType = GuiUtilDialogModalityEnum.Modal;
    private GuiUtilDialogOptionTypeEnum optionType = GuiUtilDialogOptionTypeEnum.OptionOK;
    private GuiUtilDialogActionEnum action = GuiUtilDialogActionEnum.ActionNone;
    private static final int xSizeTxtMin = 215;
    private static final int xSizeSingleChar = 8;
    private static final int maxCntCharPerLine = 80;
    private int xSize;
    private static final int ySizeDefault = 135;
    private int ySize;
    private static final int ySizeTxtSingleLine = 16;
    private static final int xPosTxt = 60;
    private static final int xSpaceRight = 25;
    private static final int yPosTxt = 20;
    private int xSizeTxt;
    private int ySizeTxt;
    private static final int xPosIcon = 15;
    private static final int yPosIcon = 20;
    private static final int sizeIcon = 33;
    private static final int maxCntCharPerButton = 10;
    private int xSizeButton1 = 90;
    private int xSizeButton2 = 90;
    private static final int ySizeButton = 25;
    private int xPosButtonCenter = 0;
    private int xPosButtonLeft = 0;
    private int xPosButtonRight = 0;
    private int yPosButton = 0;

    public GuiUtilDialog(GuiUtilDialogMessageTypeEnum guiUtilDialogMessageTypeEnum, GuiUtilDialogOptionTypeEnum guiUtilDialogOptionTypeEnum, String string, boolean bl) {
        super(GuiMain.getGuiMainObject());
        this.messageType = guiUtilDialogMessageTypeEnum;
        this.optionType = guiUtilDialogOptionTypeEnum;
        this.messageText = string;
        this.initialize();
    }

    public GuiUtilDialog(GuiUtilDialogMessageTypeEnum guiUtilDialogMessageTypeEnum, GuiUtilDialogOptionTypeEnum guiUtilDialogOptionTypeEnum, GuiUtilDialogModalityEnum guiUtilDialogModalityEnum, String string, String string2, String string3, boolean bl) {
        super(GuiMain.getGuiMainObject());
        this.modalityType = guiUtilDialogModalityEnum;
        this.messageType = guiUtilDialogMessageTypeEnum;
        this.optionType = guiUtilDialogOptionTypeEnum;
        this.messageText = string;
        this.buttonText1 = string2;
        this.buttonText2 = string3;
        this.initialize();
    }

    public GuiUtilDialogActionEnum getAction() {
        return this.action;
    }

    private void initialize() {
        this.calculateSize();
        this.addWindowListener(new WindowAction());
        this.setSize(this.xSize, this.ySize);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        if (this.modalityType == GuiUtilDialogModalityEnum.Modeless) {
            this.setModalityType(Dialog.ModalityType.MODELESS);
            this.setTitle(GuiCommon.ApplicationNameShort);
        } else {
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            switch (this.messageType) {
                case MessageInfo: {
                    this.setTitle(UtilLocale.getString("TXT_INFO"));
                    break;
                }
                case MessageWarning: {
                    this.setTitle(UtilLocale.getString("TXT_WARNING"));
                    break;
                }
                case MessageError: {
                    this.setTitle(UtilLocale.getString("TXT_ERROR"));
                    break;
                }
                case MessageQuestion: {
                    this.setTitle(UtilLocale.getString("TXT_CONFIRMATION"));
                }
            }
        }
        this.setAction(GuiUtilDialogActionEnum.ActionNone);
        this.setContentPane(this.getContentPanel());
        this.setVisible(true);
    }

    private void calculateSize() {
        int n = 0;
        int[] nArray = new int[5];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string = null;
        while (n2 != -1 && n < 5) {
            n2 = this.messageText.indexOf("<br>", n3);
            if (n2 == -1) continue;
            nArray[n] = n2;
            n3 = n2 + 1;
            ++n;
        }
        if (n > 0) {
            n4 = 0;
            for (n5 = 0; n5 <= n; ++n5) {
                string = n5 == 0 ? this.messageText.substring(0, nArray[n5]) : (n5 == n ? this.messageText.substring(nArray[n5 - 1] + 4) : this.messageText.substring(nArray[n5 - 1] + 4, nArray[n5]));
                if (string.length() <= n4) continue;
                n4 = string.length();
            }
        } else {
            n4 = this.messageText.length();
        }
        if (n4 <= 80) {
            this.xSizeTxt = n4 * 8;
            if (this.xSizeTxt < 215) {
                this.xSizeTxt = 215;
            }
            this.ySize = 135 + 16 * n;
            this.ySizeTxt = 16 + 16 * n;
        } else {
            this.xSizeTxt = 640;
            n6 = 0;
            while (n4 > 80) {
                n4 -= 80;
                ++n6;
            }
            this.ySize = 135 + 16 * n6 + 16 * n;
            this.ySizeTxt = 16 * (n6 + 1) + 16 * n;
        }
        this.xSize = 60 + this.xSizeTxt + 25;
        this.yPosButton = this.ySize - 75;
        this.xPosButtonCenter = this.xSize / 2 - this.xSizeButton1 / 2;
        if (!(this.buttonText1 != null && this.buttonText1.length() > 10 || this.buttonText2 != null && this.buttonText2.length() > 10)) {
            this.xPosButtonLeft = 3 * this.xSize / 10 - this.xSizeButton1 / 2;
            this.xPosButtonRight = 7 * this.xSize / 10 - this.xSizeButton1 / 2;
        } else {
            if (this.buttonText1 != null && this.buttonText1.length() > 10) {
                this.xSizeButton1 = this.buttonText1.length() * this.xSizeButton1 / 10;
            }
            if (this.buttonText2 != null && this.buttonText2.length() > 10) {
                this.xSizeButton2 = this.buttonText2.length() * this.xSizeButton2 / 10;
            }
            this.xPosButtonLeft = 3 * this.xSize / 10 - this.xSizeButton1 / 2;
            this.xPosButtonRight = 7 * this.xSize / 10 - this.xSizeButton2 / 2;
        }
    }

    private AastraPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new AastraPanel();
            this.contentPanel.setLayout(null);
            this.contentPanel.add(this.getLabelText());
            this.labelIcon = new AastraLabel();
            this.labelIcon.setBounds(15, 20, 33, 33);
            this.contentPanel.add(this.labelIcon);
            switch (this.messageType) {
                default: {
                    this.labelIcon.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeLarge));
                    break;
                }
                case MessageWarning: {
                    this.labelIcon.setIcon(GuiUtilIcon.getIconWarning(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeLarge));
                    break;
                }
                case MessageError: {
                    this.labelIcon.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeLarge));
                    break;
                }
                case MessageQuestion: {
                    this.labelIcon.setIcon(GuiUtilIcon.getIconHelp(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeLarge));
                }
            }
            switch (this.optionType) {
                default: {
                    this.contentPanel.add((Component)this.getButton1(buttonPosEnum.positionCenter), null);
                    break;
                }
                case OptionOKCancel: 
                case OptionYesNo: {
                    this.contentPanel.add((Component)this.getButton1(buttonPosEnum.positionLeft), null);
                    this.contentPanel.add((Component)this.getButton2(buttonPosEnum.positionRight), null);
                }
                case OptionYesNoCancel: 
            }
        }
        return this.contentPanel;
    }

    private AastraLabel getLabelText() {
        if (this.labelText == null) {
            this.labelText = new AastraLabel();
            this.labelText.setHorizontalAlignment(2);
            this.labelText.setBounds(60, 20, this.xSizeTxt, this.ySizeTxt);
            if (!this.messageText.contains("<html>")) {
                this.messageText = "<html>" + this.messageText + "</html>";
            }
            this.labelText.setText(this.messageText);
        }
        return this.labelText;
    }

    private AastraButton getButton1(buttonPosEnum buttonPosEnum2) {
        if (this.button1 == null) {
            this.button1 = new AastraButton();
            switch (buttonPosEnum2) {
                case positionLeft: {
                    this.button1.setBounds(this.xPosButtonLeft, this.yPosButton, this.xSizeButton1, 25);
                    break;
                }
                default: {
                    this.button1.setBounds(this.xPosButtonCenter, this.yPosButton, this.xSizeButton1, 25);
                }
            }
            if (this.buttonText1 != null) {
                this.button1.setText(this.buttonText1);
            } else if (this.optionType == GuiUtilDialogOptionTypeEnum.OptionYesNo) {
                this.button1.setText(UtilLocale.getString("TXT_YES"));
            } else {
                this.button1.setText(UtilLocale.getString("TXT_OK"));
            }
            this.button1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (GuiUtilDialog.this.optionType == GuiUtilDialogOptionTypeEnum.OptionYesNo) {
                        GuiUtilDialog.this.setAction(GuiUtilDialogActionEnum.ActionYes);
                    } else {
                        GuiUtilDialog.this.setAction(GuiUtilDialogActionEnum.ActionOK);
                    }
                    GuiUtilDialog.this.setVisible(false);
                }
            });
        }
        return this.button1;
    }

    private AastraButton getButton2(buttonPosEnum buttonPosEnum2) {
        if (this.button2 == null) {
            this.button2 = new AastraButton();
            switch (buttonPosEnum2) {
                default: 
            }
            this.button2.setBounds(this.xPosButtonRight, this.yPosButton, this.xSizeButton2, 25);
            if (this.buttonText2 != null) {
                this.button2.setText(this.buttonText2);
            } else if (this.optionType == GuiUtilDialogOptionTypeEnum.OptionYesNo) {
                this.button2.setText(UtilLocale.getString("TXT_NO"));
            } else {
                this.button2.setText(UtilLocale.getString("TXT_CANCEL"));
            }
            this.button2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (GuiUtilDialog.this.optionType == GuiUtilDialogOptionTypeEnum.OptionYesNo) {
                        GuiUtilDialog.this.setAction(GuiUtilDialogActionEnum.ActionNo);
                    } else {
                        GuiUtilDialog.this.setAction(GuiUtilDialogActionEnum.ActionCancel);
                    }
                    GuiUtilDialog.this.setVisible(false);
                }
            });
        }
        return this.button2;
    }

    private void setAction(GuiUtilDialogActionEnum guiUtilDialogActionEnum) {
        this.action = guiUtilDialogActionEnum;
    }

    private class WindowAction
    extends WindowAdapter {
        private WindowAction() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            GuiUtilDialog.this.setAction(GuiUtilDialogActionEnum.ActionCancel);
        }
    }

    public static enum GuiUtilDialogModalityEnum {
        Modeless,
        Modal;

    }

    public static enum GuiUtilDialogActionEnum {
        ActionNone,
        ActionOK,
        ActionCancel,
        ActionYes,
        ActionNo;

    }

    public static enum GuiUtilDialogOptionTypeEnum {
        OptionOK,
        OptionYesNo,
        OptionYesNoCancel,
        OptionOKCancel;

    }

    public static enum GuiUtilDialogMessageTypeEnum {
        MessageInfo,
        MessageWarning,
        MessageError,
        MessageQuestion;

    }

    private static enum buttonPosEnum {
        positionLeft,
        positionCenter,
        positionRight;

    }
}

