/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg.guiutil;

import com.aastra.omcfg.guiutil.GuiUtilChangeHandler;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraTextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class GuiUtilTextField
extends AastraTextField
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private GuiUtilChangeHandler utilChangeHandler = null;
    private String currentText = "";
    private String initialText;
    private boolean changed = false;

    public GuiUtilTextField() {
    }

    public GuiUtilTextField(GuiUtilChangeHandler guiUtilChangeHandler) {
        if (guiUtilChangeHandler != null) {
            this.utilChangeHandler = guiUtilChangeHandler;
            this.addKeyListener(this);
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.initialText = this.currentText = string;
    }

    public void setChanged() {
        this.changed = true;
    }

    public boolean isChange() {
        if (this.changed) {
            this.changed = false;
            return true;
        }
        return !this.initialText.equals(this.currentText);
    }

    public boolean isNotTristate() {
        return !this.getText().equals(AastraCommon.AastraTriStateText);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        String string = this.getText();
        if (this.utilChangeHandler != null && !this.utilChangeHandler.isActivated() && string != null) {
            if (this.currentText == null) {
                if (string.length() > 0) {
                    this.utilChangeHandler.activate();
                }
            } else if (!this.currentText.equals(string)) {
                this.utilChangeHandler.activate();
            }
        }
        this.currentText = string;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

