/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg.rfpcfg;

import com.aastra.omcfg.GuiInfoConsole;
import com.aastra.omcfg.GuiMain;
import com.aastra.omcfg.rfpcfg.ConfigurationFunctions;
import com.aastra.omcfg.rfpcfg.CookieDialog;
import com.aastra.omcfg.rfpcfg.NewNetworkThread;
import com.aastra.omcfg.rfpcfg.RfpDatabase;
import com.aastra.omcfg.rfpcfg.RfpRecord;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.JOptionPane;

public class NetworkEventSynchronizer
implements Runnable {
    public static final int ACTION_ADD_RFP = 1;
    public static final int ACTION_UPDATE_PARAMETER = 2;
    public static final int ACTION_SET_RESP = 3;
    public static final int ACTION_BIND_FAILED = 4;
    public static final int ACTION_SET_FAILED = 5;
    public static final int ACTION_COOKIE_RESP = 6;
    public static final int ACTION_COOKIE_FAILED = 7;
    public static final int ACTION_BACKDOOR_RESP = 8;
    public static final int ACTION_BACKDOOR_FAILED = 9;
    public static final int ACTION_RESET_RESP = 10;
    public static final int ACTION_RESET_FAILED = 11;
    public static RfpDatabase rfpDb = null;
    public static ConfigurationFunctions cf = null;
    private RfpRecord rfp = null;
    private int action;
    private String mac = null;
    private String params = null;

    public NetworkEventSynchronizer(RfpRecord rfpRecord, int n) {
        this.rfp = rfpRecord;
        this.action = n;
    }

    public NetworkEventSynchronizer(String string, int n) {
        this.mac = string;
        this.action = n;
    }

    public NetworkEventSynchronizer(String string, int n, String string2) {
        this.mac = string;
        this.action = n;
        this.params = string2;
    }

    @Override
    public void run() {
        switch (this.action) {
            case 1: {
                if (this.rfp != null) {
                    rfpDb.createRfp(this.rfp);
                    break;
                }
                rfpDb.createRfp(this.mac);
                break;
            }
            case 2: {
                RfpRecord rfpRecord;
                if (this.params == null || (rfpRecord = rfpDb.createRfp(this.mac)) == null) break;
                NewNetworkThread.processParamString(rfpRecord, this.params);
                rfpDb.createRfp(rfpRecord);
                break;
            }
            case 3: {
                RfpRecord rfpRecord = rfpDb.getRecordByMac(this.mac);
                if (rfpRecord == null) break;
                GuiInfoConsole.showInfo("Configuration of " + this.mac + " successful");
                rfpRecord.setField(1, (Object)RfpRecord.ConfigChangedEnum.CONFIG_SEND);
                rfpDb.createRfp(rfpRecord);
                break;
            }
            case 5: {
                RfpRecord rfpRecord = rfpDb.getRecordByMac(this.mac);
                if (rfpRecord == null) break;
                GuiInfoConsole.showError("Configuration of " + this.mac + " failed");
                rfpRecord.setField(1, (Object)RfpRecord.ConfigChangedEnum.CONFIG_ERROR);
                rfpDb.createRfp(rfpRecord);
                break;
            }
            case 4: {
                JOptionPane.showMessageDialog(null, "Can't bind network interface", "error", 2);
                GuiMain.getGuiMainObject().exitApplication(null);
                break;
            }
            case 6: {
                GuiInfoConsole.showInfo("Cookie received from " + this.mac + " : " + this.params);
                StringSelection stringSelection = new StringSelection(this.params);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
                CookieDialog cookieDialog = new CookieDialog((Frame)GuiMain.getGuiMainObject(), this.params);
                cookieDialog.setVisible(true);
                if (cookieDialog.str_key.isEmpty() || cf == null) break;
                cf.FactoryDefaultsSend(this.mac, cookieDialog.str_key);
                break;
            }
            case 7: {
                GuiInfoConsole.showError("Get cookie from " + this.mac + " failed");
                break;
            }
            case 8: 
            case 10: {
                GuiInfoConsole.showInfo("Factory reset of " + this.mac + " successful");
                RfpRecord rfpRecord = rfpDb.getRecordByMac(this.mac);
                if (rfpRecord == null) break;
                rfpRecord.clear();
                rfpDb.createRfp(rfpRecord);
                break;
            }
            case 11: {
                GuiInfoConsole.showError("Factory reset of " + this.mac + " failed - try to get cookie");
                break;
            }
        }
    }

    public static void setRfpDatabase(RfpDatabase rfpDatabase) {
        rfpDb = rfpDatabase;
    }

    public static void setConfigurationFunctionsObject(ConfigurationFunctions configurationFunctions) {
        cf = configurationFunctions;
    }
}

