/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg.rfpcfg;

import com.aastra.omilib.GenericDataRecord;
import com.aastra.omilib.GenericDatabase;
import com.aastra.style.AastraTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;

class ParameterDb
extends GenericDatabase {
    public static final int MAX_PARAMS = 100;
    public static String[] paramNames = new String[100];
    public static int paramCount = 0;
    public int paramDeletedCount = 0;
    public String[] paramValues = new String[100];
    public boolean[] paramDeleted = new boolean[100];
    public boolean[] paramError = new boolean[100];

    public AastraTableCellRenderer getTableCellRenderer() {
        return new TableCellColorRenderer();
    }

    public ParameterDb() {
        this.setFieldName(1, "Name");
        this.setFieldName(2, "Value");
        for (int i = 0; i < 100; ++i) {
            this.paramDeleted[i] = false;
            this.paramError[i] = false;
        }
    }

    public static int findParam(String string) {
        for (int i = 0; i < paramCount; ++i) {
            if (paramNames[i] == null || !paramNames[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean addParameter(String string) {
        int n = ParameterDb.findParam(string);
        if (n != -1) {
            if (this.paramDeleted[n]) {
                this.paramDeleted[n] = false;
                if (this.paramDeletedCount > 0) {
                    --this.paramDeletedCount;
                }
            }
            return true;
        }
        if (paramCount < 99) {
            ParameterDb.paramNames[ParameterDb.paramCount++] = string;
            return true;
        }
        return false;
    }

    public boolean addParameter(String string, String string2) {
        int n = ParameterDb.findParam(string);
        if (n != -1) {
            if (this.paramDeleted[n]) {
                this.paramDeleted[n] = false;
                if (this.paramDeletedCount > 0) {
                    this.paramDeletedCount = 0;
                }
            }
            this.paramValues[n] = string2;
            return true;
        }
        if (paramCount < 99) {
            n = paramCount++;
            ParameterDb.paramNames[n] = string;
            this.paramValues[n] = string2;
            return true;
        }
        return false;
    }

    public static boolean changeParamName(String string, String string2) {
        int n = ParameterDb.findParam(string);
        if (n == -1) {
            return false;
        }
        ParameterDb.paramNames[n] = string2;
        return true;
    }

    public boolean setParamValue(String string, String string2) {
        int n = ParameterDb.findParam(string);
        if (n == -1) {
            return false;
        }
        if (this.paramDeleted[n]) {
            return false;
        }
        this.paramError[n] = false;
        this.paramValues[n] = string2;
        return true;
    }

    public String getParamValue(String string) {
        int n = ParameterDb.findParam(string);
        if (n == -1) {
            return null;
        }
        if (this.paramDeleted[n]) {
            return null;
        }
        return this.paramValues[n];
    }

    public boolean removeParameter(String string) {
        int n = ParameterDb.findParam(string);
        if (n == -1) {
            return false;
        }
        if (this.paramDeleted[n]) {
            return true;
        }
        this.paramDeleted[n] = true;
        ++this.paramDeletedCount;
        return true;
    }

    public void updateParamDeletedCount() {
        this.paramDeletedCount = 0;
        for (int i = 0; i < paramCount; ++i) {
            if (!this.paramDeleted[i]) continue;
            ++this.paramDeletedCount;
        }
    }

    @Override
    public GenericDataRecord getRecordByIdx(int n) {
        if (n < 0 || n >= paramCount - this.paramDeletedCount) {
            return null;
        }
        int n2 = n;
        if (this.paramDeletedCount > 0) {
            int n3 = 0;
            for (int i = 0; i < paramCount; ++i) {
                if (this.paramDeleted[i]) continue;
                if (n3 == n) {
                    n2 = i;
                    break;
                }
                ++n3;
            }
        }
        GenericDataRecord genericDataRecord = new GenericDataRecord(n);
        genericDataRecord.setField(0, n);
        genericDataRecord.setField(1, paramNames[n2]);
        genericDataRecord.setField(2, this.paramValues[n2]);
        return genericDataRecord;
    }

    @Override
    public int getRecordNumber() {
        return paramCount - this.paramDeletedCount;
    }

    public void resetParamDeletedList() {
        for (int i = 0; i < paramCount; ++i) {
            this.paramDeleted[i] = false;
            this.paramDeletedCount = 0;
        }
    }

    public class TableCellColorRenderer
    extends AastraTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JComponent jComponent = (JComponent)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!bl && jComponent != null && jTable != null) {
                int n3 = jTable.convertColumnIndexToModel(n2);
                int n4 = jTable.convertRowIndexToModel(n);
                if (n3 == 1 && ParameterDb.this.paramError[n4]) {
                    jComponent.setBackground(Color.RED);
                    jComponent.setForeground(Color.WHITE);
                }
            }
            return jComponent;
        }
    }
}

