/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg.rfpcfg;

import com.aastra.omcfg.GuiInfoConsole;
import com.aastra.omcfg.guiutil.GuiUtilDetailPanel;
import com.aastra.omcfg.guiutil.GuiUtilTextField;
import com.aastra.omcfg.guiutil.GuiUtilTristateCheckBox;
import com.aastra.omcfg.rfpcfg.ConfigReader;
import com.aastra.omcfg.rfpcfg.ConfigRow;
import com.aastra.omcfg.rfpcfg.ConfigurationFunctions;
import com.aastra.omcfg.rfpcfg.ParameterDb;
import com.aastra.omcfg.rfpcfg.ParamsEnum;
import com.aastra.omcfg.rfpcfg.RfpPanel;
import com.aastra.omcfg.rfpcfg.RfpRecord;
import com.aastra.omcfg.util.UtilErrorComp;
import com.aastra.omcfg.util.UtilLocale;
import com.aastra.omcfg.util.UtilMisc;
import com.aastra.omilib.DataRecord;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.omilibgui.ConfiguratorTableModel;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraComboBox;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraTristateCheckbox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;

public class RfpDetailPanel
extends GuiUtilDetailPanel
implements ConfiguratorTableEventInterface {
    private static final long serialVersionUID = 1L;
    private static final int LABEL_FIELD_LEN = 140;
    private static final int ITEM_FIELD_LEN = 200;
    private static final int ITEM_DIST = 25;
    private static final int FIRST_ITEM_POS = 25;
    private static final int LABEL_XPOS = 20;
    private static final int LABEL_HEIGHT = 16;
    private static final int ITEM_HEIGHT = 18;
    private static final int ITEM_XPOS = 170;
    private static final int LABEL_XPOS2 = 400;
    private static final int ITEM_XPOS2 = 550;
    protected AastraButton buttonOK = null;
    protected AastraButton buttonCancel = null;
    protected AastraButton buttonChangeParamName = null;
    protected AastraButton buttonChangeParamValue = null;
    protected AastraButton buttonNewParam = null;
    protected AastraButton buttonRemoveParam = null;
    protected AastraButton buttonResetConfig = null;
    protected String actualParamName;
    protected AastraLabel labelUseLocalConfig = null;
    protected GuiUtilTristateCheckBox checkBoxUseLocalConfig = null;
    protected GuiUtilTextField textFieldMacAddress = null;
    protected AastraLabel labelIpAddress = null;
    protected GuiUtilTextField textFieldIpAddress = null;
    protected AastraLabel labelNetMask = null;
    protected GuiUtilTextField textFieldNetMask = null;
    protected AastraLabel labelGateway = null;
    protected GuiUtilTextField textFieldGateway = null;
    protected AastraLabel labelOmm1 = null;
    protected GuiUtilTextField textFieldOmm1 = null;
    protected AastraLabel labelOmm2 = null;
    protected GuiUtilTextField textFieldOmm2 = null;
    protected AastraLabel labelTftp = null;
    protected GuiUtilTextField textFieldTftp = null;
    protected AastraLabel labelTftpFile = null;
    protected GuiUtilTextField textFieldTftpFile = null;
    protected AastraLabel labelSyslogSrv = null;
    protected GuiUtilTextField textFieldSyslogSrv = null;
    protected AastraLabel labelSyslogPort = null;
    protected GuiUtilTextField textFieldSyslogPort = null;
    protected GuiUtilTextField textFieldConfigSrv = null;
    protected GuiUtilTextField textFieldDNS = null;
    protected AastraPanel tabIP = null;
    protected AastraPanel tabOM = null;
    protected AastraPanel tabCfgServers = null;
    protected AastraPanel tabOther = null;
    private RfpRecord[] rfpArr = null;
    private RfpPanel rfpPanel = null;
    private ParameterDb paramDb = null;
    private ConfiguratorTable paramTable = null;
    protected AastraLabel labelParamName = null;
    protected GuiUtilTextField textFieldParamValue = null;
    protected GuiUtilTristateCheckBox checkBoxParamValueBool = null;
    protected GuiUtilTextField textFieldParamName = null;
    protected AastraComboBox cbNewParamNames = null;
    private String errorInfo = "";
    private UtilErrorComp utilErrorComp = new UtilErrorComp();

    public RfpDetailPanel(RfpPanel rfpPanel) {
        super(500, 120);
        this.rfpPanel = rfpPanel;
        this.initialize();
    }

    private void initialize() {
        this.panelTabbed.addTab("General", null, this.getTabIP(), null);
        this.panelTabbed.addTab("OpenMobility", null, this.getTabOM(), null);
        this.panelTabbed.addTab("Other", null, this.getTabOther(), null);
        this.panelButtonBar.add((Component)this.getButtonOK(), null);
        this.panelButtonBar.add((Component)this.getButtonCancel(), null);
    }

    private void SetFieldFromRecord(GuiUtilTextField guiUtilTextField, DataRecord[] dataRecordArray, int n) {
        Object object = UtilMisc.getRecordsFieldObject(dataRecordArray, n);
        if (object != null) {
            guiUtilTextField.setText((String)object);
        } else {
            guiUtilTextField.setText("");
        }
    }

    private void setExtraParamsFromMultipleRecords(RfpRecord[] rfpRecordArray) {
        for (int i = 0; i < ParameterDb.paramCount; ++i) {
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = rfpRecordArray[0].paramDb.paramDeleted[i];
            String string = rfpRecordArray[0].paramDb.paramValues[i];
            for (int j = 1; j < rfpRecordArray.length; ++j) {
                if (bl3 != rfpRecordArray[j].paramDb.paramDeleted[i]) {
                    bl2 = false;
                }
                if (string == null) {
                    if (rfpRecordArray[j].paramDb.paramValues[i] == null) continue;
                    bl = false;
                    continue;
                }
                if (rfpRecordArray[j].paramDb.paramValues[i] == null) {
                    bl = false;
                    continue;
                }
                if (string.equals(rfpRecordArray[j].paramDb.paramValues[i])) continue;
                bl = false;
            }
            this.paramDb.paramValues[i] = bl ? string : AastraCommon.AastraTriStateText;
            this.paramDb.paramDeleted[i] = bl2 ? bl3 : false;
        }
        this.paramDb.updateParamDeletedCount();
        this.updateTextFields(null);
    }

    private AastraTristateCheckbox.State getRecordsLocalConfigState(DataRecord[] dataRecordArray) {
        AastraTristateCheckbox.State state = AastraTristateCheckbox.DONT_CARE;
        RfpRecord.LocalConfigEnum localConfigEnum = (RfpRecord.LocalConfigEnum)((Object)dataRecordArray[0].getField(3));
        if (localConfigEnum == null) {
            return state;
        }
        if (localConfigEnum == RfpRecord.LocalConfigEnum.CONFIG_YES) {
            state = AastraTristateCheckbox.SELECTED;
        } else if (localConfigEnum == RfpRecord.LocalConfigEnum.CONFIG_NO) {
            state = AastraTristateCheckbox.NOT_SELECTED;
        }
        for (int i = 1; i < dataRecordArray.length; ++i) {
            RfpRecord.LocalConfigEnum localConfigEnum2 = (RfpRecord.LocalConfigEnum)((Object)dataRecordArray[i].getField(3));
            if (localConfigEnum2 == null) {
                return AastraTristateCheckbox.DONT_CARE;
            }
            if (localConfigEnum2 == localConfigEnum) continue;
            return AastraTristateCheckbox.DONT_CARE;
        }
        return state;
    }

    public void setDetailData(DataRecord[] dataRecordArray) {
        if (dataRecordArray != null) {
            int n;
            this.utilErrorComp.clearComponents();
            for (n = 0; n < ParameterDb.paramCount; ++n) {
                this.paramDb.paramError[n] = false;
            }
            this.rfpArr = new RfpRecord[dataRecordArray.length];
            for (n = 0; n < dataRecordArray.length; ++n) {
                this.rfpArr[n] = (RfpRecord)dataRecordArray[n].clone();
                this.rfpArr[n].commitChanges();
            }
            this.setExtraParamsFromMultipleRecords(this.rfpArr);
            ((ConfiguratorTableModel)this.paramTable.getModel()).fireTableStructureChanged();
            if (this.rfpArr.length == 1) {
                RfpRecord rfpRecord = this.rfpArr[0];
                this.labelHeaderBar.setText("Detail Data " + rfpRecord.getField(2));
                this.SetFieldFromRecord(this.textFieldIpAddress, dataRecordArray, 4);
                this.textFieldIpAddress.setEnabled(true);
            } else {
                String string = "Detail Data " + this.rfpArr[0].getField(2) + ", " + this.rfpArr[1].getField(2);
                if (this.rfpArr.length > 2) {
                    string = string + ", ...";
                }
                this.labelHeaderBar.setText(string);
                this.textFieldIpAddress.setText(AastraCommon.AastraTriStateText);
                this.textFieldIpAddress.setEnabled(false);
            }
            this.checkBoxUseLocalConfig.setState(this.getRecordsLocalConfigState(dataRecordArray));
            this.SetFieldFromRecord(this.textFieldNetMask, dataRecordArray, 5);
            this.SetFieldFromRecord(this.textFieldGateway, dataRecordArray, 6);
            this.SetFieldFromRecord(this.textFieldOmm1, dataRecordArray, 7);
            this.SetFieldFromRecord(this.textFieldOmm2, dataRecordArray, 8);
            this.SetFieldFromRecord(this.textFieldTftp, dataRecordArray, 9);
            this.SetFieldFromRecord(this.textFieldTftpFile, dataRecordArray, 10);
            this.SetFieldFromRecord(this.textFieldSyslogSrv, dataRecordArray, 11);
            this.SetFieldFromRecord(this.textFieldSyslogPort, dataRecordArray, 12);
            this.SetFieldFromRecord(this.textFieldDNS, dataRecordArray, 13);
            this.SetFieldFromRecord(this.textFieldConfigSrv, dataRecordArray, 14);
        }
    }

    public void setDetailData(DataRecord dataRecord) {
        DataRecord[] dataRecordArray = new DataRecord[]{dataRecord};
        this.setDetailData(dataRecordArray);
    }

    protected AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.setBounds(70, 15, 90, 25);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpRecord[] rfpRecordArray = RfpDetailPanel.this.updateDataRecords();
                    if (rfpRecordArray != null) {
                        RfpDetailPanel.this.rfpPanel.updateRfpData(rfpRecordArray);
                        RfpDetailPanel.this.rfpPanel.hideRfpDetails();
                    } else {
                        GuiInfoConsole.showError("Errors : " + RfpDetailPanel.this.errorInfo);
                    }
                }
            });
        }
        return this.buttonOK;
    }

    protected AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.setBounds(230, 15, 90, 25);
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RfpDetailPanel.this.utilErrorComp.clearComponents();
                    RfpDetailPanel.this.rfpPanel.hideRfpDetails();
                }
            });
        }
        return this.buttonCancel;
    }

    protected AastraButton getButtonResetConfig() {
        if (this.buttonResetConfig == null) {
            this.buttonResetConfig = new AastraButton();
            this.buttonResetConfig.setText("Reset Configuration");
            this.buttonResetConfig.setBounds(390, 15, 90, 25);
            this.buttonResetConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
        }
        return this.buttonResetConfig;
    }

    private RfpRecord[] updateDataRecords() {
        String string;
        int n;
        boolean bl = true;
        boolean bl2 = true;
        this.errorInfo = "";
        if (this.rfpArr == null) {
            return null;
        }
        this.utilErrorComp.clearComponents();
        for (n = 0; n < ParameterDb.paramCount; ++n) {
            this.paramDb.paramError[n] = false;
        }
        if (this.checkBoxUseLocalConfig.isEnabled() && this.checkBoxUseLocalConfig.getState() == GuiUtilTristateCheckBox.SELECTED) {
            bl2 = false;
        }
        for (ParamsEnum paramsEnum : ParamsEnum.values()) {
            if (paramsEnum.textField == null || !paramsEnum.textField.isNotTristate()) continue;
            string = paramsEnum.textField.getText();
            if (ConfigurationFunctions.checkParam(paramsEnum.name(), string, bl2, false)) continue;
            this.errorInfo = this.errorInfo + this.utilErrorComp.getLabelText(paramsEnum.name()) + ConfigurationFunctions.getParamErrorString() + ", ";
            this.utilErrorComp.markComponent(paramsEnum.textField);
            bl = false;
        }
        for (n = 0; n < ParameterDb.paramCount; ++n) {
            if (this.paramDb.paramDeleted[n]) continue;
            string = this.paramDb.paramValues[n];
            if (string == null) {
                string = "";
            }
            if (string.equals(AastraCommon.AastraTriStateText) || ConfigurationFunctions.checkParam(ParameterDb.paramNames[n], string, bl2, true)) continue;
            this.errorInfo = this.errorInfo + ParameterDb.paramNames[n] + ConfigurationFunctions.getParamErrorString() + ", ";
            this.paramDb.paramError[n] = true;
            bl = false;
        }
        ParamsEnum paramsEnum = ParamsEnum.ommip1;
        ParamsEnum paramsEnum2 = ParamsEnum.ommip2;
        String string2 = paramsEnum.textField.getText();
        String string3 = paramsEnum2.textField.getText();
        if (string2 != null && string3 != null && string2.equals(string3) && !string2.isEmpty() && !string2.equals(AastraCommon.AastraTriStateText)) {
            this.errorInfo = this.errorInfo + "same address used for OMM and 2nd OMM, ";
            this.utilErrorComp.markComponent(paramsEnum.textField);
            this.utilErrorComp.markComponent(paramsEnum2.textField);
            bl = false;
        }
        ((ConfiguratorTableModel)this.paramTable.getModel()).fireTableDataChanged();
        if (!bl) {
            return null;
        }
        if (this.rfpArr.length == 1) {
            string = this.textFieldIpAddress.getText();
            this.rfpArr[0].setField(4, string);
        }
        for (int i = 0; i < this.rfpArr.length; ++i) {
            UtilMisc.setRecordFromTristateCheckbox(this.rfpArr[i], this.checkBoxUseLocalConfig, 3);
            for (ParamsEnum paramsEnum3 : ParamsEnum.values()) {
                if (paramsEnum3.textField == null || paramsEnum3 == ParamsEnum.ip || !paramsEnum3.textField.isNotTristate()) continue;
                string = paramsEnum3.textField.getText();
                this.rfpArr[i].setField(paramsEnum3.dbIdx, string);
            }
            boolean bl3 = false;
            if (this.rfpArr[i].getRecordChanged()) {
                bl3 = true;
            }
            for (n = 0; n < ParameterDb.paramCount; ++n) {
                if (!this.paramDb.paramDeleted[n]) {
                    if (this.rfpArr[i].paramDb.paramDeleted[n]) {
                        bl3 = true;
                    }
                    this.rfpArr[i].paramDb.paramDeleted[n] = false;
                    string = this.paramDb.paramValues[n];
                    if (string == null || string.equals(AastraCommon.AastraTriStateText)) continue;
                    if (this.rfpArr[i].paramDb.paramValues[n] == null) {
                        bl3 = true;
                    } else if (!this.rfpArr[i].paramDb.paramValues[n].equals(string)) {
                        bl3 = true;
                    }
                    this.rfpArr[i].paramDb.paramValues[n] = string;
                    continue;
                }
                if (!this.rfpArr[i].paramDb.paramDeleted[n]) {
                    bl3 = true;
                }
                this.rfpArr[i].paramDb.paramDeleted[n] = true;
            }
            if (!bl3) continue;
            this.rfpArr[i].setField(1, (Object)RfpRecord.ConfigChangedEnum.CHANGED);
        }
        return this.rfpArr;
    }

    protected AastraPanel getTabIP() {
        if (this.tabIP == null) {
            this.tabIP = new AastraPanel();
            this.tabIP.setLayout(null);
            this.labelUseLocalConfig = new AastraLabel();
            this.labelUseLocalConfig.setBounds(20, 25, 140, 16);
            this.labelUseLocalConfig.setText("Use local config");
            this.tabIP.add(this.labelUseLocalConfig);
            this.labelIpAddress = new AastraLabel();
            this.labelIpAddress.setBounds(20, 50, 140, 16);
            this.labelIpAddress.setText("IP Address");
            this.tabIP.add(this.labelIpAddress);
            this.labelNetMask = new AastraLabel();
            this.labelNetMask.setBounds(20, 75, 140, 16);
            this.labelNetMask.setText("Net Mask");
            this.tabIP.add(this.labelNetMask);
            this.labelGateway = new AastraLabel();
            this.labelGateway.setBounds(20, 100, 140, 16);
            this.labelGateway.setText("Router");
            this.tabIP.add(this.labelGateway);
            this.checkBoxUseLocalConfig = new GuiUtilTristateCheckBox();
            this.checkBoxUseLocalConfig.setBounds(165, 25, 20, 20);
            this.checkBoxUseLocalConfig.useQuestionMarkAsTristate(true);
            this.tabIP.add(this.checkBoxUseLocalConfig);
            this.textFieldIpAddress = new GuiUtilTextField();
            this.textFieldIpAddress.setBounds(170, 50, 200, 18);
            ParamsEnum.ip.setTextField(this.textFieldIpAddress);
            this.tabIP.add(this.textFieldIpAddress);
            this.textFieldNetMask = new GuiUtilTextField();
            this.textFieldNetMask.setBounds(170, 75, 200, 18);
            ParamsEnum.subnet.setTextField(this.textFieldNetMask);
            this.tabIP.add(this.textFieldNetMask);
            this.textFieldGateway = new GuiUtilTextField();
            this.textFieldGateway.setBounds(170, 100, 200, 18);
            ParamsEnum.router.setTextField(this.textFieldGateway);
            this.tabIP.add(this.textFieldGateway);
            this.buttonResetConfig = new AastraButton();
            this.buttonResetConfig.setText("Reset Configuration");
            this.buttonResetConfig.setBounds(20, 150, 120, 25);
            this.buttonResetConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (int i = 0; i < ParameterDb.paramCount; ++i) {
                        ((RfpDetailPanel)RfpDetailPanel.this).paramDb.paramValues[i] = "";
                    }
                    ((ConfiguratorTableModel)RfpDetailPanel.this.paramTable.getModel()).fireTableStructureChanged();
                    RfpDetailPanel.this.checkBoxUseLocalConfig.setState(AastraTristateCheckbox.NOT_SELECTED);
                    for (ParamsEnum paramsEnum : ParamsEnum.values()) {
                        if (paramsEnum.dbIdx == 0 || paramsEnum.textField == null) continue;
                        paramsEnum.textField.setText("");
                    }
                    RfpDetailPanel.this.utilErrorComp.clearComponents();
                    for (int i = 0; i < ParameterDb.paramCount; ++i) {
                        ((RfpDetailPanel)RfpDetailPanel.this).paramDb.paramError[i] = false;
                    }
                }
            });
            this.tabIP.add(this.buttonResetConfig);
            this.utilErrorComp.put(ParamsEnum.use_local_cfg.name(), this.labelUseLocalConfig, this.checkBoxUseLocalConfig);
            this.utilErrorComp.put(ParamsEnum.ip.name(), this.labelIpAddress, this.textFieldIpAddress);
            this.utilErrorComp.put(ParamsEnum.subnet.name(), this.labelNetMask, this.textFieldNetMask);
            this.utilErrorComp.put(ParamsEnum.router.name(), this.labelGateway, this.textFieldGateway);
        }
        return this.tabIP;
    }

    protected AastraPanel getTabOM() {
        if (this.tabOM == null) {
            this.tabOM = new AastraPanel();
            this.tabOM.setLayout(null);
            this.labelOmm1 = new AastraLabel();
            this.labelOmm1.setBounds(20, 25, 140, 16);
            this.labelOmm1.setText("OMM address");
            this.tabOM.add(this.labelOmm1);
            this.textFieldOmm1 = new GuiUtilTextField();
            this.textFieldOmm1.setBounds(170, 25, 200, 18);
            ParamsEnum.ommip1.setTextField(this.textFieldOmm1);
            this.tabOM.add(this.textFieldOmm1);
            this.labelOmm2 = new AastraLabel();
            this.labelOmm2.setBounds(20, 50, 140, 16);
            this.labelOmm2.setText("2nd OMM address");
            this.tabOM.add(this.labelOmm2);
            this.textFieldOmm2 = new GuiUtilTextField();
            this.textFieldOmm2.setBounds(170, 50, 200, 18);
            ParamsEnum.ommip2.setTextField(this.textFieldOmm2);
            this.tabOM.add(this.textFieldOmm2);
            this.labelTftp = new AastraLabel();
            this.labelTftp.setBounds(20, 75, 140, 16);
            this.labelTftp.setText("TFTP server address");
            this.tabOM.add(this.labelTftp);
            this.textFieldTftp = new GuiUtilTextField();
            this.textFieldTftp.setBounds(170, 75, 200, 18);
            ParamsEnum.siaddr.setTextField(this.textFieldTftp);
            this.tabOM.add(this.textFieldTftp);
            this.labelTftpFile = new AastraLabel();
            this.labelTftpFile.setBounds(20, 100, 140, 16);
            this.labelTftpFile.setText("TFTP file name");
            this.tabOM.add(this.labelTftpFile);
            this.textFieldTftpFile = new GuiUtilTextField();
            this.textFieldTftpFile.setBounds(170, 100, 200, 18);
            ParamsEnum.boot_file.setTextField(this.textFieldTftpFile);
            this.tabOM.add(this.textFieldTftpFile);
            this.labelSyslogSrv = new AastraLabel();
            this.labelSyslogSrv.setBounds(20, 125, 140, 16);
            this.labelSyslogSrv.setText("Syslog server address");
            this.tabOM.add(this.labelSyslogSrv);
            this.textFieldSyslogSrv = new GuiUtilTextField();
            this.textFieldSyslogSrv.setBounds(170, 125, 200, 18);
            ParamsEnum.syslgip.setTextField(this.textFieldSyslogSrv);
            this.tabOM.add(this.textFieldSyslogSrv);
            this.labelSyslogPort = new AastraLabel();
            this.labelSyslogPort.setBounds(20, 150, 140, 16);
            this.labelSyslogPort.setText("Syslog server port");
            this.tabOM.add(this.labelSyslogPort);
            this.textFieldSyslogPort = new GuiUtilTextField();
            this.textFieldSyslogPort.setBounds(170, 150, 200, 18);
            ParamsEnum.syslgport.setTextField(this.textFieldSyslogPort);
            this.tabOM.add(this.textFieldSyslogPort);
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setBounds(400, 25, 140, 16);
            aastraLabel.setText(ConfigReader.getDisplayNameFromName("dns"));
            this.tabOM.add(aastraLabel);
            this.textFieldDNS = new GuiUtilTextField();
            this.textFieldDNS.setBounds(550, 25, 200, 18);
            ParamsEnum.dns.setTextField(this.textFieldDNS);
            this.tabOM.add(this.textFieldDNS);
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(400, 50, 140, 16);
            aastraLabel2.setText(ConfigReader.getDisplayNameFromName("tftp"));
            this.tabOM.add(aastraLabel2);
            this.textFieldConfigSrv = new GuiUtilTextField();
            this.textFieldConfigSrv.setBounds(550, 50, 200, 18);
            ParamsEnum.tftp.setTextField(this.textFieldConfigSrv);
            this.tabOM.add(this.textFieldConfigSrv);
            this.utilErrorComp.put(ParamsEnum.ommip1.name(), this.labelOmm1, this.textFieldOmm1);
            this.utilErrorComp.put(ParamsEnum.ommip2.name(), this.labelOmm2, this.textFieldOmm2);
            this.utilErrorComp.put(ParamsEnum.siaddr.name(), this.labelTftp, this.textFieldTftp);
            this.utilErrorComp.put(ParamsEnum.boot_file.name(), this.labelTftpFile, this.textFieldTftpFile);
            this.utilErrorComp.put(ParamsEnum.syslgip.name(), this.labelSyslogSrv, this.textFieldSyslogSrv);
            this.utilErrorComp.put(ParamsEnum.syslgport.name(), this.labelSyslogPort, this.textFieldSyslogPort);
            this.utilErrorComp.put(ParamsEnum.dns.name(), aastraLabel, this.textFieldDNS);
            this.utilErrorComp.put(ParamsEnum.tftp.name(), aastraLabel2, this.textFieldConfigSrv);
        }
        return this.tabOM;
    }

    protected AastraPanel getTabCfgServers() {
        if (this.tabCfgServers == null) {
            this.tabCfgServers = new AastraPanel();
            this.tabCfgServers.setLayout(null);
        }
        return this.tabCfgServers;
    }

    protected AastraPanel getTabOther() {
        if (this.tabOther == null) {
            this.tabOther = new AastraPanel();
            this.tabOther.setLayout(null);
            this.paramDb = new ParameterDb();
            this.paramTable = new ConfiguratorTable(this.paramDb);
            this.paramTable.setDefaultRenderer(String.class, this.paramDb.getTableCellRenderer());
            this.paramTable.setSelectionMode(0);
            int[] nArray = new int[]{1, 2};
            this.paramTable.setColumnArr(nArray, nArray.length);
            this.paramTable.registerEventListener(this);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.paramTable);
            jScrollPane.setBounds(10, 10, 400, 170);
            this.tabOther.add(jScrollPane);
            this.textFieldParamName = new GuiUtilTextField();
            this.textFieldParamName.setBounds(420, 10, 180, 18);
            this.textFieldParamName.setEditable(false);
            this.tabOther.add(this.textFieldParamName);
            this.cbNewParamNames = new AastraComboBox();
            this.cbNewParamNames.setBounds(420, 118, 180, 18);
            this.cbNewParamNames.setEditable(true);
            for (int i = 0; i < ConfigReader.allParameters.size(); ++i) {
                ConfigRow configRow = ConfigReader.allParameters.elementAt(i);
                String string = configRow.getDisplayName();
                try {
                    ParamsEnum.valueOf(configRow.getName());
                    continue;
                }
                catch (Exception exception) {
                    this.cbNewParamNames.addItem(string);
                }
            }
            this.tabOther.add(this.cbNewParamNames);
            this.textFieldParamValue = new GuiUtilTextField();
            this.textFieldParamValue.setBounds(610, 10, 200, 18);
            this.tabOther.add(this.textFieldParamValue);
            this.checkBoxParamValueBool = new GuiUtilTristateCheckBox();
            this.checkBoxParamValueBool.setBounds(610, 10, 200, 18);
            this.checkBoxParamValueBool.setVisible(false);
            this.tabOther.add(this.checkBoxParamValueBool);
            this.buttonChangeParamValue = new AastraButton();
            this.buttonChangeParamValue.setText("Change");
            this.buttonChangeParamValue.setBounds(610, 33, 90, 25);
            this.buttonChangeParamValue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigRow configRow = null;
                    String string = RfpDetailPanel.this.textFieldParamName.getText();
                    String string2 = null;
                    if (string != null) {
                        configRow = ConfigReader.getParamFromConfig(string, true);
                        if (configRow != null) {
                            if (configRow.getType() == 1) {
                                if (RfpDetailPanel.this.checkBoxParamValueBool.getState() == AastraTristateCheckbox.SELECTED) {
                                    string2 = "1";
                                }
                                if (RfpDetailPanel.this.checkBoxParamValueBool.getState() == AastraTristateCheckbox.NOT_SELECTED) {
                                    string2 = "0";
                                }
                            } else {
                                string2 = RfpDetailPanel.this.textFieldParamValue.getText();
                            }
                        } else {
                            string2 = RfpDetailPanel.this.textFieldParamValue.getText();
                        }
                        if (string2 != null) {
                            RfpDetailPanel.this.paramDb.setParamValue(string, string2);
                            ((ConfiguratorTableModel)RfpDetailPanel.this.paramTable.getModel()).fireTableDataChanged();
                        }
                    }
                }
            });
            this.tabOther.add(this.buttonChangeParamValue);
            this.buttonRemoveParam = new AastraButton();
            this.buttonRemoveParam.setText("Remove");
            this.buttonRemoveParam.setBounds(420, 33, 90, 25);
            this.buttonRemoveParam.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = RfpDetailPanel.this.textFieldParamName.getText();
                    if (!string.equals("") && RfpDetailPanel.this.paramDb.removeParameter(string)) {
                        RfpDetailPanel.this.actualParamName = "";
                        ((ConfiguratorTableModel)RfpDetailPanel.this.paramTable.getModel()).fireTableDataChanged();
                    }
                }
            });
            this.tabOther.add(this.buttonRemoveParam);
            this.buttonNewParam = new AastraButton();
            this.buttonNewParam.setText("New");
            this.buttonNewParam.setBounds(610, 118, 90, 25);
            this.buttonNewParam.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)RfpDetailPanel.this.cbNewParamNames.getSelectedItem();
                    if (string == null) {
                        return;
                    }
                    if (!string.isEmpty()) {
                        RfpDetailPanel.this.paramDb.addParameter(string);
                        String string2 = RfpDetailPanel.this.paramDb.getParamValue(string);
                        RfpDetailPanel.this.actualParamName = string;
                        RfpDetailPanel.this.updateTextFields(string, string2);
                        ((ConfiguratorTableModel)RfpDetailPanel.this.paramTable.getModel()).fireTableDataChanged();
                    }
                }
            });
            this.tabOther.add(this.buttonNewParam);
            this.updateTextFields(null);
        }
        return this.tabOther;
    }

    private void updateTextFields(String string, String string2) {
        ConfigRow configRow = null;
        if (string != null) {
            this.textFieldParamName.setText(string);
            this.actualParamName = string;
            configRow = ConfigReader.getParamFromConfig(string, true);
            this.textFieldParamValue.setEnabled(true);
            this.buttonChangeParamValue.setEnabled(true);
            this.buttonRemoveParam.setEnabled(true);
        }
        if (string2 != null) {
            if (configRow != null) {
                if (configRow.getType() == 1) {
                    this.textFieldParamValue.setVisible(false);
                    this.checkBoxParamValueBool.setVisible(true);
                    if (string2.equals("1")) {
                        this.checkBoxParamValueBool.setState(AastraTristateCheckbox.SELECTED);
                    } else if (string2.equals("0")) {
                        this.checkBoxParamValueBool.setState(AastraTristateCheckbox.NOT_SELECTED);
                    } else {
                        this.checkBoxParamValueBool.setState(AastraTristateCheckbox.DONT_CARE);
                    }
                } else {
                    this.textFieldParamValue.setVisible(true);
                    this.checkBoxParamValueBool.setVisible(false);
                    this.textFieldParamValue.setText(string2);
                }
            } else {
                this.textFieldParamValue.setVisible(true);
                this.checkBoxParamValueBool.setVisible(false);
                this.textFieldParamValue.setText(string2);
            }
        } else if (configRow != null) {
            if (configRow.getType() == 1) {
                this.textFieldParamValue.setVisible(false);
                this.checkBoxParamValueBool.setVisible(true);
                this.checkBoxParamValueBool.setState(AastraTristateCheckbox.DONT_CARE);
            } else {
                this.textFieldParamValue.setVisible(true);
                this.checkBoxParamValueBool.setVisible(false);
                this.textFieldParamValue.setText("");
            }
        }
    }

    private void updateTextFields(DataRecord dataRecord) {
        if (dataRecord == null) {
            this.textFieldParamValue.setVisible(true);
            this.checkBoxParamValueBool.setVisible(false);
            this.textFieldParamName.setText("");
            this.textFieldParamValue.setText("");
            this.textFieldParamValue.setEnabled(false);
            this.buttonChangeParamValue.setEnabled(false);
            this.buttonRemoveParam.setEnabled(false);
            this.actualParamName = "";
            return;
        }
        String string = (String)dataRecord.getField(1);
        String string2 = (String)dataRecord.getField(2);
        this.updateTextFields(string, string2);
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.updateTextFields(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        this.updateTextFields(dataRecord);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.updateTextFields(dataRecord);
    }
}

