/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg.rfpcfg;

import com.aastra.omcfg.GuiMain;
import com.aastra.omcfg.guiutil.GuiUtilIcon;
import com.aastra.omcfg.rfpcfg.ConfigReader;
import com.aastra.omcfg.rfpcfg.ConfigurationFunctions;
import com.aastra.omcfg.rfpcfg.EthIf;
import com.aastra.omcfg.rfpcfg.IpAddressDlg;
import com.aastra.omcfg.rfpcfg.NetworkEventSynchronizer;
import com.aastra.omcfg.rfpcfg.NewNetworkThread;
import com.aastra.omcfg.rfpcfg.ParameterDb;
import com.aastra.omcfg.rfpcfg.ParamsEnum;
import com.aastra.omcfg.rfpcfg.ProxyAndPasswordDialog;
import com.aastra.omcfg.rfpcfg.RfpDatabase;
import com.aastra.omcfg.rfpcfg.RfpDetailPanel;
import com.aastra.omcfg.rfpcfg.RfpRecord;
import com.aastra.omcfg.rfpcfg.TaskPanel;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.Database;
import com.aastra.omilib.DatabaseChangeEvent;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumn;

public class RfpPanel
extends AastraPanel
implements ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface,
Database.DatabaseChangeNotificationInterface {
    private static final long serialVersionUID = 1L;
    private AastraScrollPane tablePane = null;
    private TaskPanel taskPanel = null;
    private ConfiguratorTable table = null;
    private AastraPanel rfpTableAndDetailPane = null;
    private RfpDetailPanel rfpDetailPanel = null;
    public boolean rfpDetailPanelActive = false;
    private ConfigurationFunctions sp;
    private NewNetworkThread networkThread = null;
    public RfpRecord rfpCopyFrom = null;
    private int CurrentTaskPanelSelectionState = 0;
    private RfpDatabase rfpDb = null;

    public RfpPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.rfpDb = new RfpDatabase();
        this.rfpDb.registerChangeNotificationListener(this);
        this.add((Component)this.getRfpTableAndDetailPane(), "Center");
        this.add((Component)this.getTaskPanel(), "East");
        this.sp = new ConfigurationFunctions();
        NetworkEventSynchronizer.setRfpDatabase(this.rfpDb);
        NetworkEventSynchronizer.setConfigurationFunctionsObject(this.sp);
        EthIf.initializeIpAddr();
        ConfigReader configReader = new ConfigReader("/resources/omm_param.cfg");
        configReader.readConfigFile();
        this.networkThread = new NewNetworkThread();
        this.sp.setNetworkThreadObject(this.networkThread);
        this.networkThread.setConfigFunctionsObject(this.sp);
        this.networkThread.start();
    }

    private AastraPanel getRfpTableAndDetailPane() {
        if (this.rfpTableAndDetailPane == null) {
            this.rfpTableAndDetailPane = new AastraPanel();
            this.rfpTableAndDetailPane.setLayout(new BorderLayout());
            this.rfpTableAndDetailPane.add((Component)this.getTablePane(), "Center");
        }
        return this.rfpTableAndDetailPane;
    }

    public void showRfpDetails(boolean bl) {
        if (!this.rfpDetailPanelActive && !bl) {
            return;
        }
        int n = this.table.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        DataRecord[] dataRecordArray = new DataRecord[n];
        int[] nArray = this.table.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.table.convertRowIndexToModel(nArray[i]);
            dataRecordArray[i] = this.rfpDb.getRecordByIdx(n2);
        }
        this.createRfpDetailPanel(dataRecordArray);
    }

    public void hideRfpDetails() {
        if (this.rfpDetailPanelActive) {
            this.rfpTableAndDetailPane.remove(this.getRfpDetailPanel(this));
            this.rfpTableAndDetailPane.validate();
            this.rfpDetailPanelActive = false;
            this.taskPanel.updateTaskBar(this.CurrentTaskPanelSelectionState);
        }
    }

    public void updateRfpData(RfpRecord[] rfpRecordArray) {
        if (rfpRecordArray == null) {
            return;
        }
        for (int i = 0; i < rfpRecordArray.length; ++i) {
            if (rfpRecordArray[i] == null) continue;
            this.rfpDb.createRfp(rfpRecordArray[i]);
        }
    }

    public void createRfpDetailPanel(DataRecord[] dataRecordArray) {
        if (this.rfpDetailPanelActive) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating RFP detail panel");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating RFP detail panel");
            this.rfpTableAndDetailPane.add((Component)this.getRfpDetailPanel(this), "South");
            this.rfpDetailPanelActive = true;
            this.taskPanel.updateTaskBar(this.CurrentTaskPanelSelectionState);
        }
        if (dataRecordArray != null) {
            this.rfpDetailPanel.setDetailData(dataRecordArray);
        }
        this.rfpTableAndDetailPane.validate();
    }

    private ConfiguratorTable getTable() {
        if (this.table == null) {
            this.table = new ConfiguratorTable(this.rfpDb);
            this.table.registerEventListener(this);
            int[] nArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            this.table.setColumnArr(nArray, nArray.length);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setMinWidth(18);
            tableColumn.setMaxWidth(18);
            tableColumn = this.table.getColumnModel().getColumn(2);
            tableColumn.setMinWidth(105);
            tableColumn.setMaxWidth(150);
            tableColumn = this.table.getColumnModel().getColumn(3);
            tableColumn.setMinWidth(65);
            tableColumn.setMaxWidth(65);
            tableColumn = this.table.getColumnModel().getColumn(4);
            tableColumn.setMinWidth(85);
            tableColumn.setMaxWidth(105);
            tableColumn = this.table.getColumnModel().getColumn(5);
            tableColumn.setMinWidth(85);
            tableColumn.setMaxWidth(105);
            tableColumn = this.table.getColumnModel().getColumn(6);
            tableColumn.setMinWidth(85);
            tableColumn.setMaxWidth(105);
            tableColumn = this.table.getColumnModel().getColumn(7);
            tableColumn.setMinWidth(85);
            tableColumn.setMaxWidth(105);
            tableColumn = this.table.getColumnModel().getColumn(8);
            tableColumn.setMinWidth(85);
            tableColumn.setMaxWidth(105);
            tableColumn = this.table.getColumnModel().getColumn(9);
            tableColumn.setMinWidth(85);
            tableColumn.setMaxWidth(105);
            this.table.setIconArray(3, GuiUtilIcon.getIconInactiveOKError());
            ImageIcon[] imageIconArray = new ImageIcon[]{GuiUtilIcon.getIconPlaceHolder(), GuiUtilIcon.getIconArrowRight(), GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall), GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall)};
            this.table.setIconArray(1, imageIconArray);
            this.table.registerMultiSelectListener(this);
            this.table.setActive(true);
        }
        return this.table;
    }

    private AastraScrollPane getTablePane() {
        if (this.tablePane == null) {
            this.tablePane = new AastraScrollPane(this.getTable());
        }
        return this.tablePane;
    }

    private AastraPanel getRfpDetailPanel(RfpPanel rfpPanel) {
        if (this.rfpDetailPanel == null) {
            this.rfpDetailPanel = new RfpDetailPanel(rfpPanel);
        }
        return this.rfpDetailPanel;
    }

    private AastraPanel getTaskPanel() {
        if (this.taskPanel == null) {
            this.taskPanel = new TaskPanel(this, this.getTable());
        }
        return this.taskPanel;
    }

    public void taskBarActionScan() {
        ProxyAndPasswordDialog proxyAndPasswordDialog = new ProxyAndPasswordDialog((Frame)GuiMain.getGuiMainObject(), ProxyAndPasswordDialog.DlgType.SCAN);
        proxyAndPasswordDialog.setModal(true);
        proxyAndPasswordDialog.setVisible(true);
        if (proxyAndPasswordDialog.exitWithOK) {
            this.sp.Scan(proxyAndPasswordDialog.getCBValueRequestConfig(), proxyAndPasswordDialog.getUserName(), proxyAndPasswordDialog.getPassword(), proxyAndPasswordDialog.getCBValueShowOnlyRfpWithParameters(), proxyAndPasswordDialog.getProxy());
            proxyAndPasswordDialog.saveSettings();
        }
    }

    public void taskBarActionCopy() {
        int n = this.table.getSelectedRowCount();
        if (n > 1) {
            return;
        }
        if (n == 0) {
            return;
        }
        int n2 = this.table.getSelectedRow();
        int n3 = this.table.convertRowIndexToModel(n2);
        this.rfpCopyFrom = this.rfpDb.getRecordByIdx(n3);
        String string = (String)this.rfpCopyFrom.getField(2);
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
        this.hideRfpDetails();
    }

    public void taskBarActionPaste() {
        if (this.rfpCopyFrom == null) {
            return;
        }
        IpAddressDlg ipAddressDlg = new IpAddressDlg((Frame)GuiMain.getGuiMainObject(), 2);
        ipAddressDlg.setModal(true);
        ipAddressDlg.setVisible(true);
        if (!ipAddressDlg.exitWithOK) {
            return;
        }
        int n = this.table.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = this.table.convertRowIndexToModel(nArray[i]);
            RfpRecord rfpRecord = this.rfpDb.getRecordByIdx(n3);
            if (rfpRecord == this.rfpCopyFrom) continue;
            if (ipAddressDlg.getAssignIpAddress()) {
                String string;
                String string2 = (String)rfpRecord.getField(4);
                if (string2 != null) {
                    if (!string2.isEmpty()) {
                        if (ipAddressDlg.getOverwrieIpAddress()) {
                            string = i == 0 ? ipAddressDlg.getIpAddress() : IpAddressDlg.getNextAddress(true);
                            rfpRecord.setField(4, string);
                        }
                    } else {
                        string = i == 0 ? ipAddressDlg.getIpAddress() : IpAddressDlg.getNextAddress(true);
                        rfpRecord.setField(4, string);
                    }
                } else {
                    string = i == 0 ? ipAddressDlg.getIpAddress() : IpAddressDlg.getNextAddress(true);
                    rfpRecord.setField(4, string);
                }
            }
            for (n2 = 0; n2 < 15; ++n2) {
                if (n2 == 0 || n2 == 4 || n2 == 2 || n2 == 1) continue;
                rfpRecord.setField(n2, this.rfpCopyFrom.getField(n2));
            }
            for (n2 = 0; n2 < ParameterDb.paramCount; ++n2) {
                rfpRecord.paramDb.paramValues[n2] = this.rfpCopyFrom.paramDb.paramValues[n2];
                rfpRecord.paramDb.paramDeleted[n2] = this.rfpCopyFrom.paramDb.paramDeleted[n2];
                rfpRecord.paramDb.paramDeletedCount = this.rfpCopyFrom.paramDb.paramDeletedCount;
            }
            rfpRecord.setField(1, (Object)RfpRecord.ConfigChangedEnum.CHANGED);
            this.rfpDb.createRfp(rfpRecord);
        }
        this.hideRfpDetails();
    }

    public void taskBarActionSendConfiguration() {
        ProxyAndPasswordDialog proxyAndPasswordDialog = new ProxyAndPasswordDialog((Frame)GuiMain.getGuiMainObject(), ProxyAndPasswordDialog.DlgType.SETCONFIG);
        proxyAndPasswordDialog.setModal(true);
        proxyAndPasswordDialog.setVisible(true);
        if (!proxyAndPasswordDialog.exitWithOK) {
            return;
        }
        this.sp.proxy = proxyAndPasswordDialog.getProxy();
        proxyAndPasswordDialog.saveSettings();
        int n = this.table.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        for (int i = 0; i < n; ++i) {
            int n2 = this.table.convertRowIndexToModel(nArray[i]);
            RfpRecord rfpRecord = this.rfpDb.getRecordByIdx(n2);
            this.sp.ParamSend(rfpRecord, ProxyAndPasswordDialog.user, ProxyAndPasswordDialog.password);
        }
    }

    public void taskBarActionSetToFactoryDefaults() {
        int n = this.table.getSelectedRowCount();
        if (n != 1) {
            return;
        }
        ProxyAndPasswordDialog proxyAndPasswordDialog = new ProxyAndPasswordDialog((Frame)GuiMain.getGuiMainObject(), ProxyAndPasswordDialog.DlgType.RESET);
        proxyAndPasswordDialog.setModal(true);
        proxyAndPasswordDialog.setVisible(true);
        if (!proxyAndPasswordDialog.exitWithOK) {
            return;
        }
        this.sp.proxy = proxyAndPasswordDialog.getProxy();
        proxyAndPasswordDialog.saveSettings();
        int[] nArray = this.table.getSelectedRows();
        RfpRecord rfpRecord = this.rfpDb.getRecordByIdx(this.table.convertRowIndexToModel(nArray[0]));
        this.sp.ResetReqSend((String)rfpRecord.getField(2), ProxyAndPasswordDialog.user, ProxyAndPasswordDialog.password);
    }

    public void taskBarActionRemoveRfps() {
        int n;
        int n2 = this.table.getSelectedRowCount();
        if (n2 < 1) {
            return;
        }
        this.hideRfpDetails();
        String[] stringArray = new String[n2];
        int[] nArray = this.table.getSelectedRows();
        for (n = 0; n < n2; ++n) {
            int n3 = this.table.convertRowIndexToModel(nArray[n]);
            RfpRecord rfpRecord = this.rfpDb.getRecordByIdx(n3);
            stringArray[n] = (String)rfpRecord.getField(2);
        }
        for (n = 0; n < n2; ++n) {
            RfpRecord rfpRecord = this.rfpDb.getRecordByMac(stringArray[n]);
            if (rfpRecord == null) continue;
            int n4 = (Integer)rfpRecord.getField(0);
            this.rfpDb.deleteRfp(n4);
        }
    }

    public void taskBarActionClearRfpList() {
        this.rfpDb.clearAll();
        this.rfpCopyFrom = null;
        this.hideRfpDetails();
    }

    public void taskBarActionAddRFP() {
        IpAddressDlg ipAddressDlg = new IpAddressDlg((Frame)GuiMain.getGuiMainObject(), 1);
        ipAddressDlg.setMacAddress("00:30:42:");
        ipAddressDlg.setModal(true);
        ipAddressDlg.setVisible(true);
        if (!ipAddressDlg.exitWithOK) {
            return;
        }
        String string = ipAddressDlg.getMACAddress();
        if (string == null) {
            System.out.println("no MAC input");
            return;
        }
        if (string.isEmpty()) {
            System.out.println("MAC empty");
            return;
        }
        string = string.toLowerCase();
        RfpRecord rfpRecord = this.rfpDb.createRfp(string);
        rfpRecord.setField(3, "1");
        if (ipAddressDlg.getAssignIpAddress()) {
            rfpRecord.setField(4, ipAddressDlg.getIpAddress());
        }
        this.rfpDb.createRfp(rfpRecord);
    }

    private void printField(RfpRecord rfpRecord, String string, PrintWriter printWriter) {
        try {
            ParamsEnum paramsEnum = ParamsEnum.valueOf(string);
            if (paramsEnum.dbIdx != 0) {
                Object object = rfpRecord.getField(paramsEnum.dbIdx);
                if (object != null) {
                    printWriter.print((String)object + ";");
                } else {
                    printWriter.print(";");
                }
            }
        }
        catch (Exception exception) {
            String string2 = ConfigReader.getDisplayNameFromName(string);
            if (string2 == null) {
                printWriter.print(";");
                return;
            }
            String string3 = rfpRecord.paramDb.getParamValue(string2);
            if (string3 == null) {
                printWriter.print(";");
                return;
            }
            if (string3.isEmpty()) {
                printWriter.print(";");
                return;
            }
            printWriter.print(string3 + ";");
        }
    }

    private void writeDataFile(String string, int[] nArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string, false);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "ISO-8859-1"));
            printWriter.println("# ----------------------------------------------------- #");
            printWriter.println("# instruction section                                   #");
            printWriter.println("# ----------------------------------------------------- #");
            printWriter.println(" ");
            printWriter.println("# active = ");
            printWriter.println("# net_mask = ");
            printWriter.println("# tftp_server = ");
            printWriter.println("# tftp_file = ");
            printWriter.println("# omm_1 = ");
            printWriter.println("# omm_2 = ");
            printWriter.println("# gateway = ");
            printWriter.println("# dns_server = ");
            printWriter.println("# dns_domain = ");
            printWriter.println("# syslog_addr = ");
            printWriter.println("# syslog_port = ");
            printWriter.println("# use_vlan = ");
            printWriter.println("# srvlist = ");
            printWriter.println("# broadcast_addr = ");
            printWriter.println("# vlan_id = ");
            printWriter.println("# preferred_tftp = ");
            printWriter.println("# config_file_server = ");
            printWriter.println(" ");
            printWriter.println("# ----------------------------------------------------- #");
            printWriter.println("# data sequence                                         #");
            printWriter.println("# ----------------------------------------------------- #");
            printWriter.println("#  1. MAC_ADDR           ! no instruction supported !");
            printWriter.println("#  2. ACTIVE_FLAG");
            printWriter.println("#  3. RFPADDR            ! no instruction supported !");
            printWriter.println("#  4. NET_MASK");
            printWriter.println("#  5. TFTP_SERVER");
            printWriter.println("#  6. TFTP_FILE");
            printWriter.println("#  7. OMM1");
            printWriter.println("#  8. OMM2");
            printWriter.println("#  9. GATEWAY");
            printWriter.println("# 10. DNS_SERVER");
            printWriter.println("# 11. DNS_DOMAIN");
            printWriter.println("# 12. SYSLOG_ADDR");
            printWriter.println("# 13. SYSLOG_PORT");
            printWriter.println("# 14. USE_VLAN");
            printWriter.println("# 15. SRVLIST");
            printWriter.println("# 16. BROADCAST_ADDR");
            printWriter.println("# 17. VLAN_ID");
            printWriter.println("# 18. PREFERRED_TFTP");
            printWriter.println("# 19. CONFIG_FILE_SERVER");
            printWriter.println(" ");
            printWriter.println("data_sequence");
            for (int i = 0; i < nArray.length; ++i) {
                int n = this.table.convertRowIndexToModel(nArray[i]);
                RfpRecord rfpRecord = this.rfpDb.getRecordByIdx(n);
                printWriter.print((String)rfpRecord.getField(2) + ";");
                Object object = rfpRecord.getField(3);
                if (object != null) {
                    if (object == RfpRecord.LocalConfigEnum.CONFIG_YES) {
                        printWriter.print("1;");
                    } else {
                        printWriter.print("0;");
                    }
                } else {
                    printWriter.print("0;");
                }
                this.printField(rfpRecord, "ip", printWriter);
                this.printField(rfpRecord, "subnet", printWriter);
                this.printField(rfpRecord, "siaddr", printWriter);
                this.printField(rfpRecord, "boot_file", printWriter);
                this.printField(rfpRecord, "ommip1", printWriter);
                this.printField(rfpRecord, "ommip2", printWriter);
                this.printField(rfpRecord, "router", printWriter);
                this.printField(rfpRecord, "dns", printWriter);
                this.printField(rfpRecord, "domain", printWriter);
                this.printField(rfpRecord, "syslgip", printWriter);
                this.printField(rfpRecord, "syslgport", printWriter);
                this.printField(rfpRecord, "use_vlan", printWriter);
                this.printField(rfpRecord, "srvlist", printWriter);
                this.printField(rfpRecord, "broadcast", printWriter);
                this.printField(rfpRecord, "vlanid", printWriter);
                this.printField(rfpRecord, "prefsrv", printWriter);
                this.printField(rfpRecord, "tftp", printWriter);
                printWriter.println("");
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void taskBarActionSaveConfig() {
        int n = this.table.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        this.hideRfpDetails();
        FileDialog fileDialog = new FileDialog((Frame)GuiMain.getGuiMainObject(), "save config", 1);
        fileDialog.setVisible(true);
        String string = fileDialog.getDirectory() + fileDialog.getFile();
        if (fileDialog.getFile() != null && fileDialog.getFile().length() > 0) {
            int[] nArray = this.table.getSelectedRows();
            this.writeDataFile(string, nArray);
        }
    }

    /*
     * Exception decompiling
     */
    public void taskBarActionLoadConfig() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void tableEvent() {
        if (this.taskPanel == null) {
            return;
        }
        int n = this.table.getSelectedRowCount();
        if (n == 0) {
            this.CurrentTaskPanelSelectionState = 0;
        } else if (n == 1) {
            this.CurrentTaskPanelSelectionState = 1;
        } else if (n > 1) {
            this.CurrentTaskPanelSelectionState = 2;
        }
        this.taskPanel.updateTaskBar(this.CurrentTaskPanelSelectionState);
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        this.tableEvent();
        this.showRfpDetails(false);
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.tableEvent();
        this.showRfpDetails(false);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        this.tableEvent();
        this.showRfpDetails(true);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.tableEvent();
        this.showRfpDetails(false);
    }

    @Override
    public void databaseChangeNotification(DatabaseChangeEvent databaseChangeEvent) {
        if (this.rfpDb.getRecordNumber() == 0) {
            this.taskPanel.setClearListState(false);
        } else {
            this.taskPanel.setClearListState(true);
        }
    }

    public class FileOpenFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File file, String string) {
            string.toLowerCase();
            return string.endsWith(".txt") || string.endsWith(".csv") || string.endsWith(".tpl");
        }
    }
}

