/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg.util;

import com.aastra.omcfg.GuiInfoConsole;
import com.aastra.omcfg.guiutil.GuiUtilTristateCheckBox;
import com.aastra.omcfg.util.UtilErrorComp;
import com.aastra.omcfg.util.UtilLocale;
import com.aastra.omilib.DataRecord;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraTextField;
import com.aastra.style.AastraTristateCheckbox;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UtilMisc {
    private static final Pattern patternColon = Pattern.compile("^[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}$");
    private static final Pattern patternHyphon = Pattern.compile("^[A-Fa-f0-9]{2}-[A-Fa-f0-9]{2}-[A-Fa-f0-9]{2}-[A-Fa-f0-9]{2}-[A-Fa-f0-9]{2}-[A-Fa-f0-9]{2}$");

    public static AastraTristateCheckbox.State getRecordsFieldState(DataRecord[] dataRecordArray, int n) {
        AastraTristateCheckbox.State state = AastraTristateCheckbox.DONT_CARE;
        Object object = dataRecordArray[0].getField(n);
        if (object == null) {
            return state;
        }
        boolean bl = (Boolean)object;
        state = bl ? AastraTristateCheckbox.SELECTED : AastraTristateCheckbox.NOT_SELECTED;
        for (int i = 1; i < dataRecordArray.length; ++i) {
            object = dataRecordArray[i].getField(n);
            if (object == null) {
                return AastraTristateCheckbox.DONT_CARE;
            }
            if (bl == (Boolean)object) continue;
            state = AastraTristateCheckbox.DONT_CARE;
            break;
        }
        return state;
    }

    public static Object getRecordsFieldObject(DataRecord[] dataRecordArray, int n) {
        Object object = dataRecordArray[0].getField(n);
        object = object != null && object.getClass() == Integer.class ? new Integer(0) : AastraCommon.AastraTriStateText;
        return UtilMisc.getRecordsFieldObject(dataRecordArray, n, object);
    }

    public static Object getRecordsFieldObject(DataRecord[] dataRecordArray, int n, Object object) {
        Object object2 = dataRecordArray[0].getField(n);
        for (int i = 1; i < dataRecordArray.length; ++i) {
            if (object2 != null && object2.equals(dataRecordArray[i].getField(n))) continue;
            object2 = object;
            break;
        }
        return object2;
    }

    public static void setRecordFromTristateCheckbox(DataRecord dataRecord, GuiUtilTristateCheckBox guiUtilTristateCheckBox, int n) {
        if (guiUtilTristateCheckBox.isEnabled() && guiUtilTristateCheckBox.getState() != GuiUtilTristateCheckBox.DONT_CARE) {
            dataRecord.setField(n, guiUtilTristateCheckBox.isSelected());
        }
    }

    public static void setRecordFromTristateCheckbox(DataRecord dataRecord, GuiUtilTristateCheckBox guiUtilTristateCheckBox, int n, boolean bl) {
        if ((bl || guiUtilTristateCheckBox.isEnabled()) && guiUtilTristateCheckBox.getState() != GuiUtilTristateCheckBox.DONT_CARE) {
            dataRecord.setField(n, guiUtilTristateCheckBox.isSelected());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean validateIPAddress(String string) {
        if (string == null || string.length() <= 0) return false;
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 4) return false;
        for (String string2 : stringArray) {
            int n;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n >= 0 && n <= 255) continue;
            return false;
        }
        return true;
    }

    public static boolean validateMACAddress(String string) {
        Matcher matcher = patternColon.matcher(string);
        if (matcher.matches()) {
            return true;
        }
        matcher = patternHyphon.matcher(string);
        return matcher.matches();
    }

    public static int getIntFromTextField(AastraTextField aastraTextField, String string, UtilErrorComp utilErrorComp, int n) {
        return UtilMisc.getIntFromTextField(aastraTextField, string, utilErrorComp, n, 0, null);
    }

    public static int getIntFromTextFieldNotNull(AastraTextField aastraTextField, String string, UtilErrorComp utilErrorComp, int n) {
        return UtilMisc.getIntFromTextField(aastraTextField, string, utilErrorComp, n, 1, null);
    }

    public static int getIntFromTextFieldRange(AastraTextField aastraTextField, String string, UtilErrorComp utilErrorComp, int n, int n2, int n3) {
        return UtilMisc.getIntFromTextField(aastraTextField, string, utilErrorComp, n, n2, n3);
    }

    private static int getIntFromTextField(AastraTextField aastraTextField, String string, UtilErrorComp utilErrorComp, int n, Integer n2, Integer n3) {
        int n4 = -1;
        if (aastraTextField.getText().length() > 0) {
            try {
                n4 = Integer.parseInt(aastraTextField.getText(), n);
                if (n2 != null && n4 < n2 || n3 != null && n4 > n3) {
                    n4 = -1;
                    GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_INVALID"), string));
                    utilErrorComp.markComponent(aastraTextField);
                }
            }
            catch (NumberFormatException numberFormatException) {
                GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_INPUT_FORMAT_INVALID"), string));
                utilErrorComp.markComponent(aastraTextField);
            }
        } else {
            GuiInfoConsole.showError(String.format(UtilLocale.getString("TXT_PARAMETER_*_MISSING"), string));
            utilErrorComp.markComponent(aastraTextField);
        }
        return n4;
    }
}

