/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.omcfg.util;

import com.aastra.omcfg.util.UtilConvert;
import com.aastra.omcfg.util.UtilFilterTable;
import com.aastra.omcfg.util.UtilLocale;
import com.aastra.omilib.Hex;
import com.aastra.util.UtilSpy;
import java.awt.Dimension;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class UtilPreferences {
    public static final boolean tableColumnsWidthInPreferences = false;
    static Preferences prefsGeneral = Preferences.userRoot().node("/com/mitel/omcfg/general");
    static Preferences prefsSystem = Preferences.userRoot().node("/com/mitel/omcfg/system");
    private static String[] ommSystemNameArray = null;
    private static String[] ommAddressArray = null;
    private static String[] ommUserNameArray = null;
    private static String[] syncViewImagePathArray = null;
    private static String[] localeArray = new String[2];
    private static boolean spyClassInfo = false;
    private static BitSet spyIdBitSet = null;
    private static int remainingStarts = 0;
    private static BitSet generalBooleanSettingIdBitSet = null;
    private static BitSet warningIdBitSet = null;
    private static Dimension appSize = new Dimension();
    private static boolean openRespAttribsChanged = false;
    private static boolean monitoringPermissionChanged = false;
    private static int[][] tableColumnsWidthArray = null;
    private static BitSet[] tableColumnsSelectionArray = null;
    private static UtilFilterTable.TableFilter[] tableFilterArray = new UtilFilterTable.TableFilter[TableFilterValuesKeyTypeEnum.values().length];
    private static LinkedList<PreferenceInterface> listenerList = new LinkedList();

    public static void checkOpenRespAttribs() {
    }

    public static boolean isOpenRespAttribsChanged() {
        return openRespAttribsChanged;
    }

    public static boolean isMonitoringPermissionChanged() {
        return monitoringPermissionChanged;
    }

    public static void removeObsoletePreferences() {
        for (int i = 0; i < ObsoleteGeneralKeyTypeEnum.values().length; ++i) {
            String string = ObsoleteGeneralKeyTypeEnum.values()[i].name();
            String string2 = prefsGeneral.get(string, null);
            if (string2 == null) continue;
            prefsGeneral.remove(string);
        }
    }

    public static void readLocale() {
        UtilPreferences.localeArray[0] = prefsGeneral.get(GeneralKeyTypeEnum.Language.name(), null);
        if (localeArray[0] != null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Reading pref key '" + GeneralKeyTypeEnum.Language.name() + "' = '" + localeArray[0] + "'");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Pref key '" + GeneralKeyTypeEnum.Language.name() + "' not found");
        }
        UtilPreferences.localeArray[1] = prefsGeneral.get(GeneralKeyTypeEnum.Region.name(), null);
        if (localeArray[1] != null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Reading pref key '" + GeneralKeyTypeEnum.Region.name() + "' = '" + localeArray[1] + "'");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Pref key '" + GeneralKeyTypeEnum.Region.name() + "' not found");
        }
    }

    public static void writeLocale() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Writing pref key '" + GeneralKeyTypeEnum.Language.name() + "' = '" + localeArray[0] + "'");
        prefsGeneral.put(GeneralKeyTypeEnum.Language.name(), localeArray[0]);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Writing pref key '" + GeneralKeyTypeEnum.Region.name() + "' = '" + localeArray[1] + "'");
        prefsGeneral.put(GeneralKeyTypeEnum.Region.name(), localeArray[1]);
    }

    public static Locale getLocale() {
        Locale locale = null;
        Locale locale2 = null;
        if (localeArray[0] != null && !localeArray[0].isEmpty() && localeArray[1] != null && !localeArray[1].isEmpty()) {
            locale = new Locale(localeArray[0], localeArray[1]);
            try {
                UtilLocale.LanguageType.valueOf(localeArray[0]);
                UtilLocale.RegionType.valueOf(localeArray[1]);
                locale2 = locale;
            }
            catch (Exception exception) {
                UtilPreferences.localeArray[0] = UtilLocale.LanguageType.en.name();
                UtilPreferences.localeArray[1] = UtilLocale.RegionType.US.name();
                locale2 = new Locale(localeArray[0], localeArray[1]);
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilLocale.class, "Locale '" + locale.toString() + "' invalid and set to '" + locale2.toString() + "'");
            }
        } else {
            UtilPreferences.localeArray[0] = UtilLocale.LanguageType.en.name();
            UtilPreferences.localeArray[1] = UtilLocale.RegionType.US.name();
            locale2 = new Locale(localeArray[0], localeArray[1]);
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilLocale.class, "Language or region missing and locale set to '" + locale2.toString() + "'");
        }
        return locale2;
    }

    public static void setLocale(Locale locale) {
        UtilPreferences.localeArray[0] = locale.getLanguage();
        UtilPreferences.localeArray[1] = locale.getCountry();
    }

    public static void readSpyIds() {
        String string = prefsGeneral.get(GeneralKeyTypeEnum.SpyIds.name(), null);
        if (string != null && !string.isEmpty()) {
            char[] cArray = string.toCharArray();
            spyIdBitSet = UtilConvert.byteArray2BitSet(Hex.decodeHex(cArray));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Reading pref key '" + GeneralKeyTypeEnum.SpyIds.name() + "' = " + spyIdBitSet);
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Pref key '" + GeneralKeyTypeEnum.SpyIds.name() + "' not found");
        }
    }

    public static void writeSpyIds() {
        byte[] byArray = UtilConvert.bitSet2ByteArray(spyIdBitSet);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Writing pref key '" + GeneralKeyTypeEnum.SpyIds.name() + "' = " + spyIdBitSet);
        prefsGeneral.put(GeneralKeyTypeEnum.SpyIds.name(), String.valueOf(Hex.encodeHex(byArray)));
    }

    public static BitSet getSpyIds() {
        return spyIdBitSet;
    }

    public static void setSpyIds(BitSet bitSet) {
        spyIdBitSet = bitSet;
    }

    public static void readSpyClassInfo() {
        String string = prefsGeneral.get(GeneralKeyTypeEnum.SpyClassInfo.name(), null);
        if (string != null && !string.isEmpty()) {
            spyClassInfo = true;
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Reading pref key '" + GeneralKeyTypeEnum.SpyClassInfo.name() + "' = " + spyClassInfo);
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Pref key '" + GeneralKeyTypeEnum.SpyClassInfo.name() + "' not found");
        }
    }

    public static void writeSpyClassInfo() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Writing pref key '" + GeneralKeyTypeEnum.SpyClassInfo.name() + "' = " + spyClassInfo);
        if (spyClassInfo) {
            prefsGeneral.put(GeneralKeyTypeEnum.SpyClassInfo.name(), "1");
        } else {
            prefsGeneral.remove(GeneralKeyTypeEnum.SpyClassInfo.name());
        }
    }

    public static boolean getSpyClassInfo() {
        return spyClassInfo;
    }

    public static void setSpyClassInfo(boolean bl) {
        spyClassInfo = bl;
    }

    public static void readRemainingStarts() {
        String string = prefsGeneral.get(GeneralKeyTypeEnum.RemainingStarts.name(), null);
        if (string != null && !string.isEmpty()) {
            try {
                remainingStarts = Integer.parseInt(string);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Reading pref key '" + GeneralKeyTypeEnum.RemainingStarts.name() + "' = " + remainingStarts);
            }
            catch (NumberFormatException numberFormatException) {
                remainingStarts = 0;
                UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Number format exception when reading pref key '" + GeneralKeyTypeEnum.RemainingStarts.name() + "' = '" + string + "'");
            }
        } else {
            if (spyIdBitSet != null) {
                spyIdBitSet.clear();
                spyClassInfo = false;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Pref key '" + GeneralKeyTypeEnum.RemainingStarts.name() + "' not found");
        }
    }

    public static void writeRemainingStarts() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Writing pref key '" + GeneralKeyTypeEnum.RemainingStarts.name() + "' = " + remainingStarts);
        prefsGeneral.put(GeneralKeyTypeEnum.RemainingStarts.name(), String.valueOf(remainingStarts));
    }

    public static int getRemainingStarts() {
        return remainingStarts;
    }

    public static void setRemainingStarts(int n) {
        remainingStarts = n;
    }

    public static void readGeneralBooleanSettingIds() {
        String string = prefsGeneral.get(GeneralKeyTypeEnum.GeneralBooleanSettingIds.name(), null);
        if (string != null && !string.isEmpty()) {
            char[] cArray = string.toCharArray();
            generalBooleanSettingIdBitSet = UtilConvert.byteArray2BitSet(Hex.decodeHex(cArray));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Reading pref key '" + GeneralKeyTypeEnum.GeneralBooleanSettingIds.name() + "' = " + generalBooleanSettingIdBitSet);
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Pref key '" + GeneralKeyTypeEnum.GeneralBooleanSettingIds.name() + "' not found");
        }
    }

    public static void writeGeneralBooleanSettingIds() {
        byte[] byArray = UtilConvert.bitSet2ByteArray(generalBooleanSettingIdBitSet);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Writing pref key '" + GeneralKeyTypeEnum.GeneralBooleanSettingIds.name() + "' = " + generalBooleanSettingIdBitSet);
        prefsGeneral.put(GeneralKeyTypeEnum.GeneralBooleanSettingIds.name(), String.valueOf(Hex.encodeHex(byArray)));
    }

    public static BitSet getGeneralBooleanSettingIds() {
        return generalBooleanSettingIdBitSet;
    }

    public static void setGeneralBooleanSettingIds(BitSet bitSet) {
        generalBooleanSettingIdBitSet = bitSet;
    }

    public static void readWarningIds() {
        String string = prefsGeneral.get(GeneralKeyTypeEnum.WarningIds.name(), null);
        if (string != null && !string.isEmpty()) {
            char[] cArray = string.toCharArray();
            warningIdBitSet = UtilConvert.byteArray2BitSet(Hex.decodeHex(cArray));
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Reading pref key '" + GeneralKeyTypeEnum.WarningIds.name() + "' = " + warningIdBitSet);
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Pref key '" + GeneralKeyTypeEnum.WarningIds.name() + "' not found");
        }
    }

    public static void writeWarningIds() {
        byte[] byArray = UtilConvert.bitSet2ByteArray(warningIdBitSet);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Writing pref key '" + GeneralKeyTypeEnum.WarningIds.name() + "' = " + warningIdBitSet);
        prefsGeneral.put(GeneralKeyTypeEnum.WarningIds.name(), String.valueOf(Hex.encodeHex(byArray)));
    }

    public static BitSet getWarningIds() {
        return warningIdBitSet;
    }

    public static void setWarningIds(BitSet bitSet) {
        warningIdBitSet = bitSet;
    }

    public static void readAppSize() {
        String string = prefsGeneral.get(GeneralKeyTypeEnum.ApplicationHeight.name(), null);
        if (string != null && !string.isEmpty()) {
            UtilPreferences.appSize.height = Integer.parseInt(string);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Reading pref key '" + GeneralKeyTypeEnum.ApplicationHeight.name() + "' = " + UtilPreferences.appSize.height);
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Pref key '" + GeneralKeyTypeEnum.ApplicationHeight.name() + "' not found");
        }
        String string2 = prefsGeneral.get(GeneralKeyTypeEnum.ApplicationWidth.name(), null);
        if (string2 != null && !string2.isEmpty()) {
            UtilPreferences.appSize.width = Integer.parseInt(string2);
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Reading pref key '" + GeneralKeyTypeEnum.ApplicationWidth.name() + "' = " + UtilPreferences.appSize.width);
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Pref key '" + GeneralKeyTypeEnum.ApplicationWidth.name() + "' not found");
        }
    }

    public static void writeAppSize() {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Writing pref key '" + GeneralKeyTypeEnum.ApplicationHeight.name() + "' = " + UtilPreferences.appSize.height);
        prefsGeneral.putInt(GeneralKeyTypeEnum.ApplicationHeight.name(), UtilPreferences.appSize.height);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Writing pref key '" + GeneralKeyTypeEnum.ApplicationWidth.name() + "' = " + UtilPreferences.appSize.width);
        prefsGeneral.putInt(GeneralKeyTypeEnum.ApplicationWidth.name(), UtilPreferences.appSize.width);
    }

    public static Dimension getAppSize() {
        return appSize;
    }

    public static void setAppSize(Dimension dimension) {
        appSize = dimension;
    }

    public static void readOmmSystemNames() {
        int n = 0;
        ommSystemNameArray = new String[SystemNameKeyTypeEnum.values().length];
        for (SystemNameKeyTypeEnum systemNameKeyTypeEnum : SystemNameKeyTypeEnum.values()) {
            UtilPreferences.ommSystemNameArray[n] = prefsSystem.get(systemNameKeyTypeEnum.name(), null);
            if (ommSystemNameArray[n] == null) break;
            ++n;
        }
        if (ommSystemNameArray[0] != null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Reading pref key '" + SystemNameKeyTypeEnum.OmmSystemName1.name() + "' = '" + ommSystemNameArray[0] + "'");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Pref key '" + SystemNameKeyTypeEnum.OmmSystemName1.name() + "' not found");
        }
    }

    public static void writeOmmSystemNames() {
        int n = 0;
        for (SystemNameKeyTypeEnum systemNameKeyTypeEnum : SystemNameKeyTypeEnum.values()) {
            if (n >= ommSystemNameArray.length || ommSystemNameArray[n] == null) break;
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Writing pref key '" + systemNameKeyTypeEnum.name() + "' = '" + ommSystemNameArray[n] + "'");
            prefsSystem.put(systemNameKeyTypeEnum.name(), ommSystemNameArray[n]);
            ++n;
        }
    }

    public static String[] getOmmSystemNames() {
        return ommSystemNameArray;
    }

    public static void setOmmSystemName(String string) {
        UtilPreferences.ommSystemNameArray[0] = string;
    }

    public static void readSyncViewImagePaths() {
        int n = 0;
        syncViewImagePathArray = new String[SyncViewImagePathKeyTypeEnum.values().length];
        for (SyncViewImagePathKeyTypeEnum syncViewImagePathKeyTypeEnum : SyncViewImagePathKeyTypeEnum.values()) {
            UtilPreferences.syncViewImagePathArray[n] = prefsSystem.get(syncViewImagePathKeyTypeEnum.name(), null);
            if (syncViewImagePathArray[n] == null || syncViewImagePathArray[n].isEmpty()) break;
            ++n;
        }
        if (syncViewImagePathArray[0] != null && !syncViewImagePathArray[0].isEmpty()) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Reading pref key '" + SyncViewImagePathKeyTypeEnum.SyncViewImagePath1.name() + "' = '" + syncViewImagePathArray[0] + "'");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Pref key '" + SyncViewImagePathKeyTypeEnum.SyncViewImagePath1.name() + "' not found");
        }
    }

    public static void writeSyncViewImagePaths() {
        int n = 0;
        for (SyncViewImagePathKeyTypeEnum syncViewImagePathKeyTypeEnum : SyncViewImagePathKeyTypeEnum.values()) {
            if (n >= syncViewImagePathArray.length || syncViewImagePathArray[n] == null) break;
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Writing pref key '" + syncViewImagePathKeyTypeEnum.name() + "' = '" + syncViewImagePathArray[n] + "'");
            prefsSystem.put(syncViewImagePathKeyTypeEnum.name(), syncViewImagePathArray[n]);
            ++n;
        }
    }

    public static String getSyncViewImagePath() {
        return syncViewImagePathArray[0];
    }

    public static void setSyncViewImagePath(String string) {
        UtilPreferences.syncViewImagePathArray[0] = string;
    }

    public static void readOmmAddresses() {
        int n = 0;
        ommAddressArray = new String[AddressKeyTypeEnum.values().length];
        for (AddressKeyTypeEnum addressKeyTypeEnum : AddressKeyTypeEnum.values()) {
            UtilPreferences.ommAddressArray[n] = prefsSystem.get(addressKeyTypeEnum.name(), null);
            if (ommAddressArray[n] == null || ommAddressArray[n].isEmpty()) break;
            ++n;
        }
        if (ommAddressArray[0] != null && !ommAddressArray[0].isEmpty()) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Reading pref key '" + AddressKeyTypeEnum.OmmAddress1.name() + "' = '" + ommAddressArray[0] + "'");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Pref key '" + AddressKeyTypeEnum.OmmAddress1.name() + "' not found");
        }
    }

    public static void writeOmmAddresses() {
        int n = 0;
        for (AddressKeyTypeEnum addressKeyTypeEnum : AddressKeyTypeEnum.values()) {
            if (n >= ommAddressArray.length || ommAddressArray[n] == null || ommAddressArray[n].isEmpty()) break;
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Writing pref key '" + addressKeyTypeEnum.name() + "' = '" + ommAddressArray[n] + "'");
            prefsSystem.put(addressKeyTypeEnum.name(), ommAddressArray[n]);
            ++n;
        }
        prefsGeneral.remove(GeneralKeyTypeEnum.OmmVersion.name());
    }

    public static String[] getOmmAdresses() {
        return ommAddressArray;
    }

    public static void readOmmUserNames() {
        int n = 0;
        ommUserNameArray = new String[UserNameKeyTypeEnum.values().length];
        for (UserNameKeyTypeEnum userNameKeyTypeEnum : UserNameKeyTypeEnum.values()) {
            UtilPreferences.ommUserNameArray[n] = prefsSystem.get(userNameKeyTypeEnum.name(), null);
            if (ommUserNameArray[n] == null || ommUserNameArray[n].isEmpty()) break;
            ++n;
        }
        if (ommUserNameArray[0] != null && !ommUserNameArray[0].isEmpty()) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Reading pref key '" + UserNameKeyTypeEnum.OmmUserName1.name() + "' = '" + ommUserNameArray[0] + "'");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Pref key '" + UserNameKeyTypeEnum.OmmUserName1.name() + "' not found");
        }
    }

    public static void writeOmmUserNames() {
        int n = 0;
        for (UserNameKeyTypeEnum userNameKeyTypeEnum : UserNameKeyTypeEnum.values()) {
            if (n >= ommUserNameArray.length || ommUserNameArray[n] == null || ommUserNameArray[n].isEmpty()) break;
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Writing pref key '" + userNameKeyTypeEnum.name() + "' = '" + ommUserNameArray[n] + "'");
            prefsSystem.put(userNameKeyTypeEnum.name(), ommUserNameArray[n]);
            ++n;
        }
    }

    public static String[] getOmmUserNames() {
        return ommUserNameArray;
    }

    public static void setOmmLoginData(String string, Integer n, String string2) {
        int n2 = 0;
        boolean bl = false;
        String string3 = string;
        if (n != null) {
            string3 = string3 + ":" + n.toString();
        }
        for (n2 = 0; n2 < ommAddressArray.length && ommAddressArray[n2] != null; ++n2) {
            if (!ommAddressArray[n2].equals(string3)) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (!ommUserNameArray[n2].equals(string2)) {
                UtilPreferences.ommUserNameArray[n2] = string2;
            }
            if (n2 > 0) {
                UtilPreferences.moveFirstPosition(SystemDataTypeEnum.Address, n2);
                UtilPreferences.moveFirstPosition(SystemDataTypeEnum.UserName, n2);
                UtilPreferences.moveFirstPosition(SystemDataTypeEnum.SystemName, n2);
                UtilPreferences.moveFirstPosition(SystemDataTypeEnum.SyncViewImagePath, n2);
            }
        } else {
            UtilPreferences.insertFirstPosition(SystemDataTypeEnum.Address, string3);
            UtilPreferences.insertFirstPosition(SystemDataTypeEnum.UserName, string2);
            UtilPreferences.insertFirstPosition(SystemDataTypeEnum.SystemName, "");
            UtilPreferences.insertFirstPosition(SystemDataTypeEnum.SyncViewImagePath, "");
        }
    }

    public static void readPreferences() {
        UtilPreferences.removeObsoletePreferences();
        UtilPreferences.readLocale();
        UtilPreferences.readSpyClassInfo();
        UtilPreferences.readSpyIds();
        UtilPreferences.readGeneralBooleanSettingIds();
        UtilPreferences.readWarningIds();
        UtilPreferences.readAppSize();
    }

    public static void writePreferences() {
        UtilPreferences.writeLocale();
        UtilPreferences.writeSpyClassInfo();
        UtilPreferences.writeSpyIds();
        UtilPreferences.writeGeneralBooleanSettingIds();
        UtilPreferences.writeWarningIds();
        UtilPreferences.writeAppSize();
        try {
            if (Preferences.userRoot().nodeExists("/com/aastra/omcfg/general") && Preferences.userRoot().nodeExists("/com/aastra/omcfg/system")) {
                Preferences preferences = Preferences.userRoot().node("/com/aastra/omcfg");
                preferences.removeNode();
                preferences.flush();
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        try {
            prefsSystem.flush();
            prefsGeneral.flush();
        }
        catch (BackingStoreException backingStoreException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Flushing prefs failed");
        }
    }

    private static void moveFirstPosition(SystemDataTypeEnum systemDataTypeEnum, int n) {
        String[] stringArray = null;
        switch (systemDataTypeEnum) {
            case SystemName: {
                stringArray = ommSystemNameArray;
                break;
            }
            case Address: {
                stringArray = ommAddressArray;
                break;
            }
            case UserName: {
                stringArray = ommUserNameArray;
                break;
            }
            case SyncViewImagePath: {
                stringArray = syncViewImagePathArray;
                break;
            }
            default: {
                return;
            }
        }
        String string = stringArray[n];
        for (int i = n; i > 0; --i) {
            stringArray[i] = stringArray[i - 1];
        }
        stringArray[0] = string;
    }

    private static void insertFirstPosition(SystemDataTypeEnum systemDataTypeEnum, String string) {
        int n = 0;
        String[] stringArray = null;
        switch (systemDataTypeEnum) {
            case SystemName: {
                stringArray = ommSystemNameArray;
                break;
            }
            case Address: {
                stringArray = ommAddressArray;
                break;
            }
            case UserName: {
                stringArray = ommUserNameArray;
                break;
            }
            case SyncViewImagePath: {
                stringArray = syncViewImagePathArray;
                break;
            }
            default: {
                return;
            }
        }
        for (n = 0; n < stringArray.length - 1 && stringArray[n] != null; ++n) {
        }
        for (int i = n; i > 0; --i) {
            stringArray[i] = stringArray[i - 1];
        }
        stringArray[0] = string;
    }

    public static int getOmmSystemNameArrayLength() {
        int n = 0;
        if (ommSystemNameArray != null) {
            n = ommSystemNameArray.length;
        }
        return n;
    }

    public static void registerPreferenceInterfaceListener(PreferenceInterface preferenceInterface) {
        listenerList.add(preferenceInterface);
    }

    public static void collectPreferences() {
        if (listenerList.size() != 0) {
            for (PreferenceInterface preferenceInterface : listenerList) {
                if (preferenceInterface == null) continue;
                preferenceInterface.setPreference();
            }
        }
    }

    public static int[] getTableColumnsWidth(TableColumnsWidthKeyTypeEnum tableColumnsWidthKeyTypeEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Get pref key '" + (Object)((Object)tableColumnsWidthKeyTypeEnum));
        return tableColumnsWidthArray[tableColumnsWidthKeyTypeEnum.ordinal()];
    }

    public static void setTableColumnsWidth(TableColumnsWidthKeyTypeEnum tableColumnsWidthKeyTypeEnum, int[] nArray) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Set pref key '" + (Object)((Object)tableColumnsWidthKeyTypeEnum));
        UtilPreferences.tableColumnsWidthArray[tableColumnsWidthKeyTypeEnum.ordinal()] = nArray;
    }

    public static BitSet getTableColumnsSelection(TableColSelectKeyTypeEnum tableColSelectKeyTypeEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Get pref key '" + (Object)((Object)tableColSelectKeyTypeEnum));
        return tableColumnsSelectionArray[tableColSelectKeyTypeEnum.ordinal()];
    }

    public static void setTableColumnsSelection(TableColSelectKeyTypeEnum tableColSelectKeyTypeEnum, BitSet bitSet) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Set pref key '" + (Object)((Object)tableColSelectKeyTypeEnum));
        UtilPreferences.tableColumnsSelectionArray[tableColSelectKeyTypeEnum.ordinal()] = bitSet;
    }

    public static UtilFilterTable.TableFilter getTableFilterValues(TableFilterValuesKeyTypeEnum tableFilterValuesKeyTypeEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Get pref key '" + (Object)((Object)tableFilterValuesKeyTypeEnum));
        return tableFilterArray[tableFilterValuesKeyTypeEnum.ordinal()];
    }

    public static void setTableFilterValues(TableFilterValuesKeyTypeEnum tableFilterValuesKeyTypeEnum, UtilFilterTable.TableFilter tableFilter) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, UtilPreferences.class, "Set pref key '" + (Object)((Object)tableFilterValuesKeyTypeEnum));
        UtilPreferences.tableFilterArray[tableFilterValuesKeyTypeEnum.ordinal()] = tableFilter;
    }

    public static interface PreferenceInterface {
        public void setPreference();
    }

    public static enum TableFilterValuesKeyTypeEnum {
        TableFilterValuesBtBeaconConfig,
        TableFilterValuesBtBeaconMonitor,
        TableFilterValuesBtBeaconPlacement,
        TableFilterValuesPpConfig,
        TableFilterValuesPpMonitor,
        TableFilterValuesPpDevConfig,
        TableFilterValuesPpDevMonitor,
        TableFilterValuesPpUserConfig,
        TableFilterValuesRfpConfig,
        TableFilterValuesRfpMonitor,
        TableFilterValuesRfpPlacement,
        TableFilterValuesVideoDevConfig,
        TableFilterValuesVideoDevMonitor;

    }

    public static enum TableColSelectKeyTypeEnum {
        TableColSelectPpConfig,
        TableColSelectPpMonitor,
        TableColSelectPpUserConfig,
        TableColSelectPpUserMonitor,
        TableColSelectPpDevConfig,
        TableColSelectPpDevMonitor,
        TableColSelectRfpCapture,
        TableColSelectRfpConfig,
        TableColSelectRfpImport,
        TableColSelectRfpExport,
        TableColSelectRfpMonitor,
        TableColSelectRfpExportSet,
        TableColSelectRfpPlacement,
        TableColSelectRfpQualityIp,
        TableColSelectRfpQualityMediaStream,
        TableColSelectRfpQualitySync,
        TableColSelectBtBeaconConfig,
        TableColSelectBtBeaconMonitor,
        TableColSelectBtBeaconPlacement,
        TableColSelectSiteConfig,
        TableColSelectSiteMonitor,
        TableColSelectVideoDevConfig,
        TableColSelectVideoDevMonitor,
        TableColSelectWlanProfileConfig,
        TableColSelectWlanProfileMonitor;

    }

    private static enum SystemDataTypeEnum {
        SystemName,
        Address,
        UserName,
        SyncViewImagePath;

    }

    private static enum SyncViewImagePathKeyTypeEnum {
        SyncViewImagePath1,
        SyncViewImagePath2,
        SyncViewImagePath3,
        SyncViewImagePath4,
        SyncViewImagePath5,
        SyncViewImagePath6,
        SyncViewImagePath7,
        SyncViewImagePath8,
        SyncViewImagePath9,
        SyncViewImagePath10;

    }

    private static enum UserNameKeyTypeEnum {
        OmmUserName1,
        OmmUserName2,
        OmmUserName3,
        OmmUserName4,
        OmmUserName5,
        OmmUserName6,
        OmmUserName7,
        OmmUserName8,
        OmmUserName9,
        OmmUserName10;

    }

    private static enum AddressKeyTypeEnum {
        OmmAddress1,
        OmmAddress2,
        OmmAddress3,
        OmmAddress4,
        OmmAddress5,
        OmmAddress6,
        OmmAddress7,
        OmmAddress8,
        OmmAddress9,
        OmmAddress10;

    }

    private static enum SystemNameKeyTypeEnum {
        OmmSystemName1,
        OmmSystemName2,
        OmmSystemName3,
        OmmSystemName4,
        OmmSystemName5,
        OmmSystemName6,
        OmmSystemName7,
        OmmSystemName8,
        OmmSystemName9,
        OmmSystemName10;

    }

    public static enum TableColumnsWidthKeyTypeEnum {
        TableColumnsWidthAlarmTriggerConfig,
        TableColumnsWidthAlarmTriggerMonitor,
        TableColumnsWidthBtBeaconConfig,
        TableColumnsWidthBtBeaconMonitor,
        TableColumnsWidthBtBeaconPlacement,
        TableColumnsWidthConferenceRoomConfig,
        TableColumnsWidthConferenceRoomMonitor,
        TableColumnsWidthCorpDirConfig,
        TableColumnsWidthCorpDirMonitor,
        TableColumnsWidthDigitTreatmentConfig,
        TableColumnsWidthDigitTreatmentMonitor,
        TableColumnsWidthLdapConfig,
        TableColumnsWidthLdapMonitor,
        TableColumnsWidthPpConfig,
        TableColumnsWidthPpMonitor,
        TableColumnsWidthPpDevConfig,
        TableColumnsWidthPpDevMonitor,
        TableColumnsWidthPpUserConfig,
        TableColumnsWidthPpUserMonitor,
        TableColumnsWidthRfpCapture,
        TableColumnsWidthRfpConfig,
        TableColumnsWidthRfpExport,
        TableColumnsWidthRfpImport,
        TableColumnsWidthRfpMonitor,
        TableColumnsWidthRfpPlacement,
        TableColumnsWidthRfpQualityIp,
        TableColumnsWidthRfpQualityMediaStream,
        TableColumnsWidthRfpQualitySync,
        TableColumnsWidthSystemEventLog,
        TableColumnsWidthSystemUserAccountConfig,
        TableColumnsWidthSystemUserAccountMonitor,
        TableColumnsWidthSiteConfig,
        TableColumnsWidthSiteMonitor,
        TableColumnsWidthVideoDevConfig,
        TableColumnsWidthVideoDevMonitor,
        TableColumnsWidthWlanClients,
        TableColumnsWidthWlanConfig,
        TableColumnsWidthWlanMonitor,
        TableColumnsWidthXmlApplConfig,
        TableColumnsWidthXmlApplMonitor;

    }

    private static enum ObsoleteGeneralKeyTypeEnum {
        HaveSIPStimulus,
        HaveUMO,
        HaveHCM,
        HaveConferencing,
        HaveDetailedSubscription,
        BtdFilter,
        BtBeaconFilter,
        PpDevFilter,
        PpFilter,
        PpUserFilter,
        RfpFilter,
        VideoDevFilter,
        TableFilterActiveBtBeacon,
        TableFilterActivePp,
        TableFilterActivePpDev,
        TableFilterActivePpUser,
        TableFilterActiveRfp,
        TableFilterActiveVideoDev,
        TableFilterValBtBeacon,
        TableFilterValPp,
        TableFilterValPpDev,
        TableFilterValPpUser,
        TableFilterValRfp,
        TableFilterValVideoDev;

    }

    private static enum GeneralKeyTypeEnum {
        ApplicationHeight,
        ApplicationWidth,
        HaveBluetooth,
        HaveConference,
        HaveDigitTreatment,
        HaveExternalUserData,
        HaveFACs,
        HaveLDAP,
        HaveLocating,
        HaveOMP,
        HavePagingAreas,
        HavePPFirmwareUpdate,
        HaveRFPEnrolment,
        HaveRTPPortBaseCnf,
        HaveSIP,
        HaveSecureSIP,
        HaveSNMP,
        HaveSRTP,
        HaveTZones,
        HaveUnboundDevices,
        HaveUserMonitoring,
        HaveVideo,
        HaveVoiceMailNumber,
        HaveXML,
        HaveXMLCorpDir,
        HaveXMLDynamic,
        Language,
        OmmVersion,
        Permissions,
        Region,
        RemainingStarts,
        GeneralBooleanSettingIds,
        SpyClassInfo,
        SpyIds,
        WarningIds;

    }
}

