/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.conferenceroom;

import com.aastra.oamp.conferenceroom.ConferenceRoomDetailPanel;
import com.aastra.oamp.conferenceroom.ConferenceRoomTaskPanel;
import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilConfiguratorTable;
import com.aastra.oamp.guiutil.GuiUtilDetailSplitPanel;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilMainPanel;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.omilib.ConferenceRoomHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.DataRecord;
import com.aastra.omilib.OmiMessage;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.omilibgui.ConfiguratorTableEventInterface;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

public class ConferenceRoomMainPanel
extends GuiUtilMainPanel
implements ConferenceRoomHandler.ConferenceRoomDataNotificationInterface,
ConfiguratorTableEventInterface,
ConfiguratorTable.MultiSelectionNotificationInterface {
    private static final long serialVersionUID = 1L;
    protected static final int xSizeDetailPanelSurcharge = 300;
    protected static final int ySizeDetailPanelSurcharge = 150;
    private static final int ySizeDetailPanel = 360;
    private ConferenceRoomHandler conferenceRoomHandler = null;
    private GuiMain.GuiNavPanelTypeEnum guiNavPanelType = null;
    private GuiUtilDetailSplitPanel conferenceRoomDetailSplitPane = null;
    private AastraScrollPane conferenceRoomTablePane = null;
    private ConferenceRoomDetailPanel conferenceRoomDetailPanel = null;
    private ConferenceRoomTaskPanel conferenceRoomTaskPanel = null;
    private boolean pendingConferenceRoom = false;
    private int idPending = -1;
    private int idCurrentMonitorPanel = -1;
    private int dividerLocation = 0;
    private UtilErrorComp utilErrorComp = null;
    private boolean isEditable = true;

    public ConferenceRoomMainPanel(GuiMain.GuiNavPanelTypeEnum guiNavPanelTypeEnum, ConferenceRoomHandler conferenceRoomHandler) {
        this.guiNavPanelType = guiNavPanelTypeEnum;
        this.conferenceRoomHandler = conferenceRoomHandler;
        this.conferenceRoomHandler.registerDataNotificationListener(this);
        this.initialize();
    }

    private void initialize() {
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_CONFIG) {
            this.utilErrorComp = new UtilErrorComp();
        } else {
            this.isEditable = false;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.getConferenceRoomDetailSplitPane(), "Center");
        this.add((Component)this.getConferenceRoomTaskPanel(), "East");
    }

    private void processTableEvent(DataRecord dataRecord) {
        int n = this.table.getSelectedRowCount();
        if (this.conferenceRoomDetailSplitPane.getBottomComponent() != null) {
            if (dataRecord != null) {
                ConferenceRoomHandler.ConferenceRoom conferenceRoom = (ConferenceRoomHandler.ConferenceRoom)dataRecord;
                this.createConferenceRoomDetailPanel(conferenceRoom, false);
            } else {
                this.removeConferenceRoomDetailPanel();
            }
        } else if (n == 1) {
            this.conferenceRoomTaskPanel.setTaskButtonConfigureShow(true);
        } else {
            this.conferenceRoomTaskPanel.setTaskButtonConfigureShow(false);
        }
        if (this.isEditable) {
            if (n > 0) {
                this.conferenceRoomTaskPanel.setTaskButtonDelete(true);
            } else {
                this.conferenceRoomTaskPanel.setTaskButtonDelete(false);
            }
        }
        this.updateTableInfo();
    }

    public void configureShowConferenceRoom() {
        int n;
        ConferenceRoomHandler.ConferenceRoom conferenceRoom;
        int n2 = this.table.getSelectedRow();
        if (n2 >= 0 && (conferenceRoom = this.conferenceRoomHandler.getConferenceRoomByTableIdx(n = this.table.convertRowIndexToModel(n2))) != null) {
            this.createConferenceRoomDetailPanel(conferenceRoom, false);
        }
    }

    private GuiUtilDetailSplitPanel getConferenceRoomDetailSplitPane() {
        if (this.conferenceRoomDetailSplitPane == null) {
            this.conferenceRoomDetailSplitPane = new GuiUtilDetailSplitPanel(360);
            this.conferenceRoomDetailSplitPane.setTopComponent(this.getConferenceRoomTablePane());
            this.conferenceRoomDetailSplitPane.setBottomComponent(null);
        }
        return this.conferenceRoomDetailSplitPane;
    }

    private GuiUtilConfiguratorTable getConferenceRoomTable() {
        if (this.table == null) {
            int[] nArray = new int[]{0, 1, 2, 5, 6};
            this.table = this.isEditable ? new GuiUtilConfiguratorTable(this, this.conferenceRoomHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthConferenceRoomConfig) : new GuiUtilConfiguratorTable((Object)this, this.conferenceRoomHandler.getDb(), nArray, UtilPreferences.TableColumnsWidthKeyTypeEnum.TableColumnsWidthConferenceRoomMonitor, 0);
        }
        return this.table;
    }

    private AastraScrollPane getConferenceRoomTablePane() {
        if (this.conferenceRoomTablePane == null) {
            this.conferenceRoomTablePane = new AastraScrollPane(this.getConferenceRoomTable());
            this.dividerLocation = this.conferenceRoomDetailSplitPane.getHeight() - 360;
            this.conferenceRoomTablePane.setMinimumSize(new Dimension(0, this.dividerLocation));
        }
        return this.conferenceRoomTablePane;
    }

    private void enableTableAccess() {
        this.table.setActive(true);
        if (this.isEditable) {
            this.conferenceRoomTaskPanel.setTaskButtonCreate(true);
        }
    }

    private void disableTableAccess() {
        this.table.setActive(false);
        this.conferenceRoomTaskPanel.setTaskButtonConfigureShow(false);
        if (this.isEditable) {
            this.conferenceRoomTaskPanel.setTaskButtonCreate(false);
            this.conferenceRoomTaskPanel.setTaskButtonDelete(false);
        }
    }

    private AastraPanel getConferenceRoomDetailPanel() {
        if (this.conferenceRoomDetailPanel == null) {
            this.conferenceRoomDetailPanel = new ConferenceRoomDetailPanel(this, this.guiNavPanelType, this.utilErrorComp);
        }
        return this.conferenceRoomDetailPanel;
    }

    private AastraPanel getConferenceRoomTaskPanel() {
        if (this.conferenceRoomTaskPanel == null) {
            this.conferenceRoomTaskPanel = new ConferenceRoomTaskPanel(this, this.guiNavPanelType);
        }
        return this.conferenceRoomTaskPanel;
    }

    public void createConferenceRoomDetailPanel(ConferenceRoomHandler.ConferenceRoom conferenceRoom, boolean bl) {
        if (bl) {
            this.table.removeRowSelectionAll();
        }
        if (this.conferenceRoomDetailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.pendingConferenceRoom = false;
                this.idPending = -1;
                this.utilErrorComp.clearComponents();
            }
            this.dividerLocation = this.conferenceRoomDetailSplitPane.getDividerLocation();
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Updating conference room config detail panel");
        } else {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Creating conference room config detail panel");
            this.conferenceRoomDetailSplitPane.setBottomComponent(this.getConferenceRoomDetailPanel());
        }
        if (conferenceRoom != null) {
            if (!this.isEditable) {
                this.idCurrentMonitorPanel = conferenceRoom.id;
            }
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading conference room[" + conferenceRoom.id + "]: '" + conferenceRoom.name + "','" + conferenceRoom.conferenceId + "'");
            this.conferenceRoomDetailPanel.setConferenceRoomDetailData(conferenceRoom);
        } else {
            this.conferenceRoomDetailPanel.setConferenceRoomDetailData(null);
        }
        this.conferenceRoomDetailSplitPane.setDividerLocation(this.dividerLocation);
        this.conferenceRoomDetailSplitPane.validate();
        this.conferenceRoomTaskPanel.setTaskButtonConfigureShow(false);
    }

    public void removeConferenceRoomDetailPanel() {
        if (this.conferenceRoomDetailSplitPane.getBottomComponent() != null) {
            if (this.isEditable) {
                this.pendingConferenceRoom = false;
                this.idPending = -1;
                this.utilErrorComp.clearComponents();
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing conference room config detail panel");
            } else {
                this.idCurrentMonitorPanel = -1;
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Removing conference room monitor detail panel");
            }
            this.dividerLocation = this.conferenceRoomDetailSplitPane.getDividerLocation();
            this.conferenceRoomDetailSplitPane.setBottomComponent(null);
            if (this.table.getSelectedRowCount() == 1) {
                this.conferenceRoomTaskPanel.setTaskButtonConfigureShow(true);
            }
        } else {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_GEN_INFO, this, "Tried to remove conference room detail panel, but there is none");
        }
    }

    public void createConferenceRoom() {
        ConferenceRoomHandler.ConferenceRoom conferenceRoom = this.conferenceRoomDetailPanel.getConferenceRoomDetailData();
        if (conferenceRoom != null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Creating conferenceRoom[" + conferenceRoom.id + "]: '" + conferenceRoom.name + "','" + conferenceRoom.conferenceId + "'");
            this.conferenceRoomHandler.sendCreateConferenceRoom(conferenceRoom);
            this.pendingConferenceRoom = true;
            this.idPending = -1;
        }
    }

    public void changeConferenceRoom() {
        ConferenceRoomHandler.ConferenceRoom conferenceRoom = this.conferenceRoomDetailPanel.getConferenceRoomDetailData();
        if (conferenceRoom != null) {
            UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Changing conference room[" + conferenceRoom.id + "]: '" + conferenceRoom.name + "','" + conferenceRoom.conferenceId + "'");
            this.conferenceRoomHandler.sendSetConferenceRoom(conferenceRoom);
            this.pendingConferenceRoom = true;
            this.idPending = conferenceRoom.id;
        }
    }

    public void deleteConferenceRoom() {
        GuiUtilDialog guiUtilDialog;
        int n = this.table.getSelectedRowCount();
        if (n > 0 && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionYesNo, UtilLocale.getString("TXT_DELETE_SELECTED_CONFERENCE_ROOMS_?"), true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionYes) {
            int[] nArray = this.table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = this.table.convertRowIndexToModel(nArray[i]);
                ConferenceRoomHandler.ConferenceRoom conferenceRoom = this.conferenceRoomHandler.getConferenceRoomByTableIdx(n2);
                UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Deleting conferenceRoom[" + conferenceRoom.id + "]");
                this.conferenceRoomHandler.sendDeleteConferenceRoom(conferenceRoom.id);
                if (this.conferenceRoomDetailSplitPane.getBottomComponent() == null) continue;
                this.pendingConferenceRoom = true;
                this.idPending = conferenceRoom.id;
            }
        }
    }

    @Override
    public void processTableMouseClick(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processTableMouseDoubleClick(DataRecord dataRecord) {
        ConferenceRoomHandler.ConferenceRoom conferenceRoom = (ConferenceRoomHandler.ConferenceRoom)dataRecord;
        this.createConferenceRoomDetailPanel(conferenceRoom, false);
    }

    @Override
    public void processMultiSelectionChanged(DataRecord[] dataRecordArray) {
        if (this.conferenceRoomDetailSplitPane.getBottomComponent() != null && this.table.getSelectedRowCount() > 1) {
            this.removeConferenceRoomDetailPanel();
        }
        this.conferenceRoomTaskPanel.setTaskButtonConfigureShow(false);
    }

    @Override
    public void processTableSelectionChanged(DataRecord dataRecord) {
        this.processTableEvent(dataRecord);
    }

    @Override
    public void processConferenceRoomDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "ConferenceRoom notification: " + dataNotificationEnum.toString() + ",id=" + String.valueOf(n));
        block0 : switch (dataNotificationEnum) {
            case DATA_DELETED_ALL: {
                this.disableTableAccess();
                break;
            }
            case DATA_BULK_READY: {
                this.enableTableAccess();
                break;
            }
            default: {
                if (this.isEditable) {
                    switch (dataNotificationEnum) {
                        case NEW_DATA: {
                            if (!this.pendingConferenceRoom) break block0;
                            this.removeConferenceRoomDetailPanel();
                            break;
                        }
                        case DATA_CHANGED: 
                        case DATA_DELETED: {
                            if (!this.pendingConferenceRoom || n != this.idPending) break block0;
                            this.removeConferenceRoomDetailPanel();
                            break;
                        }
                    }
                    break;
                }
                if (n != this.idCurrentMonitorPanel) break;
                switch (dataNotificationEnum) {
                    case NEW_DATA: 
                    case DATA_CHANGED: {
                        ConferenceRoomHandler.ConferenceRoom conferenceRoom = this.conferenceRoomHandler.getConferenceRoomById(n);
                        if (conferenceRoom == null) break block0;
                        this.createConferenceRoomDetailPanel(conferenceRoom, false);
                        break block0;
                    }
                    case DATA_DELETED: {
                        this.removeConferenceRoomDetailPanel();
                        break block0;
                    }
                }
            }
        }
    }

    @Override
    public void processConferenceRoomDataErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string4 = null;
        OmiMessage.errorCodes errorCodes2 = null;
        if (this.guiNavPanelType == GuiMain.GuiNavPanelTypeEnum.GUI_NAV_PANEL_MONITOR || string3 == null) {
            return;
        }
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_MSG, this, "Conference room error notification: " + dataNotificationEnum.toString() + ",id=" + String.valueOf(n) + ",errCode=" + string3 + ",bad=" + string + ",maxLen=" + string2);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            errorCodes2 = null;
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "Conference room error notification: Unknown errorCode=" + string3);
        }
        switch (dataNotificationEnum) {
            case NEW_DATA: 
            case DATA_CHANGED: {
                if (errorCodes2 != null) {
                    String string5 = this.conferenceRoomDetailPanel.getErrorLabelText(string);
                    string4 = UtilErrorHandling.getErrorMessage(errorCodes2, string5, string2);
                    GuiInfoConsole.showError(string4);
                } else {
                    GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
                }
                if (string == null) break;
                this.conferenceRoomDetailPanel.markErrorComponent(string);
                break;
            }
            case DATA_DELETED: {
                string4 = errorCodes2 != null ? (errorCodes2 == OmiMessage.errorCodes.EExist ? UtilLocale.getString("TXT_DELETING_CONFERENCE_ROOMS_FAILED") : UtilErrorHandling.getErrorMessage(errorCodes2, null, null)) : UtilLocale.getString("TXT_UNKNOWN_ERROR");
                GuiInfoConsole.showError(string4);
                break;
            }
        }
    }
}

