/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.gui;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilProdInfo;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GuiAboutDlg
extends AastraDialog {
    private static final long serialVersionUID = 1L;
    private AastraPanel aboutPanel = null;
    private AastraPanel contentPanel = null;
    private AastraButton buttonOK = null;
    private AastraLabel labelVersion = null;
    private AastraLabel labelVersionValue = null;
    private AastraLabel labelCopyright = null;
    private AastraLabel labelApplication = null;

    public GuiAboutDlg(GuiMain guiMain) {
        super(guiMain);
        this.initialize();
    }

    private void initialize() {
        this.setSize(360, 300);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(UtilLocale.getString("TXT_ABOUT") + " " + "OMP");
        this.setContentPane(this.getAboutPanel());
    }

    private AastraPanel getAboutPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new AastraPanel();
            this.contentPanel.setLayout(new BorderLayout());
            this.contentPanel.add((Component)new AastraToolBar(), "North");
            this.aboutPanel = new AastraPanel();
            this.aboutPanel.setLayout(null);
            this.aboutPanel.add(this.getButtonOK());
            this.aboutPanel.add(this.getLabelVersion());
            this.aboutPanel.add(this.getLabelVersionValue());
            this.aboutPanel.add(this.getLabelCopyright());
            this.aboutPanel.add(this.getLabelApplication());
            this.contentPanel.add((Component)this.aboutPanel, "Center");
            this.getRootPane().setDefaultButton(this.getButtonOK());
        }
        return this.contentPanel;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(135, 140, 90, 25);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiAboutDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonOK;
    }

    private AastraLabel getLabelVersion() {
        if (this.labelVersion == null) {
            this.labelVersion = new AastraLabel();
            this.labelVersion.setBounds(15, 28, 50, 16);
            this.labelVersion.setFont(AastraCommon.AastraFontHeader);
            this.labelVersion.setText(UtilLocale.getString("TXT_VERSION") + ":");
        }
        return this.labelVersion;
    }

    private AastraLabel getLabelVersionValue() {
        if (this.labelVersionValue == null) {
            this.labelVersionValue = new AastraLabel();
            this.labelVersionValue.setBounds(70, 28, 275, 32);
            this.labelVersionValue.setFont(AastraCommon.AastraFontHeader);
            String string = UtilProdInfo.getVersion();
            if (string == null || string.equals("UNKNOWN_VERSION")) {
                string = UtilLocale.getString("TXT_UNKNOWN");
            }
            this.labelVersionValue.setText("<html>" + string + "</html>");
        }
        return this.labelVersionValue;
    }

    private AastraLabel getLabelCopyright() {
        if (this.labelCopyright == null) {
            this.labelCopyright = new AastraLabel();
            this.labelCopyright.setBounds(15, 84, 330, 30);
            this.labelCopyright.setFont(AastraCommon.AastraFontHeader);
            this.labelCopyright.setText("<html>Copyright (c) 2010-2018 Mitel Networks Corporation,<br> All Rights Reserved</html>");
        }
        return this.labelCopyright;
    }

    private AastraLabel getLabelApplication() {
        if (this.labelApplication == null) {
            this.labelApplication = new AastraLabel();
            this.labelApplication.setBounds(15, 56, 330, 16);
            this.labelApplication.setFont(AastraCommon.AastraFontHeader);
            String string = "OM Management Portal";
            this.labelApplication.setText(string);
        }
        return this.labelApplication;
    }
}

