/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.gui;

import com.aastra.oamp.gui.GuiInfoConsole;
import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilButton;
import com.aastra.oamp.guiutil.GuiUtilPasswordField;
import com.aastra.oamp.guiutil.GuiUtilTextField;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilErrorHandling;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.AccountDataHandler;
import com.aastra.omilib.DataNotificationEnum;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.util.UtilSpy;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;

public class GuiChangePasswordDlg
extends AastraDialog
implements AccountDataHandler.AccountDataNotificationInterface {
    private static final long serialVersionUID = 1L;
    private static final int xPosLabel = 15;
    private static final int xSizeLabel = 140;
    private static final int ySizeLabel = 32;
    private static final int xPosTextField = 165;
    private static final int xSizeTextField = 155;
    private static final int ySizeTextField = 18;
    private OmiMessage.AccountState[] accountStateArray = null;
    private AccountDataHandler accountDataHandler = null;
    private UtilErrorComp utilErrorComp = null;
    private int idx = 0;
    private AastraPanel panelChangePassword = null;
    private AastraButton buttonOK = null;
    private AastraButton buttonExit = null;
    private AastraLabel labelAccountType = null;
    private AastraLabel labelInfo = null;
    private AastraLabel labelUserName = null;
    private GuiUtilTextField textFieldUserName = null;
    private AastraLabel labelPasswordOld = null;
    private GuiUtilPasswordField passwordFieldPasswordOld = null;
    private AastraLabel labelPassword = null;
    private GuiUtilPasswordField passwordFieldPassword = null;
    private AastraLabel labelPasswordConfirm = null;
    private GuiUtilPasswordField passwordFieldPasswordConfirm = null;
    private boolean oldPwActive = false;
    GuiUtilButton button = new GuiUtilButton();

    public GuiChangePasswordDlg(AccountDataHandler accountDataHandler) {
        super(GuiMain.getGuiMainObject());
        this.accountDataHandler = accountDataHandler;
        OmiMessage.BuiltInAccountType.user.setTranslatedString(UtilLocale.getString("TXT_READ_ONLY"));
        OmiMessage.BuiltInAccountType.admin.setTranslatedString(UtilLocale.getString("TXT_FULL_ACCESS"));
        OmiMessage.BuiltInAccountType.root.setTranslatedString(UtilLocale.getString("TXT_ROOT_SSH_ONLY"));
    }

    public void initialize() {
        this.accountStateArray = GuiMain.getOmiManagementObject().getOmmAccountState();
        this.accountDataHandler.registerDataNotificationListener(this);
        this.setSize(350, 350);
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLocationRelativeTo(null);
        this.setLayout(null);
        this.setTitle("OM Management Portal");
        this.utilErrorComp = new UtilErrorComp();
        this.add(this.getPanelChangePassword());
        this.getRootPane().setDefaultButton(this.getButtonOK());
        this.addWindowListener(new WindowAction());
        this.checkNextAccountState();
    }

    private AastraPanel getPanelChangePassword() {
        if (this.panelChangePassword == null) {
            this.panelChangePassword = new AastraPanel();
            this.panelChangePassword.setSize(350, 350);
            this.panelChangePassword.setLayout(null);
            this.labelAccountType = new AastraLabel();
            this.labelAccountType.setFont(AastraCommon.AastraFontHeader);
            this.labelAccountType.setBounds(15, 15, 300, 16);
            this.labelInfo = new AastraLabel();
            this.labelInfo.setBounds(15, 35, 300, 48);
            this.labelUserName = new AastraLabel();
            this.labelUserName.setBounds(15, 90, 140, 32);
            this.labelUserName.setText(UtilLocale.getString("TXT_USER_NAME"));
            this.labelPasswordOld = new AastraLabel();
            this.labelPasswordOld.setBounds(15, 125, 140, 32);
            this.labelPasswordOld.setText(UtilLocale.getString("TXT_PASSWORD_OLD"));
            this.labelPassword = new AastraLabel();
            this.labelPassword.setBounds(15, 160, 140, 32);
            this.labelPassword.setText(UtilLocale.getString("TXT_PASSWORD"));
            this.labelPasswordConfirm = new AastraLabel();
            this.labelPasswordConfirm.setBounds(15, 195, 140, 32);
            this.labelPasswordConfirm.setText("<html>" + UtilLocale.getString("TXT_PASSWORD_CONFIRMATION") + "</html>");
            this.panelChangePassword.add(this.labelAccountType);
            this.panelChangePassword.add(this.labelInfo);
            this.panelChangePassword.add(this.labelUserName);
            this.panelChangePassword.add(this.getTextFieldUserName());
            this.panelChangePassword.add(this.labelPasswordOld);
            this.panelChangePassword.add(this.getPasswordFieldPasswordOld());
            this.panelChangePassword.add(this.labelPassword);
            this.panelChangePassword.add(this.getPasswordFieldPassword());
            this.panelChangePassword.add(this.labelPasswordConfirm);
            this.panelChangePassword.add(this.getPasswordFieldPasswordConfirm());
            this.panelChangePassword.add(this.getButtonOK());
            this.panelChangePassword.add(this.getButtonExit());
            this.getRootPane().setDefaultButton(this.getButtonOK());
            this.utilErrorComp.put(OmiMessage.AccountType.oldPassword.toString(), this.labelPasswordOld, this.passwordFieldPasswordOld);
            this.utilErrorComp.put(OmiMessage.AccountType.password.toString(), this.labelPassword, this.passwordFieldPassword);
            this.utilErrorComp.put("passwordConfirm", this.labelPasswordConfirm, this.passwordFieldPasswordConfirm);
        }
        return this.panelChangePassword;
    }

    private GuiUtilTextField getTextFieldUserName() {
        if (this.textFieldUserName == null) {
            this.textFieldUserName = new GuiUtilTextField();
            this.textFieldUserName.setBounds(165, 90, 155, 18);
            this.textFieldUserName.setEditable(false);
        }
        return this.textFieldUserName;
    }

    private GuiUtilPasswordField getPasswordFieldPasswordOld() {
        if (this.passwordFieldPasswordOld == null) {
            this.passwordFieldPasswordOld = new GuiUtilPasswordField();
            this.passwordFieldPasswordOld.setBounds(165, 125, 155, 18);
        }
        return this.passwordFieldPasswordOld;
    }

    private GuiUtilPasswordField getPasswordFieldPassword() {
        if (this.passwordFieldPassword == null) {
            this.passwordFieldPassword = new GuiUtilPasswordField();
            this.passwordFieldPassword.setBounds(165, 160, 155, 18);
        }
        return this.passwordFieldPassword;
    }

    private GuiUtilPasswordField getPasswordFieldPasswordConfirm() {
        if (this.passwordFieldPasswordConfirm == null) {
            this.passwordFieldPasswordConfirm = new GuiUtilPasswordField();
            this.passwordFieldPasswordConfirm.setBounds(165, 195, 155, 18);
        }
        return this.passwordFieldPasswordConfirm;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = GuiUtilButton.ButtonOK(60, 250);
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiChangePasswordDlg.this.utilErrorComp.clearComponents();
                    GuiChangePasswordDlg.this.getData();
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonExit() {
        if (this.buttonExit == null) {
            this.buttonExit = GuiUtilButton.ButtonExit(200, 250);
            this.buttonExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiMain.getGuiMainObject().exitApplication(true, null);
                }
            });
        }
        return this.buttonExit;
    }

    private void checkNextAccountState() {
        String string = null;
        this.oldPwActive = false;
        do {
            if (this.accountStateArray[this.idx].id == OmiMessage.BuiltInAccountType.user.ordinal() && this.accountStateArray[this.idx].passwordState == OmiMessage.AccountPasswordStateType.expired) {
                string = UtilLocale.getString("TXT_ACCOUNT_TYPE") + ": " + UtilLocale.getString("TXT_READ_ONLY");
                this.setData(string, UtilLocale.getString("TXT_PASSWORD_EXPIRED"));
                return;
            }
            if (this.accountStateArray[this.idx].id == OmiMessage.BuiltInAccountType.admin.ordinal()) {
                if (this.accountStateArray[this.idx].passwordState == OmiMessage.AccountPasswordStateType.notChanged) {
                    string = UtilLocale.getString("TXT_ACCOUNT_TYPE") + ": " + UtilLocale.getString("TXT_FULL_ACCESS");
                    this.setData(string, UtilLocale.getString("TXT_PASSWORD_DEFAULT_ACTIVE"));
                    return;
                }
                if (this.accountStateArray[this.idx].passwordState == OmiMessage.AccountPasswordStateType.expired) {
                    this.oldPwActive = true;
                    string = UtilLocale.getString("TXT_ACCOUNT_TYPE") + ": " + UtilLocale.getString("TXT_FULL_ACCESS");
                    this.setData(string, UtilLocale.getString("TXT_PASSWORD_EXPIRED"));
                    return;
                }
            }
            if (this.accountStateArray[this.idx].id != OmiMessage.BuiltInAccountType.root.ordinal() || this.accountStateArray[this.idx].passwordState != OmiMessage.AccountPasswordStateType.notChanged) continue;
            string = UtilLocale.getString("TXT_ACCOUNT_TYPE") + ": " + UtilLocale.getString("TXT_ROOT_SSH_ONLY");
            this.setData(string, UtilLocale.getString("TXT_PASSWORD_DEFAULT_ACTIVE"));
            return;
        } while (++this.idx != this.accountStateArray.length);
        if (this.isVisible()) {
            this.setVisible(false);
        }
    }

    private void setData(String string, String string2) {
        this.labelAccountType.setText(string);
        this.labelInfo.setText("<html>" + string2 + "</html>");
        this.textFieldUserName.setText(this.accountStateArray[this.idx].username);
        this.passwordFieldPasswordOld.setText("");
        this.passwordFieldPasswordOld.setEditable(this.oldPwActive);
        this.passwordFieldPassword.setText("");
        this.passwordFieldPasswordConfirm.setText("");
        if (this.isVisible()) {
            if (this.oldPwActive) {
                this.passwordFieldPasswordOld.requestFocusInWindow();
            } else {
                this.passwordFieldPassword.requestFocusInWindow();
            }
        } else {
            this.setVisible(true);
        }
    }

    private void getData() {
        AccountDataHandler.Account account = new AccountDataHandler.Account();
        String string = null;
        String string2 = new String(this.passwordFieldPassword.getPassword());
        String string3 = new String(this.passwordFieldPasswordConfirm.getPassword());
        if (this.passwordFieldPasswordOld.isEditable()) {
            string = new String(this.passwordFieldPasswordOld.getPassword());
            if (string.length() == 0) {
                GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_OLD_NOT_SET"));
                this.markErrorComponent(OmiMessage.AccountType.oldPassword.toString());
                return;
            }
            account.setPasswordOld(string);
        }
        if (string2.length() == 0) {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_NOT_SET"));
            this.markErrorComponent(OmiMessage.AccountType.password.toString());
            return;
        }
        if (string3.length() == 0) {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION_FAILED"));
            this.markErrorComponent("passwordConfirm");
            return;
        }
        if (!string2.equals(string3)) {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_PASSWORD_CONFIRMATION_FAILED"));
            this.markErrorComponent("passwordConfirm");
            return;
        }
        account.id = this.accountStateArray[this.idx].id;
        account.setPassword(string2);
        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, String.format("Change account password: id %d, user name: '%s'\n", account.id, this.accountStateArray[this.idx].username));
        this.accountDataHandler.sendSetAccount(account);
    }

    public void markErrorComponent(String string) {
        JComponent jComponent = this.utilErrorComp.getField(string);
        if (jComponent != null) {
            this.utilErrorComp.markComponent(jComponent);
        }
    }

    public String getErrorLabelText(String string) {
        if (string == null) {
            return null;
        }
        return this.utilErrorComp.getLabelText(string);
    }

    public void deregisterAccountDataListener() {
        this.accountDataHandler.deregisterDataNotificationListener(this);
    }

    @Override
    public void processDataNotification(int n, DataNotificationEnum dataNotificationEnum) {
        String string = OmiMessage.BuiltInAccountType.values()[this.accountStateArray[this.idx].id].getTranslatedString();
        GuiInfoConsole.showInfo(String.format("%s - %s", string, UtilLocale.getString("TXT_PASSWORD_CHANGED_SUCCESSFULLY")));
        if (++this.idx < this.accountStateArray.length) {
            this.checkNextAccountState();
        } else {
            this.setVisible(false);
        }
    }

    @Override
    public void processErrorNotification(int n, DataNotificationEnum dataNotificationEnum, OmiMessage omiMessage) {
        String string = omiMessage.getAttribVal(OmiMessage.attribIds.errCode.name());
        String string2 = omiMessage.getAttribVal(OmiMessage.attribIds.bad.name());
        String string3 = omiMessage.getAttribVal(OmiMessage.attribIds.maxLen.name());
        OmiMessage.errorCodes errorCodes2 = null;
        if (string == null) {
            return;
        }
        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "AccountState error notification: " + dataNotificationEnum.toString() + ",id=" + n + ",errCode=" + string + ",bad=" + string2 + ",maxLen=" + string3);
        try {
            errorCodes2 = OmiMessage.errorCodes.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_MSG, this, "AccountState error notification: Unknown errorCode=" + string);
        }
        if (errorCodes2 != null) {
            String string4 = null;
            if (string2 != null) {
                string4 = this.getErrorLabelText(string2);
            }
            GuiInfoConsole.showError(UtilErrorHandling.getErrorMessage(errorCodes2, string4, string3));
        } else {
            GuiInfoConsole.showError(UtilLocale.getString("TXT_UNKNOWN_ERROR"));
        }
        if (string2 != null) {
            this.markErrorComponent(string2);
        }
    }

    private class WindowAction
    extends WindowAdapter {
        private WindowAction() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (GuiChangePasswordDlg.this.oldPwActive) {
                GuiChangePasswordDlg.this.passwordFieldPasswordOld.requestFocusInWindow();
            } else {
                GuiChangePasswordDlg.this.passwordFieldPassword.requestFocusInWindow();
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            GuiMain.getGuiMainObject().exitApplication(true, null);
        }
    }
}

