/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.gui;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.util.UtilErrorComp;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraComboBox;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraPasswordField;
import com.aastra.style.AastraToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class GuiLoginDlg
extends AastraDialog {
    private static final long serialVersionUID = 1L;
    private AastraPanel panelLogin = null;
    private AastraPanel contentPane = null;
    private AastraPasswordField passwordFieldPassword = null;
    private AastraLabel labelIPAddress = null;
    private AastraLabel labelUserName = null;
    private AastraLabel labelPassword = null;
    private AastraButton buttonOK = null;
    private AastraLabel labelSystemName = null;
    private AastraLabel labelInfo = null;
    private AastraButton buttonExit = null;
    private AastraComboBox comboBoxSystemName = null;
    private AastraComboBox comboBoxAddress = null;
    private AastraComboBox comboBoxUserName = null;
    private String currentIPAddress = null;
    private String currentUserName = null;
    private String currentPassword = null;
    private Integer currentPort = null;
    private int[] systemNameBox2OrgIndex = new int[UtilPreferences.getOmmSystemNameArrayLength()];
    private int[] systemNameOrg2BoxIndex = new int[UtilPreferences.getOmmSystemNameArrayLength()];
    private boolean comboBoxSystemNameInitialized = false;
    private boolean comboBoxAddressInitialized = false;
    private boolean actionListenerSystemNameActive = false;
    private boolean actionListenerAddressActive = false;
    private boolean reconnect = false;
    private UtilErrorComp utilErrorComp = null;
    private static int dlgWidth = 312;
    private static int firstRow = 56;

    public GuiLoginDlg(GuiMain guiMain, String string, String string2, Integer n, String string3, String string4, boolean bl, boolean bl2, boolean bl3) {
        super(guiMain);
        this.initialize(string, string2, n, string3, string4, bl, bl2, bl3);
    }

    private void initialize(String string, String string2, Integer n, String string3, String string4, boolean bl, boolean bl2, boolean bl3) {
        this.setSize(dlgWidth, 364);
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setLocationRelativeTo(null);
        this.setLayout(null);
        this.setTitle("OM Management Portal");
        this.utilErrorComp = new UtilErrorComp();
        this.setContentPane(this.getPanelLogin(string, string2, n, string3, string4, bl2, bl3));
        this.getRootPane().setDefaultButton(this.getButtonOK());
        this.addWindowListener(new WindowAction());
        this.reconnect = bl;
    }

    public String GetOmmIpAddress() {
        return this.currentIPAddress;
    }

    public Integer GetOmmPort() {
        return this.currentPort;
    }

    public String GetOmmUserName() {
        return this.currentUserName;
    }

    public String GetOmmPassword() {
        return this.currentPassword;
    }

    private AastraPanel getPanelLogin(String string, String string2, Integer n, String string3, String string4, boolean bl, boolean bl2) {
        if (this.contentPane == null) {
            this.contentPane = new AastraPanel();
            this.contentPane.setLayout(new BorderLayout());
            AastraToolBar aastraToolBar = new AastraToolBar();
            this.contentPane.add((Component)aastraToolBar, "North");
            this.panelLogin = new AastraPanel();
            this.labelInfo = new AastraLabel();
            this.labelInfo.setFont(AastraCommon.AastraFontHeader);
            this.labelInfo.setLocation(new Point(28, firstRow - 28));
            this.labelInfo.setSize(new Dimension(dlgWidth - 56, 28));
            if (string != null) {
                this.labelInfo.setText("<html>" + string + "</html>");
            } else {
                this.labelInfo.setText(UtilLocale.getString("TXT_LOGIN"));
            }
            this.labelSystemName = new AastraLabel();
            this.labelSystemName.setBounds(28, firstRow, 91, 28);
            this.labelSystemName.setText(UtilLocale.getString("TXT_SYSTEM_NAME"));
            this.labelIPAddress = new AastraLabel();
            this.labelIPAddress.setBounds(28, firstRow + 28, 96, 28);
            this.labelIPAddress.setText(UtilLocale.getString("TXT_IP_ADDRESS"));
            this.labelUserName = new AastraLabel();
            this.labelUserName.setBounds(28, firstRow + 56, 91, 28);
            this.labelUserName.setText(UtilLocale.getString("TXT_USER_NAME"));
            this.labelPassword = new AastraLabel();
            this.labelPassword.setBounds(28, firstRow + 84, 93, 28);
            this.labelPassword.setText(UtilLocale.getString("TXT_PASSWORD"));
            this.panelLogin = new AastraPanel();
            this.panelLogin.setLayout(null);
            this.panelLogin.add(this.getPasswordFieldPassword());
            this.panelLogin.add(this.labelIPAddress);
            this.panelLogin.add(this.labelUserName);
            this.panelLogin.add(this.labelPassword);
            this.panelLogin.add(this.getButtonOK());
            this.panelLogin.add(this.labelSystemName);
            this.panelLogin.add(this.labelInfo);
            this.panelLogin.add(this.getButtonExit());
            this.panelLogin.add(this.getComboBoxAddress());
            this.panelLogin.add(this.getComboBoxUserName());
            this.panelLogin.add(this.getComboBoxSystemName());
            if (string2 != null && string3 != null) {
                this.setComboBoxes(string2, n, string3);
                if (string4 != null) {
                    this.getPasswordFieldPassword().setText(string4);
                }
            }
            this.contentPane.add((Component)this.panelLogin, "Center");
            if (bl) {
                this.utilErrorComp.markComponent(this.getComboBoxUserName());
            }
            if (bl2) {
                this.utilErrorComp.markComponent(this.getPasswordFieldPassword());
            }
        }
        return this.contentPane;
    }

    private void setComboBoxes(String string, Integer n, String string2) {
        int n2 = 0;
        boolean bl = false;
        int n3 = this.getComboBoxAddress().getItemCount();
        String string3 = string;
        if (n != null) {
            string3 = string3 + ":" + n.toString();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!string3.equals(this.getComboBoxAddress().getItemAt(n2)) || !string2.equals(this.getComboBoxUserName().getItemAt(n2))) continue;
            bl = true;
            break;
        }
        this.comboBoxSystemNameInitialized = false;
        this.comboBoxAddressInitialized = false;
        if (bl) {
            if (this.getComboBoxSystemName().isEnabled()) {
                int n4 = this.systemNameOrg2BoxIndex[n2];
                this.getComboBoxSystemName().setSelectedIndex(n4);
            }
            this.getComboBoxAddress().setSelectedIndex(n2);
        } else {
            if (this.getComboBoxSystemName().isEnabled()) {
                this.getComboBoxSystemName().setSelectedIndex(-1);
            }
            this.getComboBoxAddress().getEditor().setItem(string3);
        }
        this.getComboBoxUserName().getEditor().setItem(string2);
        this.comboBoxSystemNameInitialized = true;
        this.comboBoxAddressInitialized = true;
    }

    private AastraPasswordField getPasswordFieldPassword() {
        if (this.passwordFieldPassword == null) {
            this.passwordFieldPassword = new AastraPasswordField();
            this.passwordFieldPassword.setBounds(121, firstRow + 84, 158, 18);
            this.passwordFieldPassword.setText(this.currentPassword);
        }
        return this.passwordFieldPassword;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(28, firstRow + 140, 84, 28);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)GuiLoginDlg.this.comboBoxAddress.getEditor().getItem();
                    if (string.isEmpty()) {
                        GuiLoginDlg.this.labelInfo.setText("<html>" + UtilLocale.getString("TXT_IP_ADDRESS_INVALID") + "</html>");
                        return;
                    }
                    if (string.contains(":")) {
                        String[] stringArray = string.split(":");
                        if (stringArray.length > 2) {
                            if (string.contains("]:")) {
                                stringArray = (string = string.replace("]:", "]-")).split("-");
                                if (stringArray.length != 2 || stringArray[0].isEmpty() || stringArray[1].isEmpty()) {
                                    GuiLoginDlg.this.labelInfo.setText("<html>" + UtilLocale.getString("TXT_IP_ADDRESS_INVALID") + "</html>");
                                    return;
                                }
                                GuiLoginDlg.this.currentIPAddress = stringArray[0];
                                try {
                                    GuiLoginDlg.this.currentPort = Integer.valueOf(stringArray[1]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    GuiLoginDlg.this.currentPort = null;
                                    GuiLoginDlg.this.labelInfo.setText("<html>" + UtilLocale.getString("TXT_IP_ADDRESS_INVALID") + "</html>");
                                    return;
                                }
                            } else {
                                GuiLoginDlg.this.currentIPAddress = string;
                                GuiLoginDlg.this.currentPort = null;
                            }
                        } else {
                            if (stringArray.length != 2 || stringArray[0].isEmpty() || stringArray[1].isEmpty()) {
                                GuiLoginDlg.this.labelInfo.setText("<html>" + UtilLocale.getString("TXT_IP_ADDRESS_INVALID") + "</html>");
                                return;
                            }
                            GuiLoginDlg.this.currentIPAddress = stringArray[0];
                            try {
                                GuiLoginDlg.this.currentPort = Integer.valueOf(stringArray[1]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                GuiLoginDlg.this.currentPort = null;
                                GuiLoginDlg.this.labelInfo.setText("<html>" + UtilLocale.getString("TXT_IP_ADDRESS_INVALID") + "</html>");
                                return;
                            }
                        }
                    } else {
                        GuiLoginDlg.this.currentIPAddress = string;
                        GuiLoginDlg.this.currentPort = null;
                    }
                    string = (String)GuiLoginDlg.this.comboBoxUserName.getEditor().getItem();
                    if (string.isEmpty()) {
                        GuiLoginDlg.this.labelInfo.setText("<html>" + UtilLocale.getString("TXT_USER_NAME_INVALID") + "</html>");
                        return;
                    }
                    GuiLoginDlg.this.currentUserName = string;
                    string = new String(GuiLoginDlg.this.passwordFieldPassword.getPassword());
                    if (string.isEmpty()) {
                        GuiLoginDlg.this.labelInfo.setText("<html>" + UtilLocale.getString("TXT_PASSWORD_INVALID") + "</html>");
                        return;
                    }
                    GuiLoginDlg.this.currentPassword = string;
                    GuiLoginDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonExit() {
        if (this.buttonExit == null) {
            this.buttonExit = new AastraButton();
            this.buttonExit.setBounds(195, firstRow + 140, 84, 28);
            this.buttonExit.setText(UtilLocale.getString("TXT_EXIT"));
            this.buttonExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiLoginDlg.this.exitApplication();
                }
            });
        }
        return this.buttonExit;
    }

    private AastraComboBox getComboBoxSystemName() {
        if (this.comboBoxSystemName == null) {
            this.comboBoxSystemName = new AastraComboBox();
            this.comboBoxSystemName.setBounds(121, firstRow, 158, 20);
            this.comboBoxSystemName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (GuiLoginDlg.this.comboBoxSystemNameInitialized && !GuiLoginDlg.this.actionListenerAddressActive) {
                        GuiLoginDlg.this.actionListenerSystemNameActive = true;
                        int n = GuiLoginDlg.this.comboBoxSystemName.getSelectedIndex();
                        int n2 = GuiLoginDlg.this.systemNameBox2OrgIndex[n];
                        GuiLoginDlg.this.comboBoxAddress.setSelectedIndex(n2);
                        GuiLoginDlg.this.passwordFieldPassword.setText("");
                        GuiLoginDlg.this.actionListenerSystemNameActive = false;
                    }
                }
            });
            String[] stringArray = (String[])UtilPreferences.getOmmSystemNames().clone();
            this.numberEqualEntries(stringArray);
            int n = 0;
            for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
                if (!stringArray[i].isEmpty()) {
                    this.comboBoxSystemName.insertItemAt(stringArray[i], n);
                    this.systemNameBox2OrgIndex[n] = i;
                    this.systemNameOrg2BoxIndex[i] = n;
                } else {
                    this.systemNameOrg2BoxIndex[i] = -1;
                }
                if (stringArray[i].isEmpty()) continue;
                ++n;
            }
            if (this.comboBoxSystemName.getItemCount() == 0) {
                this.comboBoxSystemName.setEnabled(false);
            } else {
                if (!stringArray[0].isEmpty()) {
                    this.comboBoxSystemName.setSelectedIndex(0);
                } else {
                    this.comboBoxSystemName.setSelectedIndex(-1);
                }
                this.comboBoxSystemNameInitialized = true;
            }
        }
        return this.comboBoxSystemName;
    }

    private AastraComboBox getComboBoxAddress() {
        if (this.comboBoxAddress == null) {
            this.comboBoxAddress = new AastraComboBox();
            this.comboBoxAddress.setBounds(121, firstRow + 28, 158, 20);
            this.comboBoxAddress.setEditable(true);
            this.comboBoxAddress.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (GuiLoginDlg.this.comboBoxAddressInitialized && !GuiLoginDlg.this.actionListenerSystemNameActive) {
                        GuiLoginDlg.this.actionListenerAddressActive = true;
                        int n = GuiLoginDlg.this.comboBoxAddress.getSelectedIndex();
                        if (n >= 0) {
                            int n2 = GuiLoginDlg.this.systemNameOrg2BoxIndex[n];
                            GuiLoginDlg.this.comboBoxSystemName.setSelectedIndex(n2);
                            GuiLoginDlg.this.passwordFieldPassword.setText("");
                        }
                        GuiLoginDlg.this.actionListenerAddressActive = false;
                    }
                }
            });
            String[] stringArray = UtilPreferences.getOmmAdresses();
            for (int i = 0; i < stringArray.length && stringArray[i] != null && !stringArray[i].isEmpty(); ++i) {
                this.comboBoxAddress.addItem(stringArray[i]);
            }
            this.comboBoxAddressInitialized = true;
        }
        return this.comboBoxAddress;
    }

    private AastraComboBox getComboBoxUserName() {
        if (this.comboBoxUserName == null) {
            this.comboBoxUserName = new AastraComboBox();
            this.comboBoxUserName.setBounds(121, firstRow + 56, 158, 20);
            this.comboBoxUserName.setEditable(true);
            String[] stringArray = UtilPreferences.getOmmUserNames();
            boolean bl = false;
            for (int i = 0; i < stringArray.length && stringArray[i] != null && !stringArray[i].isEmpty(); ++i) {
                for (int j = 0; j < this.comboBoxUserName.getItemCount(); ++j) {
                    if (!stringArray[i].equals(this.comboBoxUserName.getItemAt(j))) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.comboBoxUserName.addItem(stringArray[i]);
                    continue;
                }
                bl = false;
            }
        }
        return this.comboBoxUserName;
    }

    private void numberEqualEntries(String[] stringArray) {
        for (int i = stringArray.length - 1; i >= 0; --i) {
            if (stringArray[i] == null) continue;
            int n = 0;
            for (int j = i - 1; j >= 0; --j) {
                if (!stringArray[j].equals(stringArray[i])) continue;
                ++n;
            }
            if (n <= 0) continue;
            int n2 = i;
            stringArray[n2] = stringArray[n2] + " (" + (n + 1) + ")";
        }
    }

    private void exitApplication() {
        GuiMain.getGuiMainObject().exitApplication(this.reconnect, null);
    }

    private class WindowAction
    extends WindowAdapter {
        private WindowAction() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            GuiLoginDlg.this.getPasswordFieldPassword().requestFocusInWindow();
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            GuiLoginDlg.this.exitApplication();
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            GuiLoginDlg.this.exitApplication();
        }
    }
}

