/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.gui;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilDialog;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.util.UtilFileHandling;
import com.aastra.oamp.util.UtilGeneralBooleanSettings;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.oamp.util.UtilPreferences;
import com.aastra.oamp.util.UtilProdInfo;
import com.aastra.oamp.util.UtilWarnings;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCheckBox;
import com.aastra.style.AastraComboBox;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.style.AastraTabbedPane;
import com.aastra.style.AastraTextField;
import com.aastra.util.UtilSpy;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class GuiOptionsDlg
extends AastraDialog {
    private static final long serialVersionUID = 1L;
    private GuiMain guiMain = null;
    private AastraPanel panelOptions = null;
    private AastraPanel panelButtonBar = null;
    private AastraTabbedPane tabbedPaneOptions = null;
    private AastraPanel tabGeneral = null;
    private AastraButton buttonOK = null;
    private AastraButton buttonCancel = null;
    private AastraComboBox comboBoxLanguage = null;
    private AastraTextField textFieldUserDirectory = null;
    private AastraCheckBox checkBoxSettingIds = null;
    private AastraPanel tabSpy = null;
    private AastraScrollPane scrollPaneSpyLevels = null;
    private AastraPanel panelAdvancedSettings = null;
    private AastraPanel panelGeneral = null;
    private AastraPanel panelSpyIds = null;
    private AastraPanel panelWarnings = null;
    private AastraCheckBox[] checkBoxSpyIds = new AastraCheckBox[UtilSpy.SpyIdEnum.values().length];
    private AastraCheckBox[] checkBoxWarningIds = new AastraCheckBox[UtilWarnings.WarningIdEnum.values().length];
    private AastraLabel[] labelSpyIds = new AastraLabel[UtilSpy.SpyIdEnum.values().length];
    private AastraLabel[] labelWarningIds = new AastraLabel[UtilWarnings.WarningIdEnum.values().length];
    private AastraScrollPane scrollPaneWarnings = null;
    private AastraLabel labelAdditionalClassInfo = null;
    private AastraCheckBox checkBoxAdditionalClassInfo = null;
    private Locale currentLocale = null;
    private static String[] spyIdComment = new String[]{"TXT_OM_AXI_LINK_MANAGEMENT", "TXT_OM_AXI_MESSAGES", "TXT_GUI_MESSAGES", "TXT_GUI_DATABASE_OPERATIONS", "TXT_GUI_GENERAL_INFO", "TXT_GUI_RFP_SYNCHRONIZATION_VIEW", "TXT_GUI_STATISTICS", "TXT_GUI_RFP_TREE", "TXT_DATABASE", "TXT_TABLE_HANDLING", "TXT_OM_AXI_XML_PARSER", "TXT_GENERAL_INFO"};

    public GuiOptionsDlg() {
        super(GuiMain.getGuiMainObject());
        this.guiMain = GuiMain.getGuiMainObject();
        this.initialize();
    }

    private void initialize() {
        this.setSize(500, 450);
        this.setLocationRelativeTo(null);
        this.setTitle(UtilLocale.getString("TXT_OPTIONS"));
        this.setResizable(false);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setContentPane(this.getPanelOptions());
        this.getRootPane().setDefaultButton(this.getButtonCancel());
        this.addWindowListener(new WindowAction());
    }

    private JPanel getPanelOptions() {
        if (this.panelOptions == null) {
            this.panelOptions = new AastraPanel();
            this.panelOptions.setLayout(new BoxLayout(this.panelOptions, 1));
            this.panelOptions.add(this.getTabbedPaneOptions());
            this.panelOptions.add(this.getPanelButtonBar());
        }
        return this.panelOptions;
    }

    private AastraTabbedPane getTabbedPaneOptions() {
        if (this.tabbedPaneOptions == null) {
            this.tabbedPaneOptions = new AastraTabbedPane();
            this.tabbedPaneOptions.setPreferredSize(new Dimension(450, 350));
            this.tabbedPaneOptions.setMaximumSize(new Dimension(450, 350));
            this.tabbedPaneOptions.setAlignmentX(0.0f);
            this.tabbedPaneOptions.addTab(UtilLocale.getString("TXT_GENERAL"), null, this.getTabGeneral(), null);
            if (!UtilProdInfo.isPrivateProduction()) {
                this.tabbedPaneOptions.addTab(UtilLocale.getString("TXT_LOG_FILE"), null, this.getTabSpy(), null);
            } else {
                this.tabbedPaneOptions.addTab(UtilLocale.getString("TXT_EXPERT_CONSOLE"), null, this.getTabSpy(), null);
            }
        }
        return this.tabbedPaneOptions;
    }

    private AastraPanel getTabGeneral() {
        if (this.tabGeneral == null) {
            this.tabGeneral = new AastraPanel();
            this.tabGeneral.setLayout(new BoxLayout(this.tabGeneral, 1));
            this.tabGeneral.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabGeneral.add(this.getPanelGeneral());
            this.tabGeneral.add(Box.createRigidArea(new Dimension(0, 10)));
            this.tabGeneral.add(this.getScrollPaneWarnings());
        }
        return this.tabGeneral;
    }

    private AastraPanel getTabSpy() {
        if (this.tabSpy == null) {
            this.tabSpy = new AastraPanel();
            this.tabSpy.setLayout(new BoxLayout(this.tabSpy, 1));
            this.tabSpy.add(Box.createRigidArea(new Dimension(0, 10)));
            if (UtilProdInfo.isPrivateProduction()) {
                this.tabSpy.add(this.getPanelAdvancedSettings());
                this.tabSpy.add(Box.createRigidArea(new Dimension(0, 10)));
            }
            this.tabSpy.add(this.getScrollPaneSpyLevels());
        }
        return this.tabSpy;
    }

    private AastraPanel getPanelGeneral() {
        if (this.panelGeneral == null) {
            this.panelGeneral = new AastraPanel();
            this.panelGeneral.setAlignmentX(0.0f);
            this.panelGeneral.setLayout(null);
            Dimension dimension = new Dimension(430, 200);
            this.panelGeneral.setPreferredSize(dimension);
            this.panelGeneral.setMaximumSize(dimension);
            this.panelGeneral.setMinimumSize(dimension);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_GENERAL"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelGeneral.setBorder(BorderFactory.createTitledBorder(titledBorder));
            AastraLabel aastraLabel = new AastraLabel();
            aastraLabel.setText("<html>" + UtilLocale.getString("TXT_INFO_CHANGE_LANGUAGE") + "</html>");
            aastraLabel.setBounds(20, 30, 400, 36);
            aastraLabel.setIcon(GuiUtilIcon.getIconInfo(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            AastraLabel aastraLabel2 = new AastraLabel();
            aastraLabel2.setBounds(20, 75, 60, 16);
            aastraLabel2.setText(UtilLocale.getString("TXT_LANGUAGE"));
            AastraLabel aastraLabel3 = new AastraLabel();
            aastraLabel3.setBounds(20, 105, 110, 32);
            aastraLabel3.setText("<html>" + UtilLocale.getString("TXT_USER_DIRECTORY") + "</html>");
            AastraLabel aastraLabel4 = new AastraLabel();
            aastraLabel4.setText("<html>" + UtilLocale.getString(UtilGeneralBooleanSettings.SettingIdsEnum.TABLE_COL_SELECTION_SORTED_ALPHABETICALLY.text) + "</html>");
            aastraLabel4.setBounds(20, 150, 210, 32);
            this.panelGeneral.add((Component)aastraLabel, null);
            this.panelGeneral.add((Component)aastraLabel2, null);
            this.panelGeneral.add((Component)aastraLabel3, null);
            this.panelGeneral.add((Component)this.getComboBoxLanguage(), null);
            this.panelGeneral.add((Component)this.getTextFieldUserDirectory(), null);
            this.panelGeneral.add(aastraLabel4);
            this.panelGeneral.add(this.getCheckBoxSettingIds());
        }
        return this.panelGeneral;
    }

    private AastraComboBox getComboBoxLanguage() {
        if (this.comboBoxLanguage == null) {
            this.comboBoxLanguage = new AastraComboBox();
            this.comboBoxLanguage.setBounds(150, 73, 150, 20);
            for (int i = 0; i < UtilLocale.languages.length; ++i) {
                this.comboBoxLanguage.addItem(UtilLocale.languages[i].getStrLanguage());
            }
            this.currentLocale = UtilPreferences.getLocale();
            UtilLocale.LanguageType languageType = UtilLocale.LanguageType.valueOf(this.currentLocale.getLanguage());
            switch (languageType) {
                default: {
                    this.comboBoxLanguage.setSelectedIndex(UtilLocale.English);
                    break;
                }
                case de: {
                    this.comboBoxLanguage.setSelectedIndex(UtilLocale.German);
                    break;
                }
                case fr: {
                    this.comboBoxLanguage.setSelectedIndex(UtilLocale.French);
                    break;
                }
                case es: {
                    this.comboBoxLanguage.setSelectedIndex(UtilLocale.Spanish);
                }
            }
        }
        return this.comboBoxLanguage;
    }

    private AastraTextField getTextFieldUserDirectory() {
        if (this.textFieldUserDirectory == null) {
            this.textFieldUserDirectory = new AastraTextField();
            this.textFieldUserDirectory.setBounds(150, 105, 250, 20);
            this.textFieldUserDirectory.setEditable(false);
            this.textFieldUserDirectory.setText(UtilFileHandling.getWorkingDirectory());
            this.textFieldUserDirectory.setToolTipText(UtilFileHandling.getWorkingDirectory());
        }
        return this.textFieldUserDirectory;
    }

    private AastraCheckBox getCheckBoxSettingIds() {
        if (this.checkBoxSettingIds == null) {
            this.checkBoxSettingIds = new AastraCheckBox(247, 147);
            this.checkBoxSettingIds.setSelected(UtilGeneralBooleanSettings.getSingleId(UtilGeneralBooleanSettings.SettingIdsEnum.TABLE_COL_SELECTION_SORTED_ALPHABETICALLY));
        }
        return this.checkBoxSettingIds;
    }

    private AastraPanel getPanelAdvancedSettings() {
        if (this.panelAdvancedSettings == null) {
            this.panelAdvancedSettings = new AastraPanel();
            this.panelAdvancedSettings.setAlignmentX(0.0f);
            this.panelAdvancedSettings.setLayout(null);
            this.panelAdvancedSettings.setPreferredSize(new Dimension(430, 60));
            this.panelAdvancedSettings.setMaximumSize(new Dimension(430, 60));
            this.panelAdvancedSettings.setMinimumSize(new Dimension(430, 60));
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_CONSOLE_SETTINGS"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelAdvancedSettings.setBorder(BorderFactory.createTitledBorder(titledBorder));
            this.labelAdditionalClassInfo = new AastraLabel();
            this.labelAdditionalClassInfo.setBounds(25, 30, 210, 16);
            this.labelAdditionalClassInfo.setText(UtilLocale.getString("TXT_ADDITIONAL_CLASS_INFO"));
            this.panelAdvancedSettings.add((Component)this.labelAdditionalClassInfo, null);
            this.panelAdvancedSettings.add((Component)this.getCheckBoxAdditionalClassInfo(), null);
        }
        return this.panelAdvancedSettings;
    }

    private AastraScrollPane getScrollPaneSpyLevels() {
        if (this.scrollPaneSpyLevels == null) {
            this.scrollPaneSpyLevels = new AastraScrollPane(this.getPanelSpyIds(), 20, 31);
            this.scrollPaneSpyLevels.setAlignmentX(0.0f);
            int n = 100 + (this.getPanelSpyIds().getComponentCount() / 2 - 2) * 25;
            if (n > 240) {
                n = 240;
            }
            this.scrollPaneSpyLevels.setPreferredSize(new Dimension(430, n));
            this.scrollPaneSpyLevels.setMaximumSize(new Dimension(430, n));
            this.scrollPaneSpyLevels.setMinimumSize(new Dimension(430, n));
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_TRACE_LEVELS"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.scrollPaneSpyLevels.setBorder(BorderFactory.createTitledBorder(titledBorder));
        }
        return this.scrollPaneSpyLevels;
    }

    private AastraCheckBox getCheckBoxAdditionalClassInfo() {
        if (this.checkBoxAdditionalClassInfo == null) {
            this.checkBoxAdditionalClassInfo = new AastraCheckBox(275, 25);
            this.checkBoxAdditionalClassInfo.setSelected(UtilPreferences.getSpyClassInfo());
        }
        return this.checkBoxAdditionalClassInfo;
    }

    private AastraPanel getPanelSpyIds() {
        if (this.panelSpyIds == null) {
            this.panelSpyIds = new AastraPanel();
            this.panelSpyIds.setLayout(null);
            EnumSet<UtilSpy.SpyIdEnum> enumSet = EnumSet.allOf(UtilSpy.SpyIdEnum.class);
            Iterator iterator = enumSet.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                UtilSpy.SpyIdEnum spyIdEnum = (UtilSpy.SpyIdEnum)((Object)iterator.next());
                if (!spyIdEnum.spyIdValid) continue;
                this.checkBoxSpyIds[spyIdEnum.ordinal()] = new AastraCheckBox(270, 6 + spyIdEnum.ordinal() * 25);
                this.panelSpyIds.add(this.checkBoxSpyIds[spyIdEnum.ordinal()]);
                this.checkBoxSpyIds[spyIdEnum.ordinal()].setSelected(spyIdEnum.spyIdActive);
                this.labelSpyIds[spyIdEnum.ordinal()] = new AastraLabel(UtilLocale.getString(spyIdComment[spyIdEnum.ordinal()]));
                this.panelSpyIds.add(this.labelSpyIds[spyIdEnum.ordinal()]);
                this.labelSpyIds[spyIdEnum.ordinal()].setBounds(20, 10 + spyIdEnum.ordinal() * 25, 230, 25);
                ++n;
            }
            this.panelSpyIds.setPreferredSize(new Dimension(430, 10 + n * 25));
        }
        return this.panelSpyIds;
    }

    private AastraScrollPane getScrollPaneWarnings() {
        if (this.scrollPaneWarnings == null) {
            this.scrollPaneWarnings = new AastraScrollPane(this.getPanelWarnings(), 20, 31);
            this.scrollPaneWarnings.setAlignmentX(0.0f);
            this.scrollPaneWarnings.setPreferredSize(new Dimension(430, 90));
            this.scrollPaneWarnings.setMaximumSize(new Dimension(430, 90));
            this.scrollPaneWarnings.setMinimumSize(new Dimension(430, 90));
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_WARNINGS"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.scrollPaneWarnings.setBorder(BorderFactory.createTitledBorder(titledBorder));
        }
        return this.scrollPaneWarnings;
    }

    private AastraPanel getPanelWarnings() {
        if (this.panelWarnings == null) {
            this.panelWarnings = new AastraPanel();
            this.panelWarnings.setLayout(null);
            this.panelWarnings.setPreferredSize(new Dimension(1, 1));
            EnumSet<UtilWarnings.WarningIdEnum> enumSet = EnumSet.allOf(UtilWarnings.WarningIdEnum.class);
            for (UtilWarnings.WarningIdEnum warningIdEnum : enumSet) {
                this.checkBoxWarningIds[warningIdEnum.ordinal()] = new AastraCheckBox(242, 6 + warningIdEnum.ordinal() * 25);
                this.panelWarnings.add(this.checkBoxWarningIds[warningIdEnum.ordinal()]);
                this.checkBoxWarningIds[warningIdEnum.ordinal()].setSelected(warningIdEnum.active);
                this.labelWarningIds[warningIdEnum.ordinal()] = new AastraLabel();
                this.panelWarnings.add(this.labelWarningIds[warningIdEnum.ordinal()]);
                this.labelWarningIds[warningIdEnum.ordinal()].setText("<html>" + UtilLocale.getString(warningIdEnum.comment) + "</html>");
                this.labelWarningIds[warningIdEnum.ordinal()].setBounds(20, 10 + warningIdEnum.ordinal() * 25, 210, 32);
            }
            this.panelWarnings.setPreferredSize(new Dimension(450, 10 + UtilWarnings.WarningIdEnum.values().length * 25));
        }
        return this.panelWarnings;
    }

    private AastraPanel getPanelButtonBar() {
        if (this.panelButtonBar == null) {
            this.panelButtonBar = new AastraPanel();
            this.panelButtonBar.setLayout(null);
            this.panelButtonBar.setPreferredSize(new Dimension(0, 0));
            this.panelButtonBar.add(this.getButtonOK());
            this.panelButtonBar.add(this.getButtonCancel());
        }
        return this.panelButtonBar;
    }

    private JButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(110, 25, 90, 25);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiUtilDialog guiUtilDialog;
                    int n;
                    Locale locale;
                    switch (GuiOptionsDlg.this.comboBoxLanguage.getSelectedIndex()) {
                        default: {
                            locale = UtilLocale.languages[UtilLocale.English].getLocale();
                            break;
                        }
                        case 1: {
                            locale = UtilLocale.languages[UtilLocale.German].getLocale();
                            break;
                        }
                        case 2: {
                            locale = UtilLocale.languages[UtilLocale.French].getLocale();
                            break;
                        }
                        case 3: {
                            locale = UtilLocale.languages[UtilLocale.Spanish].getLocale();
                        }
                    }
                    UtilGeneralBooleanSettings.setSingleId(UtilGeneralBooleanSettings.SettingIdsEnum.TABLE_COL_SELECTION_SORTED_ALPHABETICALLY, GuiOptionsDlg.this.checkBoxSettingIds.isSelected());
                    BitSet bitSet = new BitSet();
                    for (n = 0; n < UtilWarnings.WarningIdEnum.values().length; ++n) {
                        if (GuiOptionsDlg.this.checkBoxWarningIds[n].getSelectedObjects() == null) continue;
                        bitSet.set(n);
                    }
                    UtilWarnings.setWarning(bitSet);
                    UtilPreferences.setWarningIds(bitSet);
                    n = 0;
                    BitSet bitSet2 = new BitSet();
                    for (n = 0; n < UtilSpy.SpyIdEnum.values().length; ++n) {
                        if (GuiOptionsDlg.this.checkBoxSpyIds[n] == null || GuiOptionsDlg.this.checkBoxSpyIds[n].getSelectedObjects() == null) continue;
                        bitSet2.set(n);
                        if (UtilProdInfo.isPrivateProduction() || n != 1) continue;
                        UtilPreferences.setRemainingStarts(1);
                        new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageWarning, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionOK, GuiUtilDialog.GuiUtilDialogModalityEnum.Modal, String.format(UtilLocale.getString("TXT_WARNING_SET_TRACE_LEVEL_*"), UtilLocale.getString(spyIdComment[1])), null, null, true);
                    }
                    UtilSpy.setSpyIds(bitSet2);
                    UtilPreferences.setSpyIds(bitSet2);
                    if (UtilProdInfo.isPrivateProduction()) {
                        boolean bl = GuiOptionsDlg.this.checkBoxAdditionalClassInfo.isSelected();
                        UtilSpy.setSpyClassInfo(bl);
                        UtilPreferences.setSpyClassInfo(bl);
                    }
                    if (!locale.equals(GuiOptionsDlg.this.currentLocale) && (guiUtilDialog = new GuiUtilDialog(GuiUtilDialog.GuiUtilDialogMessageTypeEnum.MessageQuestion, GuiUtilDialog.GuiUtilDialogOptionTypeEnum.OptionOKCancel, GuiUtilDialog.GuiUtilDialogModalityEnum.Modal, String.format(UtilLocale.getString("TXT_EXIT_*_?"), "OM Management Portal"), null, null, true)).getAction() == GuiUtilDialog.GuiUtilDialogActionEnum.ActionOK) {
                        GuiOptionsDlg.this.guiMain.exitApplication(true, locale);
                    }
                    GuiOptionsDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonOK;
    }

    private AastraButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new AastraButton();
            this.buttonCancel.setBounds(300, 25, 90, 25);
            this.buttonCancel.setText(UtilLocale.getString("TXT_CANCEL"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiOptionsDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonCancel;
    }

    class WindowAction
    extends WindowAdapter {
        WindowAction() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            GuiOptionsDlg.this.getComboBoxLanguage().requestFocusInWindow();
        }
    }
}

