/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.gui;

import com.aastra.oamp.util.UtilFileHandling;
import com.aastra.oamp.util.UtilProdInfo;
import com.aastra.util.UtilSpy;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;

public class GuiSpyFile
implements UtilSpy.SpyOutputInterface {
    private static final int SPY_TRACE_FILE_MAX_CNT_TOTAL = 30;
    private static final int SPY_TRACE_DELETE_FILES_OLDER_THAN_X_DAYS = 6;
    private static final int SPY_TRACE_FILE_MAX_PART_CNT = 1000;
    private static final long SPY_TRACE_FILE_MAX_SIZE = 0x40000000L;
    private static File file = null;
    private static File directory = null;
    private static Writer writer = null;
    private static int fileLineIndex = 0;
    private static boolean showMaxPartCntError = true;
    private static String fileNameSpyTraceRoot = null;
    private static String fileNameSpyTrace = null;

    public GuiSpyFile(String string) {
        fileNameSpyTraceRoot = string != null ? string : "spy_trace";
        fileNameSpyTrace = fileNameSpyTraceRoot + "_%4d_%02d_%02d_p000.log";
        this.initialize();
    }

    private void initialize() {
        int n;
        Calendar calendar = Calendar.getInstance();
        String string = String.format("%4d_%02d_%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        String string2 = String.format(fileNameSpyTrace, calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        Object[] objectArray = null;
        boolean bl = true;
        directory = new File(UtilFileHandling.getWorkingDirectory());
        if (UtilProdInfo.isPrivateProduction()) {
            System.out.println("Using working directory '" + directory.getPath() + "'");
        }
        objectArray = directory.listFiles();
        for (n = 0; n < objectArray.length; ++n) {
            String string3 = objectArray[n].getName();
            String string4 = objectArray[n].getPath();
            if (!string3.equals("spy.log") && !string3.equals("exception.log")) continue;
            if (((File)objectArray[n]).delete()) {
                if (!UtilProdInfo.isPrivateProduction()) continue;
                System.out.println("File '" + string4 + "' removed");
                continue;
            }
            System.out.println("Error: Removing file '" + string4 + "' failed");
        }
        objectArray = directory.listFiles(new SpyFilenameFilter());
        Arrays.sort(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            if (!((File)objectArray[n]).getName().contains(string) || ((File)objectArray[n]).getName().compareTo(string2) <= 0) continue;
            string2 = ((File)objectArray[n]).getName();
            if (!UtilProdInfo.isPrivateProduction()) continue;
            System.out.println("Newer file '" + ((File)objectArray[n]).getPath() + "' found");
        }
        file = new File(UtilFileHandling.getWorkingDirectory() + File.separator + string2);
        if (directory.getFreeSpace() > 0L && 0x40000000L - file.length() > directory.getFreeSpace()) {
            System.out.println("Error: Opening file '" + file.getPath() + "' failed. Not enough free space on partition");
            writer = null;
            return;
        }
        try {
            writer = new BufferedWriter(new FileWriter(file, true));
            if (UtilProdInfo.isPrivateProduction()) {
                System.out.println("File '" + file.getPath() + "' opened");
            }
        }
        catch (IOException iOException) {
            System.out.println("Error: Opening file '" + file.getPath() + "' failed");
            writer = null;
            return;
        }
        this.deleteFiles();
        if (file.length() >= 0x40000000L) {
            bl = this.createNewPartFile();
        }
        if (bl) {
            this.printHeader();
            this.redirectSystemErrorStream();
        }
    }

    private void redirectSystemErrorStream() {
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(int n) throws IOException {
                GuiSpyFile.this.spyInfo(String.valueOf((char)n));
                System.out.print(String.valueOf((char)n));
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                GuiSpyFile.this.spyInfo(new String(byArray, n, n2));
                System.out.print(new String(byArray, n, n2));
            }

            @Override
            public void write(byte[] byArray) throws IOException {
                this.write(byArray, 0, byArray.length);
            }
        };
        System.setErr(new PrintStream(outputStream, true));
    }

    @Override
    public synchronized void spyInfo(String string) {
        boolean bl = true;
        if (string.equals("\n")) {
            return;
        }
        if (writer != null) {
            if (!string.endsWith("\n")) {
                string = string + "\n";
            }
            int n = string.length();
            if (file.length() + (long)n + 9L > 0x40000000L) {
                try {
                    writer.flush();
                }
                catch (IOException iOException) {
                    System.out.println("Error: Flushing file '" + file.getPath() + "' failed");
                }
                bl = this.createNewPartFile();
            }
            if (bl) {
                try {
                    writer.write(String.format("[%7d] ", fileLineIndex++) + string);
                }
                catch (IOException iOException) {
                    System.out.println("Error: Writing to file '" + file.getPath() + "' failed");
                }
                try {
                    writer.flush();
                }
                catch (IOException iOException) {
                    System.out.println("Error: Flushing file '" + file.getPath() + "' failed");
                }
            }
        }
    }

    @Override
    public void spyError(String string) {
        this.spyInfo(string);
    }

    public String getFilePath() {
        if (file != null) {
            return file.getPath();
        }
        return null;
    }

    public void close() {
        if (writer != null) {
            try {
                writer.flush();
            }
            catch (IOException iOException) {
                System.out.println("Error: Flushing file '" + file.getPath() + "' failed");
                return;
            }
            try {
                writer.close();
            }
            catch (IOException iOException) {
                System.out.println("Error: Closing file '" + file.getPath() + "' failed");
                writer = null;
                return;
            }
            if (UtilProdInfo.isPrivateProduction()) {
                System.out.println("File '" + file.getPath() + "' closed");
            }
            writer = null;
        }
    }

    private void printHeader() {
        if (writer != null) {
            fileLineIndex = 0;
            Calendar calendar = Calendar.getInstance();
            try {
                writer.write(String.format("\n------------------------------------------\n%s%s\n------------------------------------------\n\n", "OMP trace started: ", new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS").format(calendar.getTime())));
            }
            catch (IOException iOException) {
                System.out.println("Error: Writing header to file '" + file.getPath() + "' failed");
                return;
            }
            try {
                writer.flush();
            }
            catch (IOException iOException) {
                System.out.println("Error: Flushing file '" + file.getPath() + "' failed");
            }
            if (UtilProdInfo.isPrivateProduction()) {
                System.out.println("Header in file '" + file.getPath() + "' written");
            }
        }
    }

    private boolean createNewPartFile() {
        boolean bl = false;
        if (writer != null) {
            this.close();
            int n = Integer.parseInt(file.getName().substring(22, 25));
            if (++n < 1000) {
                String string = file.getName().substring(0, 22) + String.format("%03d", n) + ".log";
                file = new File(UtilFileHandling.getWorkingDirectory() + File.separator + string);
                if (directory.getFreeSpace() > 0L && 0x40000000L - file.length() > directory.getFreeSpace()) {
                    System.out.println("Error: Opening file '" + file.getPath() + "' failed. Not enough free space on partition");
                    writer = null;
                    return bl;
                }
                try {
                    writer = new BufferedWriter(new FileWriter(file, true));
                    if (UtilProdInfo.isPrivateProduction()) {
                        System.out.println("New part file '" + file.getPath() + "' opened");
                    }
                    bl = true;
                }
                catch (IOException iOException) {
                    System.out.println("Error: Opening file '" + file.getPath() + "' failed");
                    writer = null;
                    return bl;
                }
                this.deleteFiles();
                this.printHeader();
            } else if (showMaxPartCntError) {
                System.out.println("Error: Maximum part number 999 of trace files for today exceeded");
                showMaxPartCntError = false;
            }
        }
        return bl;
    }

    private void deleteFiles() {
        String string;
        int n;
        String string2 = null;
        Object[] objectArray = null;
        File file = new File(UtilFileHandling.getWorkingDirectory());
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -6);
        String string3 = String.format("%4d_%02d_%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        objectArray = file.listFiles(new SpyFilenameFilter());
        Arrays.sort(objectArray);
        for (n = 0; n < objectArray.length && (string = ((File)objectArray[n]).getName().substring(fileNameSpyTraceRoot.length() + 1)).compareTo(string3) < 0; ++n) {
            string2 = ((File)objectArray[n]).getPath();
            if (((File)objectArray[n]).delete()) {
                if (!UtilProdInfo.isPrivateProduction()) continue;
                System.out.println("File '" + string2 + "' removed");
                continue;
            }
            System.out.println("Error: Removing file '" + string2 + "' failed");
        }
        objectArray = file.listFiles(new SpyFilenameFilter());
        Arrays.sort(objectArray);
        if (objectArray.length > 30) {
            for (n = 0; n < objectArray.length - 30; ++n) {
                string2 = ((File)objectArray[n]).getPath();
                if (((File)objectArray[n]).delete()) {
                    if (!UtilProdInfo.isPrivateProduction()) continue;
                    System.out.println("File '" + string2 + "' removed");
                    continue;
                }
                System.out.println("Error: Removing file '" + string2 + "' failed");
            }
        }
    }

    class SpyFilenameFilter
    implements FilenameFilter {
        SpyFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return string.startsWith(fileNameSpyTraceRoot);
        }
    }
}

