/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.gui;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.CommonDataHandler;
import com.aastra.omilib.OmiMessage;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraContentButton;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraStatusBar;
import com.aastra.util.UtilSpy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class GuiStatusBar
extends AastraStatusBar {
    private static final long serialVersionUID = 1L;
    private CommonDataHandler commonDataHandler = null;
    private AastraPanel panelLeft = null;
    private AastraPanel panelRight = null;
    private AastraLabel labelEncryption = null;
    private AastraLabel labelPARK = null;
    private AastraLabel labelAppState = null;
    private AastraLabel labelLinkState = null;
    private AastraContentButton buttonSubscription = null;
    private AastraContentButton buttonPpDevAutoCreate = null;
    private boolean appStateOverride = false;
    private boolean ppDevAutoCreateActive = false;
    private AastraLabel labelTableInfo = null;
    private AastraLabel labelSDC = null;
    private Border borderMatteLeft = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, GuiUtilIcon.getIconDivider()), BorderFactory.createEmptyBorder(3, 3, 3, 3));
    private Border borderMatteRight = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, GuiUtilIcon.getIconDivider()), BorderFactory.createEmptyBorder(3, 3, 3, 3));
    private Border borderLowered = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(5, 5, 5, 5));

    public GuiStatusBar(CommonDataHandler commonDataHandler) {
        this.commonDataHandler = commonDataHandler;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanelLeft(), "West");
        this.add((Component)this.getPanelRight(), "East");
        this.setBackground(AastraCommon.MitelStatusBarBackground);
    }

    private AastraPanel getPanelLeft() {
        if (this.panelLeft == null) {
            this.panelLeft = new AastraPanel();
            this.panelLeft.setLayout(new FlowLayout(0, 5, 0));
            this.panelLeft.setBackground(AastraCommon.MitelStatusBarBackground);
            this.labelEncryption = new AastraLabel();
            this.labelEncryption.setBorder(this.borderMatteRight);
            this.labelEncryption.setFont(AastraCommon.AastraFontStatusBar);
            this.labelEncryption.setText(" ");
            this.labelEncryption.setForeground(AastraCommon.MitelStatusBarForeground);
            this.labelEncryption.setToolTipText(UtilLocale.getString("TXT_ENCRYPTION"));
            this.panelLeft.add((Component)this.labelEncryption, null);
            this.showEncryptionState(false);
            this.labelPARK = new AastraLabel();
            this.labelPARK.setBorder(this.borderMatteRight);
            this.labelPARK.setFont(AastraCommon.AastraFontStatusBar);
            this.labelPARK.setForeground(AastraCommon.MitelStatusBarForeground);
            this.panelLeft.add((Component)this.labelPARK, null);
            this.showPARK(null);
            this.panelLeft.add((Component)this.getButtonSubscription(), null);
            this.showSubscriptionState(false);
            this.panelLeft.add((Component)this.getButtonPpDevAutoCreate(), null);
            this.labelAppState = new AastraLabel();
            this.labelAppState.setBorder(this.borderMatteLeft);
            this.labelAppState.setFont(AastraCommon.AastraFontStatusBar);
            this.labelAppState.setText(" ");
            this.panelLeft.add((Component)this.labelAppState, null);
            this.showAppState(AppStateEnum.APP_STATE_OK, null);
        }
        return this.panelLeft;
    }

    private AastraPanel getPanelRight() {
        if (this.panelRight == null) {
            this.panelRight = new AastraPanel();
            this.panelRight.setLayout(new FlowLayout(2));
            this.panelRight.setBackground(AastraCommon.MitelStatusBarBackground);
            this.labelTableInfo = new AastraLabel();
            this.labelTableInfo.setBorder(this.borderMatteLeft);
            this.labelTableInfo.setFont(AastraCommon.AastraFontStatusBar);
            this.labelTableInfo.setForeground(AastraCommon.MitelStatusBarForeground);
            this.labelTableInfo.setVisible(false);
            this.panelRight.add((Component)this.labelTableInfo, null);
            this.labelSDC = new AastraLabel();
            this.labelSDC.setBorder(this.borderMatteLeft);
            this.labelSDC.setFont(AastraCommon.AastraFontStatusBar);
            this.labelSDC.setForeground(Color.red);
            this.labelSDC.setText(UtilLocale.getString("TXT_CONNECTED_TO_SIP_DECT_WITH_CLOUD_ID_OMM"));
            this.labelSDC.setVisible(false);
            this.panelRight.add((Component)this.labelSDC, null);
            this.labelLinkState = new AastraLabel();
            this.labelLinkState.setBorder(this.borderMatteLeft);
            this.labelLinkState.setFont(AastraCommon.AastraFontStatusBar);
            this.labelLinkState.setForeground(AastraCommon.MitelStatusBarForeground);
            this.panelRight.add((Component)this.labelLinkState, null);
            this.showLinkState(false, null);
        }
        return this.panelRight;
    }

    private AastraContentButton getButtonSubscription() {
        if (this.buttonSubscription == null) {
            this.buttonSubscription = new AastraContentButton();
            this.buttonSubscription.setToolTipText(UtilLocale.getString("TXT_SUBSCRIPTION_20"));
            this.buttonSubscription.setIcon(GuiUtilIcon.getIconPpSubscription());
            this.buttonSubscription.setMargin(new Insets(4, 4, 4, 4));
            this.buttonSubscription.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CommonDataHandler.DECTSubscriptionMode dECTSubscriptionMode = null;
                    try {
                        dECTSubscriptionMode = (CommonDataHandler.DECTSubscriptionMode)GuiStatusBar.this.commonDataHandler.getData(CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode);
                        UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode.toString() + "=" + dECTSubscriptionMode.toString());
                    }
                    catch (CommonDataHandler.DataNotAvaillableException dataNotAvaillableException) {
                        UtilSpy.spyError(UtilSpy.SpyIdEnum.GUI_DB, this, "Reading " + CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode.toString() + " failed");
                        return;
                    }
                    if (dECTSubscriptionMode.mode != OmiMessage.DECTSubscriptionModeType.Off) {
                        dECTSubscriptionMode = new CommonDataHandler.DECTSubscriptionMode();
                        dECTSubscriptionMode.mode = OmiMessage.DECTSubscriptionModeType.Off;
                        GuiStatusBar.this.showSubscriptionState(false);
                    } else {
                        dECTSubscriptionMode = new CommonDataHandler.DECTSubscriptionMode();
                        dECTSubscriptionMode.mode = OmiMessage.DECTSubscriptionModeType.Configured;
                        dECTSubscriptionMode.timeout = 0;
                        GuiStatusBar.this.showSubscriptionState(true);
                    }
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode.toString() + "=" + dECTSubscriptionMode);
                    GuiStatusBar.this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode, dECTSubscriptionMode);
                    GuiStatusBar.this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.DECTSubscriptMode);
                }
            });
        }
        return this.buttonSubscription;
    }

    private AastraContentButton getButtonPpDevAutoCreate() {
        if (this.buttonPpDevAutoCreate == null) {
            this.buttonPpDevAutoCreate = new AastraContentButton();
            this.buttonPpDevAutoCreate.setToolTipText(UtilLocale.getString("TXT_AUTO-CREATE_ON_SUBSCRIPTION"));
            this.buttonPpDevAutoCreate.setIcon(GuiUtilIcon.getIconPpAutoCreate());
            this.buttonPpDevAutoCreate.setMargin(new Insets(4, 4, 4, 4));
            this.buttonPpDevAutoCreate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = false;
                    if (!GuiStatusBar.this.ppDevAutoCreateActive) {
                        bl = true;
                        GuiStatusBar.this.showPpDevAutoCreateState(true);
                    } else {
                        GuiStatusBar.this.showPpDevAutoCreateState(false);
                    }
                    UtilSpy.spyOut(UtilSpy.SpyIdEnum.GUI_DB, this, "Setting " + CommonDataHandler.CommonDataItemEnum.PPDevAutoCreate.toString() + "=" + bl);
                    GuiStatusBar.this.commonDataHandler.setData(CommonDataHandler.CommonDataItemEnum.PPDevAutoCreate, bl);
                    GuiStatusBar.this.commonDataHandler.commitChangesToOmm(CommonDataHandler.CommonDataItemEnum.PPDevAutoCreate);
                }
            });
        }
        return this.buttonPpDevAutoCreate;
    }

    public void showPARK(String string) {
        if (string != null && !string.isEmpty()) {
            this.labelPARK.setForeground(AastraCommon.MitelStatusBarForeground);
            this.labelPARK.setText(" PARK: " + string + " ");
        } else {
            this.labelPARK.setForeground(Color.RED.brighter());
            this.labelPARK.setText(" PARK: " + UtilLocale.getString("TXT_NONE") + " ");
        }
        this.repaint();
    }

    public void showEncryptionState(Boolean bl) {
        if (bl.booleanValue()) {
            this.labelEncryption.setIcon(GuiUtilIcon.getIconEncryptionActive());
        } else {
            this.labelEncryption.setIcon(GuiUtilIcon.getIconEncryptionInactive());
        }
        this.repaint();
    }

    public void showSubscriptionState(Boolean bl) {
        if (bl.booleanValue()) {
            this.buttonSubscription.setBorderPainted(true);
            this.buttonSubscription.setBorder(this.borderLowered);
        } else {
            this.buttonSubscription.setBorderPainted(false);
        }
        this.repaint();
    }

    public void showPpDevAutoCreateState(Boolean bl) {
        if (GuiMain.getOmiManagementObject().getOmmAttribBool(OmiMessage.OpenRespAttribType.haveUnboundDevices)) {
            if (bl.booleanValue()) {
                this.buttonPpDevAutoCreate.setBorderPainted(true);
                this.buttonPpDevAutoCreate.setBorder(this.borderLowered);
                this.ppDevAutoCreateActive = true;
            } else {
                this.buttonPpDevAutoCreate.setBorderPainted(false);
                this.ppDevAutoCreateActive = false;
            }
            this.repaint();
        }
    }

    public void setButtonPpDevAutoCreate(Boolean bl) {
        this.buttonPpDevAutoCreate.setVisible(bl);
    }

    public void showAppState(AppStateEnum appStateEnum, String string) {
        if (!this.appStateOverride) {
            switch (appStateEnum) {
                case APP_STATE_ERROR: {
                    this.labelAppState.setForeground(Color.RED.brighter());
                    this.labelAppState.setIcon(GuiUtilIcon.getIconError(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeSmall));
                    if (string != null) {
                        this.labelAppState.setText(" " + string + " ");
                        break;
                    }
                    this.labelAppState.setText(" ");
                    break;
                }
                case APP_STATE_BUSY: {
                    this.labelAppState.setForeground(AastraCommon.MitelStatusBarForeground);
                    this.labelAppState.setIcon(GuiUtilIcon.getIconBusy());
                    if (string != null) {
                        this.labelAppState.setText(" " + string + " ");
                        break;
                    }
                    this.labelAppState.setText(" ");
                    break;
                }
                case APP_STATE_INFO: {
                    this.labelAppState.setForeground(AastraCommon.MitelStatusBarForeground);
                    this.labelAppState.setIcon(null);
                    this.labelAppState.setToolTipText(null);
                    if (string != null) {
                        this.labelAppState.setText(" " + string + " ");
                        break;
                    }
                    this.labelAppState.setText(" ");
                    break;
                }
                default: {
                    this.labelAppState.setForeground(AastraCommon.MitelStatusBarForeground);
                    this.labelAppState.setIcon(null);
                    this.labelAppState.setText(" ");
                    this.labelAppState.setToolTipText(null);
                }
            }
            this.repaint();
        }
    }

    public void showAppStateSetOverride(AppStateEnum appStateEnum, String string) {
        if (!this.appStateOverride) {
            this.showAppState(appStateEnum, string);
            this.appStateOverride = true;
        }
    }

    public void showAppStateResetOverride(AppStateEnum appStateEnum, String string) {
        this.appStateOverride = false;
        this.showAppState(appStateEnum, string);
    }

    public void showLinkState(Boolean bl, String string) {
        if (bl.booleanValue()) {
            this.labelLinkState.setIcon(GuiUtilIcon.getIconConnected());
            this.labelLinkState.setToolTipText(UtilLocale.getString("TXT_CONNECTED_WITH_OMM"));
            this.labelLinkState.setText(string);
        } else {
            this.labelLinkState.setIcon(GuiUtilIcon.getIconDisconnected(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            this.labelLinkState.setToolTipText(UtilLocale.getString("TXT_NO_OMM_CONNECTION"));
            this.labelLinkState.setText(null);
        }
        this.labelLinkState.paintImmediately(this.labelLinkState.getBounds());
    }

    public void showTableInfo(int n, int n2) {
        this.labelTableInfo.setText(String.format("%d/%d", n, n2));
        this.labelTableInfo.setToolTipText(String.format(UtilLocale.getString("TXT_*_OF_*_TABLE_ENTRIES_SELECTED"), n, n2));
        if (!this.labelTableInfo.isVisible()) {
            this.labelTableInfo.setVisible(true);
        }
    }

    public void hideTableInfo() {
        this.labelTableInfo.setVisible(false);
    }

    public void setLabelSDC(boolean bl) {
        if (bl) {
            if (this.labelSDC != null) {
                this.labelSDC.setVisible(true);
            }
        } else if (this.labelSDC != null) {
            this.labelSDC.setVisible(false);
        }
    }

    public static enum AppStateEnum {
        APP_STATE_OK,
        APP_STATE_ERROR,
        APP_STATE_BUSY,
        APP_STATE_INFO;

    }
}

