/*
 * Decompiled with CFR 0.152.
 */
package com.aastra.oamp.gui;

import com.aastra.oamp.gui.GuiMain;
import com.aastra.oamp.guiutil.GuiUtilIcon;
import com.aastra.oamp.util.UtilLocale;
import com.aastra.omilib.GenericDataRecord;
import com.aastra.omilib.GenericDatabase;
import com.aastra.omilib.OmiManagement;
import com.aastra.omilib.VersionHandler;
import com.aastra.omilibgui.ConfiguratorTable;
import com.aastra.style.AastraButton;
import com.aastra.style.AastraCommon;
import com.aastra.style.AastraDialog;
import com.aastra.style.AastraLabel;
import com.aastra.style.AastraPanel;
import com.aastra.style.AastraScrollPane;
import com.aastra.style.AastraTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;

public class GuiVersionInfoDlg
extends AastraDialog {
    private static final long serialVersionUID = 1L;
    OmiManagement omiManagement = null;
    VersionHandler versionHandler = null;
    private AastraPanel panelContent = null;
    private AastraPanel panelVersions = null;
    private AastraPanel panelMessages = null;
    private AastraPanel panelAbout = null;
    private AastraPanel panelButtonBar = null;
    private AastraButton buttonOK = null;
    private AastraScrollPane scrollPaneElements = null;
    private AastraLabel labelProtocolOMP = null;
    private AastraTextField textFieldProtocolOMP = null;
    private AastraLabel labelProtocolOMM = null;
    private AastraTextField textFieldProtocolOMM = null;
    private AastraLabel labelSpecification = null;
    private AastraTextField textFieldSpecification = null;
    private ConfiguratorTable tableElements = null;
    private ElementsDatabase elementsDb = new ElementsDatabase();
    private AastraLabel labelProtocolStatus = null;

    public GuiVersionInfoDlg(VersionHandler versionHandler) {
        super(GuiMain.getGuiMainObject());
        this.omiManagement = GuiMain.getOmiManagementObject();
        this.versionHandler = versionHandler;
        this.initialize();
    }

    private void initialize() {
        this.setSize(440, 660);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(UtilLocale.getString("TXT_ABOUT") + " AXI");
        this.setContentPane(this.getPanelContent());
        this.createRecords();
    }

    private AastraPanel getPanelContent() {
        if (this.panelContent == null) {
            this.panelContent = new AastraPanel();
            this.getRootPane().setDefaultButton(this.getButtonOK());
            this.panelContent.setLayout(new BoxLayout(this.panelContent, 1));
            this.panelContent.add(this.getPanelAbout());
            this.panelContent.add(this.getPanelButtonBar());
        }
        return this.panelContent;
    }

    private AastraPanel getPanelAbout() {
        if (this.panelAbout == null) {
            this.panelAbout = new AastraPanel();
            this.panelAbout.setLayout(new BoxLayout(this.panelAbout, 1));
            this.panelAbout.add(Box.createRigidArea(new Dimension(0, 10)));
            this.panelAbout.add(this.getPanelVersions());
            this.panelAbout.add(Box.createRigidArea(new Dimension(0, 10)));
            this.panelAbout.add(this.getPanelMessages());
        }
        return this.panelAbout;
    }

    private AastraPanel getPanelVersions() {
        if (this.panelVersions == null) {
            this.panelVersions = new AastraPanel();
            Dimension dimension = new Dimension(418, 130);
            this.panelVersions.setPreferredSize(dimension);
            this.panelVersions.setMaximumSize(dimension);
            this.panelVersions.setLayout(null);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_VERSION_INFO"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelVersions.setBorder(BorderFactory.createTitledBorder(titledBorder));
            this.labelProtocolOMP = new AastraLabel();
            this.labelProtocolOMP.setBounds(30, 30, 170, 16);
            this.labelProtocolOMP.setText(UtilLocale.getString("TXT_OMP_PROTOCOL_VERSION"));
            this.labelProtocolOMM = new AastraLabel();
            this.labelProtocolOMM.setBounds(30, 60, 170, 16);
            this.labelProtocolOMM.setText(UtilLocale.getString("TXT_OMM_PROTOCOL_VERSION"));
            this.labelSpecification = new AastraLabel();
            this.labelSpecification.setBounds(30, 90, 170, 16);
            this.labelSpecification.setText(UtilLocale.getString("TXT_SPECIFICATION_VERSION"));
            this.panelVersions.add((Component)this.labelProtocolOMP, null);
            this.panelVersions.add((Component)this.getTextFieldProtocolOMP(), null);
            this.panelVersions.add((Component)this.getLabelProtocolStatus(), null);
            this.panelVersions.add((Component)this.labelProtocolOMM, null);
            this.panelVersions.add((Component)this.getTextFieldProtocolOMM(), null);
            this.panelVersions.add((Component)this.labelSpecification, null);
            this.panelVersions.add((Component)this.getTextFieldSpecification(), null);
        }
        return this.panelVersions;
    }

    private AastraTextField getTextFieldProtocolOMP() {
        if (this.textFieldProtocolOMP == null) {
            this.textFieldProtocolOMP = new AastraTextField();
            this.textFieldProtocolOMP.setBounds(220, 30, 50, 20);
            this.textFieldProtocolOMP.setEditable(false);
            this.textFieldProtocolOMP.setText("45");
        }
        return this.textFieldProtocolOMP;
    }

    private AastraLabel getLabelProtocolStatus() {
        if (this.labelProtocolStatus == null) {
            this.labelProtocolStatus = new AastraLabel();
            this.labelProtocolStatus.setBounds(290, 30, 16, 16);
            if (this.omiManagement.getOmmProtocolVersion().equals("45")) {
                this.labelProtocolStatus.setIcon(GuiUtilIcon.getIconOK(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            } else {
                this.labelProtocolStatus.setIcon(GuiUtilIcon.getIconWarning(GuiUtilIcon.GuiUtilIconSizeEnum.IconSizeMedium));
            }
        }
        return this.labelProtocolStatus;
    }

    private AastraTextField getTextFieldProtocolOMM() {
        if (this.textFieldProtocolOMM == null) {
            this.textFieldProtocolOMM = new AastraTextField();
            this.textFieldProtocolOMM.setBounds(220, 60, 50, 20);
            this.textFieldProtocolOMM.setEditable(false);
            this.textFieldProtocolOMM.setText(this.omiManagement.getOmmProtocolVersion());
        }
        return this.textFieldProtocolOMM;
    }

    private AastraTextField getTextFieldSpecification() {
        if (this.textFieldSpecification == null) {
            this.textFieldSpecification = new AastraTextField();
            this.textFieldSpecification.setBounds(220, 90, 50, 20);
            this.textFieldSpecification.setEditable(false);
            this.textFieldSpecification.setText(this.omiManagement.getOmmAxiSpecVersion());
        }
        return this.textFieldSpecification;
    }

    private AastraPanel getPanelMessages() {
        if (this.panelMessages == null) {
            this.panelMessages = new AastraPanel();
            Dimension dimension = new Dimension(418, 395);
            this.panelMessages.setPreferredSize(dimension);
            this.panelMessages.setMaximumSize(dimension);
            this.panelMessages.setLayout(new BorderLayout());
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(AastraCommon.AastraColorBorderTitled), UtilLocale.getString("TXT_MESSAGES"));
            titledBorder.setTitleFont(AastraCommon.AastraFontTitledBorder);
            this.panelMessages.setBorder(BorderFactory.createTitledBorder(titledBorder));
            this.panelMessages.add((Component)this.getScrollPaneElements(), "Center");
        }
        return this.panelMessages;
    }

    private AastraScrollPane getScrollPaneElements() {
        if (this.scrollPaneElements == null) {
            this.scrollPaneElements = new AastraScrollPane(this.getTableElements());
        }
        return this.scrollPaneElements;
    }

    private ConfiguratorTable getTableElements() {
        if (this.tableElements == null) {
            this.tableElements = new ConfiguratorTable(this.elementsDb);
            this.tableElements.setSelectionMode(0);
            int[] nArray = new int[]{1, 2, 3, 4};
            this.tableElements.setColumnArr(nArray, nArray.length);
            this.tableElements.getTableHeader().setReorderingAllowed(false);
            for (int i = 0; i < nArray.length; ++i) {
                this.tableElements.getColumnModel().getColumn(i).setResizable(false);
            }
            this.tableElements.setIconArray(4, GuiUtilIcon.getIconInactiveOKWarningError());
            TableColumn tableColumn = this.tableElements.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(380);
        }
        return this.tableElements;
    }

    private void createRecords() {
        VersionHandler.VersionDatabase versionDatabase = this.versionHandler.getDb();
        for (int i = 0; i < versionDatabase.getRecordNumber(); ++i) {
            VersionHandler.VersionElement versionElement = versionDatabase.getRecord(i);
            ElementsRecord elementsRecord = new ElementsRecord();
            elementsRecord.setField(0, i);
            switch (versionElement.compare()) {
                case MajorDiffOmilibNewer: 
                case MajorDiffOmmNewer: {
                    elementsRecord.setField(4, (Object)StatusTypeEnum.STATUS_ERROR);
                    break;
                }
                case NotSupportedOmilibDontCare: {
                    elementsRecord.setField(4, (Object)StatusTypeEnum.STATUS_DONT_CARE);
                    break;
                }
                case NotSupportedOmilibUnknown: 
                case NotSupportedOmm: 
                case MinorDiffOmilibNewer: 
                case MinorDiffOmmNewer: 
                case BugfixDiffOmilibNewer: 
                case BugfixDiffOmmNewer: {
                    elementsRecord.setField(4, (Object)StatusTypeEnum.STATUS_WARNING);
                    break;
                }
                default: {
                    elementsRecord.setField(4, (Object)StatusTypeEnum.STATUS_OK);
                }
            }
            elementsRecord.setField(1, versionElement.getName());
            String string = versionElement.getVersionOmilibString();
            if (string.equals("-1.-1.-1") || string.equals("0.0.0")) {
                elementsRecord.setField(2, "-");
            } else {
                elementsRecord.setField(2, string);
            }
            elementsRecord.setField(3, versionElement.getVersionOmmString());
            this.elementsDb.createRecord(elementsRecord);
        }
    }

    private AastraPanel getPanelButtonBar() {
        if (this.panelButtonBar == null) {
            this.panelButtonBar = new AastraPanel();
            this.panelButtonBar.setLayout(null);
            this.panelButtonBar.setPreferredSize(new Dimension(0, 0));
            this.panelButtonBar.add(this.getButtonOK());
        }
        return this.panelButtonBar;
    }

    private AastraButton getButtonOK() {
        if (this.buttonOK == null) {
            this.buttonOK = new AastraButton();
            this.buttonOK.setBounds(168, 25, 90, 25);
            this.buttonOK.setText(UtilLocale.getString("TXT_OK"));
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiVersionInfoDlg.this.setVisible(false);
                }
            });
        }
        return this.buttonOK;
    }

    public class ElementsRecord
    extends GenericDataRecord {
        public static final int IDX_ID = 0;
        public static final int IDX_MESSAGE = 1;
        public static final int IDX_OMP = 2;
        public static final int IDX_OMM = 3;
        public static final int IDX_STATUS = 4;

        public ElementsRecord() {
        }

        public ElementsRecord(int n) {
            super(n);
        }
    }

    class ElementsDatabase
    extends GenericDatabase {
        public ElementsDatabase() {
            this.setFieldName(1, UtilLocale.getString("TXT_MESSAGE"));
            this.setFieldName(2, "OMP");
            this.setFieldName(3, "OMM");
            this.setFieldName(4, UtilLocale.getString("TXT_STATUS"));
        }
    }

    private static enum StatusTypeEnum {
        STATUS_DONT_CARE,
        STATUS_OK,
        STATUS_WARNING,
        STATUS_ERROR;

    }
}

